/*
* Creation date : Mon Mar 05 16:51:55 2007
* Last modified : %modify_time%
*/
/** @file
* \brief This file contains implementation of 
* test functions for RSA cryptography
* which worked with LibTomCrypt.
*
* \version CE2_TST_RSA.c#1:csrc:1
* \author Masiuk Aliaksandr
* \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
* All Rights reserved
*/

/************************ Include Files ***********************/

#include "CE2_TST_RSA.h"
#include "memory.h"

/************************ Defines *****************************/

#ifndef MIN_RSA_SIZE
#define MIN_RSA_SIZE 512
#endif /* MIN_RSA_SIZE */

#ifndef MAX_RSA_SIZE
#define MAX_RSA_SIZE 2112
#endif /* MAX_RSA_SIZE */

/************************ Enums *******************************/
/************************ Typedefs ****************************/
/************************ Global Data *************************/

CE2Error_t TST_TestStatusReturn;

/* status variables */
int			useSTDFile;
FILE *		FileOut;
CE2Error_t	TST_ATP_Error;
CE2Error_t	TST_TestStatus;

/* keys */
CE2_RSAUserPrivKey_t	TST_PrivateKey;
CE2_RSAUserPubKey_t		TST_PublicKey;

/* test data definition */
#ifndef CE2_SW_ENGINES_ON_ROT13_MODE

TST_RSA_TestDataStruct TestData[] =
{
	/**********************************/
	/*  RSA EncryptDecrypt test data  */
	/**********************************/
	{ 
		{"Test1 "},
			/*TST_PrivetExponent_D*/
		{0x1E, 0x30, 0xD0, 0xA8, 0xC6, 0xEC, 0xFA, 0x36, 0x6, 0x2F, 0xE2, 
		0xC5, 0xB4, 0xC4, 0xE, 0x54, 0xDF, 0x98, 0x56, 0x99, 0xD8, 
		0x42, 0x2C, 0xD0, 0x7E, 0x7A, 0xE2, 0xC0, 0xD1, 0x63, 0x87, 
		0x24, 0xA3, 0xAC, 0xD8, 0x10, 0xC1, 0x6F, 0x6B, 0x40, 0xD7, 
		0x2, 0x3, 0xCD, 0x70, 0x21, 0xD5, 0x83, 0x2B, 0xD0, 0xCD, 
		0xB3, 0x28, 0x2F, 0xB, 0xFD, 0x3B, 0xD1, 0x40, 0xC8, 0x7C, 
		0x3A, 0xE7, 0xA1, 0x1F, 0x8A, 0x53, 0x39, 0xBF, 0xD5, 0xCE, 
		0x70, 0x17, 0xC6, 0x19, 0x9A, 0x28, 0x76, 0x7F, 0xF4, 0xB0, 
		0xA3, 0x30, 0xFF, 0x17, 0xAF, 0x79, 0x80, 0xA5, 0x3, 0x16, 
		0x52, 0x51, 0xF9, 0xFF, 0xA0, 0xCA, 0x77, 0x54, 0x20, 0xF6, 
		0xB5, 0xC0, 0xAA, 0x43, 0xBF, 0x5F, 0xF0, 0x6E, 0x6, 0x9F, 
		0x56, 0xB3, 0xD6, 0xFF, 0xA2, 0x54, 0x55, 0x14, 0x46, 0xC7, 
		0xB2, 0xC, 0x70, 0x41, 0xA4, 0xF5, 0x15, 0xEF, 0x19, 0x98, 
		0xB6, 0x70, 0xB3, 0x42, 0x99, 0xC9, 0xED, 0x92, 0xFE, 0x25, 
		0x5C, 0x41, 0xC1, 0x0, 0x13, 0x29, 0x31, 0xA4, 0x4, 0x82, 
		0xF, 0x5F, 0xE9, 0x76, 0x17, 0xEC, 0x5, 0x3C, 0x5C, 0x17, 
		0xD, 0x49, 0xDC, 0x1, 0xFD, 0x50, 0x86, 0x29, 0x13, 0x8F, 
		0x13, 0x69, 0xCA, 0xC3, 0xBE, 0xD, 0xD5, 0xAC, 0x7C, 0xA4, 
		0xE2, 0x74, 0xE5, 0x9D, 0x30, 0xCA, 0x13, 0xC0, 0xA9, 0x1D, 
		0xeb},
		/*TST_PublicExponent_E*/
		{0x3},
		/*TST_Modulus_N*/
		{0xB5, 0x24, 0xE3, 0xF4, 0xA9, 0x8D, 0xDD, 0x44, 0x25, 0x1F, 0x50, 
		0xA2, 0x3C, 0x98, 0x55, 0xFD, 0x3D, 0x92, 0x7, 0x9B, 0x11, 
		0x8D, 0xC, 0xE2, 0xF6, 0xE1, 0x50, 0x84, 0xE8, 0x55, 0x2A, 
		0xDB, 0xD6, 0xD, 0x10, 0x64, 0x88, 0x9C, 0x83, 0x85, 0xA, 
		0xC, 0x16, 0xD0, 0xA0, 0xCB, 0x1, 0x13, 0x6, 0xE4, 0xD2, 
		0x32, 0xF1, 0x1A, 0x47, 0xEF, 0x66, 0xE7, 0x84, 0xB2, 0xE9, 
		0x61, 0x6D, 0xC6, 0xBD, 0x3D, 0xF3, 0x5A, 0x7F, 0x2, 0xD6, 
		0xA0, 0x8E, 0xA4, 0x99, 0x9C, 0xF2, 0xC6, 0xFF, 0xBC, 0x23, 
		0xD3, 0x25, 0xFA, 0x8E, 0x1C, 0xD9, 0x3, 0xDE, 0x12, 0x85, 
		0xED, 0xEB, 0xDB, 0xFD, 0xC6, 0x6E, 0x19, 0x8E, 0x34, 0x4C, 
		0xEE, 0x11, 0x76, 0xBE, 0x24, 0xF1, 0x89, 0xC0, 0xD0, 0xA4, 
		0x34, 0x6F, 0x4D, 0xB6, 0xA5, 0xFB, 0x34, 0x96, 0xD1, 0x52, 
		0x3D, 0x56, 0x14, 0xCF, 0xD1, 0x55, 0x9B, 0xF9, 0x44, 0x6C, 
		0xE6, 0xC4, 0x13, 0xAF, 0xFD, 0x27, 0x7A, 0x2F, 0xF4, 0x4A, 
		0x95, 0x11, 0x7B, 0xA4, 0x3F, 0x72, 0x6D, 0xDE, 0xA5, 0xC2, 
		0x57, 0x49, 0x4B, 0x68, 0xB0, 0x8E, 0x9E, 0xFE, 0x1A, 0xA8, 
		0x50, 0x73, 0x8C, 0x13, 0xB8, 0x3E, 0x9A, 0x2E, 0xF8, 0x3F, 
		0x5A, 0x9A, 0x38, 0xDC, 0x25, 0x5F, 0xF1, 0xB4, 0xED, 0x45, 
		0xA3, 0x57, 0x50, 0xF5, 0x20, 0xE0, 0xB7, 0xC, 0xE9, 0x85, 
		0xb3},
		/*TST_P*/
		{0xE3, 0x2B, 0xB5, 0xC7, 0xDA, 0xC2, 0x2, 0x75, 0xAF, 0x7E, 0x46, 
		0xB5, 0x72, 0xC, 0xD, 0xD0, 0xC0, 0x20, 0x81, 0xB5, 0x69, 
		0xD1, 0xA5, 0x1E, 0xAE, 0xA7, 0x97, 0x38, 0x56, 0xBB, 0xE1, 
		0xF5, 0x1, 0xB4, 0x82, 0xEF, 0xF1, 0x41, 0x44, 0xE2, 0x2F, 
		0xD2, 0xDD, 0xED, 0xED, 0x6B, 0x6A, 0xE7, 0x26, 0xC4, 0x70, 
		0x41, 0x86, 0x7D, 0xA6, 0x44, 0xDE, 0xF3, 0xBA, 0xA1, 0x6E, 
		0x3C, 0x9C, 0xCE, 0x1F, 0xD0, 0x2F, 0xC6, 0x73, 0x2F, 0x15, 
		0x56, 0xB8, 0xE9, 0xA6, 0x96, 0xB9, 0xFC, 0x49, 0x96, 0xCA, 
		0x1B, 0x31, 0x53, 0xDA, 0x93, 0xDA, 0xFE, 0xF9, 0x9F, 0x86, 
		0x86, 0x9B, 0xAC, 0xEA, 0x73},
		/*TST_Q*/
		{0xCC, 0x21, 0xDF, 0xA6, 0xA9, 0xE9, 0x8B, 0x3, 0x78, 0x2A, 0x6B, 
		0x31, 0xBA, 0x9C, 0xDA, 0x5B, 0x78, 0x23, 0x37, 0x22, 0x97, 
		0x64, 0x78, 0x9, 0xF5, 0x69, 0x74, 0x3A, 0xEF, 0x37, 0xB5, 
		0x23, 0x5C, 0xF6, 0x55, 0xB0, 0x2E, 0x9E, 0xDB, 0x80, 0x3C, 
		0x15, 0xE0, 0x11, 0x7D, 0x0, 0x1C, 0xE, 0x7D, 0x8, 0xB, 
		0x2, 0x80, 0xD, 0xF, 0xB6, 0x2A, 0xDE, 0xE9, 0x7F, 0x98, 
		0x42, 0xF7, 0x23, 0xFE, 0x30, 0x88, 0x9D, 0x94, 0x99, 0x46, 
		0x1E, 0x7F, 0x99, 0x3E, 0x4F, 0x65, 0x7B, 0xFC, 0x1A, 0x42, 
		0xD4, 0x78, 0xAD, 0x8D, 0xC0, 0xBE, 0xF0, 0x4C, 0x5C, 0x9D, 
		0xB9, 0xED, 0x45, 0xE7, 0xc1},     
		/*TST_dP*/
		{0x97, 0x72, 0x79, 0x2F, 0xE7, 0x2C, 0x1, 0xA3, 0xCA, 0x54, 0x2F, 
		0x23, 0xA1, 0x5D, 0x5E, 0x8B, 0x2A, 0xC0, 0x56, 0x78, 0xF1, 
		0x36, 0x6E, 0x14, 0x74, 0x6F, 0xBA, 0x25, 0x8F, 0x27, 0xEB, 
		0xF8, 0xAB, 0xCD, 0xAC, 0x9F, 0xF6, 0x2B, 0x83, 0x41, 0x75, 
		0x37, 0x3E, 0x9E, 0x9E, 0x47, 0x9C, 0x9A, 0x19, 0xD8, 0x4A, 
		0xD6, 0x59, 0xA9, 0x19, 0x83, 0x3F, 0x4D, 0x27, 0x16, 0x49, 
		0x7D, 0xBD, 0xDE, 0xBF, 0xE0, 0x1F, 0xD9, 0xA2, 0x1F, 0x63, 
		0x8F, 0x25, 0xF1, 0x19, 0xB9, 0xD1, 0x52, 0xDB, 0xB9, 0xDC, 
		0x12, 0x20, 0xE2, 0x91, 0xB7, 0xE7, 0x54, 0xA6, 0x6A, 0x59, 
		0xAF, 0x12, 0x73, 0x46, 0xf7},
		/*TST_dQ*/
		{0x88, 0x16, 0x95, 0x19, 0xC6, 0x9B, 0xB2, 0x2, 0x50, 0x1C, 0x47, 
		0x76, 0x7C, 0x68, 0x91, 0x92, 0x50, 0x17, 0x7A, 0x17, 0xF, 
		0x98, 0x50, 0x6, 0xA3, 0x9B, 0xA2, 0xD1, 0xF4, 0xCF, 0xCE, 
		0x17, 0x93, 0x4E, 0xE3, 0xCA, 0xC9, 0xBF, 0x3D, 0x0, 0x28, 
		0xE, 0x95, 0x60, 0xFE, 0x0, 0x12, 0xB4, 0x53, 0x5A, 0xB2, 
		0x1, 0xAA, 0xB3, 0x5F, 0xCE, 0xC7, 0x3F, 0x46, 0x55, 0x10, 
		0x2C, 0xA4, 0xC2, 0xA9, 0x75, 0xB0, 0x69, 0xD, 0xBB, 0x84, 
		0x14, 0x55, 0x10, 0xD4, 0x34, 0xEE, 0x52, 0xA8, 0x11, 0x81, 
		0xE2, 0xFB, 0x1E, 0x5E, 0x80, 0x7F, 0x4A, 0xDD, 0x93, 0x13, 
		0xD1, 0x48, 0xD9, 0x45, 0x2b},
		/*TST_Qinv*/
		{0xD0, 0x6D, 0x9C, 0xE7, 0x87, 0xAB, 0x10, 0x2D, 0xB8, 0xED, 0xF4, 
		0x35, 0x56, 0xF1, 0xA1, 0x72, 0x8F, 0xD4, 0x44, 0xE, 0x3E, 
		0x92, 0x75, 0x20, 0xC, 0xDB, 0xCF, 0x86, 0xB4, 0x51, 0x59, 
		0x13, 0xB, 0xBF, 0xC5, 0x57, 0x40, 0x1D, 0x51, 0xDB, 0x81, 
		0xF2, 0xAB, 0xB3, 0xF5, 0xA4, 0x8A, 0x97, 0xC6, 0x6C, 0x51, 
		0x13, 0x96, 0xDD, 0x9, 0x46, 0x72, 0x2C, 0x2D, 0x73, 0xF0, 
		0xF6, 0x28, 0x67, 0x60, 0xB2, 0x91, 0xA3, 0xB4, 0x6B, 0x6E, 
		0xF6, 0x50, 0xEC, 0x6B, 0xA2, 0xC3, 0xA0, 0xE1, 0xCF, 0xC8, 
		0x2E, 0x61, 0xA, 0xB1, 0xF7, 0xAD, 0x72, 0x39, 0xCB, 0xEB, 
		0xA7, 0x93, 0x8A, 0x2A, 0x10},
		/*TST_KeySize*/
		0xC0,
		/*TST_DPSize*/
		0x60,      
		/*TST_PubExponentSize*/
		1*sizeof(DxUint8_t),
		/*TST_input_data*/
		{0xfc, 0x1d, 0x69, 0xcc, 0xd0, 0xc, 0x96, 0xbc, 0xc, 0x47, 0xb7, 0x3d, 0xd3, 0x10, 
		0x4c, 0x8b},
		/*TST_output_data*/
		{0},
		/*TST_Expected_output_data*/
		{0x2d,0x99,0x04,0x94,0x8a,0x57,0x89,0x78,0xed,0x8a,0xdd,0xea,0x63,0xf5,0xe5,0x50,
		0xea,0xb5,0x83,0x89,0xb6,0xcc,0xa9,0x84,0x73,0x1d,0x1f,0x02,0x04,0x37,0x53,0xce,
		0xd6,0xa4,0xa8,0x96,0x20,0x00,0xdd,0xb3,0x91,0x67,0xac,0xbc,0xd4,0x3d,0x22,0x95,
		0x1f,0x2a,0x6c,0x17,0x10,0x35,0xa8,0x7e,0x10,0xab,0x53,0xeb,0xb4,0xef,0x27,0xcf}
	}
};

TST_RSA_TestDataStruct TestData2[] =
{
	/**********************************/
	/*  RSA EncryptDecrypt test data  */
	/**********************************/
	{ 
		{"Test2 "},
			/*TST_PrivetExponent_D*/
		{0x66, 0x17, 0x94, 0xAE, 0x45, 0x14, 0xE1, 0x97, 0x4, 0x94, 0x47, 
		0x77, 0x79, 0xD4, 0x11, 0x46, 0xAE, 0x70, 0x47, 0x64, 0xA7, 
		0xAF, 0xAB, 0xD8, 0xDD, 0x21, 0x54, 0xDF, 0xA3, 0x85, 0xC6, 
		0x5A, 0x38, 0xE3, 0xD7, 0x5C, 0x7, 0x25, 0x8D, 0xAB, 0xB9, 
		0x8, 0x24, 0x41, 0x55, 0x11, 0x92, 0xA, 0x1C, 0x60, 0x56, 
		0x81, 0xA9, 0x14, 0x96, 0x51, 0xAB, 0xF9, 0x5E, 0x2F, 0x31, 
		0xF4, 0xE2, 0xAE, 0x2C, 0x84, 0x98, 0x51, 0x1E, 0x5C, 0x84, 
		0xC3, 0xD2, 0x60, 0xAB, 0xA4, 0xDA, 0xC0, 0xE0, 0xCD, 0x30, 
		0x79, 0x3, 0x11, 0x3C, 0x85, 0xF9, 0xF6, 0xBD, 0x13, 0x6C, 
		0xE0, 0xEF, 0x9F, 0x79, 0x73, 0x82, 0xFD, 0x4C, 0x81, 0xA3, 
		0xBA, 0x64, 0xC4, 0xCD, 0x3D, 0x45, 0xD7, 0xBE, 0x4A, 0xD5, 
		0xC0, 0xA1, 0x46, 0x3F, 0xF, 0x8C, 0x77, 0x7, 0x4C, 0x9C, 
		0x2B, 0xFD, 0xD7, 0x75, 0xEA, 0xFA, 0xF1, 0xF9, 0x1F, 0x2, 
		0xE1, 0x63, 0x85, 0x5B, 0xE6, 0x84, 0x3F, 0xE4, 0xEA, 0xDF, 
		0xAB, 0x72, 0x75, 0x32, 0xA1, 0x65, 0x11, 0x41, 0x1C, 0x1C, 
		0xA8, 0x27, 0xE1, 0x55, 0xC7, 0x42, 0xC, 0x15, 0xcd},
		/*TST_PublicExponent_E*/
		{0x01,0x00,0x01},
		/*TST_Modulus_N*/
		{0xDA, 0x84, 0xAD, 0xD, 0x10, 0xE3, 0xDF, 0x17, 0x49, 0x4B, 0x1F, 
		0x53, 0x71, 0x87, 0x1C, 0x9B, 0xCF, 0x54, 0xD1, 0xB2, 0x7C, 
		0xCB, 0xDD, 0xCA, 0xBF, 0xEE, 0xC2, 0x90, 0x7E, 0xBA, 0x7A, 
		0x8D, 0x8A, 0xD9, 0x44, 0x32, 0xB8, 0x91, 0xEB, 0x7E, 0x43, 
		0x3C, 0x91, 0x75, 0x9, 0x98, 0xEF, 0xE2, 0xD2, 0xFF, 0x58, 
		0xCC, 0xDE, 0xC0, 0x46, 0xF3, 0xBC, 0xB4, 0x3E, 0x71, 0x7D, 
		0xB0, 0x5C, 0x31, 0xFD, 0xB2, 0xE7, 0x4A, 0x97, 0xB2, 0x1A, 
		0x70, 0x94, 0x64, 0x58, 0xC5, 0x6F, 0x8E, 0x63, 0xB3, 0xC5, 
		0xBE, 0x6A, 0x60, 0x5F, 0xC8, 0xF8, 0x54, 0xF6, 0xAB, 0xB3, 
		0x91, 0x2D, 0xC2, 0xE2, 0x90, 0x21, 0xE9, 0x89, 0xD7, 0x3, 
		0xD6, 0x80, 0x15, 0xB1, 0x38, 0x5B, 0xFF, 0x78, 0xBF, 0x87, 
		0x6E, 0xA7, 0x33, 0x1C, 0x33, 0xCE, 0x0, 0x9C, 0xDA, 0x6, 
		0x45, 0xFE, 0xB6, 0xB8, 0xFA, 0xE, 0x7A, 0x87, 0xF6, 0xC0, 
		0xE, 0x4D, 0x27, 0xF4, 0xDF, 0x6D, 0x9D, 0xDB, 0x88, 0x6B, 
		0x29, 0x71, 0x35, 0x19, 0xBC, 0x8D, 0x9E, 0x4F, 0xC9, 0xCD, 
		0xBB, 0x8E, 0xF5, 0x1B, 0x7B, 0xC7, 0xCB, 0x3, 0x39},
		/*TST_P*/
		{0xFC, 0xBA, 0xF4, 0x40, 0x30, 0xC2, 0x53, 0x97, 0xA4, 0x92, 0x89, 
		0x4, 0x9C, 0xF0, 0xCF, 0xC5, 0x21, 0x47, 0x87, 0x5, 0x94, 
		0x20, 0x87, 0xF, 0xEA, 0x8F, 0x53, 0x33, 0xA1, 0x4A, 0xB1, 
		0xCE, 0x67, 0x9D, 0xDC, 0xB3, 0x7E, 0x6B, 0x86, 0xD9, 0xEF, 
		0x65, 0xA6, 0x19, 0x88, 0x57, 0x96, 0x9A, 0x57, 0x18, 0xFB, 
		0x42, 0x89, 0x59, 0x20, 0xE0, 0x9F, 0x55, 0xD0, 0x72, 0xC8, 
		0x65, 0x99, 0x24, 0xAC, 0x45, 0xF3, 0xE1, 0x8E, 0x6C, 0x6D, 
		0xE1, 0x87, 0xE, 0xB6, 0x12, 0xAC, 0x59, 0x94, 0x23},
		/*TST_Q*/
		{0xDD, 0x58, 0x69, 0x45, 0xE7, 0x1C, 0xDC, 0xCD, 0x1D, 0x2C, 0x45, 
		0x64, 0x85, 0x83, 0x6A, 0x7, 0xA8, 0x13, 0x9D, 0x1B, 0xF6, 
		0x78, 0x64, 0x21, 0xA4, 0x7F, 0x52, 0x50, 0x15, 0x67, 0xBD, 
		0xB5, 0xCB, 0x42, 0x8A, 0x3D, 0x85, 0x2D, 0xC3, 0xCE, 0xE1, 
		0xC9, 0xD8, 0xD9, 0x39, 0x2, 0x2C, 0xFC, 0xFE, 0x4C, 0xD7, 
		0x9C, 0xE1, 0xE4, 0x6B, 0xAB, 0x87, 0xDF, 0x1A, 0xF0, 0x46, 
		0x55, 0x5C, 0xEF, 0xF4, 0x13, 0x6F, 0x73, 0x83, 0x57, 0x52, 
		0xB9, 0x13, 0x8D, 0x5, 0x95, 0xD, 0x9A, 0x62, 0xf3},     
		/*TST_dP*/
		{0xD6, 0x72, 0xE4, 0xF2, 0xDA, 0xEC, 0xE9, 0xF5, 0x90, 0xE5, 0xEE, 
		0x72, 0x5, 0xA1, 0xA9, 0xB, 0x82, 0xD3, 0xA8, 0xD4, 0xA8, 
		0xFE, 0x78, 0xDC, 0x9E, 0x92, 0x3, 0x6D, 0x99, 0xFD, 0x41, 
		0xA6, 0xFC, 0xF1, 0x4C, 0xE6, 0xD9, 0xEC, 0xEF, 0xBE, 0x59, 
		0x8F, 0xD, 0x44, 0x39, 0x16, 0xE9, 0x6A, 0x9, 0x61, 0xDF, 
		0x42, 0x74, 0x3D, 0x36, 0xD2, 0xA3, 0x21, 0x34, 0x1, 0x51, 
		0xDE, 0x33, 0xF6, 0x94, 0x5F, 0xBF, 0x33, 0xB3, 0xA0, 0x7A, 
		0x14, 0x96, 0x7F, 0x7B, 0x2B, 0x99, 0x27, 0x61, 0xb5},
		/*TST_dQ*/
		{0xD2, 0xF1, 0x63, 0xFA, 0x5B, 0x63, 0xD5, 0x45, 0xA0, 0xEC, 0xC5, 
		0x1, 0x24, 0x80, 0x75, 0xF6, 0xF0, 0x6, 0x29, 0x2F, 0x31, 
		0xF7, 0xD0, 0x2D, 0x83, 0xB0, 0x57, 0x48, 0xBC, 0xED, 0x8E, 
		0xD, 0x87, 0xB5, 0x55, 0x3B, 0x86, 0x5, 0x74, 0x5B, 0x60, 
		0x30, 0xD5, 0xF9, 0x46, 0x6C, 0x3D, 0x65, 0xAA, 0x10, 0x9F, 
		0x57, 0x2, 0xAC, 0x86, 0xB4, 0x5, 0x1B, 0xE9, 0x77, 0x5D, 
		0x0, 0x13, 0x3F, 0x16, 0xD3, 0xC2, 0xDE, 0x4A, 0x28, 0x59, 
		0x4C, 0xCA, 0x46, 0x16, 0x30, 0xD3, 0xB2, 0xF3, 0x63},
		/*TST_Qinv*/
		{0xCC, 0x10, 0xB7, 0xF5, 0x77, 0xC5, 0x67, 0x88, 0xEC, 0x8C, 0x50, 
		0x1D, 0x6A, 0xC5, 0x2C, 0xFF, 0xC5, 0x3C, 0xC9, 0x8D, 0xDB, 
		0x2D, 0xF0, 0x27, 0x4F, 0xB6, 0x69, 0x4E, 0xC0, 0x71, 0xE9, 
		0x44, 0x69, 0xA7, 0xD2, 0x29, 0x71, 0x18, 0x4B, 0xC1, 0x4F, 
		0x6C, 0xCA, 0xCC, 0x3, 0x27, 0x9A, 0x4F, 0xA0, 0x8D, 0x2D, 
		0xC3, 0x70, 0x89, 0xDB, 0xB1, 0xF5, 0x1A, 0x76, 0x2A, 0xF2, 
		0xAC, 0xA, 0x4B, 0xF9, 0x0, 0x23, 0x53, 0x12, 0x34, 0xB, 
		0x53, 0x6D, 0x9E, 0xF1, 0xF6, 0x1A, 0x7A, 0x73, 0x8f},
		/*TST_KeySize*/
		0xA0,
		/*TST_DPSize*/
		0x50,      
		/*TST_PubExponentSize*/
		3*sizeof(DxUint8_t),
		/*TST_input_data*/
		{0x6b, 0x3, 0x72, 0xc2, 0x38, 0x47, 0x2f, 0xb5, 0x2b, 0x67, 0x3b, 0x5f, 0x36, 0x35, 

		0xa3, 0x16, 0xab, 0x4c, 0x47, 0x3b, 0xbc, 0x24, 0x4, 0x9b, 0xbc, 0xdf, 0x4d, 0x4d, 0xda, 0x59, 0xb3, 

		0x48, 0xa7, 0x45, 0xd, 0x7a, 0x1c, 0x32, 0xed, 0xe, 0x5d, 0x2d, 0x16, 0x8c, 0xfb, 0x6d, 0xba, 0xad, 

		0x43, 0xdb, 0xe0, 0x78, 0x8a, 0xea, 0xdc, 0x47, 0xfe, 0xd7, 0x5, 0x59, 0xf9, 0xe2, 0xda, 0xd2, 0xb3, 

		0xf2, 0xb7, 0xf1, 0x27, 0x29, 0xfa, 0x78, 0x5e, 0x38, 0xdd, 0x8e, 0xd},
		/*TST_output_data*/
		{0},
		/*TST_Expected_output_data*/
		{0x2d,0x99,0x04,0x94,0x8a,0x57,0x89,0x78,0xed,0x8a,0xdd,0xea,0x63,0xf5,0xe5,0x50,
		0xea,0xb5,0x83,0x89,0xb6,0xcc,0xa9,0x84,0x73,0x1d,0x1f,0x02,0x04,0x37,0x53,0xce,
		0xd6,0xa4,0xa8,0x96,0x20,0x00,0xdd,0xb3,0x91,0x67,0xac,0xbc,0xd4,0x3d,0x22,0x95,
		0x1f,0x2a,0x6c,0x17,0x10,0x35,0xa8,0x7e,0x10,0xab,0x53,0xeb,0xb4,0xef,0x27,0xcf}
	}
};

TST_RSA_TestDataStruct TST_RSA_Acceptance_Primitive_TestData[] =
{
        /**********************************/
        /*  RSA EncryptDecrypt test data  */
        /**********************************/
    {
        {"Acceptance test - RSA - "},
        /*TST_PrivetExponent_D*/
        {0x1B,0x84,0x53,0x6D,0xBE,0xF2,0xF1,0x11,0x66,0xEA,0x12,0x73,0x84,0xB5,0x71,0xB1,
        0xF2,0xCA,0xC3,0x0C,0xDF,0x69,0xF4,0x50,0x0A,0x5C,0x42,0xF6,0x61,0x56,0x21,0xB2,
        0xA7,0x9D,0x52,0x6F,0xF8,0x60,0x01,0xA3,0x5B,0x04,0x11,0xB5,0x16,0xF9,0x0C,0x54,
        0xE3,0xCC,0xFC,0x35,0x95,0x12,0xED,0xE4,0x0F,0xDC,0xD3,0x2D,0xB0,0x55,0x73,0xF9,
        0x36,0xCC,0xEF,0xD9,0x37,0xE1,0x1F,0xFC,0x83,0x93,0x71,0x6A,0xF8,0x16,0xE3,0x21,
        0x18,0x63,0x39,0x33,0xA3,0xEE,0x0B,0x7A,0x70,0x78,0x5D,0x26,0xF3,0x8C,0xCF,0x1B,
        0x0D,0xA9,0x80,0x98,0xA1,0x08,0x62,0x53,0xDA,0xE5,0x3A,0xC4,0xAC,0x33,0xFE,0xA8,
        0xCE,0x25,0x20,0x3C,0x8F,0xBC,0x10,0x31,0xA5,0xB7,0x54,0x79,0xA3,0x15,0xAF,0xAB,
        0x9E,0xF4,0x18,0xE0,0x0E,0x01,0x4A,0x58,0x76,0x14,0x23,0xBA,0x6B,0xA4,0x6D,0xBD,
        0xEC,0x5B,0x17,0x9E,0x33,0x47,0x00,0x2D,0x5F,0xB9,0xB5,0x74,0x55,0x10,0x0B,0x7D,
        0x79,0x76,0xAA,0x0A,0x10,0xD3,0x43,0x1A,0x0C,0xFC,0xC1,0xBC,0x58,0xC5,0x4A,0x65,
        0x8C,0xEA,0x58,0x6F,0xFB,0x3D,0xA8,0xEE,0xFD,0xFA,0x4D,0xE3,0x19,0xB9,0xCE,0xB0,
        0x35,0x2F,0x46,0x36,0x9A,0xC7,0xB8,0x09,0x96,0x63,0x8B,0x86,0xEE,0x6B,0x5F,0x32,
        0x26,0x9A,0xBB,0xDF,0x59,0x0B,0x41,0xE5,0x94,0x6D,0x57,0x8D,0xC0,0xD1,0x4C,0x60,
        0x5D,0x11,0xCA,0xC3,0x50,0xC1,0x2A,0x63,0xFD,0xFA,0x19,0x0F,0x45,0x47,0xF2,0xD3,
        0x7A,0x3B,0xA0,0x02,0xDE,0xF3,0x9A,0x15,0x0B,0x64,0x3F,0x3C,0x87,0x70,0x28,0x09},
        /*TST_PublicExponent_E*/
        {0x01,0x00,0x01},
        /*TST_Modulus_N*/
        {0xB6,0xA5,0x18,0xBA,0x64,0xF1,0xF4,0xD3,0x53,0x8D,0x05,0x52,0x62,0x76,0x95,0xF7,
        0x6C,0x06,0x21,0xD1,0x3D,0x1D,0x8A,0xAB,0x47,0x0E,0xD6,0xC4,0x12,0x67,0x90,0x6D,
        0x9F,0x03,0x58,0x93,0x7A,0xCD,0x09,0x11,0x15,0xFF,0x61,0x13,0xAD,0xEA,0xBD,0x18,
        0xBF,0x38,0x99,0xA0,0x76,0xDD,0x7B,0x1A,0x91,0xC0,0xCC,0x5F,0xD0,0xCA,0x23,0x9F,
        0xDD,0x09,0x4A,0x4D,0xC2,0x20,0xE3,0xD3,0x1D,0xE0,0x45,0xED,0xBB,0xF6,0x5E,0x88,
        0x09,0xB8,0xF2,0xA7,0x05,0x22,0x56,0xB2,0x6E,0x9C,0x48,0x0F,0x93,0x21,0xF4,0xC7,
        0x48,0x22,0xDE,0xE0,0x6B,0x54,0xEE,0x43,0x5B,0x5E,0xF2,0x55,0x69,0xCB,0x06,0xC5,
        0x42,0xA8,0x6F,0x6D,0xB2,0xDF,0x82,0xCC,0x07,0xBC,0x05,0xDE,0x0E,0xDD,0x68,0x04,
        0xC3,0xF3,0xB7,0x43,0x43,0xB6,0x17,0xEB,0xE0,0x42,0x8C,0x23,0x18,0x09,0x26,0x10,
        0x71,0x7A,0x91,0x1D,0x8F,0xE2,0x20,0x97,0xA6,0x34,0x8D,0x4E,0x42,0xF7,0x69,0xA1,
        0x21,0x4D,0x1F,0xAC,0x1C,0xC3,0xC9,0x44,0x5C,0x56,0x34,0xF7,0x98,0x35,0x54,0xC4,
        0x73,0x7E,0x23,0xF9,0x8A,0x94,0xA0,0xB3,0x81,0xD2,0x90,0xFF,0x96,0x28,0x13,0x67,
        0x09,0xF8,0x27,0x51,0xF3,0x55,0xAF,0x4F,0x40,0xCD,0xEF,0xFA,0x1B,0xF3,0x01,0x8B,
        0x7B,0x18,0x3D,0x37,0x4C,0x57,0xFF,0x7D,0x11,0xA7,0x8B,0xB7,0x02,0xBD,0x67,0x68,
        0x57,0x8D,0x4E,0x44,0x4C,0xFD,0x88,0x13,0x0F,0xB6,0xC6,0x21,0x3A,0xCA,0xCB,0x4A,
        0xC6,0xDB,0xDB,0x14,0xF9,0x6E,0xED,0x7C,0x9A,0xE4,0xDD,0x23,0x71,0xE9,0x62,0x73},
        /*TST_P*/
        {0xD3,0x1F,0xD7,0xE2,0x39,0xE8,0x75,0x17,0x29,0x9B,0x56,0x9E,0x6B,0x5D,0xFF,0xB8,
        0xE6,0x00,0xF9,0x8E,0xD6,0xCF,0x37,0x23,0xC8,0x83,0x21,0xEC,0x5E,0x2F,0x81,0x95,
        0x63,0x96,0x01,0x62,0xE0,0x98,0xB3,0xED,0x86,0x0A,0xBF,0xA9,0x23,0xE1,0x9F,0x3F,
        0x46,0x55,0x77,0x00,0x04,0x8B,0xBD,0x50,0xB8,0xC3,0x25,0x18,0x21,0xB9,0x0C,0xFF,
        0x8B,0xA4,0x70,0x40,0xA3,0x04,0xEF,0x5A,0x97,0x7A,0x34,0x11,0x6E,0xDA,0x20,0xD9,
        0xF3,0xD5,0x36,0x92,0x56,0x32,0x70,0x67,0xDE,0x01,0x24,0xEF,0xC1,0xAF,0xD3,0x6E,
        0xF7,0xC2,0x96,0x36,0xAE,0x02,0x75,0xA9,0x97,0x31,0x18,0xA7,0x94,0x79,0x48,0x7D,
        0x7F,0x4B,0xF8,0x1D,0x95,0x0B,0x73,0x65,0x65,0x57,0xAA,0xAE,0xFC,0x32,0x61,0xF5},
        /*TST_Q*/
        {0xDD,0x77,0x90,0xF8,0x5F,0x33,0x1D,0xB5,0x40,0x9B,0x52,0x6B,0xEE,0x14,0x3B,0x9A,
        0x22,0x04,0xC1,0x27,0xAE,0x51,0x3F,0x4C,0x33,0x09,0x27,0x54,0x84,0xD9,0x09,0xF2,
        0x15,0x28,0x1D,0x64,0xED,0xDE,0x02,0xE3,0x51,0xA3,0x19,0xBC,0x7E,0xBD,0xF2,0x7A,
        0xE2,0x3B,0x20,0x7F,0xD8,0x63,0xD1,0xFD,0x26,0xD5,0x1F,0x61,0xA4,0xE5,0x09,0x57,
        0xA3,0x42,0xE2,0xEE,0x79,0xD5,0x97,0x0D,0x26,0xE4,0x0A,0x51,0x99,0x03,0x43,0x9C,
        0x5E,0x36,0x7D,0x96,0xD7,0x80,0x7F,0x3C,0x96,0x00,0xFE,0x2A,0xB6,0x12,0x46,0x47,
        0x2B,0xD4,0x3A,0xE5,0xEB,0xD1,0x4A,0x4C,0x8F,0x88,0xED,0x20,0x5D,0x17,0xE3,0x75,
        0x16,0xFA,0xD4,0xD7,0x1D,0x01,0xA4,0x8B,0x11,0x2F,0x57,0x21,0x84,0x73,0x29,0xC7},     
        /*TST_dP*/
        {0xA0,0x97,0xB9,0x44,0x68,0xDE,0x0C,0xAB,0x08,0xC8,0x13,0x54,0x3F,0xC1,0x69,0xB2,
        0x80,0xAA,0x3F,0x2A,0x4A,0xF5,0xA6,0x30,0xBE,0xE6,0x18,0x98,0xCE,0x6F,0xFE,0x76,
        0xDF,0x20,0x8C,0x7F,0x64,0xEE,0x62,0xF7,0x0B,0x1E,0x03,0xFA,0x29,0xC4,0x06,0xB9,
        0x3F,0xCB,0xE4,0xD0,0x0B,0xA5,0x2B,0xE5,0x4A,0x15,0x8E,0x92,0xD3,0x9C,0x0A,0x6A,
        0x1C,0x13,0x82,0x1B,0x78,0xA5,0x59,0x58,0x24,0x9F,0x1D,0x1A,0x21,0xA3,0x24,0x98,
        0x05,0x64,0xAA,0xB5,0x17,0x82,0x18,0x84,0xB9,0x97,0x4F,0x3C,0x5C,0xAD,0x5C,0xFC,
        0x2C,0xD4,0x44,0x24,0xE5,0xAA,0x13,0x4C,0x64,0x28,0x41,0x63,0xBF,0x89,0x9D,0xFD,
        0x70,0x26,0x1E,0x5E,0x8A,0x30,0x02,0xA0,0x1F,0x3D,0x57,0x24,0xF1,0xCB,0x75,0x3D},
        /*TST_dQ*/
        {0xD0,0x5C,0xBC,0xD5,0x20,0xE4,0x3B,0xB0,0x1A,0xEF,0xC7,0x34,0xEA,0x52,0xB8,0xDC,
        0xC3,0xE2,0xCB,0x43,0xA5,0x1A,0xA5,0xBD,0xF0,0x4A,0x4D,0x69,0x94,0x6F,0x8A,0x8E,
        0xEB,0x5E,0xC9,0x80,0xFA,0xD6,0xA4,0xCA,0xF0,0x34,0xCE,0x72,0xEC,0x9F,0x93,0x32,
        0x10,0x04,0xE7,0x07,0xC1,0x33,0xF1,0x0E,0x06,0xE9,0xFE,0xD3,0x64,0x4B,0x64,0x65,
        0xC2,0xA1,0x9C,0x56,0x17,0xE4,0x5F,0x70,0x2D,0x45,0xE1,0x7B,0x71,0xC5,0x83,0x67,
        0xEB,0xAF,0xC2,0xAB,0x17,0x67,0xBA,0xCD,0xEA,0xA7,0x56,0x7A,0x22,0xC0,0xC0,0xC4,
        0x17,0x35,0x5E,0x90,0x91,0x34,0x60,0x7D,0xF5,0x91,0x32,0xDF,0xFF,0x16,0x09,0x97,
        0x51,0x1E,0x7E,0xFF,0x40,0x38,0x1A,0x72,0x08,0xA2,0x0C,0x8C,0xE9,0x4B,0x5C,0x63},
        /*TST_Qinv*/
        {0xC1,0xFE,0xFB,0x08,0x6B,0x5B,0x8B,0xA8,0xA5,0x23,0xA9,0x3B,0xB6,0x44,0x54,0x73,
        0xFB,0x4A,0x18,0xAE,0xF1,0x01,0x14,0x48,0xFF,0x0A,0x11,0xA6,0x11,0x66,0xA1,0x04,
        0x84,0xF9,0x51,0x1A,0x53,0xDA,0x45,0x99,0x59,0xA2,0xC7,0x9E,0xFC,0xDB,0xB7,0x2D,
        0x73,0x18,0x23,0xB3,0xD6,0x11,0xB6,0x2C,0x87,0x59,0xDF,0x5E,0xDA,0xD7,0xA4,0x28,
        0x78,0x87,0x9F,0x34,0x38,0x43,0x72,0x81,0xE5,0x18,0x08,0x61,0x18,0xBC,0xD2,0x6F,
        0x64,0xFF,0x62,0xFA,0xDC,0xD9,0xD1,0x9A,0x42,0xBC,0x0A,0xE4,0xD0,0xEB,0x7E,0x2C,
        0xBC,0x72,0xA7,0x3F,0xE5,0xD9,0xE4,0x9A,0xA4,0xCD,0x82,0xE6,0x35,0x85,0xCE,0x04,
        0x11,0x73,0x11,0xF3,0xA9,0xEA,0x4C,0x14,0xEC,0xF7,0xB5,0x99,0xBF,0x5C,0x15,0x7D},
        /*TST_KeySize*/
        256*sizeof(DxUint8_t),
        /*TST_DPSize*/
        128*sizeof(DxUint8_t),      
        /*TST_PubExponentSize*/
        3*sizeof(DxUint8_t),
        /*TST_input_data*/
        {0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,
        0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,
        0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,
        0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,
        0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,
        0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,
        0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,
        0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,
        0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,
        0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,
        0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,
        0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,
        0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,
        0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,
        0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,
        0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77},
        /*TST_output_data*/
        {0},
        /*TST_Expected_output_data*/
        {0xa7,0xd2,0xdf,0xc9,0x8a,0x2b,0xe0,0x43,0xaf,0x0a,0xab,0x96,0xd6,0xc2,0xc3,0x6f,
        0xfd,0x8f,0x18,0x9f,0xb0,0x73,0xa6,0x3e,0x36,0x0f,0xdd,0xb1,0xfa,0xbe,0x27,0x90,
        0x8c,0xae,0x2e,0x3b,0x04,0xda,0xfd,0xb3,0x5f,0xe7,0x54,0x48,0x4a,0xc0,0x7b,0xf2,
        0x48,0x6c,0xf5,0xdb,0x5d,0x1a,0x6f,0xe4,0x30,0xa7,0x71,0x77,0x97,0x11,0xc8,0x62,
        0xc3,0xb7,0x01,0x8e,0xc1,0xac,0xc1,0xa7,0xd3,0x3e,0xec,0xda,0xe3,0xcc,0x03,0x86,
        0x62,0x06,0x30,0xb2,0xda,0x4b,0x9d,0x7c,0x50,0x99,0x21,0x2a,0xc7,0x1a,0xad,0xcf,
        0x56,0xbb,0x2d,0xdc,0xc4,0xfc,0xcf,0x35,0xb7,0xcb,0x4a,0x01,0xea,0x9f,0x2a,0x8a,
        0xd5,0x76,0x4a,0x71,0xf0,0x84,0x21,0x16,0x1a,0x16,0x00,0x00,0x00,0x00,0x00,0x00}
    },
    { 
        {"Acceptance test - RSA - "},
        /*TST_PrivetExponent_D*/
        {0x0C,0x64,0x7A,0xB7,0x54,0xC7,0x3D,0x76,0xAF,0x5D,0xB4,0x53,0x81,0xD8,0xED,0x0D,
        0xB4,0xC7,0xA7,0xC4,0x9C,0x1A,0x6D,0x90,0x66,0xE3,0xC2,0xC2,0x81,0x24,0xF0,0x2E,
        0x6C,0xB8,0xD8,0xAF,0x11,0x08,0xA7,0xD2,0x77,0xD6,0x22,0x2D,0xAC,0x47,0xD1,0x78,
        0x16,0x8B,0x5E,0xDB,0x24,0xE8,0x54,0xB2,0x9C,0x5F,0x56,0x8E,0xC2,0x20,0x2A,0x73,
        0x51,0x96,0x67,0xC1,0x12,0xF7,0x50,0x41,0x2F,0xA8,0x78,0xD3,0xC9,0x98,0x79,0x72,
        0x7A,0xDF,0x82,0x7A,0x4E,0x41,0xFF,0xD9,0x78,0x4E,0xFB,0xEA,0xD4,0x61,0xE9,0x03,
        0x2D,0x85,0x49,0x1C,0x3D,0x20,0x98,0x0A,0xF9,0x5F,0x21,0x73,0x3C,0x1A,0x98,0x8B,
        0x80,0xD6,0x0F,0xA2,0xEA,0x61,0x99,0xB7,0xF1,0x98,0x42,0x6B,0xC6,0xF7,0xE4,0x85},
        /*TST_PublicExponent_E*/
        {0x01,0x00,0x01},
        /*TST_Modulus_N*/
        {0xF2,0xB9,0x46,0xD3,0xE1,0x45,0x3E,0xD8,0x78,0x78,0x6A,0xC3,0x08,0x3B,0x74,0xC5,
        0x12,0x64,0xD1,0xE8,0x3F,0x46,0x66,0x70,0x8F,0x9C,0x05,0x0D,0x85,0x96,0x4A,0x76,
        0x27,0xAB,0x3C,0x14,0xF5,0x66,0x3D,0xEE,0x10,0x00,0x8F,0xEC,0x17,0x8F,0x3D,0xF7,
        0xF3,0x60,0x94,0x58,0x8B,0x4E,0x6F,0xEF,0x6B,0x8D,0xB7,0x9A,0xF5,0xAF,0xD6,0x95,
        0xFA,0x0B,0xE6,0x47,0x84,0x1A,0x4B,0x18,0xE4,0xEC,0x95,0xF4,0x15,0x42,0x2A,0x4D,
        0xEC,0xF8,0x76,0x12,0x6D,0xAB,0x64,0x51,0xF0,0xE9,0x0C,0xC9,0x65,0x55,0x06,0x68,
        0x49,0xFE,0xF3,0x8D,0x13,0xDE,0x4A,0x6E,0x97,0x63,0x39,0xDD,0xE9,0xBF,0x98,0xAA,
        0xC3,0x34,0x23,0x65,0x99,0x82,0x46,0x9F,0x11,0x1C,0x55,0x1F,0xE6,0x72,0x15,0x7F},
        /*TST_P*/
        {0xF4,0x24,0x83,0xBD,0x3E,0xBE,0x38,0xFB,0x32,0x87,0x60,0x77,0x45,0x8C,0xA6,0xD1,
        0x9F,0xD3,0x26,0x4E,0xD4,0x83,0xBB,0xA0,0xC2,0xBC,0x3F,0x59,0x6E,0x49,0x1A,0x5F,
        0xA1,0x7D,0xC5,0xCA,0x97,0xCA,0x8C,0x12,0x7A,0xD6,0x2B,0x9D,0xA8,0x52,0x4C,0x21,
        0xCF,0x0F,0x48,0x60,0xDD,0x1F,0x42,0x4F,0xCA,0x5D,0xC5,0xC1,0x8F,0x80,0xC9,0x83},
        /*TST_Q*/
        {0xFE,0x83,0x1E,0xDC,0xA3,0xF4,0x11,0x17,0x77,0xD7,0x85,0x80,0xE9,0x12,0x99,0x6C,
        0xF3,0x22,0x87,0xCB,0x76,0xFD,0xF4,0x31,0xF1,0xA9,0x23,0xF4,0xE7,0x8C,0x50,0x91,
        0x2C,0xFB,0x22,0x9E,0x0F,0xBA,0xA6,0x56,0xEF,0xD0,0xC8,0x7B,0x54,0x0F,0xA4,0x4C,
        0x8F,0x49,0xEB,0xE8,0x44,0xF1,0x9E,0xBF,0x05,0xA5,0x62,0x29,0x88,0x35,0x8F,0x55},     
        /*TST_dP*/
        {0x9A,0x49,0x19,0x17,0xD7,0x36,0xCF,0x3B,0xAF,0xCA,0xED,0xA3,0x72,0x48,0x58,0x83,
        0xD0,0xC4,0xD7,0x48,0xA9,0xF4,0x35,0xF6,0x7A,0x1A,0x0C,0xCE,0xAF,0x6B,0x73,0x47,
        0x4B,0xFE,0xF7,0xA7,0xF8,0x15,0x00,0x40,0x0D,0x70,0x9B,0x4F,0x9E,0xB7,0xA3,0x75,
        0x1A,0x2D,0x46,0x48,0x30,0x75,0x38,0xAA,0xC3,0xF0,0x4E,0xB0,0xEB,0xC7,0x2F,0x91},
        /*TST_dQ*/
        {0x72,0x84,0x2C,0xEE,0xBA,0x16,0xA7,0x5A,0x17,0xE2,0x31,0x7F,0xBF,0x5F,0x4F,0x09,
        0x66,0x9C,0xB2,0xDD,0x29,0xBD,0x3A,0x92,0xFE,0x59,0x4C,0x84,0x75,0x6A,0xFD,0x15,
        0x55,0x57,0xEA,0x4B,0x94,0x68,0x37,0x50,0x06,0xB7,0xBA,0x7D,0x43,0x65,0x86,0x57,
        0xAC,0x61,0x66,0x74,0x2C,0x11,0x4B,0x8C,0x47,0xCE,0x12,0x4C,0xFD,0xAC,0x9B,0xC1},
        /*TST_Qinv*/
        {0xCD,0x55,0xCB,0x06,0xBD,0xD6,0xCD,0xC3,0xCF,0xE8,0xBF,0xB1,0x98,0x1F,0x15,0x79,
        0x0A,0x17,0xA6,0xAC,0x78,0x08,0x6B,0xBF,0x21,0x87,0x60,0x51,0x9D,0x87,0x55,0xC0,
        0xB3,0xC8,0x2D,0x83,0xFE,0x17,0xFB,0xB0,0x96,0x55,0x60,0x7B,0xBC,0x10,0x87,0x95,
        0x7B,0x8E,0xB1,0x7D,0xC4,0xDA,0xF2,0xAA,0x36,0x4D,0x35,0xCC,0x2A,0xCF,0x53,0xF9},
        /*TST_KeySize*/
        128*sizeof(DxUint8_t),
        /*TST_DPSize*/
        64*sizeof(DxUint8_t),      
        /*TST_PubExponentSize*/
        3*sizeof(DxUint8_t),
        /*TST_input_data*/
        {0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,
        0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,
        0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,
        0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,
        0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,
        0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,
        0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,
        0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77,0x77},
        /*TST_output_data*/
        {0},
        /*TST_Expected_output_data*/
        {0xa7,0xd2,0xdf,0xc9,0x8a,0x2b,0xe0,0x43,0xaf,0x0a,0xab,0x96,0xd6,0xc2,0xc3,0x6f,
        0xfd,0x8f,0x18,0x9f,0xb0,0x73,0xa6,0x3e,0x36,0x0f,0xdd,0xb1,0xfa,0xbe,0x27,0x90,
        0x8c,0xae,0x2e,0x3b,0x04,0xda,0xfd,0xb3,0x5f,0xe7,0x54,0x48,0x4a,0xc0,0x7b,0xf2,
        0x48,0x6c,0xf5,0xdb,0x5d,0x1a,0x6f,0xe4,0x30,0xa7,0x71,0x77,0x97,0x11,0xc8,0x62,
        0xc3,0xb7,0x01,0x8e,0xc1,0xac,0xc1,0xa7,0xd3,0x3e,0xec,0xda,0xe3,0xcc,0x03,0x86,
        0x62,0x06,0x30,0xb2,0xda,0x4b,0x9d,0x7c,0x50,0x99,0x21,0x2a,0xc7,0x1a,0xad,0xcf,
        0x56,0xbb,0x2d,0xdc,0xc4,0xfc,0xcf,0x35,0xb7,0xcb,0x4a,0x01,0xea,0x9f,0x2a,0x8a,
        0xd5,0x76,0x4a,0x71,0xf0,0x84,0x21,0x16,0x1a,0x16,0x00,0x00,0x00,0x00,0x00,0x00}
    },
    { 
        {"Acceptance test - RSA 512bit "},
        /*TST_PrivetExponent_D*/
        {0xa8,0xd6,0xfa,0x2b,0x47,0xde,0x8c,0x36,0x04,0x2a,0x32,0x55,0x7c,0xf5,0xde,0x2e,
         0xe3,0xc1,0x62,0x72,0x83,0x55,0x27,0x76,0x9f,0x6b,0xe0,0xfa,0x9a,0x26,0x03,0x9b,
         0x41,0x1f,0xd6,0xbc,0x3d,0x77,0xd0,0x5f,0xb0,0x71,0x00,0xf6,0x27,0xa7,0x55,0xf8,
         0xb4,0xc7,0x5a,0x31,0xeb,0xce,0x51,0x19,0x94,0x21,0xa6,0xac,0xb8,0xf5,0xbb,0x01},
        /*TST_PublicExponent_E*/
        {0x01,0x00,0x01},
        /*TST_Modulus_N*/
        {0xbb,0x3d,0xf1,0x3f,0x1d,0xcf,0xc6,0xfa,0x13,0x56,0xb3,0x95,0x53,0xcf,0xbd,0x10,
         0xf4,0x75,0xfe,0x7d,0xf6,0x89,0xa1,0x06,0x94,0x67,0xd4,0x5c,0xb7,0x89,0xbe,0xed,
         0xe2,0x49,0x51,0x6b,0xf0,0xd2,0x7c,0xef,0x67,0xbb,0xf6,0x9a,0x8b,0x67,0x51,0xe8,
         0xc0,0xbf,0x52,0xbc,0x2f,0x10,0xc1,0x85,0x77,0x18,0x60,0x52,0x67,0x94,0xd7,0x57},
        /*TST_P*/
        {0xf4,0xab,0x4e,0xda,0x43,0xf4,0xcd,0x34,0xb1,0xd8,0xf4,0xd6,0x97,0xea,0x6f,0x07,
         0xc8,0xfd,0xa6,0x28,0x33,0x4c,0xaf,0x60,0x9b,0x0c,0x48,0x79,0x0a,0xb0,0x14,0xb1},
        /*TST_Q*/
        {0xc3,0xe9,0xcd,0x5a,0xef,0xa1,0x27,0x15,0xbf,0x34,0xc0,0xca,0x41,0x79,0x39,0x19,
         0xf6,0xd2,0x12,0x14,0x14,0x29,0x8e,0x36,0x06,0xa8,0xd3,0xe5,0x90,0x2c,0x4e,0x87},     
        /*TST_dP*/
        {0x40,0xa1,0x80,0x12,0xe8,0x20,0xa2,0x94,0x68,0xe6,0x86,0xc6,0xa9,0x1a,0xa4,0x79,
         0xc9,0xfe,0x37,0x06,0x27,0x86,0xfa,0x4c,0xea,0xa8,0x33,0xfc,0xc5,0x75,0xfe,0x01},
        /*TST_dQ*/
        {0x59,0x58,0x87,0x0e,0xb1,0xba,0x0c,0xd9,0x1e,0x1a,0x30,0xd2,0x0c,0x89,0xfc,0x40,
         0x9b,0x0f,0xb2,0xae,0xf5,0x82,0xfe,0x18,0x25,0x71,0x59,0x31,0x98,0x4e,0x9c,0x81},
        /*TST_Qinv*/
        {0xa5,0x61,0xd2,0x0d,0x6d,0xe7,0x20,0xa5,0xaf,0x9b,0x59,0x8c,0x98,0xa4,0x6a,0x4a,
         0xaf,0x76,0xab,0x60,0x57,0xd4,0xdc,0x71,0xb5,0x1d,0xf2,0xac,0x22,0x0a,0xb6,0xf5},
        /*TST_KeySize*/
        64*sizeof(DxUint8_t),
        /*TST_DPSize*/
        32*sizeof(DxUint8_t),      
        /*TST_PubExponentSize*/
        3*sizeof(DxUint8_t),
        /*TST_input_data*/
        {0x41,0x1f,0xd6,0xbc,0x3d,0x77,0xd0,0x5f,0xb0,0x71,0x00,0xf6,0x27,0xa7,0x55,0xf8,
         0xb4,0xc7,0x5a,0x31,0xeb,0xce,0x51,0x19,0x94,0x21,0xa6,0xac,0xb8,0xf5,0xbb,0x01,
         0xa8,0xd6,0xfa,0x2b,0x47,0xde,0x8c,0x36,0x04,0x2a,0x32,0x55,0x7c,0xf5,0xde,0x2e,
         0xe3,0xc1,0x62,0x72,0x83,0x55,0x27,0x76,0x9f,0x6b,0xe0,0xfa,0x9a,0x26,0x03,0x9b},
        /*TST_output_data*/
        {0},
        /*TST_Expected_output_data*/
        {0x2d,0x99,0x04,0x94,0x8a,0x57,0x89,0x78,0xed,0x8a,0xdd,0xea,0x63,0xf5,0xe5,0x50,
         0xea,0xb5,0x83,0x89,0xb6,0xcc,0xa9,0x84,0x73,0x1d,0x1f,0x02,0x04,0x37,0x53,0xce,
         0xd6,0xa4,0xa8,0x96,0x20,0x00,0xdd,0xb3,0x91,0x67,0xac,0xbc,0xd4,0x3d,0x22,0x95,
         0x1f,0x2a,0x6c,0x17,0x10,0x35,0xa8,0x7e,0x10,0xab,0x53,0xeb,0xb4,0xef,0x27,0xcf}
    },
    { 
        {"Acceptance test - RSA 1024bit "},
        /*TST_PrivetExponent_D*/
        {0x0e,0x85,0x98,0x0c,0x64,0xed,0x94,0x26,0x69,0x65,0x35,0x7b,0x14,0x8d,0x78,0x58,
         0x1f,0xcc,0xaf,0x34,0x9d,0xbb,0x97,0x5d,0xdb,0xd4,0x54,0xbf,0xd3,0x14,0x30,0xf7,
         0xbc,0xad,0x1f,0x90,0x8f,0xf6,0xa4,0xad,0xec,0x59,0x63,0x6f,0xd0,0xb5,0x4b,0xc8,
         0x14,0x61,0x41,0x84,0x7a,0x1b,0xbf,0x74,0xa7,0x83,0x82,0x12,0x6a,0x78,0x2c,0xb3,
         0xd7,0xe3,0x72,0xfd,0x8c,0x14,0x6b,0x8d,0x0c,0xa4,0x78,0x16,0x78,0x13,0x23,0xe6,
         0x00,0xe7,0x29,0xc5,0xc9,0xe7,0xa7,0x88,0x4d,0x9a,0x35,0x16,0xf9,0xb8,0x10,0x76,
         0xdf,0x9b,0xbb,0x1d,0x3e,0xdf,0x80,0x67,0xf1,0x0f,0xe7,0xc7,0x2a,0x14,0x70,0x30,
         0x09,0xd0,0x38,0xd3,0x95,0xe7,0x2f,0x37,0x76,0x78,0xc1,0xf9,0xaf,0x1a,0x81,0xa1},
        /*TST_PublicExponent_E*/
        {0x01,0x00,0x01},
        /*TST_Modulus_N*/
        {0xe6,0xf1,0x8f,0xaf,0x4d,0xb6,0x24,0xa6,0x94,0x71,0xfb,0xeb,0x01,0x56,0xb6,0xdb,
         0xca,0xdf,0xf2,0x2a,0x6c,0xb9,0x6f,0xd8,0x70,0xf2,0x8e,0x44,0x32,0xb1,0x0c,0x1b,
         0xee,0xa8,0xdc,0x03,0x33,0x72,0xe6,0xc0,0x83,0xa7,0x47,0x34,0x01,0x10,0x1e,0xa6,
         0x1f,0x04,0xe6,0xb3,0x41,0xec,0x97,0x59,0xf2,0xf6,0xf7,0x7c,0x16,0xc5,0xdd,0x97,
         0xf5,0xdb,0x6c,0x60,0xbd,0x53,0xbc,0xa9,0xbd,0xd7,0xae,0xbf,0x70,0xf3,0x38,0xf4,
         0xb4,0x5a,0x25,0x9c,0xcf,0xf1,0x2f,0xaf,0xdb,0x5d,0x43,0x5a,0xeb,0x07,0x5d,0xa7,
         0xd8,0x44,0xa1,0x50,0x2a,0x98,0xba,0xba,0x81,0xc1,0x61,0x87,0x09,0x3b,0x54,0x8c,
         0x20,0xde,0xc3,0x62,0x64,0xcf,0xc0,0x3f,0xe7,0x97,0xa7,0x7d,0x65,0x8e,0x31,0xeb},
        /*TST_P*/
        {0xff,0x33,0xf2,0x64,0x08,0xeb,0x67,0xb4,0xf8,0xec,0xa8,0x0a,0x19,0x60,0xb3,0xaa,
         0x9b,0x3d,0x03,0x65,0x43,0x4e,0x93,0xb6,0x20,0x38,0xe5,0xc1,0x1a,0xca,0xc0,0xb0,
         0xf2,0x6d,0x78,0xbf,0x18,0x5d,0x3d,0xa6,0xd3,0x31,0xe8,0xc8,0x36,0xc7,0xf6,0xb2,
         0xfd,0x5a,0x02,0x28,0x08,0xdc,0x57,0xb6,0x44,0x5d,0x3a,0x70,0x7d,0xfa,0x49,0x91},
        /*TST_Q*/
        {0xe7,0xaa,0x37,0xa4,0x6d,0x38,0x16,0x3f,0x3d,0x76,0x61,0x48,0xce,0x8e,0xdb,0x71,
         0x2f,0x37,0xed,0x8a,0x9f,0xfd,0x47,0x4e,0xb4,0x37,0x05,0x60,0xbc,0x7a,0xd8,0xca,
         0x6a,0x2e,0xb4,0x37,0x3e,0xc9,0xea,0x12,0x49,0x40,0x37,0x24,0x36,0x4d,0xb4,0x6a,
         0x40,0xc2,0xe5,0xe4,0x26,0xf9,0xdc,0x8a,0x07,0x9a,0x10,0x76,0x81,0x50,0xa5,0xbb},     
        /*TST_dP*/
        {0x4a,0x3a,0x5b,0xc8,0x48,0xe7,0xdf,0x94,0x3d,0xca,0xe7,0xdd,0x78,0x20,0x2e,0x61,
         0xf3,0x21,0x3d,0xf9,0x98,0x28,0x24,0xc2,0x96,0x80,0xb6,0x23,0x02,0x9d,0xf2,0x8a,
         0x05,0x19,0x5e,0x43,0x86,0xdc,0xa7,0xef,0xfc,0x01,0xca,0x49,0x61,0xd5,0xab,0xa5,
         0xc8,0x17,0x04,0x05,0x8c,0xfe,0x39,0xec,0xe3,0xd9,0x92,0x03,0xe2,0x40,0x88,0x61},
        /*TST_dQ*/
        {0x36,0x0b,0x6e,0xc9,0xac,0x35,0x2e,0x73,0x78,0x6a,0x3a,0x8d,0xda,0xaa,0x57,0x25,
         0x53,0x87,0xaf,0xa1,0xec,0x6b,0x11,0x0c,0x9a,0x5c,0x4f,0xa3,0xde,0xb4,0xa6,0x08,
         0xaa,0xb6,0xd4,0x92,0x22,0xd2,0xc6,0x09,0x98,0x0f,0x24,0x0e,0x0d,0xa1,0x19,0x1a,
         0xc4,0x9a,0xf3,0x38,0xc3,0xa2,0xfc,0xc1,0x32,0xbe,0xcd,0x62,0x68,0x0e,0xa1,0x6b},
        /*TST_Qinv*/
        {0x3e,0xd1,0x50,0xec,0x76,0x0d,0xc9,0x46,0x57,0x0a,0xc9,0x73,0x16,0xdd,0x38,0x03,
         0x9d,0x36,0x61,0x19,0x08,0x6d,0x07,0x99,0xe6,0x97,0xfb,0x85,0x82,0x1d,0x00,0x7e,
         0xbe,0x17,0x7c,0x87,0xa7,0xb7,0xb2,0xaa,0x40,0x22,0xa5,0x53,0x52,0xc8,0x0b,0xf1,
         0x79,0x3a,0x24,0xa7,0xc9,0xcb,0x22,0xda,0x9a,0x17,0xc1,0x78,0xdd,0x9d,0x16,0x7d},
        /*TST_KeySize*/
        128*sizeof(DxUint8_t),
        /*TST_DPSize*/
        64*sizeof(DxUint8_t),     
        /*TST_PubExponentSize*/
        3*sizeof(DxUint8_t),
        /*TST_input_data*/
        {0x98,0x62,0xed,0xc7,0x71,0x65,0x13,0xfb,0x51,0x62,0x3e,0xa5,0xfd,0xee,0xe3,0x8f,
         0x68,0x89,0xc7,0x74,0xed,0x81,0xce,0x57,0x8f,0x12,0xe1,0x08,0x84,0xdf,0x5e,0x44,
         0x69,0xba,0x6b,0x1a,0x3d,0x5c,0xe6,0x3e,0x82,0x51,0xd1,0x9f,0x07,0x74,0x48,0x20,
         0x4b,0x2b,0x4e,0x78,0x07,0x90,0xdd,0xfc,0x47,0x6b,0x99,0xe0,0xbb,0x94,0xd7,0x45,
         0x7f,0xb7,0xe3,0xca,0x94,0xb8,0x8e,0x7b,0x89,0x62,0xba,0x10,0x7d,0x7b,0x6d,0xb9,
         0x74,0x92,0xfa,0xcd,0xb4,0x26,0x22,0x91,0x74,0x41,0xe0,0xff,0xe3,0x63,0xe2,0x12,
         0xe4,0x2f,0x78,0x6a,0xb2,0x45,0x18,0x1e,0x81,0x58,0x07,0xc7,0x94,0xef,0x30,0x19,
         0x4c,0x1f,0x0c,0x44,0x45,0x83,0x43,0x4b,0xe2,0xce,0x0d,0xe4,0x71,0xe5,0x56,0x9d},
        /*TST_output_data*/
        {0},
        /*TST_Expected_output_data*/
        {0x65,0x8f,0xdc,0xcc,0x47,0x1f,0x35,0x16,0xa0,0xd8,0xde,0x08,0xc1,0x02,0xd7,0x7d,
         0x90,0x24,0x3f,0xb2,0x28,0xff,0x80,0xa9,0x46,0xc0,0xc4,0x3f,0x79,0x28,0x3c,0x6c,
         0x21,0x8f,0xa7,0xbf,0x90,0x14,0x68,0xc6,0x9a,0xfb,0x54,0x78,0x5d,0xab,0x4b,0x6e,
         0x0b,0x35,0x24,0x89,0x55,0x9e,0x93,0x44,0x23,0x06,0xd8,0xd5,0x19,0xf2,0x0b,0x97,
         0xf4,0x86,0x8e,0x7b,0x28,0x33,0x33,0x56,0x58,0x19,0xee,0xa5,0x75,0x17,0x22,0x2c,
         0x50,0xad,0xd5,0x8b,0xa0,0x42,0xea,0x98,0x96,0xc0,0x01,0x0e,0xa5,0xdf,0x67,0x41,
         0x9a,0x10,0x71,0x1b,0xd4,0xeb,0x4d,0xeb,0xe9,0xce,0xbe,0xc3,0x1e,0x35,0xcc,0x6e,
         0x58,0xd9,0x3b,0xe3,0x52,0x88,0xbb,0x0e,0x04,0x02,0xbd,0x7c,0xfe,0xa5,0x6f,0xf5}
    },
    { 
        {"Acceptance test - RSA 2048bit "},
        /*TST_PrivetExponent_D*/
        {0x0c,0x5b,0xc0,0x19,0x59,0xe7,0xcf,0x70,0x62,0xf8,0x19,0xa6,0xc9,0xcc,0xa4,0x6a,
         0xcd,0x12,0x0b,0x30,0xda,0xfc,0x68,0x51,0x18,0xc4,0x87,0x06,0x57,0x8f,0xaf,0x97,
         0x6f,0x96,0x20,0xa9,0x83,0x1c,0xb2,0x69,0xc4,0xaf,0xe6,0xf3,0x9f,0x23,0xf9,0x92,
         0x41,0x7c,0x83,0xd2,0x73,0xfb,0xe9,0xa7,0x5d,0x55,0xe7,0xb4,0xd7,0x13,0xb0,0x17,
         0xce,0x40,0xbb,0x14,0xe0,0x93,0x1f,0xb2,0x2c,0xf1,0x1f,0x01,0x86,0x2f,0x3d,0x22,
         0xa4,0x47,0xbb,0x9d,0x02,0x39,0xae,0x9d,0x1a,0x1f,0xed,0x4a,0xf3,0xc4,0x17,0xa8,
         0x05,0x8b,0x3d,0x04,0x62,0x99,0x91,0x91,0x3f,0xac,0x1f,0x15,0xb3,0x9f,0x06,0x1b,
         0x05,0xe9,0xa6,0x4f,0xec,0xc8,0x35,0x9d,0xc3,0x8f,0x82,0x26,0xc8,0x6e,0x94,0x8c,
         0x8a,0x29,0x42,0x10,0x91,0x72,0xf7,0x6c,0xe3,0xb0,0x07,0x0b,0x2f,0xff,0x33,0x84,
         0xc3,0x5a,0xc2,0x13,0x15,0xd3,0xe2,0xdb,0x98,0x2f,0x44,0xba,0x34,0xcb,0xbe,0x63,
         0x6b,0x73,0x36,0xe5,0x27,0x11,0x70,0x6d,0x7a,0xb2,0x74,0x34,0xb6,0x8f,0xe9,0x09,
         0x57,0x67,0xc8,0x50,0x1c,0x7e,0x7b,0xe6,0xd4,0xb8,0xaf,0x7c,0xbe,0x2d,0x16,0x0f,
         0x76,0x44,0x3a,0xfe,0x8d,0x6d,0xc8,0xec,0xa9,0xd5,0x48,0x1f,0xbb,0x85,0x50,0x3f,
         0xef,0xbd,0x8b,0xfd,0x9f,0xf1,0xb8,0x00,0x09,0x67,0x49,0x74,0xc5,0xe9,0xf2,0xd5,
         0x26,0xf1,0x93,0x59,0x73,0xf7,0x84,0x98,0xa5,0xa3,0x25,0xbe,0x73,0xc8,0x1c,0xb4,
         0x1c,0xef,0xbb,0x20,0x59,0x4f,0x3a,0x74,0x92,0xda,0x15,0x76,0xa4,0x12,0xb0,0x21},
        /*TST_PublicExponent_E*/
        {0x01,0x00,0x01},
        /*TST_Modulus_N*/
        {0xb5,0x84,0x8f,0x09,0xa3,0x94,0xac,0x97,0x25,0x17,0x54,0x46,0x6c,0x49,0xcb,0x69,
         0xff,0x21,0x68,0x03,0x1b,0xb9,0xf6,0xe8,0x14,0x84,0xa2,0xa5,0x62,0x39,0x8d,0xe4,
         0x2f,0x22,0xc8,0x53,0xc0,0x8e,0x9a,0x5c,0x6f,0x2b,0xb2,0xa2,0x24,0x77,0x60,0xa1,
         0x47,0xa5,0x6c,0xd5,0xe0,0x77,0x33,0x7a,0xd5,0xf5,0xf6,0x4a,0x0e,0x7d,0x06,0xbd,
         0xb2,0x3b,0x83,0xef,0xaf,0xad,0x65,0xda,0xdb,0xd0,0x7d,0xea,0x09,0x73,0xf8,0x4e,
         0x1b,0xe7,0xaa,0xe6,0x84,0x57,0xb6,0xf3,0x88,0xf3,0xb0,0x4d,0x2b,0xa9,0xe8,0x23,
         0xa3,0xee,0x3f,0x16,0xd0,0x08,0x80,0x38,0x11,0x4a,0x66,0x3a,0xad,0x14,0x68,0xc4,
         0x37,0xce,0x36,0x7a,0xf4,0xe0,0x95,0x0d,0xf3,0xae,0x2b,0x46,0xb7,0xac,0x4a,0x8a,
         0xa0,0xe1,0x78,0xd1,0x38,0xa9,0x36,0xdb,0x3d,0xde,0x04,0xa2,0x35,0x79,0x1f,0xc5,
         0x13,0x39,0xf8,0x5b,0xf3,0x5a,0xb5,0xcb,0xf9,0x8f,0x1c,0xf8,0xad,0x09,0x0f,0x03,
         0x04,0xf3,0xcc,0x02,0x4c,0xa8,0x6d,0xe1,0x0a,0x3f,0x71,0x75,0x69,0xf4,0xd3,0xe6,
         0xa8,0x2c,0x92,0x0b,0xb5,0x6d,0x7d,0xf9,0x61,0x68,0x42,0xd7,0xbe,0xde,0x32,0x9f,
         0xfb,0x7a,0x23,0x2d,0xc5,0x22,0x3d,0x90,0xc3,0x38,0x12,0x5e,0xb0,0x9b,0xc0,0x5c,
         0x7b,0x5d,0x4f,0x7a,0xec,0x65,0xb6,0xe1,0x24,0xfa,0x00,0x15,0xe3,0x5e,0x4f,0x80,
         0x2e,0x79,0xe7,0x29,0xdc,0x4d,0xa2,0x15,0x68,0xe7,0x83,0xc9,0x40,0xfc,0x89,0xa9,
         0x6a,0x47,0xff,0xbc,0x39,0x6d,0x0a,0x75,0xe1,0x6e,0x17,0x39,0x5f,0x1e,0x4f,0xdf},
        /*TST_P*/
        {0xf1,0x4b,0x87,0x28,0x1c,0xbf,0x5e,0x14,0xeb,0x6d,0x33,0x42,0x80,0x95,0xe4,0xd5,
         0x58,0xa8,0xa7,0x1a,0xf9,0xae,0x93,0xc7,0xba,0x00,0x31,0x02,0x5c,0x49,0xa8,0xa1,
         0x04,0x36,0xa9,0x35,0x6d,0xc8,0x25,0x7e,0x79,0x96,0x2a,0xca,0x3a,0x13,0xd5,0x3f,
         0xa6,0xf8,0x04,0xd0,0xf1,0x5a,0xf3,0x8d,0x6e,0x09,0xdb,0x25,0x3d,0x3c,0xe2,0x72,
         0xce,0x88,0x66,0xca,0xf3,0x3d,0x70,0x96,0x96,0xf1,0xef,0x45,0xde,0x11,0x4e,0x6a,
         0xb6,0x5d,0x9d,0xd4,0xdd,0x3e,0x16,0xb2,0x54,0xcc,0xf8,0xbe,0x6a,0x02,0x2d,0x73,
         0x8e,0x4a,0xa7,0x49,0xc0,0xb9,0xc2,0x26,0x93,0xd4,0x03,0xff,0x27,0x3a,0x57,0xa7,
         0xed,0xfd,0xdf,0x20,0xdb,0x7e,0x47,0xed,0x32,0xb5,0x20,0x8e,0xd4,0x1f,0xb6,0x07},
        /*TST_Q*/
        {0xc0,0x94,0x70,0x77,0x38,0xdb,0x39,0x48,0xf4,0x69,0x16,0x7f,0x16,0x66,0x69,0xde,
         0xb2,0x37,0xf6,0x62,0x24,0x88,0x2d,0x85,0x64,0xaf,0xcd,0x3d,0x7c,0x5a,0xb2,0xf7,
         0x86,0xf4,0xc4,0xaf,0xd7,0x7f,0x94,0x86,0x2f,0xd1,0x9d,0x77,0x0c,0x45,0x89,0x31,
         0xd2,0xab,0x19,0xea,0x48,0x39,0xfd,0xaa,0xae,0x6f,0x08,0x08,0x03,0x13,0x03,0x7e,
         0x83,0x23,0x01,0x30,0x6b,0xfa,0xb2,0x71,0xec,0xd2,0x79,0x8e,0xcd,0x6e,0x93,0x26,
         0x35,0x98,0x52,0x92,0x36,0x34,0xd3,0x24,0xfa,0xab,0xc6,0x46,0xdf,0x36,0xae,0xc7,
         0xca,0x5e,0x9f,0x83,0xe3,0xfc,0x08,0x50,0x77,0xe9,0xe1,0xb0,0xff,0x90,0x5e,0x0e,
         0x3e,0x38,0x73,0xe8,0x91,0x04,0xeb,0x65,0x26,0x98,0x5b,0x7c,0xab,0xbc,0x61,0x69},     
        /*TST_dP*/
        {0x12,0x47,0xbb,0x8c,0x91,0x68,0xfa,0x12,0xb1,0xa7,0x4b,0x3b,0xdd,0x8b,0xfd,0x93,
         0x20,0x2d,0x5e,0xc3,0x8f,0x68,0xe7,0x6f,0x39,0x2b,0x2c,0x8b,0x56,0x3c,0x8a,0x56,
         0xf0,0x7f,0xc7,0x9f,0xf1,0x9a,0x39,0x24,0xf4,0xc7,0x28,0xa4,0xbb,0x73,0xa7,0x33,
         0x34,0x4e,0x13,0xe7,0x54,0x71,0xa4,0x83,0xf1,0x73,0x33,0xb4,0x05,0x88,0xa8,0x4b,
         0x34,0x54,0x67,0x1d,0x37,0x02,0x4f,0x96,0x49,0x07,0x39,0x2e,0x5c,0xdd,0x88,0xc8,
         0x52,0xda,0x92,0xcb,0x7e,0x9b,0x66,0x92,0xca,0x13,0xe1,0x40,0x63,0xbd,0x98,0x7d,
         0xe9,0xa8,0xc4,0x35,0xb5,0x31,0x1d,0x81,0x58,0xaf,0xb6,0x41,0xcd,0x52,0x01,0x34,
         0x0a,0xb6,0xb2,0x01,0xc6,0x3f,0x31,0xe9,0xc9,0x6e,0xa9,0x71,0xc8,0xa6,0x42,0x5f},
        /*TST_dQ*/
        {0x3a,0x05,0xff,0x84,0xcc,0x6a,0xb0,0xed,0xdc,0x46,0x35,0x73,0x01,0x2a,0xc6,0x47,
         0x44,0xe7,0x3b,0xa3,0x02,0x62,0xcd,0x64,0x5d,0x9b,0xe2,0x78,0xde,0x18,0xed,0xc7,
         0x4a,0xb0,0x40,0xfa,0xc2,0x31,0x3c,0x6c,0xd9,0xc7,0x8c,0x6c,0x2c,0x14,0x5f,0x6b,
         0xd5,0x8f,0x9b,0xf5,0x4c,0xe1,0xbc,0x1e,0x4b,0x04,0x45,0x25,0x34,0xd7,0xeb,0xbb,
         0x98,0x83,0x59,0x7e,0x5f,0x6a,0x5f,0x8d,0x97,0xcf,0x2a,0xb4,0xee,0x0c,0x9c,0xe5,
         0x6c,0x4c,0x82,0xc4,0x6e,0xf4,0xa7,0x91,0x82,0xbd,0x72,0xb6,0x33,0xd6,0xe3,0xfe,
         0x6a,0x68,0xec,0x22,0xee,0xf4,0x27,0x05,0x27,0xbc,0x1e,0x36,0x18,0x2a,0x45,0x4c,
         0x81,0x4e,0xbd,0x0d,0x9b,0x74,0x22,0x00,0x8e,0x0a,0x65,0xb6,0x40,0x80,0x37,0xd1},
        /*TST_Qinv*/
        {0x33,0x78,0x62,0x66,0x02,0x52,0xda,0xf3,0xca,0xa1,0xef,0xc0,0xc4,0xae,0x13,0x10,
         0x9b,0xc7,0xe8,0x50,0x12,0x0c,0x77,0xe0,0x96,0x8d,0x23,0xd4,0xd7,0x13,0xa3,0xae,
         0xc7,0xcd,0x90,0xd2,0x4f,0x81,0x06,0x47,0x64,0xc8,0x4b,0x7a,0x1d,0x1c,0xeb,0x96,
         0x22,0xc3,0xbf,0x87,0x1e,0x1c,0x75,0x6a,0xe9,0xda,0x62,0xeb,0x05,0x27,0x9c,0xe3,
         0x40,0xe5,0x48,0xfe,0x51,0x93,0x73,0x44,0xf3,0x55,0x30,0xed,0xd9,0x3a,0x9c,0x4b,
         0xab,0x89,0x44,0x6b,0x38,0xf6,0xb5,0x35,0xbd,0xa7,0xf4,0x3d,0x10,0x2b,0xa5,0xdd,
         0x0a,0x92,0x32,0x1d,0xcc,0x96,0x06,0x46,0xfe,0x68,0x06,0x65,0x41,0xc1,0x2c,0x86,
         0x9f,0x8f,0x01,0xae,0x3a,0x9f,0xed,0x8d,0x58,0x37,0x61,0x36,0xd6,0xc0,0xc3,0xe0},
        /*TST_KeySize*/
        256*sizeof(DxUint8_t),
        /*TST_DPSize*/
        128*sizeof(DxUint8_t),     
        /*TST_PubExponentSize*/
        3*sizeof(DxUint8_t),
        /*TST_input_data*/
        {0x0c,0x5b,0xc0,0x19,0x59,0xe7,0xcf,0x70,0x62,0xf8,0x19,0xa6,0xc9,0xcc,0xa4,0x6a,
         0xcd,0x12,0x0b,0x30,0xda,0xfc,0x68,0x51,0x18,0xc4,0x87,0x06,0x57,0x8f,0xaf,0x97,
         0x6f,0x96,0x20,0xa9,0x83,0x1c,0xb2,0x69,0xc4,0xaf,0xe6,0xf3,0x9f,0x23,0xf9,0x92,
         0x41,0x7c,0x83,0xd2,0x73,0xfb,0xe9,0xa7,0x5d,0x55,0xe7,0xb4,0xd7,0x13,0xb0,0x17,
         0xce,0x40,0xbb,0x14,0xe0,0x93,0x1f,0xb2,0x2c,0xf1,0x1f,0x01,0x86,0x2f,0x3d,0x22,
         0xa4,0x47,0xbb,0x9d,0x02,0x39,0xae,0x9d,0x1a,0x1f,0xed,0x4a,0xf3,0xc4,0x17,0xa8,
         0x05,0x8b,0x3d,0x04,0x62,0x99,0x91,0x91,0x3f,0xac,0x1f,0x15,0xb3,0x9f,0x06,0x1b,
         0x05,0xe9,0xa6,0x4f,0xec,0xc8,0x35,0x9d,0xc3,0x8f,0x82,0x26,0xc8,0x6e,0x94,0x8c,
         0x8a,0x29,0x42,0x10,0x91,0x72,0xf7,0x6c,0xe3,0xb0,0x07,0x0b,0x2f,0xff,0x33,0x84,
         0xc3,0x5a,0xc2,0x13,0x15,0xd3,0xe2,0xdb,0x98,0x2f,0x44,0xba,0x34,0xcb,0xbe,0x63,
         0x6b,0x73,0x36,0xe5,0x27,0x11,0x70,0x6d,0x7a,0xb2,0x74,0x34,0xb6,0x8f,0xe9,0x09,
         0x57,0x67,0xc8,0x50,0x1c,0x7e,0x7b,0xe6,0xd4,0xb8,0xaf,0x7c,0xbe,0x2d,0x16,0x0f,
         0x76,0x44,0x3a,0xfe,0x8d,0x6d,0xc8,0xec,0xa9,0xd5,0x48,0x1f,0xbb,0x85,0x50,0x3f,
         0xef,0xbd,0x8b,0xfd,0x9f,0xf1,0xb8,0x00,0x09,0x67,0x49,0x74,0xc5,0xe9,0xf2,0xd5,
         0x26,0xf1,0x93,0x59,0x73,0xf7,0x84,0x98,0xa5,0xa3,0x25,0xbe,0x73,0xc8,0x1c,0xb4,
         0x1c,0xef,0xbb,0x20,0x59,0x4f,0x3a,0x74,0x92,0xda,0x15,0x76,0xa4,0x12,0xb0,0x21},
        /*TST_output_data*/
        {0},
        /*TST_Expected_output_data*/
        {0x9f,0x5c,0x50,0x40,0x5e,0xe3,0xcd,0x73,0xa8,0xfd,0x6e,0xc8,0x1b,0x10,0x48,0xc2,
         0x31,0xc7,0xb5,0x3c,0xff,0x91,0x2f,0x1b,0xa3,0x33,0x7c,0x3c,0x18,0x06,0x17,0x47,
         0x86,0xb0,0x88,0x3c,0x6a,0x65,0xb7,0xd2,0x9f,0x0d,0x89,0xbe,0x01,0xa2,0x2a,0x29,
         0x00,0x91,0xe2,0xa4,0x48,0xd2,0x0f,0x9e,0xb4,0xb8,0xc5,0xcf,0x7f,0xb7,0xbd,0x32,
         0xc9,0x9c,0x0b,0x34,0x9b,0x15,0x65,0x6d,0x93,0xf9,0x31,0x4e,0x71,0x23,0x3f,0xb8,
         0xae,0xc4,0x6a,0xa9,0x2a,0x37,0xbb,0x60,0xaa,0x58,0x64,0xa1,0xbd,0xfd,0xa8,0x01,
         0xb9,0x7c,0xd2,0x06,0x28,0xb5,0x85,0x31,0xff,0x08,0xd6,0xa4,0x52,0xa3,0x92,0xc4,
         0xa6,0x3f,0xf4,0x9e,0xcf,0x18,0x54,0x8c,0x0a,0xa6,0x80,0xf6,0xc6,0x67,0x72,0xb9,
         0x85,0x0b,0x82,0x83,0xc0,0x8b,0x1c,0xd3,0x62,0x55,0x7d,0xca,0x83,0x82,0x44,0x3d,
         0xbb,0x47,0xbb,0x8d,0x5c,0x03,0x53,0xea,0xa1,0xe5,0x5a,0x96,0x9e,0xa9,0x8e,0xb2,
         0x4f,0x3b,0x8e,0xcf,0x2e,0x31,0xb6,0x01,0xc7,0xff,0x4f,0x3f,0xc8,0xba,0xda,0x6b,
         0xa1,0x0a,0xd7,0x66,0x9b,0x7b,0xd4,0x9c,0xce,0xb5,0xf5,0xeb,0x56,0x17,0x8d,0x30,
         0x2f,0x14,0xbf,0xe0,0x99,0x23,0x7c,0x7f,0x42,0xe4,0x85,0x27,0x97,0x8b,0x16,0xc4,
         0xa4,0x88,0x53,0x6c,0x33,0x1c,0x24,0x22,0xaf,0xf5,0xd1,0xe1,0xac,0x3b,0xab,0xe2,
         0x23,0x7a,0xff,0xe0,0x68,0x47,0x8b,0x86,0x7e,0x71,0x2a,0x1c,0xbe,0x45,0x05,0x3d,
         0x28,0x84,0x0c,0x50,0xab,0x05,0x72,0x27,0xc3,0xc6,0x0b,0xa7,0x3c,0xf9,0x1a,0x26}
    },
    { 
        {"Acceptance test - RSA 2112 "},
        /*TST_PrivetExponent_D*/
        {0x3E,0x56,0x70,0x88,0xC6,0xF0,0x9B,0xD9,0x44,0x10,0x2E,0x49,0x30,0x59,0xCD,0x0F,
        0x03,0xF1,0x3C,0x85,0x21,0xC4,0xA7,0x0B,0x39,0x6A,0x7F,0x02,0x2D,0xD0,0x9F,0x8C,
        0xAE,0xEB,0x51,0x26,0x85,0x52,0xFC,0xC6,0x68,0xED,0x71,0x9E,0xF5,0x33,0xCB,0xB3,
        0x5D,0x3F,0x3E,0x56,0x15,0xD3,0x9C,0x83,0x5A,0x62,0x91,0x9C,0xBF,0x53,0x14,0x60,
        0x15,0x53,0xAC,0x86,0x63,0xEF,0xB4,0x91,0xAA,0x59,0x47,0x9B,0x2C,0x2A,0x90,0xC2,
        0x03,0xEA,0xBE,0x74,0x57,0x13,0x8B,0x27,0x05,0xFD,0xDD,0xA7,0x7B,0xEB,0x19,0xD9,
        0xB0,0x53,0xB8,0x24,0x59,0x70,0x17,0xDE,0xFC,0xCB,0x32,0x64,0x7E,0x35,0x88,0x26,
        0x1A,0x50,0xB0,0xCF,0x4B,0xED,0x8D,0x16,0xF2,0xC7,0xC7,0x7D,0xFF,0x1D,0xA6,0x2D,
        0xDD,0xBF,0x28,0x44,0xF1,0x11,0x37,0xBF,0xA4,0xAA,0x1A,0x0E,0x71,0x82,0x3A,0xFD,
        0x6E,0xF9,0xE2,0x96,0x04,0xCE,0x0A,0x55,0xB3,0x62,0x44,0xF8,0xB4,0x30,0xA6,0x6D,
        0x4E,0x98,0x95,0xCC,0xD8,0x05,0x64,0xAC,0x05,0xF9,0x7F,0x03,0x99,0x32,0x66,0x91,
        0x8F,0xFE,0x00,0xFF,0x92,0x1A,0x4C,0x6D,0xAF,0x27,0xED,0xE4,0x2E,0x55,0xE4,0x16,
        0xA0,0xD3,0x2C,0x7A,0xFF,0x19,0xDC,0xA7,0x0D,0x3F,0xA0,0x4E,0xCF,0xF6,0xE9,0xB5,
        0xE7,0x3A,0xE4,0xB1,0x88,0xDD,0x0A,0x38,0x33,0xE8,0x5B,0xAD,0xC2,0x78,0xD7,0x7E,
        0x6B,0xF7,0x30,0x78,0x6D,0x81,0xE5,0xF3,0x01,0xD6,0xFB,0x7B,0x58,0x53,0x09,0xE7,
        0xFC,0xA0,0x4D,0x0D,0x59,0x04,0xB2,0xCE,0x48,0x9E,0x2D,0x82,0xC1,0xF8,0xB7,0xB1,
        0xAF,0xE9,0xF0,0xA7,0x9D,0x1F,0xE3,0x79},
        /*TST_PublicExponent_E*/
        {0x01,0x00,0x01},
        /*TST_Modulus_N*/
        {0xCA,0x51,0x9A,0xBF,0x0B,0xB1,0x96,0x03,0x5F,0x03,0x15,0xC8,0xEF,0xB2,0x47,0x48,
	    0xBE,0x92,0xE3,0xA5,0x0D,0xDA,0x9C,0x77,0x53,0xF5,0xE9,0xF9,0x8B,0x7A,0x24,0x25,
	    0xDC,0x87,0x25,0x0E,0x03,0xCC,0x0C,0x57,0x24,0x78,0xC6,0x3B,0xA5,0x6A,0x3C,0xD1,
	    0x17,0x8C,0xD4,0xB2,0x80,0xE7,0x11,0x3D,0xBD,0x29,0x91,0xEC,0x83,0x7D,0x91,0x84,
	    0x29,0x2C,0x88,0xE4,0xE9,0xE7,0x6F,0xE5,0xD1,0xD0,0x88,0xC5,0xB7,0xC8,0xE3,0xA5,
	    0xBE,0x5D,0x5C,0xED,0xA6,0x44,0x1B,0x77,0x8D,0x5A,0xC1,0x40,0x01,0x0C,0x07,0x35,
	    0xFF,0x14,0x67,0x80,0x54,0xA4,0x44,0xB3,0x86,0x2B,0x86,0x57,0x5B,0x51,0x47,0xF0,
	    0xEB,0x62,0x2D,0x69,0x45,0x9F,0xB0,0x23,0x17,0x11,0xE4,0x42,0x28,0xE4,0xC5,0xA9,
	    0xF7,0xEC,0xB4,0x6F,0xC9,0x59,0x14,0xBE,0x0D,0x10,0x9B,0x72,0x43,0x52,0x4A,0x74,
	    0x20,0x8A,0xEE,0x1F,0xD4,0x53,0x5D,0xBC,0xDA,0xFA,0x6F,0x2B,0xD1,0xA1,0xCC,0x00,
	    0xC1,0x23,0x1C,0x7B,0x75,0x9D,0xDE,0x06,0x09,0x3F,0xB9,0x8F,0x4B,0x22,0x57,0x56,
	    0x73,0x0F,0x9D,0x89,0x09,0x27,0xC3,0x41,0xEE,0x18,0xE2,0x7D,0x88,0x11,0x0D,0xC6,
	    0x43,0xDC,0x08,0x8D,0xD8,0x3F,0x2C,0xB3,0xB1,0xF1,0xB3,0x76,0x22,0xB5,0x92,0x3C,
	    0xB0,0x8E,0x4D,0x16,0x70,0xBE,0xE8,0xFF,0x5B,0x5F,0x44,0xFD,0x57,0x80,0x01,0x2D,
	    0x83,0x86,0xB1,0x86,0x11,0xB0,0x92,0x32,0x13,0xB1,0xC1,0xB0,0xF3,0xFB,0xA9,0x31,
	    0x51,0x39,0xDF,0x42,0x15,0xA7,0x52,0xB6,0xA4,0x6C,0x92,0x10,0xF7,0x67,0xBC,0xC5,
	    0x65,0xA5,0x3D,0xD4,0x34,0x8E,0x1E,0x37},
        /*TST_P*/
        {0},
        /*TST_Q*/
        {0},     
        /*TST_dP*/
        {0},
        /*TST_dQ*/
        {0},
        /*TST_Qinv*/
        {0},
        /*TST_KeySize*/
        264*sizeof(DxUint8_t),
        /*TST_DPSize*/
        32*sizeof(DxUint8_t),      
        /*TST_PubExponentSize*/
        3*sizeof(DxUint8_t),
        /*TST_input_data*/
        {0},
        /*TST_output_data*/
        {0},
        /*TST_Expected_output_data*/
        {0}
    },
};

TST_RSA_TestSignVerifyDataStruct TST_RSA_Acceptance_SignVerify_TestData[] =
{
        /**********************************/
        /*  RSA SignVerify test data      */
        /**********************************/
        /*  512 bit key                   */
        /**********************************/
    { 
        {"Acceptance test - RSA SignVerify 16byteData/512bit key "},
        /*TST_PrivetExponent_D*/
        {0x1e,0x44,0x11,0x20,0x0f,0x3f,0x66,0x1e,0x0a,0xab,0xbb,0xfa,0xfb,0xee,0x9c,0x79,
         0xf8,0xa4,0xa8,0xbb,0x1d,0x12,0x9e,0xbf,0x30,0xdc,0xb0,0x82,0x54,0x58,0xdc,0x64,
         0x58,0xb0,0x97,0xfc,0x05,0x00,0xf5,0x68,0xb8,0x39,0xc8,0x09,0x2b,0xfb,0xcd,0x2e,
         0x1b,0x70,0x20,0xda,0x68,0x9b,0x16,0xf6,0x8d,0xee,0x01,0x32,0x51,0x53,0x37,0x41},
        /*TST_PublicExponent_E*/
        {0x01,0x00,0x01},
        /*TST_Modulus_N*/
        {0xcc,0x41,0xad,0x7d,0x9f,0xc3,0xd3,0x54,0x09,0x38,0x82,0xb8,0x95,0x5b,0x09,0xcb,
         0xac,0xc4,0x10,0x20,0xa1,0x7c,0x58,0x18,0xaa,0x15,0x63,0xa5,0xf8,0x70,0x6d,0x2d,
         0x4b,0x36,0x20,0x8d,0x12,0x8c,0x78,0xa4,0x6a,0x6e,0xf2,0x27,0x49,0x50,0x09,0xb1,
         0x17,0xe4,0x19,0x58,0x74,0x2b,0xd3,0xd5,0xb6,0x43,0xfa,0x6c,0x11,0x80,0xe8,0x2f},
        /*TST_P*/
        {0xfb,0x7f,0x3c,0x7b,0xf8,0x68,0xf2,0x98,0x75,0x3a,0xdc,0x79,0xca,0xab,0x24,0x15,
         0xfb,0x61,0x94,0xc8,0xf2,0x3a,0x08,0x67,0xbe,0x9e,0x76,0xcb,0x2c,0x7f,0x98,0xcf},
        /*TST_Q*/
        {0xcf,0xe9,0xe8,0xdf,0xf6,0xc3,0x00,0x81,0x8a,0x95,0x38,0xa2,0x80,0x54,0xfd,0x62,
         0xff,0x3d,0xf1,0x65,0x00,0x0b,0xe7,0x7c,0xea,0xd8,0xa7,0x21,0x21,0x98,0xd2,0xa1},     
        /*TST_dP*/
        {0x7d,0x6e,0x92,0x0e,0x0a,0x70,0xdd,0x3d,0xa8,0x8a,0x38,0xd8,0x0d,0x7a,0x99,0xbe,
         0xd4,0xe7,0x70,0x3b,0x60,0x84,0x0d,0x19,0x20,0xfb,0x0b,0xa8,0x7d,0x83,0x0e,0x05},
        /*TST_dQ*/
        {0x6a,0x38,0x6c,0x9b,0x0f,0x6c,0xac,0xb3,0x81,0xe3,0x9e,0x9d,0x96,0xc6,0xd4,0xf5,
         0x60,0xc5,0x7a,0xb0,0x49,0x07,0xcb,0xea,0x4b,0xe9,0x07,0xe9,0xab,0x4a,0x72,0x41},
        /*TST_Qinv*/
        {0x3b,0x67,0x2a,0x6c,0xa4,0xd7,0x75,0x5b,0x05,0x4e,0xf0,0x48,0xab,0x14,0xca,0xc3,
         0xaa,0x58,0x92,0x31,0x4c,0x70,0xc0,0xb0,0x95,0x9d,0x86,0xf8,0xcd,0x77,0x45,0x97},
        /*TST_KeySize*/
        64*sizeof(DxUint8_t),
        /*TST_DPSize*/
        32*sizeof(DxUint8_t),      
        /*TST_PubExponentSize*/
        3*sizeof(DxUint8_t),
        /*TST_SaltLength*/
        20,
        /*TST_input_data*/
        {0x41,0x1f,0xd6,0xbc,0x3d,0x77,0xd0,0x5f,0xb0,0x71,0x00,0xf6,0x27,0xa7,0x55,0xf8},
        /*TST_input_dataSize*/
        16*sizeof(DxUint8_t), 
        /*TST_output_signiture*/
        {0},
    },
    { 
        {"Acceptance test - RSA SignVerify 32byteData/512bit key "},
        /*TST_PrivetExponent_D*/
        {0xc1,0xba,0x8b,0x24,0x0e,0x6b,0x9f,0xec,0xd7,0x7d,0x82,0x06,0x13,0x56,0x8e,0x76,
         0x40,0x4a,0xfb,0xbc,0x70,0x73,0xad,0x12,0x76,0xf3,0x9a,0x53,0x45,0x73,0x5e,0xe3,
         0x10,0x72,0x6c,0x7e,0xe6,0x0b,0xb9,0x05,0x01,0x6e,0x0a,0xe1,0xd6,0xf4,0x6e,0x94,
         0xe5,0xc2,0xc9,0xfc,0x74,0x0d,0xba,0x22,0x90,0x5e,0x3a,0x0c,0x26,0x4e,0x06,0x99},
        /*TST_PublicExponent_E*/
        {0x01,0x00,0x01},
        /*TST_Modulus_N*/
        {0xfa,0x87,0xde,0x9c,0xd3,0xa2,0xd7,0x8a,0x32,0x2e,0xf2,0x3a,0x3d,0x97,0x52,0x5f,
         0xb5,0xa5,0xeb,0xf9,0x11,0xfe,0x78,0xd7,0xbd,0x59,0xcf,0xe2,0x41,0x70,0xbd,0xbb,
         0xf6,0x1d,0x0d,0x04,0x0c,0x99,0x7e,0xef,0x97,0x05,0x45,0x9d,0xad,0xe9,0x07,0x20,
         0x90,0x9f,0x6b,0x3d,0xf6,0x3c,0xe6,0x3e,0xfe,0x8b,0x6a,0xce,0x95,0xbc,0x6c,0x39},
        /*TST_P*/
        {0xfe,0xd1,0xcc,0x65,0xff,0xc0,0xbf,0x89,0xbe,0x1f,0x8f,0xfb,0xbb,0x44,0x62,0x35,
         0x7c,0xa9,0x25,0xb4,0xe6,0x3f,0x76,0xdd,0x75,0xc7,0xb8,0x95,0x70,0x4b,0x34,0x13},
        /*TST_Q*/
        {0xfb,0xb0,0xfc,0x21,0xee,0x9a,0xf1,0x33,0xb4,0x2a,0xe7,0x44,0xee,0x27,0xf1,0xf7,
         0x98,0x07,0xb0,0xc3,0x2c,0xbb,0x6b,0xcd,0x95,0x54,0x1d,0xd4,0x12,0xf3,0xf0,0x03},     
        /*TST_dP*/
        {0x3d,0x4f,0x0c,0xf6,0x9d,0x8a,0x2a,0x8b,0x61,0x8b,0x06,0x81,0x72,0x95,0x09,0x6c,
         0x05,0x0a,0x4d,0x60,0x30,0xe5,0xa4,0x1b,0xb4,0x72,0xd1,0x1e,0x63,0x5e,0x34,0xb1},
        /*TST_dQ*/
        {0x05,0x51,0xab,0x32,0x68,0x61,0x7b,0xe1,0x74,0xd8,0x47,0x44,0xec,0xa7,0x89,0x74,
         0x8b,0x10,0xf6,0x8a,0x59,0x62,0xa8,0x97,0x92,0xa5,0x51,0x70,0x0e,0xea,0x7a,0xd3},
        /*TST_Qinv*/
        {0x82,0x80,0xd0,0x53,0xc2,0xb0,0x19,0x8e,0x05,0xac,0xc4,0x29,0x06,0x89,0x17,0x0f,
         0x4c,0x6d,0xdc,0xcb,0x47,0x16,0x4e,0xc6,0x5a,0xa6,0xaf,0xc1,0x90,0x0e,0x86,0xb5},
        /*TST_KeySize*/
        64*sizeof(DxUint8_t),
        /*TST_DPSize*/
        32*sizeof(DxUint8_t),      
        /*TST_PubExponentSize*/
        3*sizeof(DxUint8_t),
        /*TST_SaltLength*/
        20,       
        /*TST_input_data*/
        {0x05,0x51,0xab,0x32,0x68,0x61,0x7b,0xe1,0x74,0xd8,0x47,0x44,0xec,0xa7,0x89,0x74,
         0x8b,0x10,0xf6,0x8a,0x59,0x62,0xa8,0x97,0x92,0xa5,0x51,0x70,0x0e,0xea,0x7a,0xd3},
        /*TST_input_dataSize*/
        32*sizeof(DxUint8_t), 
        /*TST_output_signiture*/
        {0},
    },
    { 
        {"Acceptance test - RSA SignVerify 512byteData/512bit key "},
        /*TST_PrivetExponent_D*/
        {0x9c,0xe4,0x36,0xf3,0x44,0x01,0x34,0x24,0xa5,0xb5,0x42,0xef,0xff,0x77,0x13,0x9d,
         0x14,0x7b,0xe0,0xa7,0xdb,0x6f,0xd0,0x9e,0xda,0x11,0xc4,0x72,0x44,0x15,0xd6,0x04,
         0xbb,0x0f,0x01,0xd0,0x20,0x31,0x3b,0xf1,0x1b,0x72,0x3e,0x76,0xf9,0x96,0xf2,0x4d,
         0xb0,0x94,0xb3,0x2b,0x1c,0xef,0x35,0x32,0xed,0x61,0x1f,0xc5,0xa2,0xdc,0x08,0x81},
        /*TST_PublicExponent_E*/
        {0x01,0x00,0x01},
        /*TST_Modulus_N*/
        {0xc4,0x55,0x71,0xea,0xc0,0x32,0x54,0x63,0xa1,0x6e,0xb2,0x4c,0x65,0x10,0x5d,0xb7,
         0xa5,0x33,0x92,0x3a,0xb0,0x2d,0xd0,0x00,0x49,0x71,0x80,0x6d,0x89,0x94,0x34,0xb6,
         0xd6,0xcc,0x82,0xa3,0x3b,0x52,0xa4,0xc4,0x0a,0x25,0x32,0xb6,0xc7,0x70,0x49,0x54,
         0x5b,0x83,0x94,0xa4,0x37,0xe2,0x82,0x7c,0x17,0x08,0xbe,0x73,0xf1,0x02,0x20,0xaf},
        /*TST_P*/
        {0xef,0x62,0xd0,0x70,0x56,0x14,0x71,0x52,0x25,0x3d,0xaa,0x46,0xc5,0xb6,0xea,0xaa,
         0xe8,0x2a,0xc2,0xa1,0x41,0x91,0x65,0xaa,0x09,0x43,0xc5,0x7a,0x3e,0xaf,0x67,0xef},
        /*TST_Q*/
        {0xd1,0xf5,0xb8,0x20,0xa7,0x16,0x75,0x8f,0xa0,0x8f,0x8e,0x38,0x1d,0x61,0xc6,0x12,
         0xd7,0x3c,0x46,0x44,0xc1,0xc1,0xe0,0xba,0xac,0xf2,0xd5,0x3a,0xa8,0x5e,0x13,0x41},     
        /*TST_dP*/
        {0x39,0xad,0xf6,0x89,0x4a,0xc4,0x6c,0x35,0x9d,0xd1,0x88,0xe8,0xba,0x95,0x03,0x60,
         0x20,0xc6,0xc4,0xd4,0xb4,0x06,0xc3,0x97,0x3f,0xda,0x3b,0x87,0xe3,0xf8,0xc1,0xb3},
        /*TST_dQ*/
        {0x1d,0xbf,0x07,0x60,0x30,0xec,0x00,0xa9,0xe1,0xa0,0x95,0x10,0xa4,0x31,0x07,0x04,
         0x02,0x54,0x7a,0xcc,0x20,0xfb,0x5b,0xe0,0x76,0xc2,0x4c,0xad,0x6b,0xcf,0x30,0x41},
        /*TST_Qinv*/
        {0xe1,0x14,0xa4,0x72,0x7a,0xc1,0x22,0x10,0x06,0x4f,0x70,0x38,0xf3,0xa8,0x37,0x4a,
         0xe0,0x8f,0x25,0x7d,0xfb,0xb3,0x2c,0x46,0xc0,0xbe,0xd3,0xbd,0x49,0x0d,0x8e,0xa1},
        /*TST_KeySize*/
        64*sizeof(DxUint8_t),
        /*TST_DPSize*/
        32*sizeof(DxUint8_t),      
        /*TST_PubExponentSize*/
        3*sizeof(DxUint8_t),
        /*TST_SaltLength*/
        20,       
        /*TST_input_data*/
        {0xb5,0xb3,0x1c,0x2d,0xbd,0x46,0x65,0xc7,0x70,0xda,0x69,0x5b,0x4f,0xbf,0x9e,0x43,
         0xd4,0x19,0x02,0xc1,0x59,0x3c,0x8b,0xad,0xaf,0xfb,0xa8,0x81,0x90,0xa7,0x84,0x04,
         0x93,0xd5,0x0f,0x82,0xd2,0x21,0xd8,0xe1,0x1a,0x4e,0xad,0xbe,0xe5,0x94,0xb1,0xa1,
         0x55,0x9f,0x59,0x5d,0x8c,0x5b,0xcb,0xa6,0x65,0xf2,0x40,0x13,0xd5,0x5c,0x90,0x48,
         0x90,0xaf,0x29,0xcb,0x23,0x34,0x58,0xa7,0xef,0x2d,0x5d,0x5b,0x79,0x82,0x20,0x4b,
         0xd7,0x02,0x03,0x7c,0x0f,0xf3,0x16,0x5b,0x30,0x8d,0x51,0x17,0x97,0xb5,0xdc,0x62,
         0x19,0xed,0xfc,0xdf,0x04,0xa4,0xc7,0x70,0x63,0x30,0x7e,0x65,0x6a,0x58,0xbb,0x17,
         0x95,0x3a,0x48,0x9a,0x3f,0x36,0xe6,0x5f,0x15,0xdf,0x8c,0x93,0x82,0x86,0x46,0x7b,
         0x76,0x96,0x5e,0xa8,0x59,0xa5,0xf3,0x2b,0x25,0x80,0x84,0xbe,0x7e,0x73,0xeb,0x35,
         0xb9,0xd2,0xfb,0x7a,0x1e,0xe3,0xd3,0xcf,0xed,0x4c,0x53,0x69,0xec,0x01,0x0a,0x5b,
         0x79,0x5e,0xf2,0xbd,0xe6,0x29,0x57,0x57,0x00,0x41,0xc0,0x3a,0x6b,0x68,0x38,0x33,
         0xbc,0x61,0x80,0x8f,0xb9,0x1d,0x24,0xbe,0x4d,0x8c,0x9e,0x8c,0x0b,0x67,0x72,0xc5,
         0x87,0x0f,0xd6,0xce,0xc1,0x15,0x08,0xb9,0x31,0xdb,0x76,0xe8,0x52,0x52,0xfc,0x43,
         0x3d,0xc5,0x57,0x35,0xba,0xe9,0x2b,0x5a,0x9e,0x20,0xbc,0xb4,0x9c,0x5d,0xf1,0xa1,
         0x28,0xe3,0xa0,0x90,0x8a,0xb8,0xa2,0xc2,0xfc,0x21,0x4c,0x41,0xa6,0xd9,0x81,0x1e,
         0xab,0x28,0xd6,0x59,0xe4,0x85,0x6f,0x54,0x69,0x76,0x44,0xc9,0xdc,0x2a,0x26,0x43,
         0x1d,0x8b,0xd7,0x9c,0x34,0x78,0x1b,0x1a,0xd8,0x66,0x1b,0xd5,0xc6,0x5d,0x11,0x7e,
         0x54,0x22,0x11,0x09,0xa1,0xda,0x2f,0x98,0x79,0xd2,0x81,0x6f,0x38,0x37,0x95,0x47,
         0x2d,0x46,0xeb,0x33,0xc9,0xb9,0xc9,0x4b,0xa9,0x7c,0x7b,0xd2,0x5c,0x00,0xd6,0xf5,
         0xb6,0x37,0xa8,0x4f,0x87,0x00,0x72,0x58,0x47,0xa1,0xa1,0xfb,0xd7,0xa9,0x2a,0xa9,
         0x32,0x25,0xd9,0xb4,0xf7,0xaf,0x8e,0x6f,0x18,0x7c,0x96,0xfe,0xc5,0xfe,0x7c,0x03,
         0xf9,0x1d,0x91,0xb5,0x7d,0xde,0x78,0x97,0x31,0x88,0xf9,0x53,0xcd,0xce,0xbb,0xdc,
         0x93,0xfc,0xd8,0x2e,0xe7,0xd1,0x67,0xc1,0x05,0xd0,0x1f,0xed,0x9b,0xe2,0x7b,0xe1,
         0xf4,0xd9,0x3a,0x6f,0x22,0xb2,0x69,0xb9,0xb2,0x93,0xdc,0x87,0x2c,0x25,0x6b,0x96,
         0x67,0xd0,0xdd,0x32,0x87,0x89,0xc1,0xce,0x25,0xba,0x13,0xcb,0x4c,0x40,0xdc,0x3b,
         0x78,0x4d,0x22,0xd7,0x90,0xee,0xf2,0x99,0xeb,0x47,0xe5,0x23,0x03,0x9f,0x09,0x69,
         0xb2,0xa0,0x5a,0xc7,0x37,0x13,0xcc,0xb5,0x0d,0x53,0xb3,0xcf,0x10,0x9d,0xfc,0xe7,
         0x9c,0x76,0xbe,0x1c,0x30,0xfb,0xea,0x67,0xc5,0x12,0x14,0x59,0x61,0x2d,0xde,0x0b,
         0xea,0xb2,0xeb,0x5d,0x9e,0x7e,0xc6,0xde,0x2e,0x66,0x8d,0xac,0x1d,0xd6,0x34,0xa0,
         0x66,0x9d,0x12,0x0c,0x32,0xa1,0xce,0xd1,0x9d,0xcb,0x94,0xaa,0x91,0x94,0xdf,0x71,
         0x20,0x06,0x4f,0x35,0x72,0x3a,0xef,0x8f,0xf5,0xd7,0x20,0x27,0x65,0x58,0xde,0x41,
         0x07,0x7f,0x1c,0x9f,0x83,0xb6,0x19,0x3d,0xc2,0xd1,0x3d,0xd0,0xc0,0xe6,0xe7,0xa1},
        /*TST_input_dataSize*/
        512*sizeof(DxUint8_t), 
        /*TST_output_signiture*/
        {0},
    },  
    { 
        {"Acceptance test - RSA SignVerify 1536byteData/512bit key "},
        /*TST_PrivetExponent_D*/
        {0xc4,0x9e,0xbb,0xa0,0x84,0x11,0x48,0x2e,0xda,0xc9,0x2d,0x94,0xe6,0xf6,0x09,0x33,
         0x49,0xa1,0xc3,0x95,0xe4,0x97,0xd1,0xc0,0x0f,0x4b,0xc6,0x77,0xeb,0xf3,0x47,0x34,
         0x17,0xe3,0x05,0x61,0x6c,0xf3,0x0e,0x5d,0x03,0x4a,0xc8,0xb7,0x3c,0x58,0xcf,0x84,
         0x37,0x31,0x2f,0xd1,0x69,0x46,0xc8,0x5a,0x3a,0xa7,0x08,0xaa,0x2b,0x9a,0xcb,0xe5},
        /*TST_PublicExponent_E*/
        {0x01,0x00,0x01},
        /*TST_Modulus_N*/
        {0xce,0x92,0xfa,0xce,0x30,0x6c,0xfc,0x43,0x09,0xae,0x6c,0x5c,0x63,0xe6,0xef,0x0b,
        0x38,0x31,0x01,0x8f,0xec,0x07,0x6d,0xf6,0xf7,0xa7,0xef,0xc3,0x77,0xf1,0x56,0x56,
        0xd3,0x09,0x7e,0x8d,0x9e,0x56,0x45,0xd2,0x8b,0x04,0x0c,0x3c,0x04,0x91,0x97,0xdb,
        0x2a,0x1d,0x50,0xa3,0x39,0x79,0x7f,0xd3,0x98,0x22,0x67,0x56,0xfe,0xbb,0x3d,0x85},
        /*TST_P*/
        {0xf9,0x7f,0x04,0x49,0xbf,0x4f,0x9e,0x36,0x9d,0x9d,0x98,0x32,0xe9,0x21,0x27,0x7e,
        0x7d,0x72,0xc1,0x51,0x20,0xe7,0x85,0x0a,0x93,0x3a,0xfb,0x61,0x1d,0x46,0xad,0x03},
        /*TST_Q*/
        {0xd3,0xf5,0x87,0x25,0x44,0x47,0xd9,0x45,0x49,0x48,0xc6,0x04,0x12,0x46,0x60,0xcd,
        0xc8,0xd5,0x86,0x25,0x5a,0xb8,0x8e,0xe8,0xac,0x40,0xeb,0x54,0x65,0xc5,0x50,0xd7},
        /*TST_dP*/
        {0x33,0xdc,0xb2,0x50,0x7e,0x23,0x17,0xb9,0x34,0xa4,0x48,0xb9,0xf4,0x79,0xfe,0xd2,
        0xad,0x53,0x08,0x5a,0x4b,0xe3,0xb4,0x65,0x11,0x5b,0xc6,0x5b,0x56,0x91,0x95,0x6f},
        /*TST_dQ*/
        {0x37,0xc3,0x8e,0xec,0xb5,0x0c,0x1a,0x13,0x6a,0x76,0x64,0xf2,0x49,0x44,0x8e,0xcf,
        0x55,0x19,0x28,0x13,0xc7,0xcc,0x6a,0x7c,0xb8,0x64,0xd4,0x04,0xfe,0x49,0x6d,0x3d},
        /*TST_Qinv*/
        {0xeb,0xf5,0x86,0x0c,0xd1,0xe7,0x5d,0xb6,0x7a,0x5e,0x5b,0x79,0x55,0xb1,0x54,0x9e,
        0xcd,0x9c,0x18,0x0f,0x94,0x98,0x56,0x72,0xec,0x46,0x17,0xa0,0x2e,0x73,0x34,0xb6},
        /*TST_KeySize*/
        64*sizeof(DxUint8_t),
        /*TST_DPSize*/
        32*sizeof(DxUint8_t),     
        /*TST_PubExponentSize*/
        3*sizeof(DxUint8_t),
        /*TST_SaltLength*/
        20,
        /*TST_input_data*/
        {0x5d,0xef,0xd4,0xc1,0xd8,0xed,0xd4,0x20,0xe5,0x83,0x14,0x94,0x2c,0x10,0x8d,0x07,
        0x77,0x7f,0x8d,0x5d,0xae,0x6c,0x50,0xb5,0x05,0x89,0xd1,0xec,0x74,0x41,0xdf,0x63,
        0x68,0x9b,0x73,0x03,0xb8,0x60,0x41,0x7e,0xda,0x80,0x8d,0xd7,0x57,0xb2,0x40,0x24,
        0x7c,0x5b,0x3b,0x93,0x52,0xb1,0xeb,0xab,0xd1,0x20,0x1e,0xd4,0x51,0xed,0x15,0x1a,
        0x41,0x19,0xda,0x2e,0x1b,0x88,0xd4,0xad,0x97,0x62,0x98,0xa5,0x20,0xba,0x02,0x56,
        0x84,0x6d,0x85,0x35,0xef,0x4d,0xbf,0x37,0x1a,0x7f,0x50,0x4b,0xc0,0x22,0xed,0x28,
        0x52,0x31,0xb0,0x4a,0xeb,0xab,0xb2,0x37,0x86,0xf1,0xdc,0x07,0x6f,0x6f,0xfa,0x23,
        0xf7,0x7e,0x11,0x4d,0x6c,0x89,0xf3,0xe1,0x48,0x6f,0x10,0x5a,0xa9,0x29,0x8f,0x17,
        0x01,0xad,0x9e,0x60,0x0f,0x12,0x06,0xa4,0x0e,0xf4,0x02,0x04,0x2c,0x1a,0x51,0x16,
        0x3d,0x56,0x8a,0xe2,0xb1,0xad,0xb0,0x31,0xc3,0xb8,0x06,0x08,0xf4,0x4a,0x24,0x6f,
        0xb8,0x54,0x4b,0x76,0x6f,0x05,0xf6,0x7a,0x96,0x35,0xb1,0xa5,0x3f,0x03,0x2e,0xb4,
        0xbe,0xbd,0x96,0xfd,0xa6,0x01,0x1d,0xb0,0xf4,0x22,0xd9,0x5d,0x89,0xcd,0xd4,0xb6,
        0xde,0xed,0x60,0x97,0xf3,0xcb,0xaa,0x43,0x88,0x7a,0x92,0xf1,0x90,0x72,0xba,0x87,
        0xe3,0x7b,0xdd,0xa5,0x33,0xcd,0x63,0xe5,0x41,0x75,0x32,0x61,0x50,0xfa,0xc6,0x76,
        0xda,0x41,0x84,0xc8,0x83,0xae,0x4b,0x86,0x4b,0x8c,0x4d,0xf0,0x07,0xaf,0x1d,0x16,
        0x12,0x57,0x08,0xe2,0x40,0x58,0xa9,0x58,0x13,0x78,0xb8,0x1d,0x32,0x19,0x23,0x36,
        0x16,0x18,0x60,0x13,0x07,0xf4,0x01,0xcc,0x47,0x33,0x89,0xaa,0x8d,0x01,0x7e,0xe9,
        0xb4,0x1b,0xbf,0xbc,0xb5,0xeb,0x18,0x92,0xd3,0xf4,0x14,0x98,0x15,0x71,0x12,0x7f,
        0xf9,0x39,0x9b,0x7f,0x67,0xe6,0xf3,0x9c,0xe4,0x36,0xee,0x28,0x08,0xb2,0x05,0x89,
        0x32,0x8d,0xa9,0x3c,0x7a,0xce,0xd8,0x1a,0xe7,0xb2,0xed,0xda,0xe3,0x4b,0xbc,0xd8,
        0xeb,0x6e,0xde,0x14,0x8b,0xcc,0x4a,0x7e,0x8a,0x5f,0x25,0x71,0x62,0x08,0xdc,0x7d,
        0xf2,0x76,0x6f,0x69,0x77,0x49,0x10,0x78,0xb9,0x77,0xec,0xec,0x82,0xef,0x49,0xc9,
        0x54,0x7d,0xd1,0xdb,0x5b,0xee,0x2d,0xfa,0xa1,0x74,0xd6,0x8d,0x81,0x4c,0x28,0x4d,
        0x5e,0x9d,0xb9,0x4c,0x95,0xa4,0xe8,0x35,0xaf,0x0e,0xb9,0xd5,0xdc,0xa5,0xe0,0xda,
        0x9d,0x2f,0x1b,0xdb,0xc0,0x93,0xc5,0x99,0x91,0x3e,0xa9,0x85,0x4f,0xc5,0x14,0x82,
        0xdd,0xcc,0x2e,0xeb,0xba,0x26,0x89,0xd8,0x33,0x3e,0xfb,0x9d,0xd7,0xb5,0xa9,0x94,
        0x2c,0x4c,0x65,0x1d,0xa0,0x05,0x3a,0xe2,0xc2,0x85,0x44,0x60,0xb2,0xbd,0xc5,0xa3,
        0xd6,0xc9,0x76,0x50,0xcf,0x18,0x1b,0xe9,0xac,0xce,0x5a,0x4d,0x5d,0x66,0xcd,0x7e,
        0x6a,0x9c,0x56,0xa7,0xe5,0x8a,0xb3,0x5e,0x9d,0x11,0x52,0x26,0x94,0x7a,0x66,0x38,
        0xb3,0x5d,0x3a,0x83,0xbd,0xc2,0xc5,0xf1,0x82,0x87,0x80,0xec,0x55,0x02,0x74,0x21,
        0xbf,0xe6,0x97,0x83,0x75,0x6b,0x58,0x93,0x88,0xa9,0x79,0xdf,0xdc,0x45,0x1d,0xc9,
        0xdb,0x50,0x22,0x8a,0x6a,0x6c,0xb0,0x77,0x1c,0x31,0x12,0x82,0xa6,0xcf,0xc5,0x03,
        0x94,0xf4,0xcf,0xb9,0x3a,0xf0,0x52,0x0b,0xec,0x17,0x61,0x94,0x72,0x66,0x12,0xdf,
        0xb6,0x6a,0xd5,0x6f,0xc0,0x5e,0x04,0x03,0xe4,0x94,0xbb,0x18,0x3a,0x16,0xe9,0xae,
        0x4f,0x8c,0xa7,0x4f,0x1a,0x60,0xc9,0x4e,0x32,0x21,0xb3,0x4d,0x3e,0x25,0x6f,0x01,
        0xac,0x73,0xfc,0x3a,0xa6,0xdf,0xe8,0x1d,0x41,0x77,0x21,0xb4,0xf8,0x1e,0x08,0xaa,
        0x5a,0x77,0xc7,0x4f,0xff,0x05,0xe4,0xe2,0xc0,0x90,0x17,0x10,0x27,0xca,0x59,0xb8,
        0x25,0x32,0x3e,0xf1,0x03,0x39,0x84,0x4e,0x9b,0xa3,0xec,0x61,0xc8,0x31,0x48,0x7d,
        0x1b,0x7d,0xd6,0xc0,0xd0,0x25,0xcc,0x51,0x00,0x2b,0x34,0xe7,0x18,0x9c,0xfa,0x8b,
        0x89,0x70,0x44,0x9e,0xc1,0xb2,0x01,0x1d,0x5b,0xe1,0xc5,0x24,0x92,0x95,0xd4,0xb1,
        0xfc,0x65,0x7d,0xab,0x75,0x09,0xa9,0x23,0x58,0xbc,0xb3,0xd9,0xf6,0xe4,0x7a,0x02,
        0x40,0xf5,0xb5,0x48,0xc7,0x93,0x87,0x13,0xe7,0xf7,0x54,0x07,0x3e,0x93,0xd2,0xce,
        0x63,0xf9,0x63,0x17,0xd5,0xf9,0xa2,0xde,0x32,0x09,0x3b,0xee,0xaa,0xeb,0x01,0xa5,
        0xb2,0x89,0x3a,0xf8,0xfd,0x24,0x3d,0xb6,0xa8,0xad,0x40,0x11,0xb5,0x73,0x6b,0x5a,
        0xba,0xff,0x31,0x0c,0xda,0x3c,0xdf,0x0c,0xf5,0xdc,0x75,0x2f,0x1c,0xf6,0xb6,0xfd,
        0x48,0xf4,0x7b,0xb5,0x4b,0xac,0x4c,0x91,0x06,0xcd,0x31,0x4a,0xdd,0x7d,0xc6,0xdf,
        0x68,0x40,0x8e,0x93,0x6b,0x1c,0x89,0x34,0x09,0xfb,0x09,0xa3,0x34,0x50,0xc1,0x91,
        0x68,0xfd,0x1f,0x87,0x99,0x75,0xdc,0x29,0x6a,0x1d,0xd1,0xbb,0x9f,0xf9,0x0c,0xe4,
        0xd5,0x84,0x23,0xb2,0x70,0xdf,0xc8,0xdf,0xd6,0x2e,0x9e,0x53,0xdb,0x40,0x4b,0xe9,
        0x7b,0x6e,0xcf,0x76,0xcf,0xc5,0x14,0x08,0x3a,0x67,0xc5,0x6b,0xe4,0x2e,0x64,0xf2,
        0x69,0x93,0x97,0x73,0xd2,0xce,0xc3,0x94,0xc4,0x3f,0xdc,0x45,0xf7,0x0d,0x7c,0x8e,
        0xea,0x0d,0x32,0x8b,0xd5,0xe5,0x1c,0xb5,0xe0,0x71,0xb8,0x62,0x92,0x65,0xf7,0x90,
        0x8c,0x34,0x93,0xde,0x77,0x31,0xa3,0xdb,0x3b,0xf4,0x6d,0x83,0x71,0x00,0x7b,0x07,
        0x1c,0xa3,0xf1,0xcd,0x93,0x1d,0x1d,0xb8,0xc2,0x04,0x50,0xa9,0x92,0xe6,0xec,0x46,
        0xa6,0x31,0xbf,0xfa,0x48,0x50,0x8f,0x3c,0xa3,0x17,0xf6,0x15,0x32,0x61,0x71,0xdc,
        0x78,0xf7,0xb3,0x45,0xf2,0xb4,0x3f,0x9a,0x4a,0xe7,0x35,0x47,0xcd,0xf9,0x6c,0x9c,
        0x1f,0x50,0xc2,0xcf,0x2d,0x72,0xb0,0x40,0x64,0x6e,0x22,0x01,0x21,0x78,0x85,0x96,
        0x68,0xd3,0x21,0xf9,0xd8,0xf4,0xa9,0xe2,0xde,0xe4,0x10,0x44,0x2a,0xe6,0x9f,0x1b,
        0x5f,0x5a,0x45,0x65,0x0f,0xe1,0x2e,0x6e,0xe6,0xc2,0x96,0x51,0x25,0x8c,0xe0,0xbc,
        0x52,0xfd,0xe2,0xf3,0x2e,0x23,0x84,0x18,0xe8,0xc1,0x89,0xa9,0x90,0xf4,0xac,0x4a,
        0xce,0x16,0xef,0xc5,0xd4,0xe3,0x30,0x4f,0x91,0xda,0xfd,0x0d,0x28,0xe6,0xa9,0xd6,
        0xa0,0x3e,0x9f,0x3b,0xdd,0x8a,0xf7,0xc4,0xcf,0x47,0x47,0x7d,0xe9,0x6c,0xbc,0xb1,
        0xd5,0x4e,0x69,0xf6,0x66,0xc1,0xde,0x69,0xce,0x80,0xfd,0x3b,0x11,0xcf,0x09,0x6d,
        0xb9,0x5e,0x00,0xd7,0xcc,0x71,0x2b,0x6f,0xfb,0x3e,0xf3,0xc8,0x1c,0x96,0xf6,0xd9,
        0xda,0xc8,0x5a,0x00,0xab,0xc3,0x61,0x47,0x03,0x7a,0x3e,0xe5,0xc8,0x8d,0x28,0x08,
        0x05,0x25,0xac,0xd1,0xe2,0x1f,0x47,0xa0,0xd4,0x6e,0x34,0x93,0x11,0xba,0x83,0x49,
        0x47,0x4d,0x6b,0xec,0x8d,0x30,0xe1,0x6e,0x9a,0x91,0x69,0x12,0x34,0x68,0x2d,0x2f,
        0xec,0x5b,0x4c,0x31,0x09,0xde,0x74,0xe0,0xc2,0x9e,0xb3,0xe5,0xb0,0x20,0x8a,0x89,
        0x82,0xa5,0x44,0xc1,0xf3,0x52,0x85,0x68,0xf9,0x8d,0x26,0xcb,0x3f,0xaa,0x40,0x6a,
        0xd6,0xc7,0x87,0xfd,0x28,0xf4,0xda,0xb6,0x2d,0x98,0x18,0xc6,0xe1,0x10,0x34,0x22,
        0xf5,0x98,0x8c,0x87,0xc4,0x6f,0x76,0xbb,0x8a,0x36,0x1c,0x17,0xd0,0x99,0x8b,0x42,
        0x2b,0x32,0x06,0x3f,0x26,0xaa,0xa0,0xaa,0x7d,0x22,0x0a,0x3e,0x8c,0xd1,0xa9,0x9b,
        0x06,0xee,0xeb,0x46,0xea,0xd0,0xdc,0xf2,0xb3,0x54,0xf4,0xfe,0xd0,0x7f,0x33,0x3e,
        0x53,0x64,0x71,0xfe,0xed,0x48,0xef,0x44,0x1a,0x05,0x31,0x56,0x99,0xac,0x10,0x7c,
        0x1f,0x6e,0x0b,0x07,0x4c,0xbd,0xde,0x92,0xde,0xae,0x56,0x88,0x25,0xa2,0x63,0xe7,
        0xb7,0x25,0x6f,0x43,0x64,0x16,0xee,0x0d,0x6c,0x09,0x36,0x15,0xf0,0xe9,0x91,0x4e,
        0xa7,0xe2,0x91,0xd1,0xd2,0x7d,0xa4,0x25,0x72,0x0d,0xe8,0xbe,0xb8,0x4b,0x41,0xc3,
        0xbd,0x3d,0xa8,0x15,0x73,0x5c,0xc6,0x8c,0xdc,0xf5,0xc1,0x84,0x79,0xd0,0x56,0x98,
        0x06,0x10,0x28,0xad,0x64,0x5a,0x57,0x33,0xd7,0x39,0x55,0xa7,0x71,0xc1,0xf5,0x5c,
        0xce,0x73,0xc5,0x7c,0x02,0x61,0x9e,0x49,0xd0,0x93,0x79,0xa9,0x1d,0xa8,0x84,0xe2,
        0xa3,0xc0,0x76,0xa2,0xea,0x9a,0x1f,0x42,0x74,0xfa,0x43,0x4b,0x38,0x4e,0xa8,0x3a,
        0x53,0x90,0x6e,0x80,0xf9,0x6e,0x9f,0xcd,0xb1,0xa9,0x07,0x8e,0xc2,0xbb,0x46,0xb5,
        0xe8,0xbc,0x23,0xb8,0x4c,0x86,0x23,0xdc,0xb3,0x18,0x5b,0xb3,0xf6,0x38,0x82,0xe3,
        0xb2,0x5d,0x4a,0x2a,0x40,0xcb,0xf0,0x9f,0xe8,0x00,0x12,0x3b,0x51,0x4f,0xc2,0x97,
        0x3c,0xcb,0xd8,0xf7,0x72,0x66,0x8c,0x88,0xfb,0x5a,0x44,0xe6,0x91,0xc8,0xaa,0xe1,
        0x55,0x9f,0x02,0x81,0xc0,0xc0,0xbb,0x48,0xdb,0x60,0x43,0xb6,0xb3,0xad,0x20,0x13,
        0x07,0xb4,0x3d,0x68,0x45,0x82,0x81,0xcf,0xb5,0x89,0xa6,0xec,0xf3,0x46,0x49,0xbc,
        0xa2,0x21,0x3d,0x8d,0x5f,0x95,0x25,0x4e,0xf4,0x90,0x42,0x09,0xce,0x1d,0x89,0xae,
        0xb2,0x40,0xf9,0x12,0xab,0x21,0x2b,0x37,0x47,0x6d,0x2b,0xce,0x02,0xfa,0x86,0xfa,
        0x03,0xaa,0xa4,0x57,0x06,0x91,0x58,0x3b,0x9a,0x5a,0xb6,0x3c,0x8c,0xe6,0x25,0xf2,
        0xa3,0x37,0xb5,0xfe,0x8d,0x8d,0xb2,0x4a,0x1a,0xce,0x79,0x93,0xa8,0x2b,0x8a,0x25,
        0xdf,0x01,0xdf,0xe6,0x9e,0xfd,0x7c,0x96,0x34,0x84,0x48,0x55,0xd4,0x52,0x1b,0x66,
        0x43,0x61,0x18,0x32,0xd4,0x0c,0x3d,0x90,0x96,0x74,0x38,0x43,0xcc,0x23,0x7c,0xc4,
        0x9d,0xef,0x95,0x43,0x0d,0x21,0xb8,0xe8,0x2c,0xd7,0x9f,0x5e,0x8d,0xa7,0x94,0x92,
        0xfa,0x85,0xcb,0xb8,0x66,0xe7,0xf4,0x90,0x23,0x27,0x11,0xe7,0x56,0x28,0x85,0x60,
        0xa7,0x3c,0x6e,0x74,0x3d,0x45,0x35,0xb8,0xe9,0x1b,0x64,0x5e,0xa1,0x2e,0xb7,0xff},
        /*TST_input_dataSize*/
        1536*sizeof(DxUint8_t), 
        /*TST_output_signiture*/
        {0},
    },
        /**********************************/
        /*  1024 bit key                  */
        /**********************************/
    { 
        {"Acceptance test - RSA SignVerify 16byteData/1024bit key "},
        /*TST_PrivetExponent_D*/
        {0x21,0x9f,0x56,0x7b,0x14,0x77,0xaa,0x85,0x3f,0xee,0x76,0x95,0x30,0x8e,0xf6,0xa8,
         0x2d,0x61,0x71,0x43,0x66,0xb1,0xa8,0x7d,0x42,0x1c,0x3c,0x22,0x46,0x8a,0xe0,0xa5,
         0xbb,0x39,0xbb,0x23,0x28,0xbd,0x18,0xce,0xac,0xaa,0xb2,0x82,0x02,0xac,0x1b,0x31,
         0xd3,0xf5,0x7f,0x24,0x58,0xf9,0x7c,0x09,0x82,0x44,0xa5,0x23,0x88,0xe6,0x43,0x47,
         0x35,0x2c,0xf5,0x69,0x59,0xd2,0xfb,0x9d,0xae,0x20,0xf2,0xd9,0xba,0xce,0x57,0x03,
         0x2a,0xbe,0x3b,0xfb,0x70,0x43,0x0d,0x50,0xb2,0x74,0x02,0xe9,0xd9,0x55,0xe8,0x06,
         0x41,0x9f,0xf5,0x66,0x1e,0x55,0x9c,0x0e,0xae,0xf9,0x02,0x12,0x63,0xc2,0xf7,0x96,
         0x0c,0xba,0xa6,0x0c,0x23,0xc3,0xc5,0x25,0x38,0xa1,0x6f,0x00,0x4e,0xff,0xa4,0x81},
        /*TST_PublicExponent_E*/
        {0x01,0x00,0x01},
        /*TST_Modulus_N*/
        {0xc1,0xde,0x65,0xc5,0x0e,0x29,0x54,0x7b,0xa9,0xc6,0x37,0x7d,0x58,0x6e,0x13,0x87,
         0xe8,0x12,0x59,0x36,0x19,0x9c,0x3f,0x94,0xd8,0xfa,0x6b,0x72,0x9d,0x26,0x0b,0xd0,
         0xe0,0xdc,0x54,0xcc,0x3d,0x16,0xc8,0x8a,0xdd,0xee,0x3b,0xa8,0x5d,0xa7,0x92,0x0a,
         0x29,0x56,0x6c,0x9a,0x9a,0x47,0xea,0xce,0x2f,0x70,0x04,0x82,0x3b,0x0d,0x33,0xe3,
         0x7b,0xdf,0xf1,0xa5,0x8d,0xe8,0x16,0x6a,0x5a,0xe7,0x7e,0x69,0xd1,0xc3,0xc7,0xc0,
         0xc9,0xc9,0xbb,0xa2,0xa5,0x62,0x4f,0xaa,0x9d,0x7c,0xfc,0xc4,0x81,0x97,0xfb,0xfc,
         0x93,0xed,0xdd,0x71,0xae,0xa6,0x48,0xda,0x1f,0x41,0x00,0xb7,0x4e,0x7e,0x1d,0xc7,
         0xf8,0x7e,0x48,0x22,0xa4,0x1e,0x85,0xac,0x99,0x6f,0x35,0xee,0x4d,0xba,0xd7,0xe1},
        /*TST_P*/
        {0xef,0x76,0xdb,0x53,0x75,0xc7,0x79,0x75,0x4c,0x89,0x07,0xc3,0x08,0xca,0x7d,0x19,
         0x9b,0x51,0x21,0x0e,0x0d,0x95,0x62,0x72,0xe2,0x48,0xb6,0xcd,0x82,0x67,0x9f,0x44,
         0xfe,0x12,0xed,0x06,0x89,0x98,0x15,0xcb,0xeb,0xad,0x24,0x6a,0xaf,0x66,0xd0,0x44,
         0xd8,0x52,0xc3,0xcb,0xb4,0xf9,0xdd,0x99,0x7b,0xee,0x64,0x90,0xfd,0x3d,0xbd,0xc9},
        /*TST_Q*/
        {0xcf,0x41,0x85,0xe4,0xeb,0x1e,0x48,0x86,0x61,0xdf,0x0c,0xaf,0xc1,0xcf,0x4f,0xef,
         0x42,0xfb,0x16,0x6b,0xc6,0x75,0x2f,0x71,0x20,0x3a,0x52,0xe5,0x77,0xd4,0x4d,0x20,
         0x98,0xd2,0xce,0xc4,0x57,0xd4,0x42,0xb9,0xa0,0x31,0x23,0xcd,0x47,0x43,0xbb,0xc3,
         0x71,0xf5,0x7d,0x11,0xbf,0x2b,0xa9,0xcf,0x25,0x19,0xf0,0x8a,0xe6,0xcf,0x75,0x59},     
        /*TST_dP*/
        {0xcf,0xdb,0xb4,0xdf,0xca,0x31,0x7e,0xfd,0x51,0x94,0xf4,0x96,0xd7,0xef,0xa4,0x0d,
         0x71,0x23,0x47,0xf5,0x01,0xd7,0x74,0xa0,0x52,0x49,0x59,0xdc,0x23,0x60,0xbd,0x00,
         0x4f,0x26,0xb0,0x75,0xe7,0x43,0x8b,0x4f,0xf9,0xdf,0xcd,0xe7,0x89,0x1f,0x4e,0x93,
         0x23,0xcf,0x1b,0xc3,0x9b,0xf0,0xf3,0xe8,0xc1,0x89,0x99,0xe3,0xbc,0xde,0x35,0xf9},
        /*TST_dQ*/
        {0x2f,0x7e,0x4a,0x5a,0x7c,0xee,0x81,0x9c,0x19,0xcd,0x6d,0x30,0xd1,0x6e,0xda,0x58,
         0x6f,0xb6,0xee,0x1a,0x60,0x6d,0xf6,0x23,0x2c,0x49,0x71,0x39,0x98,0x4e,0x14,0x26,
         0x86,0x1e,0xb8,0xb7,0x11,0x91,0x58,0x81,0x05,0x0e,0x7d,0xaf,0xca,0xc6,0xe0,0xbe,
         0x16,0xdd,0x34,0x7d,0xde,0x9a,0xf8,0xdc,0xb9,0x19,0xca,0x9f,0x69,0xe8,0xdc,0x71},
        /*TST_Qinv*/
        {0x88,0x2f,0x0c,0x95,0xec,0x54,0x87,0x98,0xb2,0xe3,0x54,0x00,0xa0,0xc9,0x1e,0xbc,
         0x34,0xb8,0xfe,0x64,0x06,0xe5,0x87,0x61,0x21,0x8d,0xf5,0x6f,0x58,0xcc,0x4a,0x4b,
         0x6c,0xb6,0x6c,0xac,0x4d,0xb7,0x3a,0x2a,0x07,0x16,0xd9,0xb9,0x98,0x4a,0x89,0xe7,
         0x83,0x50,0x31,0xc9,0x2b,0x07,0x06,0xff,0xef,0xb4,0x21,0x8b,0xa8,0x04,0x60,0xfb},
        /*TST_KeySize*/
        128*sizeof(DxUint8_t),
        /*TST_DPSize*/
        64*sizeof(DxUint8_t),       
        /*TST_PubExponentSize*/
        3*sizeof(DxUint8_t),
        /*TST_SaltLength*/
        20,       
        /*TST_input_data*/
        {0x3b,0x67,0x2a,0x6c,0xa4,0xd7,0x75,0x5b,0x05,0x4e,0xf0,0x48,0xab,0x14,0xca,0xc3},
        /*TST_input_dataSize*/
        16*sizeof(DxUint8_t), 
        /*TST_output_signiture*/
        {0},
    },
    { 
        {"Acceptance test - RSA SignVerify 32byteData/1024bit key "},
        /*TST_PrivetExponent_D*/
        {0xa3,0x03,0x83,0xc4,0x7c,0xd2,0xff,0x38,0x34,0xcf,0xbe,0xb1,0xc6,0xdb,0x6e,0x14,
         0x9e,0xdf,0xbb,0xd7,0xc5,0xdf,0x8d,0x69,0x7a,0x07,0x75,0xbc,0xde,0x37,0x0c,0x75,
         0x5c,0x71,0xdf,0x18,0x42,0x78,0x95,0x50,0xd2,0x42,0x91,0x47,0xb9,0x59,0xb1,0x75,
         0xd5,0x8f,0x08,0xfe,0x60,0x56,0x47,0x64,0x27,0xbb,0xcb,0xb0,0x73,0x84,0x90,0x25,
         0xb6,0xeb,0x68,0x11,0xba,0xd9,0xaf,0x99,0xe9,0x3f,0xfd,0x55,0x3b,0x65,0xf6,0xbb,
         0x56,0x80,0x8c,0xc1,0xf4,0x7a,0xc4,0x50,0xd8,0x0c,0x54,0x24,0x7a,0x92,0x89,0x8a,
         0x09,0x58,0x5d,0x5b,0x6d,0x34,0x74,0x62,0x0c,0xc1,0x5c,0xb5,0xe5,0x6e,0x08,0xc6,
         0xc9,0xd6,0x16,0x3b,0x37,0xcf,0x63,0x19,0xb9,0xd4,0xe5,0xa7,0x92,0xa5,0x69,0x49},
        /*TST_PublicExponent_E*/
        {0x01,0x00,0x01},
        /*TST_Modulus_N*/
        {0xb8,0xa9,0x73,0xa8,0xac,0x13,0x10,0x13,0xa1,0x0e,0xf6,0x82,0xc5,0xbf,0x27,0x00,
         0x67,0x08,0x1c,0x11,0xd0,0x42,0xc7,0x24,0xe9,0x09,0xeb,0x6f,0x32,0xc5,0x73,0xc8,
         0xda,0x05,0x97,0x50,0xc7,0x95,0xfa,0x4a,0x09,0x3c,0x8e,0xbd,0xa0,0xf9,0xf7,0xcd,
         0x8d,0x2b,0x03,0x45,0x97,0xa5,0x32,0xfe,0xad,0x70,0x7c,0xf1,0x86,0xe7,0x28,0x2f,
         0xb0,0x7d,0x8d,0xfd,0x14,0xbf,0xfb,0xca,0x8c,0xa3,0x87,0x10,0x2c,0x73,0xea,0xe7,
         0xb8,0xa6,0x87,0x40,0x3e,0xcd,0x5d,0x22,0xb0,0xb2,0x07,0x16,0x5f,0xc6,0x02,0xbc,
         0xda,0x54,0x9a,0x4a,0x43,0xcd,0x41,0xb6,0xda,0x69,0x46,0xd9,0xeb,0xfe,0xb1,0xba,
         0x1e,0x33,0xff,0xd9,0x18,0xea,0xa6,0xd2,0x9e,0x70,0xd6,0xa2,0xfa,0xb1,0x87,0xcd},
        /*TST_P*/
        {0xf3,0xa5,0xd3,0x14,0xfc,0xa8,0x95,0xae,0xa5,0x29,0x68,0xa9,0x99,0xe3,0x90,0x3f,
         0xfc,0x41,0xd6,0xdb,0x2e,0x10,0xa8,0x35,0x9e,0xa6,0x82,0x71,0xe0,0x01,0xf4,0xc5,
         0xc6,0xda,0x00,0x28,0xa2,0x53,0xd8,0xdc,0x06,0xc9,0x6c,0xbb,0x92,0x2c,0x16,0x1c,
         0x0b,0xe4,0x33,0x19,0x67,0xe5,0x26,0xfc,0x44,0xf6,0x4c,0xb4,0xbd,0x71,0xa9,0xe3},
        /*TST_Q*/
        {0xc2,0x06,0x14,0xd0,0xf2,0x98,0xdc,0x8c,0x6a,0xe8,0x23,0x3e,0xb7,0xe5,0x6b,0x1e,
         0x7a,0x58,0xe7,0x80,0x2a,0xc2,0xea,0x73,0xa6,0x14,0x8f,0xd5,0x86,0x2f,0xb4,0x2c,
         0x00,0xd2,0x56,0x25,0xcb,0xeb,0x31,0xb0,0xfd,0x02,0x4c,0xde,0x81,0xe0,0xa2,0x4d,
         0xe8,0x21,0x20,0x15,0x0a,0x15,0x75,0xe2,0x97,0xf6,0xfc,0xe3,0x65,0x97,0x76,0x8f},     
        /*TST_dP*/
        {0xda,0xfe,0xdf,0x7d,0x6b,0xa3,0xb3,0xf6,0x68,0x29,0x92,0x13,0x6f,0x68,0xa5,0x4d,
         0x7d,0xd5,0x47,0xe3,0x75,0xc2,0x2f,0x0f,0x12,0xec,0xa3,0x2e,0xeb,0xa3,0x96,0x78,
         0xf6,0x45,0x18,0x03,0x6d,0xf4,0x63,0x65,0x51,0x0c,0x57,0x19,0x39,0x47,0x3b,0x10,
         0x36,0x78,0x04,0x9d,0xff,0x4e,0x6e,0xfe,0x2c,0x96,0x1d,0x58,0x0f,0x37,0x4c,0xf5},
        /*TST_dQ*/
        {0x02,0xb7,0xbf,0x16,0xe6,0x2f,0x09,0xf7,0xd5,0x8f,0x86,0xde,0xdc,0x08,0x94,0xa5,
         0x8a,0xa5,0x30,0x28,0xf5,0x70,0x61,0x84,0x59,0x31,0x34,0x8a,0x93,0x24,0x9b,0xeb,
         0x79,0xdf,0x78,0x61,0x73,0x27,0xca,0x3c,0x66,0x6e,0xdf,0xd0,0xc6,0x14,0xf5,0x71,
         0x0d,0xed,0x58,0xdb,0xb2,0x96,0x76,0x5e,0x44,0x2e,0xab,0x80,0x2b,0xee,0x21,0x35},
        /*TST_Qinv*/
        {0xe1,0x74,0x70,0xd9,0xf1,0xa3,0xeb,0x93,0x41,0xb2,0xac,0xcb,0x63,0x5b,0x7f,0x7a,
         0x7d,0x11,0x9e,0xd5,0x54,0xf9,0xd3,0x25,0xd7,0xc3,0xe2,0x95,0x0a,0x6c,0xb9,0xaf,
         0xb2,0x54,0x4f,0x80,0xcf,0x53,0x01,0x49,0x5d,0x57,0x03,0x14,0x28,0x90,0x33,0x39,
         0xdb,0xb0,0x29,0xb6,0x72,0x09,0x65,0xf1,0x5d,0x1e,0x9a,0x19,0x2e,0x75,0x74,0x95},
        /*TST_KeySize*/
        128*sizeof(DxUint8_t),
        /*TST_DPSize*/
        64*sizeof(DxUint8_t),       
        /*TST_PubExponentSize*/
        3*sizeof(DxUint8_t),
        /*TST_SaltLength*/
        20,       
        /*TST_input_data*/
        {0x88,0x2f,0x0c,0x95,0xec,0x54,0x87,0x98,0xb2,0xe3,0x54,0x00,0xa0,0xc9,0x1e,0xbc,
         0x34,0xb8,0xfe,0x64,0x06,0xe5,0x87,0x61,0x21,0x8d,0xf5,0x6f,0x58,0xcc,0x4a,0x4b},
        /*TST_input_dataSize*/
        32*sizeof(DxUint8_t), 
        /*TST_output_signiture*/
        {0},
    },
    { 
        {"Acceptance test - RSA SignVerify 512byteData/1024bit key "},
        /*TST_PrivetExponent_D*/
        {0x12,0x9f,0x22,0xe4,0x94,0x92,0x15,0xc7,0xed,0xe7,0xe9,0xce,0x56,0x8f,0xf3,0x7a,
         0x1f,0x20,0xbe,0x3f,0x8d,0xc1,0x65,0xef,0x54,0xc4,0x97,0x02,0x14,0x94,0xa0,0xbe,
         0xef,0x3d,0x08,0x1c,0x74,0x2b,0x66,0x0a,0x02,0x7d,0xc3,0xef,0xda,0x91,0xcb,0xd3,
         0xad,0x42,0x4e,0xe1,0x68,0xdd,0xe5,0x32,0x8a,0xaf,0x0b,0x7e,0xc0,0x2d,0xed,0x23,
         0x7d,0x02,0x98,0xf7,0x86,0xe6,0x55,0xa4,0xde,0x1f,0xa8,0x07,0x3a,0x47,0x51,0x20,
         0x55,0x8b,0x0f,0x3f,0x8c,0xbe,0x97,0x30,0x89,0x5d,0x7c,0xf8,0xb7,0x1c,0xb5,0x52,
         0x2a,0xb8,0x37,0x43,0xf2,0x75,0x14,0xba,0x86,0x8b,0xa2,0x12,0xfd,0xe5,0x9d,0xb0,
         0xd7,0xee,0xd8,0x36,0x73,0x61,0xf5,0x09,0x14,0x42,0x05,0xbb,0x7f,0xb5,0x23,0x1d},
        /*TST_PublicExponent_E*/
        {0x01,0x00,0x01},
        /*TST_Modulus_N*/
        {0xc0,0x85,0xfa,0x40,0xff,0x80,0x7a,0x87,0x46,0xde,0x82,0x5f,0x67,0x6f,0xfd,0x2d,
         0x0d,0xb9,0xb4,0x7e,0x00,0x47,0xdf,0x66,0x00,0x13,0xdc,0x3e,0xfb,0xde,0x74,0x0c,
         0x70,0x1b,0x6f,0x7b,0x63,0x23,0x96,0x68,0xf1,0x02,0x13,0xb1,0x45,0x15,0x9f,0x37,
         0x69,0x5d,0x17,0xc6,0x7b,0x4e,0xb6,0x7a,0x09,0xd6,0x54,0x7a,0x1c,0x60,0xa7,0x6b,
         0x48,0x14,0xc0,0xda,0xfa,0xce,0x72,0xec,0x0d,0x28,0xff,0xb7,0x6e,0x7a,0xae,0xa8,
         0x78,0xab,0x4f,0xb5,0x4e,0xef,0x38,0xac,0xd2,0x86,0x12,0xd1,0x5a,0xd1,0xb0,0x95,
         0x3c,0xd1,0x9b,0x4d,0xc4,0xce,0x87,0xf9,0x43,0x98,0x4f,0xdd,0xa0,0x8c,0x18,0xfa,
         0x0f,0x23,0x80,0xde,0xe8,0x9d,0x3f,0xda,0xe3,0x21,0x7a,0xa3,0x4e,0xc3,0x45,0x99},
        /*TST_P*/
        {0xfd,0x93,0xcb,0x3f,0x2c,0xcf,0x0d,0xe5,0x29,0x48,0x7f,0x22,0x81,0x8a,0x69,0x33,
         0x50,0x44,0x33,0x98,0x4b,0xa7,0xff,0xca,0x54,0x34,0xea,0x33,0xcf,0x38,0xe8,0x81,
         0xf5,0x84,0x77,0x5b,0xd2,0x8b,0xb2,0x48,0x21,0xda,0xb5,0x60,0xd4,0xb7,0xd0,0x62,
         0xf7,0x42,0x14,0x38,0x23,0x90,0xc1,0x31,0xd5,0x97,0xfd,0xe5,0xf9,0xda,0x3f,0x6f},
        /*TST_Q*/
        {0xc2,0x5c,0xdb,0x31,0x1c,0xf4,0xab,0xb1,0x3e,0x3c,0xbc,0x3c,0x25,0xa8,0x49,0xfe,
         0xae,0x8b,0xaa,0xa5,0xc1,0xa5,0xa5,0x12,0x20,0x0e,0xc0,0x93,0x5d,0x6b,0x73,0xc1,
         0xb3,0x08,0x67,0xe8,0x05,0xd8,0xbc,0x6d,0x46,0x29,0x53,0x4d,0xd4,0x68,0x1b,0xe7,
         0xeb,0x2f,0xe2,0xed,0x4c,0x52,0x62,0x59,0x5c,0x90,0xf5,0x78,0x2c,0xc8,0x47,0x77},     
        /*TST_dP*/
        {0xed,0xb7,0xa5,0xab,0xfd,0xd7,0xc5,0x90,0xf5,0x58,0xaf,0x46,0xab,0xe6,0x13,0xa5,
         0x35,0x34,0x1a,0xa2,0x45,0x1a,0xa3,0x63,0x0b,0xf9,0xe7,0x2c,0xd6,0xb0,0xe4,0xd7,
         0x20,0x51,0x24,0x8c,0x02,0x1f,0x4f,0xec,0xeb,0x3f,0xdb,0x15,0x81,0x95,0x28,0x57,
         0xfe,0xb0,0x05,0xc0,0x73,0x26,0xfa,0xd6,0x3b,0x04,0x97,0xd3,0x06,0x9d,0xa1,0x25},
        /*TST_dQ*/
        {0x2f,0xc0,0xec,0xc1,0xe6,0x61,0x5f,0x05,0xcf,0x4a,0xd0,0xdc,0xde,0x4b,0xb8,0xd2,
         0x70,0x44,0x34,0x8b,0x41,0x46,0xd7,0x85,0xda,0x86,0x85,0x5e,0x2f,0xa7,0xc4,0xeb,
         0x24,0x77,0xbe,0x3f,0xcd,0x9f,0xf0,0xbb,0xd0,0x6f,0x3a,0xde,0x76,0x7f,0x95,0xcb,
         0xa7,0x87,0x3e,0x74,0x1b,0x3a,0x6a,0x9b,0x96,0x18,0xaf,0x96,0xf5,0x39,0xc8,0x05},
        /*TST_Qinv*/
        {0x76,0x1a,0xb7,0x92,0xd9,0x87,0xd8,0xba,0x0b,0x23,0xf1,0xf6,0x73,0x11,0xd5,0x9a,
         0x37,0xcf,0xef,0xab,0x9c,0x69,0x62,0x10,0x20,0x07,0x15,0x2a,0x5d,0x06,0x18,0x8a,
         0xc7,0xcd,0x56,0x1c,0xfa,0x40,0x54,0x04,0x82,0xd9,0xb8,0xfb,0xce,0x5f,0x03,0xa8,
         0x81,0x11,0xd4,0x88,0xbb,0x45,0xf8,0x96,0xad,0x8f,0xf1,0x5e,0x6b,0x93,0x7d,0x88},
        /*TST_KeySize*/
        128*sizeof(DxUint8_t),
        /*TST_DPSize*/
        64*sizeof(DxUint8_t),       
        /*TST_PubExponentSize*/
        3*sizeof(DxUint8_t),
        /*TST_SaltLength*/
        20,       
        /*TST_input_data*/
        {0xc0,0xdb,0x63,0x66,0x93,0x80,0x39,0xd3,0xda,0xd1,0x7a,0x95,0x61,0x29,0x0a,0xb3,
         0xac,0xd0,0xa1,0x81,0xa2,0x37,0xb9,0xba,0x4b,0x0d,0x27,0x7b,0x82,0x7f,0x1f,0xd2,
         0x82,0xc4,0x90,0x76,0x83,0xde,0xe1,0xf7,0xec,0x87,0xde,0x4c,0x5d,0xba,0x10,0x1e,
         0x31,0xa2,0x8c,0x5e,0x2f,0xff,0x1b,0x6a,0x77,0x8a,0x39,0xd3,0x6c,0x7f,0xa3,0x9d,
         0xfb,0x89,0x57,0xb2,0xa1,0xa3,0x6a,0x48,0x1c,0x07,0x57,0x5f,0x14,0x3e,0xd9,0x64,
         0x61,0xa7,0x85,0xa2,0x92,0x30,0xfa,0x39,0x93,0xe0,0x75,0x90,0x2a,0xc6,0xb9,0x58,
         0xa7,0x28,0x6e,0xea,0x8c,0x05,0xd9,0x78,0x74,0xa4,0x05,0xf2,0x5b,0x54,0xb0,0xb6,
         0xf2,0xd3,0x85,0x07,0xe2,0x10,0xd7,0x78,0xe6,0x25,0xf8,0x18,0xb6,0x77,0xa0,0x7a,
         0xfc,0x48,0x7a,0x5c,0xd6,0x51,0xee,0xc3,0x73,0x2d,0x75,0x01,0x91,0x12,0x96,0xc7,
         0x8e,0xb4,0xf4,0x84,0x10,0x0b,0x53,0xdd,0x41,0xd4,0x1b,0x45,0xb6,0xa1,0xe7,0x0f,
         0xf5,0x5d,0xd9,0x06,0xea,0x2a,0x0b,0xb2,0x40,0xd7,0xab,0x30,0xdf,0xf5,0x35,0xb0,
         0x6b,0xec,0x06,0x00,0xe9,0x57,0x3e,0xd5,0x9f,0x9e,0x90,0xf8,0xef,0x67,0xcd,0x76,
         0x5e,0xb4,0x95,0x63,0x90,0xa1,0xc4,0x3c,0xb9,0x40,0x8c,0x8f,0x3f,0x23,0xe7,0x6b,
         0xc0,0x7d,0x7e,0x58,0x4a,0x16,0x46,0x97,0x8d,0x1c,0xa1,0x55,0x72,0xba,0x9f,0x72,
         0x40,0xcb,0x7c,0x50,0xff,0xa3,0x0d,0x78,0xcb,0x8e,0x56,0xda,0xa0,0x94,0x97,0xa1,
         0xb6,0x8b,0x77,0x21,0x13,0xa7,0xaf,0x9c,0x2c,0x85,0x12,0x75,0x06,0x0e,0x17,0x05,
         0x06,0xbf,0x66,0x51,0xef,0x75,0x3c,0x10,0xba,0x86,0x3b,0xc8,0xc0,0x36,0x84,0x66,
         0x56,0xf4,0x91,0xc2,0x0c,0x5f,0xf0,0xc2,0xa0,0xdf,0x9b,0xf3,0x09,0x54,0xd3,0x53,
         0x35,0x3a,0x15,0x67,0xe0,0x23,0x4b,0x3a,0xb6,0x6e,0xe6,0x8b,0x3b,0x78,0x48,0x1a,
         0x16,0x58,0x7e,0x9a,0xc9,0x09,0x1e,0xf7,0x71,0xa9,0x47,0x6e,0xab,0x4c,0x27,0xf8,
         0x5e,0x15,0xa7,0x18,0xdb,0xe8,0xf0,0xce,0x07,0x15,0x06,0xac,0x8f,0xf3,0xc6,0xfd,
         0x69,0x21,0x48,0x5e,0xb0,0xc8,0xbf,0xe8,0x85,0xd1,0x03,0xac,0x00,0xa3,0x25,0x57,
         0x01,0xba,0x3b,0x6f,0x3f,0x68,0xf0,0xfb,0xf2,0xf0,0xce,0x38,0x75,0x93,0x97,0xff,
         0x3e,0xad,0xc1,0xe8,0xcd,0xb3,0x13,0x26,0xea,0xbe,0x87,0x58,0xae,0x01,0xaf,0x7e,
         0xae,0x80,0xcf,0xe2,0x74,0xd2,0x43,0x2f,0x0b,0x50,0x3a,0xaa,0x68,0xe6,0xc9,0x00,
         0x7a,0x39,0x91,0x44,0x52,0x74,0xb4,0xd7,0xcc,0xbc,0x76,0xa4,0x17,0x6e,0x03,0x8e,
         0xa6,0x59,0x51,0xe8,0xf4,0x19,0x18,0xe6,0x76,0xcc,0xef,0x5a,0x44,0x6c,0xb3,0x3c,
         0x3c,0x2c,0x25,0xa2,0x66,0xd6,0x72,0xd3,0x44,0x41,0xf4,0x8d,0x74,0xc2,0x77,0xf8,
         0xc3,0x4d,0x58,0x3f,0xfe,0x4b,0xfd,0x87,0x01,0xea,0x12,0x52,0x7e,0x91,0x53,0xec,
         0xc7,0x86,0xbb,0x12,0xe5,0xaa,0xef,0x85,0xb9,0x9e,0xb0,0xfe,0xcb,0x5b,0x5b,0x55,
         0x59,0xe1,0x00,0xac,0x9c,0x69,0x3c,0xa2,0x98,0xf4,0x95,0xd9,0x60,0xc2,0x2b,0x4f,
         0xf8,0xc8,0x87,0x88,0x6f,0x5c,0xee,0x47,0x8f,0x40,0xe5,0xb6,0x4b,0xd7,0xcf,0x21},
        /*TST_input_dataSize*/
        512*sizeof(DxUint8_t), 
        /*TST_output_signiture*/
        {0},
    }, 
    { 
        {"Acceptance test - RSA SignVerify 1536byteData/1024bit key "},
        /*TST_PrivetExponent_D*/
        {0xa6,0xe0,0xfc,0x63,0x45,0x30,0x67,0x0f,0x13,0xda,0x33,0xd3,0x4d,0x78,0x1d,0xd0,
        0x0f,0x31,0x7a,0xbe,0x2a,0x97,0xc9,0x16,0x72,0x55,0x29,0xbe,0x50,0xfa,0x05,0x14,
        0xed,0x45,0x78,0x95,0xe2,0x03,0x1d,0x76,0xd8,0x14,0x31,0xbc,0xdf,0x1c,0x3a,0x21,
        0x8f,0x70,0x02,0x58,0xdc,0xcf,0x0b,0xb0,0x1b,0xcd,0x2e,0x1b,0xca,0x0d,0x1e,0x4a,
        0x52,0x2f,0xc5,0x06,0xcf,0x2d,0x0b,0xb7,0xe2,0x40,0xc7,0x6c,0xcc,0xa9,0xc6,0xd0,
        0x49,0x62,0x2e,0xd9,0x91,0x7f,0xb5,0x44,0x51,0xcc,0xd8,0x68,0xb3,0xdc,0x40,0xd0,
        0xe6,0xb7,0xcd,0x8a,0x27,0x00,0xd8,0x8e,0xe7,0xd3,0x73,0xd2,0x2c,0xf2,0x08,0x50,
        0xda,0x20,0x44,0x81,0x83,0xc7,0x61,0x99,0xe8,0xde,0x35,0x58,0x5c,0x7e,0x8e,0x45},
        /*TST_PublicExponent_E*/
        {0x01,0x00,0x01},
        /*TST_Modulus_N*/
        {0xcb,0xb4,0x95,0x26,0x8c,0x84,0x71,0x58,0xe3,0x6e,0x26,0x11,0x24,0xa1,0x9e,0x9b,
        0x04,0xe0,0x2c,0x04,0xb2,0xc2,0x79,0x70,0x0b,0x93,0x49,0x0d,0x17,0x97,0x03,0x95,
        0xde,0xfc,0xa3,0x42,0x99,0xaf,0x14,0xc3,0xec,0x59,0xb5,0x44,0xae,0x32,0x7b,0x6b,
        0x4b,0xfa,0xaf,0xec,0x15,0x7e,0x9f,0x39,0xad,0xb2,0x8b,0x7e,0x5c,0xe6,0x00,0x2a,
        0x9a,0x27,0x27,0xab,0x9a,0xe9,0x8c,0x84,0x53,0xa9,0x8c,0x84,0x30,0x9a,0x44,0x85,
        0xb2,0xc2,0x2e,0x69,0xb4,0x46,0xfb,0x51,0xca,0x30,0xe2,0x75,0x2b,0x69,0xd6,0x5f,
        0xdd,0xab,0x8a,0x67,0x90,0xad,0x47,0x3e,0x5b,0x18,0x5b,0x69,0x32,0xe0,0x90,0x52,
        0x44,0xf5,0xb3,0x34,0xbb,0x4d,0xc2,0xb7,0xfc,0xe1,0x0b,0x9a,0x95,0x5c,0x4f,0x99},
        /*TST_P*/
        {0xe5,0x14,0xa5,0x74,0x79,0xcf,0x60,0x2c,0x0e,0x44,0x46,0x4e,0x8c,0xd0,0xfd,0x12,
        0x48,0x75,0x4f,0x26,0x5c,0x34,0x78,0xde,0xa6,0x67,0x0c,0x53,0xbe,0xa6,0x97,0xdd,
        0x7d,0xa5,0xb7,0x2f,0x2c,0x61,0x8c,0x14,0x40,0xb7,0x27,0xae,0x9f,0x4f,0x53,0xff,
        0x49,0xf8,0xa8,0x6c,0x7e,0xb8,0x5c,0xb0,0x93,0xca,0xcb,0x0f,0x1d,0x36,0x06,0xb3},
        /*TST_Q*/
        {0xe3,0xa4,0x94,0xdd,0xa4,0xbb,0xe1,0xed,0x85,0x4c,0xf7,0xad,0xe3,0x7f,0x07,0xf9,
        0xea,0x6d,0xdd,0xf1,0x86,0x58,0xac,0xbe,0x5b,0x9d,0x1e,0x87,0x40,0xd7,0xcd,0x2b,
        0x1a,0xdb,0x4b,0xd7,0x79,0xb9,0x60,0xc5,0x23,0xa9,0x63,0xba,0x30,0xfa,0x9f,0x06,
        0xc7,0x16,0x03,0xd3,0x8f,0x4d,0x87,0xc8,0x1b,0x09,0x21,0x07,0x6f,0x0e,0x96,0x83},
        /*TST_dP*/
        {0x77,0x0d,0xff,0xdf,0x44,0xdf,0x2d,0xd0,0x37,0xa9,0xec,0x10,0x2e,0xc6,0xfe,0x7f,
        0x5e,0x00,0xf9,0x9d,0xaa,0x15,0xeb,0x2b,0x6b,0xb7,0xea,0x84,0x2b,0x75,0x51,0x3f,
        0xdf,0x69,0x1c,0x86,0xfb,0xbd,0xc6,0x9b,0x4f,0xf6,0xe0,0x3c,0xb4,0xb6,0xf9,0xa4,
        0x97,0xc1,0x0f,0x67,0x33,0x84,0x85,0x47,0x8f,0xc7,0xb9,0x38,0xa5,0xa9,0xca,0x59},
        /*TST_dQ*/
        {0xa4,0xec,0xe3,0x71,0xa5,0x5c,0xfd,0xb5,0x70,0xe3,0x2f,0x7a,0x8b,0x1c,0xc8,0xb1,
        0x96,0xd7,0x9c,0x79,0xd4,0xc4,0xbf,0xfa,0x76,0x33,0x62,0x1f,0xc9,0xa9,0xcf,0x9a,
        0x50,0x2d,0xdb,0x47,0xb4,0x87,0xcb,0x05,0x68,0xed,0xdb,0x33,0xd5,0x32,0x6e,0x2e,
        0xa1,0xe4,0x60,0x47,0x51,0x46,0x71,0x7e,0x57,0xa0,0x08,0x8e,0xf3,0x36,0x15,0x73},
        /*TST_Qinv*/
        {0xcd,0xd5,0x52,0xed,0xfe,0x27,0x57,0x57,0xce,0xee,0x07,0x1e,0x72,0x07,0x27,0x14,
        0xd2,0x54,0x85,0xd6,0xe6,0xab,0x24,0xc4,0xee,0x43,0xf0,0xfd,0x77,0x98,0xff,0xce,
        0xcd,0xa2,0x6f,0xae,0x09,0xb7,0x30,0x0a,0x70,0xb0,0x7c,0x17,0xa0,0x22,0xb8,0x67,
        0x9e,0x0d,0x4a,0xb4,0x48,0x7a,0xeb,0x8b,0x13,0x2f,0x8b,0x6a,0xff,0x28,0x5b,0x39},
        /*TST_KeySize*/
        128*sizeof(DxUint8_t),
        /*TST_DPSize*/
        64*sizeof(DxUint8_t),      
        /*TST_PubExponentSize*/
        3*sizeof(DxUint8_t),
        /*TST_SaltLength*/
        20,       
        /*TST_input_data*/
        {0x20,0x68,0x63,0x6a,0x1f,0x92,0xb1,0x5d,0xed,0x71,0x7f,0xfb,0x40,0x30,0x54,0x79,
        0x09,0x50,0xc8,0xe7,0xa6,0x03,0x4e,0xb5,0x59,0xd6,0x52,0x75,0xf9,0x93,0x84,0xe2,
        0xe7,0x66,0x73,0x22,0x44,0x3e,0x5d,0x48,0x61,0x76,0x45,0x1d,0x77,0xb5,0x47,0x20,
        0x99,0x13,0x29,0xcb,0xe6,0x7d,0x32,0x18,0x03,0x5a,0x3f,0x44,0xc9,0x6e,0x13,0xd3,
        0x3a,0xff,0xef,0xd4,0xba,0x37,0x62,0x66,0x7c,0xca,0x63,0x7b,0x3a,0xd9,0x9d,0xdc,
        0x29,0x15,0x0a,0x6e,0x2c,0x27,0xc3,0xb3,0x47,0x50,0x17,0x93,0x57,0x4c,0xda,0x5d,
        0x01,0x7d,0xff,0x09,0xe9,0x45,0x6a,0xc0,0x24,0xb4,0xff,0x9e,0xef,0x63,0xff,0xb6,
        0xa1,0x9f,0x94,0x56,0xde,0xca,0xaa,0x8d,0x0e,0xff,0x01,0xeb,0x0d,0xf5,0x80,0x88,
        0x24,0x26,0xcd,0x47,0x39,0x30,0x1a,0x5c,0x42,0x7b,0x42,0x0c,0x00,0x1c,0x14,0xb4,
        0xe9,0xf9,0xee,0x0d,0x66,0x2e,0x8f,0xae,0x3e,0xb0,0x26,0xd3,0x52,0x30,0xae,0x5c,
        0x8c,0x43,0x7e,0x19,0x12,0xbf,0x1c,0x44,0xbf,0x68,0x53,0x4f,0xd3,0xcc,0x85,0xe1,
        0xe9,0x6b,0x42,0x1b,0x2a,0x1b,0x18,0x1f,0xc1,0xab,0xad,0xd3,0x8e,0xc7,0x0c,0xe2,
        0x1f,0x1b,0x3d,0x04,0xdc,0xbc,0x18,0x80,0x81,0xc3,0x5a,0xef,0xd2,0x3b,0xf9,0x42,
        0x8a,0x3d,0xb5,0x06,0x94,0x59,0xf0,0xe7,0x7d,0x38,0xbf,0x73,0x2a,0x80,0x41,0x21,
        0xc6,0xf8,0x30,0x92,0xff,0xed,0xb5,0x16,0x72,0xd4,0x81,0x72,0x63,0x30,0x19,0xe1,
        0xb2,0xb6,0x71,0x58,0x0a,0xaf,0xbd,0x0e,0x5c,0x9f,0x84,0x3c,0x8c,0x24,0xf6,0x21,
        0x6a,0x20,0x7f,0x4a,0xe3,0x1a,0x9c,0x10,0x79,0xe2,0xee,0x62,0xf0,0x74,0x8d,0xc5,
        0x4a,0x1f,0x9e,0x98,0xf6,0xe7,0x28,0x9d,0x45,0x27,0x23,0xb5,0x1d,0x7b,0xd2,0xeb,
        0xf1,0xdc,0x53,0xb4,0xf0,0x0d,0x75,0x75,0x7d,0x37,0xc9,0x46,0xe0,0xd0,0xfc,0xf6,
        0x3b,0xc0,0x63,0x4f,0xbf,0xc7,0xd8,0x9b,0x1f,0x19,0xc5,0x67,0x45,0x4c,0x7e,0x86,
        0x45,0x74,0xd4,0x59,0x8f,0x8d,0xe7,0x4e,0x68,0x19,0x3b,0xa7,0x9b,0x09,0x0e,0x7d,
        0x6b,0xe1,0xe9,0x04,0xcd,0x18,0x76,0x10,0xd4,0xbd,0x91,0xd8,0x6d,0x61,0xa1,0xfa,
        0x4c,0x30,0x29,0xc0,0x26,0x61,0x9a,0xa2,0x21,0xd1,0x6c,0x0c,0x89,0xea,0x6c,0x61,
        0xc4,0xca,0x58,0x3f,0x88,0xa1,0xa9,0x05,0x4b,0x5b,0xb0,0x92,0xfb,0x80,0xe4,0x50,
        0xf0,0x58,0x7b,0x72,0x1f,0x52,0x37,0x79,0x90,0xa6,0x83,0xfd,0x12,0x3a,0xbe,0xaa,
        0x2d,0xc3,0xd7,0x89,0x58,0x2c,0x1a,0x80,0x6c,0x3b,0x49,0x1d,0x59,0x72,0xef,0x8f,
        0x17,0x33,0xf1,0xf5,0xe0,0x28,0x66,0xdc,0x9d,0xe2,0xa8,0x02,0x9e,0xc0,0xab,0x60,
        0x8d,0x13,0x8e,0x68,0xa5,0x7f,0x70,0x8c,0x1f,0xa5,0x85,0xff,0xed,0xfe,0x69,0xbf,
        0xab,0x0a,0xb4,0xd3,0xd3,0xab,0xce,0xd1,0x30,0xcb,0x05,0xa4,0x95,0x45,0xdc,0x8c,
        0xce,0x03,0xa6,0x66,0xd7,0x64,0x54,0x2e,0x4c,0xe0,0x8c,0xc2,0x21,0xee,0xfb,0xe9,
        0x93,0x25,0xeb,0x93,0x5e,0xa2,0x18,0x63,0x31,0xab,0xbf,0x6a,0x5f,0x91,0xf9,0x36,
        0xd7,0xdb,0x47,0x0b,0x56,0xa0,0x6e,0x70,0xdb,0x35,0x85,0xed,0x5c,0x09,0x4c,0x14,
        0xb7,0xcc,0xbf,0xbe,0xeb,0xd7,0xeb,0x97,0x88,0xc8,0x01,0xdd,0x64,0x6c,0xa9,0x64,
        0x90,0xe3,0x98,0xde,0x8a,0xfe,0x65,0x59,0xb4,0xec,0x98,0x09,0x05,0x16,0x05,0x48,
        0xff,0x47,0x58,0xdb,0xe1,0x10,0xf0,0x77,0x1d,0x6b,0xf1,0x83,0x0c,0x9e,0x94,0x20,
        0xe1,0x62,0xc2,0x67,0xdc,0x45,0xe2,0xf1,0xc0,0x4d,0xef,0x9d,0x86,0xde,0xcd,0x8d,
        0x53,0xdd,0xdd,0x72,0xa8,0x16,0xcf,0x0a,0xd8,0xdb,0xb7,0xe7,0xc0,0xee,0x63,0x71,
        0xb2,0xa2,0xec,0x2e,0xb2,0x3c,0x8c,0x41,0xe5,0x9f,0xaf,0x31,0x46,0x29,0x4d,0xec,
        0x9b,0xd8,0x76,0x0c,0xa8,0xb1,0x2f,0x58,0xa2,0x62,0x7c,0x8e,0xe6,0x26,0xbe,0x60,
        0xeb,0xe9,0x3f,0xbc,0x75,0xad,0x0c,0x50,0x0c,0x2c,0x03,0x4e,0xad,0xbe,0x2c,0x6c,
        0xbf,0x7e,0x4d,0x30,0x48,0xa8,0xb8,0x6a,0x61,0x46,0x68,0x02,0xe8,0x0c,0x4c,0xf3,
        0x74,0x80,0xe3,0x98,0x8e,0x5e,0x09,0x27,0x1e,0x3a,0x11,0x7b,0x23,0x67,0x13,0x16,
        0xa7,0x18,0x87,0x66,0xf3,0xc5,0x13,0x47,0xff,0xd0,0xa2,0xca,0x2c,0x69,0xb6,0x34,
        0x35,0xaf,0xff,0x4a,0x63,0x17,0x2c,0xcc,0x01,0x12,0x01,0x40,0x10,0xea,0xaa,0xf0,
        0x3c,0xed,0x4f,0x36,0x0e,0xce,0xe8,0xf7,0x62,0x48,0x53,0x6e,0x1c,0x04,0xa3,0x2b,
        0x17,0xbd,0xbc,0x5b,0x5e,0xa2,0x1d,0x49,0x9f,0xfc,0xfc,0x25,0xdc,0x10,0x98,0x05,
        0x64,0x47,0xcb,0x29,0x02,0x8c,0xde,0x83,0x74,0xf6,0xa2,0x76,0x1e,0xa7,0xbc,0xdf,
        0x00,0xf4,0x41,0x52,0xe6,0xc6,0x83,0xa6,0xde,0x3f,0x2a,0xb3,0xef,0xa1,0x86,0x5a,
        0x08,0x6c,0x23,0xc6,0x37,0xc7,0x9e,0xf2,0x1b,0x21,0xb8,0x6b,0x9c,0x18,0xa9,0x58,
        0xd9,0x9a,0xb7,0xb7,0x62,0x4a,0x06,0xe9,0xa8,0x25,0xb2,0x71,0xb2,0x65,0x1b,0xf9,
        0x11,0xa5,0x80,0x95,0x15,0x47,0xd0,0x4c,0x41,0x13,0xbc,0xd5,0xfd,0x20,0x11,0x9e,
        0x8b,0xf8,0x45,0x13,0x3c,0xf7,0x4f,0x1c,0xe4,0xf4,0xbc,0xe7,0x8b,0x24,0x00,0xe9,
        0x65,0x3a,0x0a,0x1f,0x05,0xd3,0x1b,0x9a,0xcd,0x12,0xd7,0x3a,0xa9,0x87,0x9d,0xba,
        0xfd,0x56,0x14,0xec,0xdb,0x95,0x06,0x46,0x7a,0xf5,0x72,0x9e,0xe3,0xa5,0xdc,0x32,
        0xee,0x73,0xe8,0xeb,0x6d,0x35,0x27,0xe3,0xa7,0x67,0x31,0x24,0x08,0x15,0xf4,0xb3,
        0x16,0xfc,0x4b,0xcd,0xa7,0xec,0xd3,0x70,0x51,0x70,0xfa,0x1d,0x23,0xb1,0x58,0xdd,
        0x92,0x98,0x43,0x82,0xb6,0x33,0x9d,0x2f,0xb7,0x5a,0xf1,0x1a,0x82,0x92,0xbe,0x91,
        0xc0,0x31,0x13,0x3b,0x08,0xc3,0x5c,0xa1,0x53,0xad,0x7c,0xec,0xb1,0x10,0x1c,0xf0,
        0x3b,0xf0,0x42,0x6a,0x49,0x96,0x25,0x86,0xe5,0x32,0x40,0xa5,0x7f,0xc5,0xa5,0x5c,
        0xe2,0x3e,0x94,0xc0,0x66,0xe3,0x4c,0xe1,0x67,0xf3,0x21,0x94,0xf7,0x8a,0xcf,0x76,
        0xd0,0xc4,0x0e,0x2d,0x8c,0x25,0x66,0xf1,0x19,0x39,0x45,0x4c,0x67,0x77,0x4f,0x1d,
        0x63,0x6b,0xf5,0xe3,0x29,0x15,0x49,0x38,0x75,0x8c,0x10,0x9c,0x5b,0xe6,0x19,0x74,
        0x39,0x5c,0xce,0x52,0xe9,0xaa,0x09,0x77,0x3b,0xb5,0x29,0x97,0xa2,0x70,0x64,0xdc,
        0x2d,0x00,0x5f,0x2d,0xb9,0x1f,0xfb,0xaf,0x66,0xbe,0x72,0x8c,0x47,0xee,0xa4,0xf4,
        0x5e,0x00,0xab,0x62,0xc7,0xeb,0xb5,0x21,0x33,0xef,0x13,0x0e,0x98,0x78,0x8d,0x9f,
        0x27,0x45,0xf9,0x24,0x7f,0xc9,0x0c,0x4d,0x20,0xd2,0x6f,0xed,0x22,0x68,0x15,0xfd,
        0x27,0xf8,0xcd,0xe4,0x8e,0xb2,0x13,0xf6,0xe9,0x2f,0x2c,0x3a,0xb1,0x57,0x72,0x70,
        0x39,0x82,0xec,0x52,0xe1,0xdd,0x21,0x1b,0x8c,0x10,0x2e,0x46,0x54,0x1d,0x17,0x98,
        0x7c,0x8b,0x5b,0x60,0xa5,0xc5,0xcb,0xfe,0x45,0xbd,0x9b,0xa2,0x56,0xd4,0xba,0x56,
        0x4b,0xfe,0x5f,0x3f,0x48,0x21,0xe5,0x1f,0x92,0xbf,0xd8,0x1f,0x45,0xd5,0x50,0xcc,
        0x45,0x03,0x7d,0x5f,0x76,0xec,0x84,0x41,0x30,0xe0,0x89,0xce,0xed,0xb9,0x0d,0x5a,
        0x45,0x02,0x7b,0x71,0x1d,0x5f,0xfd,0x63,0x1b,0x28,0x94,0x00,0x5d,0x58,0x68,0xa1,
        0x6a,0xa6,0x5d,0x68,0x68,0xf1,0xe6,0xc8,0x90,0xe1,0x1e,0x47,0xe0,0xcc,0x15,0x82,
        0x0f,0xd6,0x67,0x72,0xc6,0x5d,0x14,0xef,0x0d,0x94,0x8b,0x72,0x04,0x6d,0x08,0x1f,
        0xd3,0xbd,0x20,0x03,0xe3,0x9b,0x9b,0x9a,0x4f,0x08,0x81,0x94,0x95,0xd6,0x77,0xd8,
        0x92,0xc2,0x4c,0xca,0xad,0xe4,0xd0,0xc9,0x52,0x49,0xe5,0xfc,0xa2,0xde,0xd8,0x4f,
        0x68,0x8f,0xf1,0xb8,0x4f,0xb1,0x48,0xbf,0x53,0x9d,0xdb,0x3d,0x76,0x9e,0xde,0x64,
        0xb4,0x0e,0x52,0xff,0x38,0xbb,0xd9,0xfb,0xd0,0x90,0xc9,0x27,0x9f,0x71,0x7f,0x38,
        0x12,0x66,0xf6,0x10,0x15,0xfc,0x98,0x40,0x86,0xe8,0x53,0xcb,0xe9,0xee,0xf0,0x2d,
        0x5e,0x01,0xa0,0x9b,0xd1,0xac,0xd8,0x8d,0x71,0xb0,0x5f,0x7a,0x63,0xef,0xa6,0xe2,
        0xb7,0x88,0x57,0x92,0x9b,0x44,0x30,0x24,0xce,0x31,0x12,0xc5,0x58,0x8c,0x55,0x3b,
        0x79,0xe4,0x5f,0x26,0xdf,0x7d,0x75,0x85,0x1b,0xf3,0xd0,0x7d,0x56,0x1f,0xf4,0x56,
        0x40,0x3e,0x3d,0xc7,0x4a,0x50,0xbb,0x73,0x15,0xbf,0x40,0xb3,0x2a,0x41,0xb6,0x96,
        0xeb,0xff,0xb6,0x26,0xca,0xf7,0x57,0xed,0xb8,0x9f,0x44,0xb8,0xe0,0xcb,0x12,0x9b,
        0x96,0xd0,0xd0,0x35,0x8a,0xea,0xdf,0x35,0x42,0xdb,0x04,0x1d,0xc7,0xd5,0xbb,0x47,
        0x9e,0x9a,0xce,0x25,0xf9,0xe2,0x27,0xcc,0x2f,0xfd,0xe2,0xb4,0x6a,0xb9,0xa7,0xb9,
        0x9f,0x86,0x37,0x66,0xc4,0xd8,0x44,0x73,0x3d,0xcd,0x86,0x8c,0x97,0x10,0x0b,0x55,
        0x78,0xfd,0xcf,0xaa,0xd6,0x06,0x8c,0x2b,0x68,0x55,0xd3,0xf8,0x5a,0xb2,0x5c,0xb9,
        0x45,0xa8,0x9b,0xe2,0x5e,0xe3,0x93,0x35,0xee,0xdd,0xef,0x88,0x02,0xba,0x4f,0xc8,
        0x63,0x70,0xe0,0x3e,0xc8,0x2a,0x2f,0x11,0x4b,0xef,0x3f,0x0c,0x1a,0x7e,0xd9,0xa2,
        0x6f,0x7d,0x23,0x2f,0xc2,0xd3,0x74,0x81,0x3d,0x53,0x67,0x97,0x70,0x9a,0x2e,0xa8,
        0x46,0x3a,0x29,0x68,0x37,0x18,0xb7,0x86,0xc0,0x12,0x4d,0x79,0x10,0xe5,0xc5,0x7c,
        0x05,0x4e,0xf8,0xd7,0x56,0x70,0x8e,0x61,0x12,0x76,0x15,0x43,0x49,0x79,0x51,0xfe,
        0x08,0xa4,0xd3,0xb0,0x8b,0x96,0xcd,0x93,0xaf,0x07,0x25,0xc6,0xa6,0xaf,0xc8,0x50,
        0xee,0x63,0x41,0x62,0x84,0x82,0x8a,0xdc,0x55,0x8f,0x22,0x13,0xf5,0x1f,0x5f,0xd1,
        0x93,0xf6,0x06,0x9e,0x2d,0x6d,0x19,0x3e,0x00,0x17,0xf0,0x7b,0x43,0xa3,0x8b,0x25},
        /*TST_input_dataSize*/
        1536*sizeof(DxUint8_t), 
        /*TST_output_signiture*/
        {0},
    },
        /**********************************/
        /*  2048 bit key                  */
        /**********************************/    
    { 
        {"Acceptance test - RSA SignVerify 16byteData/2048bit key "},
        /*TST_PrivetExponent_D*/
        {0x19,0xd5,0x40,0x04,0x82,0x85,0x9d,0x97,0x1a,0x4f,0x83,0x5e,0x22,0x13,0x1a,0x6f,
         0x02,0xd7,0xb8,0x17,0xef,0x86,0x68,0x8c,0xe2,0x14,0x8b,0xbc,0x24,0xe0,0x64,0xb6,
         0x23,0x6c,0xc7,0x80,0xf3,0xdf,0x70,0x5b,0xac,0x68,0xbb,0xb8,0x74,0x48,0xdd,0x33,
         0x10,0x10,0xc8,0x43,0xb3,0xf3,0x2c,0x00,0x8a,0xf8,0xd0,0xbb,0xc0,0x4b,0xe8,0xae,
         0xcd,0x3e,0x14,0xad,0x4d,0x84,0x96,0x75,0x53,0x3e,0x96,0x6a,0xff,0x5c,0xba,0x85,
         0xe1,0x26,0x7b,0xa3,0xf2,0x4d,0x7e,0x69,0xab,0x96,0x56,0x2f,0x28,0xdb,0xd0,0x72,
         0x0c,0x31,0x7d,0x49,0xfc,0xaf,0x21,0x2c,0x13,0x56,0x0f,0x34,0x71,0x66,0x6c,0x9d,
         0x86,0xf4,0x28,0x19,0x74,0x76,0xe4,0x11,0x92,0xb8,0xef,0xd0,0x87,0xa5,0x86,0x2a,
         0x83,0x30,0xbf,0x15,0xdf,0x36,0xf4,0xe1,0xdc,0x65,0x94,0x66,0xef,0x7a,0xfa,0x6b,
         0xcb,0x59,0x29,0xac,0x4c,0xa0,0x4f,0x12,0xf3,0x4a,0x1e,0x79,0x7f,0x13,0xef,0x12,
         0xd6,0xbf,0xc4,0x95,0xad,0x89,0x03,0x62,0xe9,0x8c,0x2c,0x79,0x48,0xd5,0x4b,0x65,
         0x9a,0xba,0x7b,0x5d,0xbe,0x98,0x59,0x9a,0xed,0x23,0xe6,0x6d,0x7c,0x51,0xc1,0xd6,
         0x72,0x77,0xb2,0x63,0x96,0xbf,0x03,0xf7,0x14,0xb4,0x80,0x29,0x2b,0x64,0xdc,0xf6,
         0x2f,0xe4,0x35,0x09,0xb0,0xf8,0x9c,0x13,0xfa,0x99,0x66,0x1e,0x19,0x0c,0xad,0x6c,
         0xae,0x7e,0xba,0x82,0x77,0x33,0x95,0xf9,0xd3,0xa8,0x83,0xa7,0x73,0x9f,0xb3,0xef,
         0xe5,0xc6,0x7f,0x26,0x82,0xd2,0x26,0xd8,0xa6,0xbe,0x78,0xe5,0x02,0x16,0xa7,0x81},
        /*TST_PublicExponent_E*/
        {0x01,0x00,0x01},
        /*TST_Modulus_N*/
        {0xd7,0xd6,0x06,0x52,0xd9,0x4c,0x1c,0x9c,0xe9,0xa1,0xab,0x97,0x38,0x0b,0x5f,0xc2,
         0x4b,0x27,0x21,0x04,0x4b,0xa9,0x94,0xcc,0x85,0x34,0x04,0x33,0x31,0x9f,0xf8,0x61,
         0x64,0x39,0x46,0x4a,0x42,0x97,0x4f,0x57,0xc0,0x70,0x03,0x2b,0xfe,0x79,0xfa,0x62,
         0x57,0x97,0x50,0x2b,0xbd,0x62,0x8f,0x75,0xd9,0x67,0x1f,0x16,0x9e,0x35,0xd1,0x17,
         0x8f,0xa1,0x06,0x81,0xd5,0x80,0xfa,0x72,0xef,0x8c,0x64,0x0c,0xb8,0x95,0x25,0x07,
         0x8f,0x9c,0xae,0x3a,0x27,0xfe,0x74,0xf1,0x0d,0x72,0x49,0x06,0x1a,0xba,0x76,0x34,
         0x5e,0xa1,0x67,0x1d,0x2d,0x13,0x1e,0xc8,0x67,0x76,0x3a,0x0b,0x3f,0x25,0xa9,0xb5,
         0x2e,0xeb,0xbc,0x09,0xcf,0x2f,0xed,0x7a,0x48,0x24,0xa2,0xb5,0x2e,0x04,0xe3,0xae,
         0x12,0xe1,0x9d,0xc4,0x5d,0x56,0x36,0x76,0x03,0x03,0xb9,0x49,0xee,0x12,0xf5,0x32,
         0x62,0x18,0xea,0x7e,0x74,0x47,0x48,0x97,0x95,0x92,0x3e,0xdb,0x73,0x5e,0xeb,0x22,
         0x37,0xc1,0x63,0xbf,0x44,0x1e,0x5f,0xf3,0x5c,0xcc,0x34,0xaa,0xb8,0x3f,0xaf,0x89,
         0x21,0x0c,0x0c,0x5a,0x93,0xca,0x91,0x34,0x68,0x9a,0x65,0xc4,0x81,0xfe,0x05,0xb8,
         0x99,0x55,0x99,0xd8,0x58,0x18,0x74,0x2a,0xce,0x31,0x7a,0xa3,0xa6,0x60,0xa0,0x72,
         0x65,0xed,0xad,0x95,0x1d,0xf8,0x72,0xb1,0x36,0xdc,0x53,0x2a,0x68,0x7f,0xce,0x82,
         0x4f,0xb1,0xe3,0xef,0x02,0x64,0x4c,0x7e,0xd3,0x57,0x51,0x72,0xe0,0x06,0x3c,0xbd,
         0xce,0x04,0x33,0x9a,0x66,0xa4,0x83,0x29,0x56,0xf3,0xe9,0xec,0xab,0x12,0x9d,0xfd},
        /*TST_P*/
        {0xf9,0xba,0xdf,0xfa,0x9b,0xc2,0xb2,0x45,0xd3,0x2f,0x57,0x8a,0x9e,0x62,0xaa,0x9c,
         0x10,0x11,0xe8,0x04,0x22,0x7d,0xd6,0xd9,0xc5,0x12,0xff,0xdc,0x8e,0x47,0x5a,0x65,
         0x96,0x94,0x94,0x96,0x1b,0xba,0xe0,0x6e,0x1a,0xca,0xb5,0xd3,0x07,0x2e,0x18,0xce,
         0xd8,0x99,0x88,0xf1,0x9b,0xf3,0x00,0xd6,0xc2,0xf7,0x40,0xca,0x81,0x25,0x5b,0x45,
         0xbb,0x42,0xc2,0xb8,0x97,0x46,0xfe,0x2d,0xd2,0xf8,0xed,0x7a,0x2f,0xbc,0x00,0xac,
         0xa8,0x4d,0xf6,0x70,0xe9,0x93,0xf2,0x1f,0x66,0xfa,0x6a,0xf5,0x99,0x8e,0x95,0x3d,
         0x4d,0x58,0x66,0x28,0xd1,0x3b,0x0a,0xcd,0xe0,0x14,0x23,0x18,0x7d,0x81,0xb7,0x93,
         0x28,0xff,0x45,0x3f,0xa2,0xeb,0x04,0x84,0xdd,0x51,0x46,0xb3,0x74,0x4b,0xd7,0x25},
        /*TST_Q*/
         {0xdd,0x41,0x4c,0x63,0x98,0x2a,0x8d,0xf3,0xd5,0x3f,0xcb,0x78,0xf3,0x76,0x01,0x85,
         0x8d,0x86,0x63,0x8e,0x59,0x35,0x48,0xe7,0xa4,0x77,0xe0,0xc1,0x18,0x9c,0x63,0xff,
         0xee,0x80,0xe7,0x00,0xe1,0x6a,0x20,0x39,0x82,0xc9,0x4b,0x7d,0x92,0x91,0x41,0x41,
         0x96,0xe7,0x05,0xaf,0xeb,0xc3,0x74,0x0f,0x9f,0x25,0xf7,0x1c,0x1d,0xda,0x29,0x76,
         0x83,0x46,0x3f,0x52,0xa1,0x02,0xb7,0xf9,0xd3,0x8c,0x76,0xc8,0xbe,0x60,0x77,0xb9,
         0xd5,0x4e,0x18,0x13,0x2b,0x0c,0x7a,0xef,0xd9,0x1b,0x31,0x75,0x74,0xa5,0x08,0xec,
         0x5f,0x0e,0x65,0x0f,0xe4,0xfc,0x70,0xe7,0x12,0xc7,0x2f,0x66,0x06,0xe6,0xf7,0x46,
         0xc9,0x5d,0x04,0xe7,0xf3,0x5a,0x24,0x58,0x0d,0xd5,0x4d,0x14,0x90,0x57,0x7f,0xf9},     
        /*TST_dP*/
         {0xca,0xc4,0xe6,0xaa,0x18,0xa0,0xcc,0x99,0x8f,0x71,0x08,0x36,0xa0,0x85,0xe2,0x9b,
         0x97,0x1c,0xc2,0xf3,0xe0,0x81,0xa6,0xda,0xe9,0x7e,0x94,0xcb,0xa3,0xa6,0xe2,0x0a,
         0x4c,0x6a,0xd5,0xfe,0xd0,0x03,0x3b,0xc9,0x8a,0xed,0x7f,0x17,0x1a,0xe4,0x5d,0xf6,
         0x4d,0xbe,0xd4,0x87,0xc1,0x25,0x5d,0x50,0x03,0xbc,0x39,0x1a,0x74,0x24,0x3d,0xe8,
         0xef,0xb4,0xb4,0x60,0xa7,0x4c,0x58,0x84,0x22,0xa2,0x46,0x48,0x88,0xcb,0xb1,0x0c,
         0x80,0x17,0xd5,0x7b,0x36,0xdd,0x0e,0xa2,0x5a,0xbe,0x07,0xec,0xe5,0x42,0xf5,0x80,
         0x71,0xf5,0xcd,0xf5,0x64,0x75,0xf9,0x3e,0xd2,0xab,0xe7,0x17,0x32,0x89,0x09,0xe2,
         0x6e,0x4e,0x5f,0x0e,0xdd,0x9c,0xcf,0xed,0x85,0xba,0x41,0x9a,0xe2,0x59,0xd6,0x15},
        /*TST_dQ*/
         {0xa9,0x7a,0xf0,0x61,0xc5,0xd8,0xaa,0xfd,0xe1,0x16,0xc9,0xec,0xaf,0x49,0x70,0x66,
         0xf5,0xfe,0xc0,0x59,0xf4,0xd9,0x8d,0x2b,0xeb,0x5e,0xec,0x69,0xdd,0x49,0x46,0x8c,
         0x70,0x0c,0x8b,0x66,0xb0,0x44,0x93,0xc4,0x99,0xfb,0x49,0x79,0x3a,0x01,0x4c,0x24,
         0x4a,0xcc,0x52,0x1d,0xec,0x91,0xbe,0x60,0x8c,0xff,0x0e,0xe7,0x99,0xb2,0x58,0x5a,
         0x70,0xba,0x29,0x9d,0x48,0xba,0x85,0x64,0xb7,0xf8,0x7b,0xb0,0xcf,0xab,0xa3,0x6a,
         0x55,0x0b,0x4a,0x03,0xbc,0xd1,0x05,0x86,0x9e,0x1e,0x67,0x67,0x5a,0x5f,0x64,0x93,
         0x73,0x48,0xda,0x7f,0x2f,0x5f,0x73,0xb8,0x7d,0x38,0xd8,0x84,0xe5,0xba,0x9c,0x25,
         0xbb,0xef,0x25,0xe7,0xeb,0x0f,0xdc,0x91,0x1a,0x9f,0x8e,0x38,0xb7,0x4c,0x5f,0x39},
        /*TST_Qinv*/
        {0xa6,0x1d,0xc0,0xb0,0x32,0x7b,0x00,0x3e,0xa2,0x13,0xbf,0x5a,0x1d,0xc2,0x1b,0xb1,
         0xcb,0x18,0x0d,0x8f,0xae,0x7f,0xb4,0xc1,0x57,0x85,0x8a,0x5b,0x0a,0xdf,0xf3,0x5d,
         0x9c,0xab,0x81,0x43,0x9e,0xf4,0x5e,0x3f,0x5e,0x37,0x85,0x9d,0xb8,0x8a,0x82,0xde,
         0xbf,0x16,0xdc,0x75,0x3b,0x98,0xdc,0x41,0x25,0x3f,0x19,0x89,0x02,0xf2,0xec,0xef,
         0xd8,0x05,0x48,0x5a,0x8c,0x1b,0xbe,0x2d,0x8e,0xef,0x0b,0xe4,0xa9,0x78,0x1f,0x1c,
         0xfc,0xf3,0xd9,0x4c,0xae,0x5e,0x77,0x90,0x31,0xb7,0x16,0xca,0xf0,0xa0,0xea,0x4d,
         0x59,0xc9,0x90,0x04,0x7e,0x1b,0x36,0x86,0x5a,0xca,0xb4,0x0d,0xa3,0xa1,0xb8,0x2d,
         0x68,0x38,0x5f,0xcb,0xae,0x36,0x4f,0x5d,0x55,0x16,0xfd,0xc5,0x2f,0x8b,0xb2,0xec},
         /*TST_KeySize*/
        256*sizeof(DxUint8_t),
        /*TST_DPSize*/
        128*sizeof(DxUint8_t),      
        /*TST_PubExponentSize*/
        3*sizeof(DxUint8_t),
        /*TST_SaltLength*/
        20,       
        /*TST_input_data*/
        {0xa9,0x7a,0xf0,0x61,0xc5,0xd8,0xaa,0xfd,0xe1,0x16,0xc9,0xec,0xaf,0x49,0x70,0x66},
        /*TST_input_dataSize*/
        16*sizeof(DxUint8_t), 
        /*TST_output_signiture*/
        {0},
    },
    { 
        {"Acceptance test - RSA SignVerify 32byteData/2048bit key "},
        /*TST_PrivetExponent_D*/
        {0x53,0x40,0x45,0xb5,0xaf,0x1c,0x7f,0x2c,0x57,0x54,0xce,0x02,0x15,0xb5,0x74,0x86,
         0xa6,0xff,0x31,0xe0,0xb3,0x70,0xec,0x03,0x2f,0x53,0x88,0xd8,0x44,0x27,0x5a,0x64,
         0x3f,0xc7,0xba,0xdf,0x07,0xa2,0x1d,0x34,0xc0,0xe6,0x38,0x7e,0x32,0xfd,0xc3,0x12,
         0x52,0x59,0xed,0xa0,0xe8,0xaf,0x4e,0x85,0xd7,0x08,0x7d,0x04,0xd8,0xaa,0xd7,0xb9,
         0x91,0x12,0x7b,0xbc,0x1f,0x7d,0x93,0xac,0xda,0xc5,0x8f,0x41,0xeb,0x6a,0x49,0xf9,
         0xa0,0x58,0x2e,0x79,0x93,0xfa,0xd5,0x93,0x16,0xad,0xb4,0x3b,0xfb,0x41,0x6e,0x02,
         0xe8,0xcc,0x65,0x6c,0x30,0xae,0x2e,0x99,0x09,0x21,0x45,0x89,0x4a,0x3c,0x02,0xa1,
         0x38,0xba,0x1c,0xa6,0xbe,0xa8,0xbd,0x34,0xaa,0x24,0xd4,0xb5,0x86,0x34,0x35,0x22,
         0xb6,0x35,0x97,0x9c,0xe2,0xe2,0xf6,0x6b,0x01,0xf3,0x23,0x2e,0x37,0x8a,0x0a,0x3e,
         0x13,0xf3,0x7f,0xf1,0x27,0x57,0xf0,0x03,0x27,0x01,0x28,0x43,0x18,0xbc,0x18,0x26,
         0x21,0xc7,0x24,0x89,0xc8,0x3a,0x31,0x3c,0xe8,0xe7,0x61,0xde,0x9c,0x16,0xe6,0x83,
         0x44,0xe7,0x68,0x66,0x2e,0x26,0x3f,0x32,0x9b,0x3d,0x42,0x9f,0xcc,0xd3,0x45,0x7d,
         0x93,0x0d,0x16,0x9e,0x8d,0xec,0x8e,0xc2,0xcb,0xb1,0x6b,0xb8,0x4c,0x0a,0xbf,0x86,
         0xc4,0x58,0x3d,0xa4,0xe0,0x44,0x0e,0xd0,0x3e,0xb9,0xd1,0xce,0xc9,0x62,0x5e,0xf4,
         0xa6,0x02,0xb2,0x9d,0x1d,0xbb,0xe6,0xd2,0x79,0xbf,0x71,0x77,0xa4,0xa5,0xbe,0xc0,
         0xfa,0x2c,0x5a,0xbc,0x6c,0x88,0x6e,0x9d,0x2e,0x47,0x7f,0x3b,0x6e,0x0f,0x0d,0x21},
        /*TST_PublicExponent_E*/
        {0x01,0x00,0x01},
        /*TST_Modulus_N*/
        {0xd0,0xa0,0xa0,0x48,0x90,0x45,0x5d,0xfb,0x5d,0x6f,0xcd,0x7a,0x6f,0xe7,0x0a,0x60,
         0x97,0xab,0x0a,0x6a,0x15,0xf1,0x6d,0xc1,0x26,0x0b,0xfb,0xba,0xe6,0x63,0x70,0xf5,
         0xd7,0x3d,0x1b,0xdd,0xe1,0x78,0x41,0x61,0x02,0x60,0xe2,0x85,0x15,0xcf,0x31,0x6a,
         0x52,0x58,0xce,0x10,0xa9,0xf0,0x18,0x53,0xb0,0xe3,0x9c,0xd4,0xe7,0xf4,0x92,0x04,
         0x00,0x6e,0x63,0x49,0x04,0x8f,0x07,0x12,0x63,0x52,0x8f,0x62,0x12,0x71,0xc2,0xcc,
         0x7e,0x69,0x8d,0x5e,0x8b,0xc0,0x31,0x00,0xab,0x0a,0x35,0x80,0xd1,0x39,0x05,0xea,
         0x73,0xe4,0xe3,0x07,0xd0,0x04,0xb1,0x0d,0xef,0xcf,0xe7,0x5b,0x63,0x1d,0xa6,0x3a,
         0x5f,0xf6,0xcf,0xd8,0xcc,0x63,0x42,0x25,0xd1,0x6b,0x5a,0x8d,0x11,0x3e,0xd6,0xa5,
         0xe6,0x91,0x1a,0xdb,0x13,0xb8,0x88,0xf7,0xe3,0x97,0x14,0x39,0x58,0x56,0xb0,0x21,
         0xf7,0x2c,0xf6,0x6c,0xdd,0x14,0x17,0x6b,0xdf,0x61,0xe4,0xce,0xfa,0x44,0x21,0x10,
         0xd9,0x7e,0xe3,0xe1,0x27,0xa0,0x33,0x1e,0xa8,0x72,0x36,0xe6,0x85,0x41,0x1b,0x91,
         0xd7,0x0c,0xf4,0x41,0xe5,0xef,0xb0,0xaa,0xcb,0x68,0xed,0x70,0xc7,0xb7,0xd9,0xcc,
         0xba,0x81,0x58,0xc9,0x8c,0x13,0x5f,0xce,0xbc,0x5a,0x73,0xff,0xda,0x21,0xa1,0x53,
         0x6e,0x4d,0x4a,0x29,0xd0,0x31,0xd2,0x0f,0x5b,0xf6,0xe2,0xaa,0xda,0xae,0xb0,0x18,
         0x88,0x0d,0x8d,0x9a,0xe0,0x85,0x65,0x7f,0x5f,0x66,0x30,0xf6,0xfd,0x0d,0x03,0x48,
         0xd6,0x41,0xfc,0x2b,0x82,0xde,0x25,0x6c,0x37,0xba,0x59,0x90,0xe1,0xb3,0xcd,0x41},
        /*TST_P*/
        {0xe7,0xeb,0x06,0x43,0x91,0xf3,0xa7,0x57,0x1f,0xd7,0x55,0x0a,0xa0,0xbf,0x19,0x23,
         0x39,0x43,0xe2,0xe6,0xaf,0x94,0x49,0xc2,0x50,0xbc,0xc4,0x37,0x76,0xfd,0x4a,0xb4,
         0x56,0x3d,0xd3,0x9a,0xe9,0x29,0x9d,0x8a,0x5d,0xce,0x0f,0x07,0x33,0x3d,0x68,0xbc,
         0xd5,0xaa,0xbb,0xeb,0xd8,0xfd,0x05,0x99,0xe4,0xb9,0x9f,0x7a,0x4d,0x91,0xd9,0x96,
         0x33,0xca,0x79,0xfe,0x02,0xa0,0x8e,0x5d,0x74,0x8c,0x8c,0xb2,0x31,0xd8,0x4d,0x7e,
         0x7f,0xab,0x0a,0xbb,0x34,0x58,0x94,0xae,0xc0,0x57,0xce,0x59,0xa5,0x65,0x1d,0x38,
         0x82,0x6e,0xcd,0x91,0x27,0x8f,0xe8,0x5a,0xf6,0x4a,0x2e,0x80,0x5c,0x23,0xf2,0x23,
         0x74,0x21,0xea,0x2c,0x1a,0x33,0x8e,0xd1,0x84,0x95,0x3d,0x96,0xea,0xcf,0xa7,0xdb},
        /*TST_Q*/
        {0xe6,0x4a,0x7a,0x37,0x3c,0xdb,0x44,0x01,0xc9,0xf4,0x2a,0x4c,0x9b,0x01,0x87,0x18,
         0xc2,0x47,0xcb,0x82,0xa9,0x24,0x6b,0x96,0x11,0x39,0xed,0x19,0x7f,0xfe,0xdc,0x4a,
         0x8f,0x7f,0x56,0x6e,0xaf,0x31,0x57,0xb8,0xd7,0x8f,0x4c,0x3a,0x7e,0xad,0x23,0x94,
         0x49,0x67,0x6a,0x3e,0x7e,0x38,0xa0,0x54,0x39,0x9e,0x2c,0xdd,0xa8,0x66,0x81,0xbb,
         0x56,0x4a,0xb4,0xb4,0xc8,0x39,0x4a,0xac,0xc5,0xec,0x37,0x3e,0x13,0x62,0xfa,0x8a,
         0xbb,0xbd,0xb7,0x32,0xcc,0xa0,0xa1,0x2e,0xab,0x57,0x7f,0x5c,0xec,0x72,0x4a,0xd6,
         0x93,0x72,0xcf,0xb3,0xbb,0xb0,0x9b,0xc7,0x22,0xd8,0x65,0x39,0x18,0x20,0x3e,0x44,
         0x12,0x82,0x39,0x89,0x8e,0xad,0x9c,0x94,0x4f,0x04,0x66,0x43,0xea,0xba,0x88,0x13},     
        /*TST_dP*/
        {0xd0,0x9c,0xa9,0x32,0xc8,0xab,0x9a,0x40,0x15,0x85,0x35,0x9a,0xec,0xc3,0x58,0xd2,
         0x45,0x65,0x9a,0x49,0x95,0x70,0x56,0xf4,0xb2,0x79,0x4a,0x2a,0xf6,0x1e,0x9b,0x3f,
         0x22,0x40,0x55,0x02,0x88,0x6f,0x85,0xa5,0x7c,0x01,0xa9,0xa4,0xf9,0x63,0x68,0xbe,
         0x4b,0x98,0x5b,0x97,0xa7,0xc4,0xd9,0x6f,0xf7,0xbd,0x3d,0x05,0xdf,0x96,0xad,0x59,
         0x9d,0xd6,0xa8,0xeb,0x62,0xe3,0x97,0x8b,0xdb,0x15,0xbe,0x4d,0x5f,0xe6,0xc8,0xb6,
         0x5c,0x12,0xb8,0x01,0x72,0xf1,0xa7,0x34,0x96,0x11,0xa5,0xad,0x1f,0xc8,0x97,0x83,
         0x48,0x58,0x71,0x12,0xfb,0xba,0x47,0xf0,0xe2,0x90,0x11,0xca,0x26,0x97,0xb2,0xec,
         0x4f,0x3f,0x5e,0x8c,0x33,0x39,0x63,0x63,0x75,0xd6,0x64,0xe3,0x46,0xee,0x69,0x77},
        /*TST_dQ*/
        {0xbb,0x81,0x6e,0xab,0x65,0x28,0x9e,0xe1,0xd9,0xfe,0xad,0x26,0x3c,0x9b,0x6c,0xd5,
         0x52,0xf2,0xc4,0x18,0x3a,0x02,0x06,0x7b,0x64,0xc1,0x46,0x75,0x19,0xcb,0x78,0xb0,
         0x58,0xd0,0x74,0x9e,0xa0,0x94,0xcb,0x79,0x1c,0x42,0x77,0xed,0xb4,0xd0,0xe2,0x84,
         0x4d,0x94,0x1f,0x64,0x8c,0xbf,0x2c,0x84,0x07,0x79,0xeb,0xcb,0xfa,0xde,0xa3,0xc8,
         0xd6,0x04,0xf3,0xc7,0xb2,0xb3,0x3b,0x43,0x1b,0xd0,0x2e,0x56,0xa3,0xd0,0x56,0x70,
         0xf9,0x56,0x0a,0x41,0x19,0x6d,0xbc,0x6f,0x54,0x61,0x64,0xb9,0x53,0x67,0xe7,0xd9,
         0x78,0xaa,0xe5,0xc4,0xd1,0x10,0x86,0x76,0x08,0xc0,0x2b,0x02,0xe6,0xca,0xf2,0x07,
         0xd9,0x0e,0x21,0x2d,0x08,0x78,0x01,0x62,0x9c,0x47,0xd7,0xc0,0x7a,0xf1,0xaf,0xf3},
        /*TST_Qinv*/
        {0xb2,0x13,0x28,0x97,0x44,0x7b,0x26,0x94,0x55,0x4a,0xd9,0xd4,0x3f,0xad,0x66,0xda,
         0x67,0x18,0x92,0x4e,0x71,0xa5,0x85,0x20,0xcb,0x66,0x37,0x05,0x89,0xb5,0x1e,0xa3,
         0xb8,0x22,0x89,0x2a,0xb0,0x31,0x4a,0xdc,0x59,0x4f,0x7b,0x95,0x09,0xdd,0x0c,0xc6,
         0xa3,0x4d,0x4b,0x34,0xce,0x46,0x48,0x4d,0x79,0x64,0x24,0x73,0xf1,0x13,0xc1,0xa7,
         0x58,0x20,0xfb,0x32,0xe3,0x1b,0x15,0xad,0xfe,0xb9,0xcb,0x0c,0x8f,0xb6,0x13,0x11,
         0xab,0x16,0x07,0x2b,0xab,0x20,0x65,0x87,0x70,0xa4,0x4c,0x4f,0x2a,0x0f,0x8b,0x9a,
         0x30,0x7e,0xee,0x85,0x45,0xda,0x6b,0xab,0x7a,0xb8,0xfa,0x19,0x95,0xb1,0xd2,0x09,
         0xe3,0x00,0x7c,0x93,0x81,0xea,0xa3,0x19,0xa7,0x8f,0xea,0x81,0x65,0x63,0x2a,0x45},
         /*TST_KeySize*/
        256*sizeof(DxUint8_t),
        /*TST_DPSize*/
        128*sizeof(DxUint8_t),      
        /*TST_PubExponentSize*/
        3*sizeof(DxUint8_t),
        /*TST_SaltLength*/
        20,       
        /*TST_input_data*/
        {0x3b,0x67,0x2a,0x6c,0xa4,0xd7,0x75,0x5b,0x05,0x4e,0xf0,0x48,0xab,0x14,0xca,0xc3,
         0xaa,0x58,0x92,0x31,0x4c,0x70,0xc0,0xb0,0x95,0x9d,0x86,0xf8,0xcd,0x77,0x45,0x97},
        /*TST_input_dataSize*/
        32*sizeof(DxUint8_t), 
        /*TST_output_signiture*/
        {0},
    },
    { 
        {"Acceptance test - RSA SignVerify 512byteData/2048bit key "},
        /*TST_PrivetExponent_D*/
        {0x8f,0x19,0xde,0xd8,0x8f,0xf5,0x9c,0xba,0x8a,0xe5,0xf2,0x2d,0x24,0x26,0xa4,0x9f,
        0x09,0x9d,0x60,0x6e,0x5e,0xee,0xbd,0x6f,0xf9,0x22,0xe4,0x74,0xea,0xcc,0x00,0x8b,
        0x16,0x68,0x20,0x37,0xcc,0x07,0xa5,0xd8,0x6a,0x63,0xdf,0x85,0x2f,0xd1,0x35,0xe7,
        0x5a,0x32,0x9e,0x3e,0x48,0xc5,0x95,0xc9,0x1e,0x6c,0xcb,0xf4,0xf7,0xa7,0xb1,0xa6,
        0x06,0xde,0xcd,0x98,0x86,0x72,0x39,0xe8,0x38,0x37,0x24,0xf4,0xa0,0xb3,0x63,0x02,
        0x6d,0x6b,0xca,0xb3,0x74,0xdb,0xd4,0xf9,0xbd,0x44,0xac,0x12,0x48,0x1b,0x9a,0xc9,
        0xb7,0x24,0x05,0x47,0xaf,0x96,0xbe,0xc4,0x1f,0xdb,0x14,0xbf,0x8d,0xce,0x06,0x16,
        0x6b,0x15,0x6d,0x69,0xce,0x44,0xaf,0xb3,0x0f,0x46,0x29,0x54,0x08,0xb0,0xc0,0x94,
        0x5b,0xd5,0xe9,0x23,0xf4,0x7c,0x58,0x0e,0xe3,0xd9,0xc1,0xee,0x83,0x9e,0x5e,0x37,
        0x98,0xb8,0xed,0x8e,0x96,0xb8,0x30,0xfe,0x07,0xdb,0xbb,0x72,0x6e,0x3b,0x00,0x3c,
        0x57,0x31,0xd0,0xcf,0xbc,0xea,0x60,0xe7,0xd7,0x81,0x2c,0x70,0x2f,0x96,0x9b,0xb1,
        0x77,0x76,0x18,0x07,0x71,0x6c,0xda,0x06,0x17,0x33,0x79,0x86,0x78,0xa0,0xfb,0x48,
        0x55,0xa4,0xe4,0x9f,0xe5,0x52,0xd6,0xea,0xbb,0xaa,0x8e,0xee,0xdd,0xce,0x50,0x2a,
        0xcd,0xb9,0x8d,0x65,0x87,0x5b,0x1b,0x3b,0x76,0xaf,0x0c,0x1d,0x24,0x0f,0x52,0x9a,
        0x80,0x15,0x88,0x92,0x80,0x5c,0xf5,0x7c,0x70,0xb9,0x9b,0xaa,0xb4,0x8e,0x6c,0x95,
        0x35,0x92,0x42,0xb5,0xe2,0xf3,0x9a,0x6f,0x51,0x28,0x19,0x34,0x3b,0xef,0x95,0x29},
        /*TST_PublicExponent_E*/
        {0x01,0x00,0x01},
        /*TST_Modulus_N*/
        {0xb0,0x8a,0x9f,0x8c,0xb9,0x40,0xc6,0x8b,0x33,0x31,0xd4,0x30,0xdb,0x4d,0x5f,0x72,
        0xd0,0x5d,0xba,0xd8,0x97,0x88,0xbd,0xb5,0x58,0xc3,0xf2,0xcb,0x85,0xb2,0xb5,0xa9,
        0x97,0x16,0x22,0xfe,0xc8,0x30,0x3c,0xd5,0xde,0x5a,0xe7,0xc0,0x45,0x31,0x74,0xc3,
        0x2b,0x91,0x88,0x00,0x61,0x7a,0x6b,0x7c,0x89,0xdf,0x0f,0x22,0xa6,0xce,0xe7,0xca,
        0xf4,0x73,0xed,0xa0,0x70,0x78,0x34,0xfb,0x77,0x45,0xaa,0x13,0x77,0x95,0x6b,0xe6,
        0xc5,0x0f,0x4f,0x81,0x50,0xdd,0x42,0x4d,0x78,0xb4,0x1f,0x20,0x2f,0xdf,0x17,0x2b,
        0xdb,0x7f,0xe4,0xc2,0xf6,0x3b,0xe4,0x6e,0x0a,0x47,0xa9,0x59,0x03,0xb6,0xa2,0x8c,
        0x13,0x28,0xdc,0xdc,0x66,0x85,0x9a,0x18,0x99,0xd4,0x1a,0x0d,0x6f,0x7b,0x59,0x3c,
        0x58,0x39,0xe9,0x82,0xa4,0xd8,0x8d,0xcc,0xd5,0xcb,0x6a,0x6c,0x48,0x0a,0x0d,0x5e,
        0x15,0x27,0xe3,0x57,0x62,0x7b,0x60,0xd9,0x97,0xdd,0x05,0x62,0xa2,0xe2,0xa6,0x0c,
        0x5b,0x74,0x72,0x44,0xc3,0x65,0x9f,0x55,0xa2,0x9e,0xbf,0x3b,0x2c,0xee,0xc6,0x47,
        0x2e,0x31,0x31,0x28,0xcd,0x70,0x22,0x44,0x2d,0xf4,0x86,0x55,0xcd,0xfa,0xc5,0x73,
        0xa9,0x4a,0x4d,0xd2,0x4f,0xaa,0xc7,0xbd,0xd4,0x0e,0x2a,0x31,0x5e,0x3b,0x0c,0xcb,
        0xd0,0x2c,0xe0,0xf5,0x4e,0x45,0xed,0x83,0x74,0x5d,0x55,0x2d,0x45,0xf8,0xc1,0xb4,
        0x74,0x9c,0xe0,0xf8,0xc7,0xb2,0x39,0x8b,0x37,0x15,0xd7,0x3a,0xa0,0x1e,0x0a,0xa4,
        0x81,0xcb,0x21,0x6f,0xe6,0x4c,0xaa,0xd7,0x83,0x26,0xaf,0x1e,0x0d,0x69,0x66,0xeb},
        /*TST_P*/
        {0xdb,0x11,0xac,0x82,0xcc,0xce,0xcd,0xd5,0xaa,0x91,0x86,0x6c,0x2e,0x7a,0x5c,0x85,
        0xcc,0xbe,0x04,0xd5,0xd0,0x94,0x70,0x3c,0x0e,0x7b,0x0d,0x21,0xf3,0x27,0x3d,0x61,
        0x9c,0x58,0x96,0x3f,0xb4,0x20,0x85,0xe2,0x67,0xe4,0x97,0xbf,0xa0,0xa7,0xa7,0x2d,
        0xba,0x6a,0x19,0x26,0x9f,0x20,0xd1,0xd5,0xc6,0xa8,0xa4,0xaa,0x9d,0x8d,0x7e,0x53,
        0xe1,0x16,0x23,0x29,0xfe,0xf8,0x69,0xcc,0x0a,0xa0,0x46,0x3b,0xd5,0x13,0x3b,0xec,
        0xa9,0xe2,0x97,0x4f,0xe1,0x49,0xd2,0x8c,0xad,0x7b,0x13,0x39,0x8b,0x94,0xd0,0xbb,
        0x52,0xc3,0x95,0xd7,0x44,0xb5,0xb0,0x89,0x55,0xd0,0x8a,0x71,0x5b,0xcf,0x52,0x33,
        0xd7,0x18,0x31,0xef,0xe6,0xe5,0xd7,0xbf,0xc2,0x78,0x93,0x12,0x81,0x97,0x8e,0x85},
        /*TST_Q*/
        {0xce,0x4d,0x98,0x66,0xf0,0x4c,0xe2,0xb8,0x12,0xf5,0x96,0x4c,0x25,0x5a,0x9d,0x75,
        0x4a,0x89,0x44,0xb9,0x70,0xad,0x16,0xd1,0xc2,0xcc,0x26,0x74,0xde,0x41,0xea,0x28,
        0x25,0x03,0xfc,0x6f,0x3e,0x2f,0xeb,0xb6,0x3d,0x91,0xff,0x6b,0xa5,0x26,0x52,0x6d,
        0x20,0xf3,0x65,0xb8,0xd6,0x99,0x02,0x51,0xfe,0x8f,0xef,0xd3,0xc3,0xb2,0xc3,0x73,
        0xf4,0xb9,0xb8,0x20,0x0d,0xa4,0x3d,0xc6,0x5d,0x62,0xc1,0x73,0xf7,0xeb,0x63,0xf9,
        0xdf,0x18,0xe9,0x5c,0xb1,0x94,0x8c,0x01,0x64,0xc0,0x80,0x60,0x65,0x53,0xf1,0x9e,
        0xa9,0x67,0x05,0xa6,0x7b,0x97,0x86,0x55,0xef,0xd5,0x60,0x6d,0x4c,0xc3,0xa4,0xb0,
        0x53,0x3a,0x18,0xfe,0xe8,0x64,0xb3,0xcd,0xa9,0x94,0xa3,0xad,0xe0,0xe5,0x32,0xaf},      
        /*TST_dP*/
        {0xab,0xc0,0xe1,0x95,0xf3,0x69,0x38,0x6c,0x0a,0xbc,0xe9,0xbd,0x2b,0x7b,0x77,0xca,
        0xd7,0x49,0x2b,0x95,0x4f,0x60,0xf1,0xd5,0xc4,0x2c,0xa9,0x91,0x32,0x88,0x53,0x51,
        0x92,0x38,0xca,0x23,0xcb,0xdf,0xab,0xd8,0x64,0x48,0x0e,0xc9,0x88,0xf5,0xa8,0xd6,
        0xeb,0x4e,0x7f,0xc5,0x8e,0x01,0x37,0x42,0xf9,0xec,0x02,0x9e,0x59,0xc4,0x33,0x85,
        0x23,0xf6,0x2d,0x3f,0xa1,0xcd,0xb5,0x74,0xe9,0xe7,0xda,0xe8,0xd2,0x17,0xb0,0x65,
        0xce,0x93,0xfe,0xb9,0xfc,0x11,0xda,0xe7,0xbc,0xa3,0xbf,0xe0,0xe0,0x14,0x9e,0xca,
        0x1f,0x0b,0x85,0x11,0x2f,0xa7,0x9b,0x6f,0x31,0x3e,0xbd,0x2c,0x3f,0x24,0xfe,0x77,
        0xf2,0x6d,0xdf,0xc9,0x0d,0x28,0xaa,0xcc,0x87,0x75,0xed,0x29,0x17,0x3d,0x71,0xd9},
        /*TST_dQ*/
        {0xa9,0x2a,0x11,0x7c,0xdf,0x30,0x7c,0x7b,0xe9,0xf7,0xfd,0x2d,0x25,0x38,0x1f,0x83,
        0x2d,0x02,0x50,0x1b,0x2b,0x1c,0x93,0x68,0x9f,0x2d,0xdd,0x9e,0xd9,0x1c,0xfd,0x8f,
        0xbb,0x82,0x80,0x3d,0x0b,0xa6,0x29,0xc6,0xfe,0xc7,0xb7,0xc4,0xa1,0xe0,0x41,0x98,
        0x80,0x7b,0x74,0xfe,0xd2,0xe1,0x16,0x78,0xfb,0x9f,0x35,0x4d,0xd4,0xdb,0xc1,0xcf,
        0x54,0x6d,0xf1,0x60,0x3f,0x2f,0x5d,0x04,0x4a,0x51,0x0f,0x46,0x33,0x95,0x8e,0x1e,
        0x37,0x64,0xea,0xfd,0xfa,0x13,0x4f,0x96,0x58,0xf2,0x4c,0x92,0x3e,0xa4,0x4d,0xad,
        0x07,0x45,0x95,0xe9,0x84,0xd0,0xa3,0xf3,0xd5,0xbc,0x86,0xdc,0x39,0x24,0xf7,0xe7,
        0x29,0xe7,0xaa,0xd5,0x62,0xe4,0x28,0x57,0xcc,0xe5,0x38,0x2d,0xfd,0x0a,0x93,0xbb},
        /*TST_Qinv*/
        {0x78,0xe0,0x41,0x17,0x2c,0xc8,0x50,0x51,0x7b,0x2b,0x44,0x8c,0xff,0x55,0x31,0xc7,
        0x31,0xa6,0xca,0x58,0x79,0x25,0x33,0x91,0x91,0x1b,0xf2,0xc6,0xf9,0x8b,0xdb,0x8e,
        0xc6,0x94,0x96,0x7b,0xd0,0x14,0xc3,0xb6,0x59,0x57,0x04,0xf6,0x31,0x3b,0x92,0x04,
        0x06,0xa7,0xa1,0x9d,0x78,0x92,0x33,0xbf,0x4c,0xcb,0x3f,0x7d,0x86,0x83,0x3a,0x7b,
        0x92,0x09,0x30,0x9e,0xf5,0x91,0x01,0xa1,0xaf,0xff,0x08,0xed,0x2d,0x76,0x8a,0x69,
        0xfb,0x99,0x00,0x2c,0x3b,0x40,0x16,0x53,0xbb,0x9b,0xae,0x09,0xd3,0x2f,0x77,0xd7,
        0xb1,0x41,0x67,0x97,0x93,0x08,0xc8,0xcb,0xa8,0x32,0x4f,0xa9,0xb4,0x28,0x9f,0x1b,
        0x1d,0x47,0xdc,0xc2,0xa9,0x2a,0xa0,0x08,0xdc,0x4a,0xe5,0xc7,0x57,0x63,0x0a,0xc3},
        /*TST_KeySize*/
        256*sizeof(DxUint8_t),
        /*TST_DPSize*/
        128*sizeof(DxUint8_t),      
        /*TST_PubExponentSize*/
        3*sizeof(DxUint8_t),
        /*TST_SaltLength*/
        20,       
        /*TST_input_data*/
        {0xa3,0x03,0x83,0xc4,0x7c,0xd2,0xff,0x38,0x34,0xcf,0xbe,0xb1,0xc6,0xdb,0x6e,0x14,
         0x9e,0xdf,0xbb,0xd7,0xc5,0xdf,0x8d,0x69,0x7a,0x07,0x75,0xbc,0xde,0x37,0x0c,0x75,
         0x5c,0x71,0xdf,0x18,0x42,0x78,0x95,0x50,0xd2,0x42,0x91,0x47,0xb9,0x59,0xb1,0x75,
         0xd5,0x8f,0x08,0xfe,0x60,0x56,0x47,0x64,0x27,0xbb,0xcb,0xb0,0x73,0x84,0x90,0x25,
         0xb6,0xeb,0x68,0x11,0xba,0xd9,0xaf,0x99,0xe9,0x3f,0xfd,0x55,0x3b,0x65,0xf6,0xbb,
         0x56,0x80,0x8c,0xc1,0xf4,0x7a,0xc4,0x50,0xd8,0x0c,0x54,0x24,0x7a,0x92,0x89,0x8a,
         0x09,0x58,0x5d,0x5b,0x6d,0x34,0x74,0x62,0x0c,0xc1,0x5c,0xb5,0xe5,0x6e,0x08,0xc6,
         0xc9,0xd6,0x16,0x3b,0x37,0xcf,0x63,0x19,0xb9,0xd4,0xe5,0xa7,0x92,0xa5,0x69,0x49,
         0xa3,0x03,0x83,0xc4,0x7c,0xd2,0xff,0x38,0x34,0xcf,0xbe,0xb1,0xc6,0xdb,0x6e,0x14,
         0x9e,0xdf,0xbb,0xd7,0xc5,0xdf,0x8d,0x69,0x7a,0x07,0x75,0xbc,0xde,0x37,0x0c,0x75,
         0x5c,0x71,0xdf,0x18,0x42,0x78,0x95,0x50,0xd2,0x42,0x91,0x47,0xb9,0x59,0xb1,0x75,
         0xd5,0x8f,0x08,0xfe,0x60,0x56,0x47,0x64,0x27,0xbb,0xcb,0xb0,0x73,0x84,0x90,0x25,
         0xb6,0xeb,0x68,0x11,0xba,0xd9,0xaf,0x99,0xe9,0x3f,0xfd,0x55,0x3b,0x65,0xf6,0xbb,
         0x56,0x80,0x8c,0xc1,0xf4,0x7a,0xc4,0x50,0xd8,0x0c,0x54,0x24,0x7a,0x92,0x89,0x8a,
         0x09,0x58,0x5d,0x5b,0x6d,0x34,0x74,0x62,0x0c,0xc1,0x5c,0xb5,0xe5,0x6e,0x08,0xc6,
         0xc9,0xd6,0x16,0x3b,0x37,0xcf,0x63,0x19,0xb9,0xd4,0xe5,0xa7,0x92,0xa5,0x69,0x49,
         0xa3,0x03,0x83,0xc4,0x7c,0xd2,0xff,0x38,0x34,0xcf,0xbe,0xb1,0xc6,0xdb,0x6e,0x14,
         0x9e,0xdf,0xbb,0xd7,0xc5,0xdf,0x8d,0x69,0x7a,0x07,0x75,0xbc,0xde,0x37,0x0c,0x75,
         0x5c,0x71,0xdf,0x18,0x42,0x78,0x95,0x50,0xd2,0x42,0x91,0x47,0xb9,0x59,0xb1,0x75,
         0xd5,0x8f,0x08,0xfe,0x60,0x56,0x47,0x64,0x27,0xbb,0xcb,0xb0,0x73,0x84,0x90,0x25,
         0xb6,0xeb,0x68,0x11,0xba,0xd9,0xaf,0x99,0xe9,0x3f,0xfd,0x55,0x3b,0x65,0xf6,0xbb,
         0x56,0x80,0x8c,0xc1,0xf4,0x7a,0xc4,0x50,0xd8,0x0c,0x54,0x24,0x7a,0x92,0x89,0x8a,
         0x09,0x58,0x5d,0x5b,0x6d,0x34,0x74,0x62,0x0c,0xc1,0x5c,0xb5,0xe5,0x6e,0x08,0xc6,
         0xc9,0xd6,0x16,0x3b,0x37,0xcf,0x63,0x19,0xb9,0xd4,0xe5,0xa7,0x92,0xa5,0x69,0x49,
         0xa3,0x03,0x83,0xc4,0x7c,0xd2,0xff,0x38,0x34,0xcf,0xbe,0xb1,0xc6,0xdb,0x6e,0x14,
         0x9e,0xdf,0xbb,0xd7,0xc5,0xdf,0x8d,0x69,0x7a,0x07,0x75,0xbc,0xde,0x37,0x0c,0x75,
         0x5c,0x71,0xdf,0x18,0x42,0x78,0x95,0x50,0xd2,0x42,0x91,0x47,0xb9,0x59,0xb1,0x75,
         0xd5,0x8f,0x08,0xfe,0x60,0x56,0x47,0x64,0x27,0xbb,0xcb,0xb0,0x73,0x84,0x90,0x25,
         0xb6,0xeb,0x68,0x11,0xba,0xd9,0xaf,0x99,0xe9,0x3f,0xfd,0x55,0x3b,0x65,0xf6,0xbb,
         0x56,0x80,0x8c,0xc1,0xf4,0x7a,0xc4,0x50,0xd8,0x0c,0x54,0x24,0x7a,0x92,0x89,0x8a,
         0x09,0x58,0x5d,0x5b,0x6d,0x34,0x74,0x62,0x0c,0xc1,0x5c,0xb5,0xe5,0x6e,0x08,0xc6,
         0xc9,0xd6,0x16,0x3b,0x37,0xcf,0x63,0x19,0xb9,0xd4,0xe5,0xa7,0x92,0xa5,0x69,0x49},
        /*TST_input_dataSize*/
        512*sizeof(DxUint8_t), 
        /*TST_output_signiture*/
        {0},
    },  
   { 
        {"Acceptance test - RSA SignVerify 1536byteData/2048bit key "},
        /*TST_PrivetExponent_D*/
        {0xad,0x39,0x0a,0xd1,0x7e,0xf9,0x71,0x86,0xbb,0xcf,0x0f,0x55,0x34,0xc2,0x7d,0x4d,
        0xce,0x15,0x00,0xd9,0xe9,0x17,0x6d,0xd6,0xbd,0xd7,0x86,0xda,0xd2,0xc3,0x69,0xd2,
        0x73,0xff,0x19,0x2b,0x54,0xd9,0xab,0xf5,0xad,0x58,0x74,0xbf,0xe9,0xc2,0x82,0x36,
        0x4a,0x39,0xf8,0xaf,0x43,0xa6,0xec,0x48,0x90,0x35,0xd6,0x51,0xff,0xcf,0xa2,0x43,
        0x1c,0x5f,0x2e,0x67,0x21,0x6c,0x13,0xa9,0x79,0x64,0x17,0x38,0xd5,0x55,0x90,0xf9,
        0x62,0x88,0x3f,0x57,0x33,0xbe,0xe7,0xf7,0x3f,0x0c,0xb4,0x85,0x7e,0xf5,0xe3,0x71,
        0x4f,0x4f,0x8e,0x84,0x35,0xe3,0x5d,0xb5,0xbf,0x12,0x5e,0x75,0xff,0xde,0x8e,0x7c,
        0x3f,0xf6,0x52,0xad,0x92,0x19,0xb1,0x4a,0x66,0x68,0xbf,0xff,0x7d,0xd0,0x47,0xbb,
        0x7a,0xe8,0x24,0xd3,0xd3,0x55,0xe9,0x56,0xdf,0x30,0x74,0xf1,0xff,0x02,0xf6,0x96,
        0x8f,0x5f,0xb2,0x6f,0x39,0x3c,0x05,0x33,0xf0,0x21,0x1a,0x95,0x90,0x2e,0xf8,0xdb,
        0xcf,0x0b,0xb4,0x91,0xe4,0xd6,0x73,0xc7,0x87,0x32,0x02,0x1e,0xc2,0x58,0x6f,0xe8,
        0x4e,0x84,0x91,0x51,0xcd,0xcf,0xb4,0xd7,0x15,0x23,0x93,0x7a,0x92,0x5b,0xdc,0xdf,
        0xc3,0xea,0xb3,0xd4,0xd8,0xb5,0xdb,0xe5,0x29,0x5d,0x4c,0x5f,0xdb,0x8d,0x32,0x82,
        0x20,0x50,0x17,0xe1,0x81,0x8e,0xdd,0x93,0x07,0x7a,0xdd,0xf6,0x9a,0x57,0x5b,0x89,
        0xc9,0x40,0xe4,0x86,0x63,0x80,0xac,0xa1,0x0f,0x17,0x98,0x6a,0x36,0x91,0x37,0x0d,
        0xd4,0x9b,0x84,0x07,0x87,0x67,0x28,0x66,0x2f,0x1a,0xa0,0x41,0x91,0x84,0xe1,0xd1},
        /*TST_PublicExponent_E*/
        {0x01,0x00,0x01},
        /*TST_Modulus_N*/
        {0xd3,0xa8,0x85,0xb1,0x1f,0x30,0xd1,0xdb,0x37,0x7d,0x29,0x29,0xb2,0x55,0x6d,0x08,
        0xaa,0x28,0x81,0xe4,0xf9,0xb9,0xa9,0x46,0xe7,0xa6,0x5e,0x35,0x9d,0xf9,0x9b,0x6a,
        0x3c,0x11,0xdb,0x33,0xf0,0x5e,0x64,0x9c,0x23,0x45,0xc0,0x76,0xf8,0xda,0x29,0x03,
        0x3f,0x67,0x96,0x0c,0x16,0x2d,0x04,0x8f,0x79,0xe4,0x80,0x41,0xc7,0xea,0xa0,0x92,
        0xec,0x40,0x46,0x97,0xc7,0x1f,0x46,0xfd,0x7c,0x24,0x33,0x61,0x4b,0x31,0xc3,0x8d,
        0x02,0x34,0x0d,0x83,0xa6,0xd5,0x3b,0xba,0x9d,0xc1,0x0d,0x82,0x20,0x51,0xb9,0x47,
        0xda,0xe3,0xd4,0x56,0x16,0x11,0x63,0xfd,0x01,0x9f,0x93,0x4b,0x3b,0x74,0x3d,0xc1,
        0x7c,0x8c,0x11,0xa8,0xc6,0x21,0x32,0x8e,0x1d,0xe9,0x9d,0xf2,0x48,0x20,0x8f,0x05,
        0x84,0x1c,0x45,0x93,0x16,0xae,0x81,0xfb,0x5b,0xf9,0xbd,0x36,0x2a,0x78,0x6e,0x88,
        0x56,0x05,0xd6,0xe8,0x36,0x34,0x3b,0x0e,0xbf,0x19,0x65,0x35,0x4a,0x83,0xdf,0x9b,
        0xb4,0xa3,0x3f,0x9e,0xf1,0x9d,0x35,0x96,0x58,0xee,0x91,0x2a,0x04,0x44,0xc4,0xd6,
        0x36,0x35,0x95,0x14,0xf6,0xd1,0x8b,0xa5,0xf4,0x8f,0x21,0x50,0x09,0x25,0xf2,0x6f,
        0x89,0xd7,0x11,0xf7,0x25,0xd4,0x5a,0x06,0xa2,0xf2,0x2e,0xaa,0x51,0x95,0x3a,0x50,
        0xbd,0xa0,0x1e,0xb4,0xa3,0x4e,0x23,0x05,0xb9,0xe0,0x70,0x46,0xaa,0x4b,0x09,0xee,
        0xca,0xa6,0xbf,0xb8,0x2c,0x82,0x06,0x40,0x6d,0xb4,0x46,0x3f,0x8a,0x68,0x08,0xa8,
        0x86,0x56,0xfa,0xe5,0x5e,0x18,0x9f,0x3f,0x18,0x4e,0xf3,0x0b,0xae,0xdf,0x05,0x71},
        /*TST_P*/
        {0xec,0x58,0x16,0x55,0xca,0x1f,0xfa,0x53,0x64,0x91,0x2a,0x51,0xfd,0x57,0x08,0xb6,
        0x9e,0x5b,0x82,0x91,0xb0,0x42,0xad,0x62,0x0a,0x37,0x83,0x4a,0xdc,0x1c,0xab,0xef,
        0xbb,0x59,0x04,0x62,0x0f,0xf6,0xb0,0x03,0x4a,0x0d,0x97,0x70,0x61,0xc2,0xbf,0x3c,
        0x2e,0xb9,0x4f,0xe3,0xa1,0xf4,0x6f,0x6b,0x79,0x98,0xc4,0x5a,0xc4,0xd0,0x82,0x0a,
        0x00,0xda,0x54,0xb9,0x9e,0x0a,0x68,0xe2,0x12,0x7a,0x29,0xf7,0xbc,0xe9,0x44,0x44,
        0x8a,0xaf,0xba,0x34,0x4a,0xa0,0x3f,0x44,0x42,0xb1,0xfb,0x78,0x86,0xd6,0xe6,0x2b,
        0xc7,0xa7,0xa0,0x6f,0xde,0x75,0x62,0xdb,0x61,0x17,0x93,0xc3,0xb3,0x3c,0xbf,0x97,
        0x42,0x97,0x7e,0x1f,0xb2,0x15,0x9c,0x16,0xff,0x97,0x4d,0x34,0x8c,0xa5,0xdc,0x83},
        /*TST_Q*/
        {0xe5,0x42,0xdb,0xe2,0xab,0x91,0x50,0x66,0xb0,0x86,0x3d,0xd8,0x6a,0x81,0x6b,0xce,
        0x85,0x0f,0xca,0xff,0x6d,0xbd,0x2c,0x62,0x3e,0x25,0x79,0x1b,0xe2,0x70,0x8d,0x41,
        0x71,0x5c,0x15,0x7c,0x69,0x68,0xda,0x50,0x16,0xe8,0xb8,0x6d,0x92,0x48,0xa8,0xe8,
        0x7b,0xff,0x64,0x7d,0xdf,0xc4,0x73,0x45,0xe8,0x22,0x84,0xe8,0x1a,0xa0,0x3e,0x6a,
        0x9c,0x16,0x13,0x36,0x54,0x8d,0x92,0x3e,0x2d,0xe7,0xec,0xe2,0x80,0x4b,0xbf,0x99,
        0xfa,0xaf,0x36,0x76,0xb7,0xa3,0xae,0x05,0xd3,0xe6,0x8c,0xda,0x8b,0xee,0xd5,0x31,
        0xb3,0x8b,0x1c,0xe1,0x5c,0xcf,0xca,0xe3,0x17,0xfc,0xd3,0x77,0x2a,0xfb,0xf3,0x10,
        0x68,0x39,0xc9,0x16,0x08,0x0a,0x31,0x15,0xb1,0xcf,0x3a,0xa3,0xc9,0xaa,0x1b,0xfb},
        /*TST_dP*/
        {0x7d,0xf2,0xef,0x6c,0x26,0x7b,0xe6,0x1d,0xfc,0xd0,0xf3,0x79,0xa0,0x05,0x7a,0xaa,
        0x3f,0x37,0xcb,0x1c,0x32,0x8f,0x45,0xf0,0xa2,0x3b,0x35,0x27,0x76,0xa7,0x7c,0xe5,
        0x13,0xb4,0xfb,0x85,0xfa,0xb5,0xde,0xd4,0xd1,0xe8,0xee,0x54,0x40,0x74,0xd5,0x0e,
        0x90,0x63,0xc6,0xf4,0x2b,0x01,0xa5,0x42,0xe4,0x19,0x0a,0x42,0xc8,0xf1,0xc8,0xea,
        0xe5,0xcb,0x74,0x2d,0x3a,0xd0,0x97,0x56,0x2a,0xbc,0x99,0x92,0xe1,0x44,0x7a,0x52,
        0x00,0x8a,0x67,0x33,0xa8,0xb5,0x3f,0x21,0xf4,0x5c,0xff,0x03,0x1a,0xf0,0x78,0xd6,
        0xc9,0xde,0x45,0xbc,0x78,0x13,0x9c,0x6c,0x06,0x90,0xd6,0xf9,0x0a,0x92,0x8c,0x13,
        0x62,0xb4,0x72,0xcd,0x17,0x4d,0x36,0xd2,0x76,0xc0,0xbd,0xaf,0x0c,0x68,0xf3,0x5b},
        /*TST_dQ*/
        {0xae,0xf4,0x87,0xd3,0x02,0x35,0x01,0xd3,0x6b,0xf0,0xf5,0xef,0x5a,0xcf,0xeb,0x52,
        0x8e,0x0e,0xd0,0x4e,0x7f,0x13,0x77,0x74,0x7d,0x92,0xa1,0x4a,0x9b,0x52,0x63,0x29,
        0xc6,0xf5,0x8b,0xdc,0x06,0xa1,0x22,0xc1,0x2d,0xca,0x69,0x3c,0x0c,0xff,0x70,0x0f,
        0x02,0xd9,0x92,0x79,0xd0,0xb3,0x1d,0x79,0x02,0xbe,0x9d,0x08,0x77,0x91,0x44,0x30,
        0x9d,0x6e,0xe7,0x38,0x75,0xec,0x17,0xe7,0x65,0xa6,0xf1,0x0a,0xa4,0xf7,0xa9,0x7f,
        0x3b,0x64,0x4c,0xbe,0xea,0x43,0x79,0xc1,0x2e,0xc5,0x69,0x46,0x3a,0xb5,0x87,0x72,
        0xc7,0x5e,0x69,0x2a,0xbe,0x66,0x40,0xa1,0x6f,0x23,0xdc,0xc8,0xbb,0x3f,0xcc,0x6c,
        0xff,0xec,0xe1,0x3c,0xf3,0xe3,0xbb,0x33,0xa0,0x1e,0xd1,0xd4,0x3e,0x48,0x97,0xd3},
        /*TST_Qinv*/
        {0x8f,0xb7,0x06,0x99,0x7b,0x1e,0x75,0xe4,0x5d,0x5a,0x18,0xfa,0x0f,0xcd,0xa6,0xf6,
        0x6c,0x08,0x38,0xf4,0xd4,0x81,0x3a,0x11,0xf0,0x66,0x22,0x85,0xf9,0xda,0x5a,0x2b,
        0x93,0x51,0x58,0x37,0x70,0xcd,0xd6,0xdc,0xa1,0xbd,0x04,0x87,0x80,0xde,0xe4,0xf0,
        0x3b,0xe5,0x79,0x88,0x14,0x3d,0x45,0x74,0x09,0xbc,0xcc,0x1b,0xc1,0x72,0xea,0x07,
        0xa7,0x7f,0xb2,0x24,0x6a,0x08,0x38,0xde,0x64,0x18,0x45,0x6b,0xa9,0x40,0xda,0x2e,
        0xd0,0xee,0xa4,0x28,0x87,0xcd,0x6e,0x83,0x4b,0x76,0x0f,0x2c,0x27,0xd5,0xf6,0xa9,
        0xb2,0x33,0xd6,0x45,0x7e,0x95,0xd1,0xab,0x84,0xcc,0x59,0x9e,0x01,0x41,0x17,0x80,
        0xad,0x18,0xe8,0x83,0x25,0xe4,0x09,0x32,0xdc,0xab,0xa8,0xba,0x97,0xb6,0xf4,0x56},
        /*TST_KeySize*/
        256*sizeof(DxUint8_t),
        /*TST_DPSize*/
        128*sizeof(DxUint8_t),    
        /*TST_PubExponentSize*/
        3*sizeof(DxUint8_t),
        /*TST_SaltLength*/
        20,       
        /*TST_input_data*/
        {0x5e,0x1f,0x8b,0x2c,0xc9,0xe4,0x74,0x10,0x84,0xbe,0xff,0x5e,0x0e,0x04,0xbe,0xaf,
        0xab,0xbc,0x2b,0xeb,0xb5,0xa6,0x96,0x6a,0x33,0x7d,0x62,0x59,0xad,0x79,0x71,0x60,
        0x3e,0x18,0xdd,0x81,0xea,0x1e,0xe9,0x44,0x32,0xda,0x37,0x11,0xe6,0xac,0x3b,0xdd,
        0x3b,0xc4,0xef,0x09,0x1d,0x2c,0xc8,0x86,0xc6,0x09,0xe9,0x3e,0x90,0x1e,0x98,0xaf,
        0x07,0x91,0xee,0xd9,0x43,0xf2,0xd2,0x5b,0x75,0x79,0x28,0xd9,0xbf,0x8f,0x45,0xa0,
        0x49,0x90,0xa6,0x8d,0x91,0xd0,0xe2,0x2b,0x02,0xdc,0xde,0x1b,0xc9,0x02,0x40,0xb9,
        0xe4,0x13,0x26,0xfc,0x7b,0x67,0x17,0x9e,0x74,0x22,0x3a,0x7d,0x42,0xb6,0xc5,0x42,
        0xfd,0xa9,0xb9,0x40,0xb8,0x99,0xcd,0x9f,0x0f,0x7d,0xa7,0xb9,0xff,0x2d,0x52,0xc4,
        0xfb,0x25,0xed,0xb2,0x3b,0x85,0xa0,0x55,0x58,0x5d,0xd5,0xc7,0x16,0x28,0xa4,0x09,
        0x80,0x96,0x8e,0xea,0x3b,0x8f,0x6f,0x2a,0x14,0x74,0xae,0xe0,0xdb,0xa8,0xb7,0x19,
        0x74,0x4f,0xab,0xc2,0x2b,0x55,0x55,0xc8,0x48,0xb2,0x61,0x7d,0xe3,0xed,0xc8,0x3e,
        0xfa,0xdf,0x8f,0x53,0xc1,0xba,0xb1,0x16,0x39,0x4a,0x5a,0x57,0x04,0x7a,0x55,0x00,
        0x78,0x19,0xc8,0xf5,0xf2,0xde,0x1f,0x3e,0x6d,0xaa,0x46,0x68,0x53,0x0e,0x1b,0x28,
        0x92,0x0d,0x23,0x42,0xf3,0x23,0x7b,0xa9,0xa8,0x86,0x12,0xe8,0x23,0xab,0x16,0xc0,
        0x2f,0x0c,0xac,0x13,0x39,0x29,0xe4,0x01,0xee,0xcc,0xec,0x50,0x0c,0x92,0x84,0x11,
        0x71,0xa7,0xb1,0x80,0x79,0xd1,0xb6,0x2d,0x86,0xb0,0x40,0x59,0xe0,0x44,0xe1,0xa3,
        0xc0,0xaf,0xbf,0xe4,0xa7,0x3c,0x8e,0x57,0xf4,0xa1,0xbb,0xfd,0xb6,0x81,0xea,0x3f,
        0xbf,0x35,0xa3,0xd6,0xfa,0xcc,0x48,0xe8,0xfe,0x50,0x4b,0x73,0xe2,0x4b,0x9d,0xef,
        0x53,0x8a,0x6a,0x2f,0xe5,0x21,0x03,0x89,0xa7,0xb0,0x1c,0x36,0xfa,0xe4,0x37,0xfb,
        0xa3,0x40,0x60,0x09,0x1e,0x1d,0x1b,0x23,0x35,0xef,0x9b,0xfe,0xd2,0xcb,0x34,0xed,
        0x12,0x26,0x13,0xbe,0x9a,0xe0,0x2d,0xde,0x2e,0x81,0x75,0xc4,0x80,0xc2,0x52,0x8d,
        0x45,0x4f,0x50,0xe4,0x8e,0xcb,0x16,0x25,0x56,0x14,0x98,0xc2,0x57,0xc9,0x8d,0xe5,
        0x23,0x0a,0x24,0x57,0x6f,0x7f,0xf2,0xa0,0xb2,0x9c,0x2f,0x70,0xef,0x23,0x23,0x3d,
        0xce,0xea,0xdb,0x2e,0xf2,0xde,0x20,0x38,0x87,0x48,0xaa,0x87,0x1a,0x4f,0x90,0x1f,
        0xae,0xbe,0x03,0xc3,0x0c,0x08,0x3c,0x15,0x5a,0x8a,0xb3,0x00,0xef,0x0f,0x92,0x53,
        0x66,0x99,0x69,0xae,0xf1,0x5f,0x23,0xa2,0xf0,0x12,0x39,0x14,0xc3,0x64,0x25,0xe2,
        0xdc,0xcb,0x1a,0xca,0x18,0x82,0xf2,0x87,0x4f,0xd2,0x68,0x3c,0x2a,0x8f,0x87,0x16,
        0x34,0xe5,0x62,0x2d,0x34,0x55,0x06,0xac,0xbb,0xfa,0xad,0x32,0xf9,0x11,0x34,0x78,
        0xd4,0xb8,0xcf,0x33,0x3c,0xf6,0xfc,0x3c,0xb8,0xfc,0xb5,0xee,0x45,0xaa,0xea,0xcf,
        0x61,0x55,0x2e,0x73,0x63,0xc8,0xb1,0x9e,0x0d,0x88,0x6e,0xa9,0x64,0x5d,0xa5,0x27,
        0xbf,0x0d,0x8c,0xc8,0x1f,0x6b,0x42,0x7d,0xbe,0x90,0x04,0xdc,0xeb,0x69,0xa3,0xc7,
        0x14,0x72,0x35,0x48,0x25,0xc0,0x0b,0xc0,0x11,0x45,0xe4,0x41,0xad,0x50,0x60,0x38,
        0xc5,0x53,0xb8,0x4f,0x6a,0xe9,0xab,0x91,0x89,0x17,0xbc,0xcf,0xc2,0xd2,0x9a,0x43,
        0x76,0xc2,0xe0,0x74,0x22,0x46,0xfe,0x59,0xec,0xb8,0x77,0xc1,0x7c,0xf2,0x4e,0xf3,
        0x0d,0x11,0xba,0x91,0xc4,0x79,0x21,0xc2,0x40,0x19,0x44,0x8f,0x72,0xf0,0xb8,0x8e,
        0xaf,0xcf,0x95,0xbe,0x03,0x61,0x72,0xb3,0xc9,0x6a,0x90,0xf3,0x78,0x4c,0x55,0x9f,
        0xc0,0xcf,0xfc,0x56,0xd6,0x21,0x8c,0x56,0x0c,0x1c,0x06,0xe4,0xa4,0xc8,0xe3,0xef,
        0xe6,0x21,0xbd,0xf0,0x70,0x1a,0x4d,0x14,0xce,0xe1,0x95,0x9d,0x4a,0x65,0x5e,0x85,
        0x05,0x16,0xe5,0x65,0x47,0xeb,0xd2,0x96,0x14,0xaa,0x69,0x96,0x00,0x64,0x04,0xad,
        0x44,0x3e,0xc1,0xd0,0x10,0x78,0x78,0xc5,0x23,0xa7,0xf0,0x88,0x9a,0x45,0x52,0xee,
        0x05,0x6c,0xdd,0x88,0xc0,0xdf,0xdc,0xca,0x81,0x4a,0xd5,0x6c,0x2d,0xcb,0x04,0x11,
        0xf0,0xb0,0x07,0x27,0x8c,0x83,0xdb,0x0e,0xf1,0x44,0x07,0x7c,0x0f,0xf5,0x17,0x20,
        0xe8,0x5c,0x4c,0x85,0xe9,0x04,0x92,0x3a,0x7a,0x85,0xb2,0x30,0xd4,0x05,0xc9,0x63,
        0x12,0xff,0xf9,0xbc,0x8b,0x43,0x5e,0x36,0x60,0x3e,0x44,0x41,0x51,0x7c,0x97,0x64,
        0xd5,0x6b,0x9a,0x25,0x69,0x62,0xdc,0x2d,0x28,0xe1,0x69,0xa8,0x9c,0x1b,0x3d,0xeb,
        0xd4,0xb1,0xfe,0x59,0xb6,0xc1,0xea,0x87,0x97,0x1f,0x0e,0x9e,0x09,0xe2,0xb8,0x01,
        0xf4,0x23,0x30,0x30,0xe9,0x01,0xa3,0xed,0xb2,0xe8,0x60,0x9d,0x2e,0x14,0x47,0xf0,
        0x5c,0x50,0x7d,0xc4,0xb5,0x04,0x65,0x47,0xbf,0x6e,0xcc,0x5c,0xdf,0x30,0x64,0x41,
        0x6e,0x0b,0x74,0x6e,0x10,0xea,0xcd,0xc0,0x41,0x22,0x00,0xd6,0x31,0xf8,0xce,0xbc,
        0xd2,0x64,0xe0,0xc6,0x2f,0x14,0xb9,0xbf,0xff,0xb4,0xe8,0x43,0x7a,0x6d,0x82,0x6a,
        0x6b,0xab,0xcf,0xa7,0x87,0x24,0x44,0xef,0xfd,0x16,0xb1,0x1d,0x4e,0xcf,0xbc,0x95,
        0x5f,0x73,0x8e,0x27,0xcd,0xfa,0xcc,0x37,0x80,0x78,0xc9,0x1b,0x83,0xa1,0xfa,0xc5,
        0x12,0x8c,0xaa,0xa2,0xf5,0xb7,0xee,0xc1,0x0d,0x4c,0xdc,0x38,0x2d,0xa2,0xf8,0xc4,
        0x2b,0x07,0xef,0xaf,0x36,0xbd,0x88,0xf7,0x69,0x42,0xd7,0xac,0xa1,0xd4,0xb4,0x9a,
        0x8c,0x35,0x6b,0x28,0x03,0xac,0xb5,0x80,0x9a,0x4c,0xe7,0xf0,0x75,0x78,0x6a,0x90,
        0x5d,0xa7,0x6b,0x26,0x12,0x65,0xd3,0x46,0xe3,0x9b,0x7a,0xbe,0x7d,0x0f,0x97,0x31,
        0x01,0x2e,0x7c,0x01,0x59,0x0a,0x80,0x72,0xcb,0x9f,0x3c,0x0d,0xce,0x5a,0xfa,0x43,
        0x1d,0xdc,0x6a,0x53,0x0b,0xfb,0x97,0x6e,0x16,0x09,0x1a,0x18,0xbe,0x59,0x8d,0xd1,
        0x98,0x00,0x43,0xf5,0x9e,0xd9,0x36,0xe1,0xc9,0xcc,0x41,0x57,0xe2,0x4f,0x90,0x24,
        0x95,0x2c,0x54,0xff,0xc7,0x85,0xbb,0xb5,0x29,0x16,0x1f,0x83,0x0d,0xbb,0x7e,0xc3,
        0x79,0x32,0x2a,0xcc,0x7a,0x21,0xc1,0x13,0xbb,0x5b,0x60,0x96,0x56,0x5f,0x14,0x7a,
        0xea,0x22,0x91,0xf2,0xee,0x0e,0x27,0x64,0x45,0x4a,0xf1,0xc7,0x12,0x3c,0x50,0x50,
        0xcd,0x4c,0x97,0x4d,0x97,0xeb,0x08,0x51,0xca,0xd4,0x00,0x91,0xd5,0x92,0x6e,0x8e,
        0x47,0x43,0x89,0xf4,0x29,0x9b,0xc3,0xc2,0x91,0x2c,0xf8,0xac,0x74,0xe4,0xec,0xbe,
        0xbc,0xd7,0xf4,0x41,0x9a,0x3e,0xf3,0xe2,0x1e,0xc0,0x88,0x11,0x05,0xf1,0x86,0xa8,
        0xd2,0x19,0xa5,0xcd,0x20,0x36,0x77,0x19,0x36,0x44,0x9d,0xfa,0xdc,0xbb,0x3a,0x55,
        0x6d,0x5a,0xa8,0x70,0x2e,0x23,0x6a,0x10,0xde,0xa7,0x62,0xde,0x8e,0x83,0x44,0x0f,
        0xb3,0x2b,0x4b,0x44,0x7a,0xe6,0x2b,0xaf,0x5b,0x1a,0x46,0x78,0xf1,0xca,0x22,0x5f,
        0x09,0x5d,0x1b,0xa2,0xf9,0xa1,0x55,0x21,0x33,0x0f,0xf5,0xc0,0x19,0x51,0x91,0x0d,
        0x13,0x01,0xe4,0x23,0xdf,0xb4,0xc7,0xce,0x29,0x37,0x5d,0xef,0x5c,0x18,0x8d,0x22,
        0xb7,0x68,0xb5,0x9f,0xa3,0xc0,0x9c,0x5e,0x44,0x82,0xa9,0x7f,0x4e,0x61,0x53,0xe8,
        0x1a,0x24,0xd9,0x30,0xf9,0xa6,0x33,0xbc,0xc8,0x22,0x48,0x27,0xc4,0xad,0x61,0xe7,
        0xa0,0x04,0xde,0x2e,0xd5,0x88,0x28,0x0f,0x3a,0x87,0xe6,0xe2,0xd4,0xbd,0x74,0xe9,
        0xef,0x1b,0x90,0x34,0x6d,0xc7,0x57,0xc1,0x5f,0x63,0x71,0xe8,0xd2,0x92,0x88,0xf6,
        0xeb,0xb8,0xfe,0x19,0x37,0x02,0xdf,0x7c,0x3c,0xa7,0x14,0xb2,0x54,0x6d,0xda,0x58,
        0xbb,0x6e,0x73,0xf6,0xe6,0x1c,0x1b,0x27,0x16,0x83,0x3e,0xfa,0x2e,0xce,0xe8,0x97,
        0xc1,0x0d,0x7d,0x26,0x70,0x35,0xaa,0xec,0x73,0x68,0x9b,0xb7,0x75,0x77,0x6f,0x7d,
        0xa5,0xa6,0xe9,0x40,0x0a,0xaf,0x68,0x34,0x16,0x09,0x19,0x24,0x7f,0x69,0x6b,0x12,
        0x4a,0x8a,0xc3,0x1e,0x29,0x2a,0x72,0xa9,0x06,0x55,0xe4,0xb9,0xe0,0xe5,0x19,0x9f,
        0xd6,0x4a,0x59,0xd8,0x81,0x87,0x24,0x32,0x87,0x7d,0x69,0x2f,0x6d,0x6c,0xf8,0xae,
        0xad,0xb7,0x38,0xc8,0x09,0xe7,0x1d,0xf9,0x1e,0xf3,0x55,0x80,0x3c,0xbf,0xc2,0x08,
        0x75,0xe2,0x2d,0x87,0xf4,0xac,0x39,0x67,0x91,0x68,0x95,0xe4,0xa2,0xde,0x76,0xb5,
        0x13,0x1c,0x45,0xee,0xb9,0x76,0x94,0x25,0xe3,0xcc,0x57,0xd3,0x32,0x0b,0x51,0xfe,
        0xab,0xf6,0xcc,0x15,0x0b,0x27,0x8d,0x1c,0x5a,0x50,0x07,0x08,0xc3,0xc7,0xcf,0x6d,
        0xa3,0x42,0x50,0x56,0xe0,0xdf,0xc0,0x74,0x7c,0x67,0x53,0x7c,0x6a,0xd3,0xae,0xca,
        0xa0,0x0f,0x9e,0x4a,0x6d,0xff,0x0a,0x98,0x0d,0xc0,0x26,0x66,0x7b,0x30,0xea,0x1f,
        0x86,0xb0,0xc3,0xc9,0x27,0x28,0x88,0x30,0x12,0x4c,0xaf,0x41,0x8b,0x1e,0xc1,0xb4,
        0x7b,0xb4,0x0b,0xee,0xc3,0x3c,0x97,0x25,0xd0,0x3d,0x5a,0xc5,0x6f,0x20,0xaf,0x12,
        0xe3,0xee,0x04,0x0f,0x36,0x5b,0xd3,0x9f,0xcc,0x04,0xd5,0xeb,0x3e,0xf5,0x72,0x03,
        0x65,0x6e,0x7b,0xc8,0xb4,0xe7,0x1b,0x09,0xcb,0x51,0x0b,0xec,0x4a,0x9f,0x06,0x90,
        0xe3,0x85,0x7d,0xf0,0xb4,0x7f,0x8b,0x0b,0xd3,0x16,0x2b,0x42,0x2a,0x5f,0xa9,0x01,
        0x85,0xc4,0x56,0xa1,0xe9,0x06,0x80,0x8d,0x28,0x83,0xa1,0xa4,0xb2,0xb5,0xd7,0xdf,
        0xae,0xfc,0x94,0x34,0x49,0x9d,0x97,0xba,0x4e,0x0a,0x1b,0x0d,0xf8,0x64,0x4e,0xf4,
        0x04,0x3e,0x04,0x41,0x09,0xa4,0xad,0xf9,0x0c,0x5b,0x84,0xb5,0x4f,0x6b,0x0a,0x48,
        0x6b,0xdb,0xb3,0xa2,0x9e,0xbc,0xdf,0xf5,0x66,0x69,0x0b,0x16,0x4f,0x0c,0x49,0x25,
        0x09,0x64,0xed,0x70,0xbd,0xc6,0x8a,0x95,0xa1,0x62,0x1d,0xe7,0xcb,0xc8,0x87,0x13},
        /*TST_input_dataSize*/
        1536*sizeof(DxUint8_t), 
        /*TST_output_signiture*/
        {0},
    },
};

TST_RSA_TestExtHashSignVerifyDataStruct TST_RSA_Acceptance_ExtHashSignVerify_TestData[] =
{
        /*******************************************/
        /*  RSA External Hash SignVerify test data */
        /*******************************************/
        /*  512 bit key                   */
        /**********************************/
    { 
        {"Acceptance test - RSA External Hash SignVerify 512bit key "},
        /*TST_PrivetExponent_D*/
        {0xca,0xbb,0x7e,0x86,0x1e,0x28,0xca,0xdc,0x0c,0x71,0x74,0xb2,0x67,0x84,0x1a,0xd1,
         0xba,0x11,0xfc,0xd8,0x3e,0xc1,0x91,0xfb,0xe1,0xae,0x01,0x25,0x79,0x88,0xeb,0x29,
         0x37,0x84,0xa6,0x6d,0x41,0xf0,0x08,0x9e,0xab,0x97,0x77,0x83,0x98,0x4e,0x9f,0x6b,
         0x64,0x7a,0x6b,0xcf,0x9c,0xdc,0xac,0xbb,0x04,0x95,0x2a,0xd6,0x39,0x74,0x36,0x89},
        /*TST_PublicExponent_E*/
        {0x01,0x00,0x01},
        /*TST_Modulus_N*/
        {0xe4,0x78,0x72,0x76,0x39,0xd6,0xbf,0x7a,0x47,0x52,0x1a,0xb1,0x99,0x75,0xa9,0x32,
         0xd4,0xa3,0x54,0xb7,0x12,0xae,0x85,0x32,0x4c,0x06,0x1a,0xde,0x3f,0x66,0x9d,0xbc,
         0x42,0x8c,0x50,0x6e,0xde,0xc8,0x40,0x9a,0x10,0x86,0xa9,0x09,0x27,0x8c,0xf6,0xb6,
         0x95,0x8c,0xf9,0x4d,0x24,0x2e,0x5a,0xc4,0x05,0x2d,0x7a,0xce,0xdc,0x6f,0x4e,0x59},
        /*TST_P*/
        {0xf3,0xa3,0xd7,0x6b,0x3c,0x72,0x27,0x9e,0x00,0x0c,0xec,0x3b,0x2e,0xfe,0xaf,0xca,
        0x3c,0x94,0x88,0xfb,0xfd,0x89,0xa3,0x28,0xf3,0x0f,0xeb,0x51,0xc0,0x38,0x76,0xcf},
        /*TST_Q*/
        {0xf0,0x0f,0x99,0x4e,0xf6,0x1a,0x49,0xc4,0x01,0xcc,0x5e,0x74,0x38,0xba,0x8b,0xba,
         0x62,0x54,0x85,0x4c,0x1a,0x69,0xc1,0xd8,0xad,0x45,0x6f,0xf4,0x67,0xed,0xb2,0x57},
        /*TST_dP*/
        {0x60,0x8a,0xce,0xc4,0x96,0x6a,0x21,0x9a,0xb1,0x28,0x6d,0xbf,0x31,0xeb,0x07,0xdb,
         0x5a,0x4f,0xfd,0x4b,0xe4,0xf6,0x52,0x29,0xda,0xce,0xb7,0x0f,0x68,0xdc,0xb6,0xef},
        /*TST_dQ*/
        {0x38,0xed,0x2a,0x08,0xbc,0x79,0x6d,0x66,0xaa,0x9a,0x81,0x07,0x84,0x70,0x50,0x34,
        0x29,0x9f,0x2b,0x60,0xe9,0x9e,0x8c,0x96,0x4a,0x38,0x7e,0x1c,0xf2,0x0c,0x3e,0xcf},
        /*TST_Qinv*/
        {0x0a,0xfd,0x35,0x95,0xe8,0xf4,0x6c,0x91,0xc0,0x07,0x51,0x8e,0xd9,0xe4,0x16,0xd3,
         0x7a,0x18,0x31,0xae,0x48,0xc4,0x87,0x5f,0x2b,0xbe,0xfc,0xf9,0x8c,0xd2,0x95,0x29},
        /*TST_KeySize*/
        64*sizeof(DxUint8_t),
        /*TST_DPSize*/
        32*sizeof(DxUint8_t),       
        /*TST_PubExponentSize*/
        3*sizeof(DxUint8_t),
        /*TST_SaltLength*/
        20,
        /*TST_input_hash_SHA1*/
        {0x41,0x1f,0xd6,0xbc,0x3d,0x77,0xd0,0x5f,0xb0,0x71,0x00,0xf6,0x27,0xa7,0x55,0xf8,
         0x41,0x1f,0xd6,0xbc},
        /*TST_input_hash_MD5*/
        {0x5a,0x4f,0xfd,0x4b,0xe4,0xf6,0x52,0x29,0xda,0xce,0xb7,0x0f,0x68,0xdc,0xb6,0xef}, 
        /*TST_input_hash_SHA224*/
        {0x72,0x81,0x1f,0xd4,0x62,0x3a,0xeb,0x4f,0x9b,0x86,0x09,0x25,0x12,0x19,0x58,0xb5,
        0x29,0x50,0xb9,0x4b,0x92,0x15,0x3a,0xc9,0x03,0x29,0x85,0xe8},
        /*TST_input_hash_SHA256*/
        {0x53,0xca,0xe2,0x11,0x6d,0x21,0x1e,0x0e,0x79,0x91,0xf7,0x57,0xbe,0x44,0x4b,0x4e,
        0x59,0xbd,0x78,0x8d,0xc5,0xfc,0xaf,0xf7,0xfb,0x46,0xaa,0x0a,0x4c,0xb1,0x7d,0x98}, 
        /*TST_input_hash_SHA384*/
        {0xb2,0xcc,0x90,0xbf,0x28,0x3d,0x21,0x86,0x87,0x17,0xaa,0x1e,0x5f,0x75,0x73,0x79,
        0x82,0x40,0x7e,0xb7,0x18,0x50,0xd4,0x5c,0x2f,0xb1,0xd8,0xe4,0x20,0xec,0xef,0xf7,
        0x66,0xbf,0x4d,0x62,0x3c,0xe0,0x2e,0x3a,0xbb,0xfc,0x69,0xa2,0x19,0x96,0x4b,0xd1},
        /*TST_input_hash_SHA512*/
        {0xd2,0xf5,0x71,0xe2,0x8d,0x37,0x5c,0xdd,0xe4,0x65,0xa7,0x24,0xc3,0xfa,0xc7,0x5a,
        0x41,0x7d,0xaa,0xed,0xcc,0x53,0x8a,0x31,0x36,0x00,0x51,0x1d,0xa5,0xa2,0x39,0xcc,
        0x4b,0x1d,0x93,0x8e,0x0a,0x50,0x95,0x10,0x7e,0x63,0x63,0x9e,0x2b,0xce,0x93,0xdf,
        0xca,0x33,0xc1,0x6b,0x8f,0xf0,0x4b,0x5c,0x11,0xaf,0x66,0x96,0x9d,0x43,0xf1,0x5e}, 
        /*TST_output_signiture*/
        {0},
    },
        /**********************************/
        /*  1024 bit key                  */
        /**********************************/
    { 
        {"Acceptance test - RSA External Hash SignVerify 1024bit key "},
        /*TST_PrivetExponent_D*/
        {0x7c,0x4f,0x48,0x18,0x51,0x0b,0x3d,0x3e,0xbb,0x29,0xc0,0xa5,0xc8,0x10,0xcf,0xf6,
         0x6e,0xb9,0x0a,0xb8,0xe7,0xae,0xb3,0xc9,0x09,0x8f,0xd2,0xf9,0x0b,0xec,0x88,0x53,
         0x6d,0x80,0xc2,0x25,0x76,0x94,0xff,0xb5,0xcb,0xc3,0x3d,0xcc,0x7d,0x8a,0xdc,0x84,
         0xd3,0x23,0x2a,0xcd,0x43,0x97,0x90,0xb0,0x70,0xcb,0xdd,0x46,0x60,0xce,0x5d,0x81,
         0xb3,0x75,0xd8,0x04,0x8a,0xb9,0x2e,0x46,0xd7,0xb0,0xc6,0x0a,0x2d,0xb5,0x3c,0xe0,
         0x1b,0xd1,0xd1,0xee,0x26,0x00,0x81,0xc4,0xe0,0x17,0xb1,0x12,0x5c,0xbe,0x9a,0x4a,
         0xa3,0x38,0x77,0x9a,0xc9,0xdf,0x24,0x73,0xb1,0xe1,0xfa,0x11,0xf2,0xb1,0x0b,0xc5,
         0x48,0xa1,0x8d,0xab,0xed,0x6a,0x92,0xfc,0xe0,0x07,0xfa,0xa6,0x01,0xfa,0xc0,0xb9},
        /*TST_PublicExponent_E*/
        {
        0x01,0x00,0x01},
        /*TST_Modulus_N*/
        {0xb4,0x2a,0x42,0x2d,0xc2,0xe9,0x62,0x74,0xc5,0xe6,0x82,0xf7,0x7b,0xd5,0x73,0x15,
         0xc5,0x8f,0x8a,0x41,0x55,0x88,0xf0,0x66,0xcb,0x7c,0x12,0x3c,0x03,0xe7,0x68,0x97,
         0xcd,0x57,0xe9,0xb4,0xf8,0x00,0xce,0x39,0x6f,0xdb,0x5e,0x60,0xed,0xff,0xba,0x85,
         0xb5,0x1f,0x84,0x2d,0x7c,0x43,0xf0,0x08,0xf9,0xd9,0x0c,0xe7,0x4f,0xb5,0xcd,0xe7,
         0x73,0xb0,0x78,0x8a,0xc5,0xd3,0x9a,0x02,0x64,0xac,0xc8,0x27,0xa5,0x12,0xfd,0xe6,
         0x4f,0x77,0x87,0x50,0xe7,0xa2,0xcc,0x82,0x87,0x90,0x08,0x32,0x8f,0xc4,0x76,0xbb,
         0x25,0x23,0x4a,0xd5,0x5c,0x20,0xd5,0x59,0x50,0xfa,0x5f,0x80,0xce,0x7f,0xf6,0xe6,
         0x65,0x39,0xe2,0x2f,0x16,0x9e,0x2f,0x7d,0xe1,0x2e,0xb5,0xda,0x60,0x12,0xe9,0x73},
        /*TST_P*/
        {0xe4,0x8e,0xbf,0x67,0xe0,0xa0,0x2a,0xfe,0x14,0x71,0x60,0x6f,0x8f,0x4d,0xd4,0xee,
         0xa3,0x9b,0xdf,0x81,0x80,0xfb,0xa1,0xf1,0x5c,0xd1,0xd4,0x14,0xa1,0x36,0xc9,0x8a,
         0x03,0x61,0x00,0xb7,0x50,0x64,0x34,0x9c,0xce,0xab,0x93,0xd0,0x63,0xbb,0x11,0x62,
         0xc0,0x20,0x5c,0x76,0x3f,0x2a,0x0f,0x56,0xba,0xc6,0xd8,0x77,0x16,0x4e,0xa2,0x7f},
        /*TST_Q*/
        {0xc9,0xcc,0x0d,0x99,0xed,0x28,0x1a,0xf6,0x7d,0x15,0x55,0x8d,0x57,0xe7,0x4e,0x50,
         0x37,0x63,0x43,0x4f,0x6e,0xb8,0xeb,0xe9,0x2f,0x3f,0x06,0xc0,0x98,0x2c,0x45,0xe4,
         0xd0,0x6c,0x03,0x00,0xfd,0x3a,0x2a,0x8b,0xa9,0x3e,0x1f,0x8f,0xf0,0x77,0xa0,0xc4,
         0x4a,0x19,0xac,0x6a,0x20,0x3a,0x2d,0xf5,0x58,0xdd,0xb5,0x14,0x46,0x64,0xd7,0x0d},
        /*TST_dP*/
        {0xd4,0x78,0x4f,0x3f,0x45,0xf6,0x1f,0x81,0x6b,0x87,0xaa,0x5a,0x8b,0x21,0x93,0x9c,
         0xf4,0xc3,0x66,0x97,0x81,0x4c,0x6b,0x53,0x71,0x32,0x2e,0xb1,0xae,0xdc,0xbb,0xa6,
         0x6d,0x55,0xb3,0xd0,0xb6,0x0f,0x31,0x49,0xc4,0x66,0x84,0x56,0xe9,0x1f,0x72,0x1e,
         0x16,0xf4,0xfe,0x7f,0x7e,0x60,0x9f,0x39,0xc5,0x10,0x2d,0x13,0x27,0xcd,0x9a,0x09},
        /*TST_dQ*/
        {0x20,0x66,0xd6,0x4c,0x3f,0xeb,0x2f,0xa1,0x22,0x66,0x79,0x8d,0x2f,0x6f,0x21,0x80,
         0xf9,0xd3,0xc3,0x6c,0x0e,0xb0,0x3c,0x98,0xfd,0x90,0x16,0x2a,0x78,0x84,0xab,0x58,
         0x59,0x2a,0xee,0xb4,0x8a,0xf4,0x7a,0xfe,0x5f,0xd7,0x6c,0xc3,0xf4,0xed,0x90,0x6f,
         0xd4,0x22,0x19,0x30,0x15,0x2a,0xa2,0x54,0x81,0xc7,0x5f,0x9a,0xf8,0xce,0x9a,0x45},
        /*TST_Qinv*/
        {0x31,0x7d,0x4f,0xb7,0xc5,0xac,0xe8,0xc0,0x8e,0xaf,0x1a,0xca,0xee,0x9c,0xe7,0x9c,
         0x4d,0xed,0x44,0x91,0x32,0xce,0x75,0xd9,0xd1,0x62,0xb0,0xc8,0x00,0xe0,0xf2,0x72,
         0xcc,0x71,0x67,0x9b,0xc1,0x2b,0x79,0xe2,0x14,0xcd,0x42,0xfc,0x98,0x53,0xaf,0x8c,
         0xee,0x35,0x78,0x6f,0xf5,0xdb,0xb7,0x24,0xf3,0xc9,0xe0,0x18,0x5e,0x5f,0x15,0xe4},
        /*TST_KeySize*/
        128*sizeof(DxUint8_t),
        /*TST_DPSize*/
        64*sizeof(DxUint8_t),       
        /*TST_PubExponentSize*/
        3*sizeof(DxUint8_t),
        /*TST_SaltLength*/
        20,       
        /*TST_input_hash_SHA1*/
        {0xe4,0x8e,0xbf,0x67,0xe0,0xa0,0x2a,0xfe,0x14,0x71,0x60,0x6f,0x8f,0x4d,0xd4,0xee,
         0x16,0xf4,0xfe,0x7f},
        /*TST_input_hash_MD5*/
        {0xd4,0x22,0x19,0x30,0x15,0x2a,0xa2,0x54,0x81,0xc7,0x5f,0x9a,0xf8,0xce,0x9a,0x45}, 
        /*TST_input_hash_SHA224*/
        {0x28,0x42,0x5d,0x60,0xbf,0xea,0xd8,0x24,0x86,0x38,0x82,0x06,0x5a,0x79,0xfc,0x2e,
        0x75,0xe0,0xc6,0xd8,0x47,0xf8,0x88,0xac,0x3d,0xb4,0x0f,0x5f},
        /*TST_input_hash_SHA256*/
        {0x48,0x6d,0x45,0x40,0xd9,0x12,0xe6,0x0a,0x4d,0xd9,0x2d,0xb8,0x09,0xe5,0x01,0xce,
        0x54,0x67,0xac,0x24,0xca,0xad,0x15,0x09,0xf1,0x49,0x4b,0x36,0x07,0xdc,0xe4,0x3b}, 
        /*TST_input_hash_SHA384*/
        {0x1b,0x10,0xf2,0x2a,0x31,0x9d,0xb2,0xd0,0x0a,0xd2,0x9d,0xd0,0x77,0xe0,0x42,0x44,
        0xda,0x5b,0x7b,0x97,0x4d,0x8c,0xfe,0x14,0xdc,0x20,0x8e,0xe6,0x12,0xa7,0x1a,0x5f,
        0x43,0x43,0xaf,0xf2,0x64,0xb9,0xa0,0xc8,0x06,0xd1,0xaf,0xda,0xff,0x7b,0xe0,0x68},
        /*TST_input_hash_SHA512*/
        {0x07,0x4e,0xb7,0xf6,0x40,0x79,0x15,0x5c,0xd5,0xc5,0x81,0xb3,0xdf,0x81,0x24,0x1b,
        0x51,0x9b,0x95,0xf7,0xb0,0x5c,0xd6,0xaa,0xe8,0x07,0xf1,0x78,0x38,0xdd,0x89,0xf3,
        0x6d,0x1f,0xaa,0x65,0x5d,0x7f,0x03,0x4b,0x6d,0x19,0xfa,0x33,0xe5,0xa7,0x46,0x4e,
        0x44,0x3b,0x53,0xd6,0x4f,0x24,0xb3,0xbf,0xed,0xf3,0x94,0x3f,0x7e,0xbe,0xa8,0x41}, 
        /*TST_output_signiture*/
        {0},
    },
        /**********************************/
        /*  2048 bit key                  */
        /**********************************/
    { 
        {"Acceptance test - RSA External Hash SignVerify 2048bit key "},
        /*TST_PrivetExponent_D*/
        {0x26,0xf9,0x21,0xa5,0xa0,0x34,0x53,0x86,0x17,0x00,0x93,0xb5,0xef,0x9b,0xa0,0xf9,
         0xe9,0x17,0xd7,0xb2,0x6b,0x26,0xa7,0x29,0xd7,0xfd,0x7a,0x13,0xf1,0x9b,0x2b,0xe1,
         0x95,0x63,0x2c,0xf2,0x30,0xed,0xe3,0xf4,0xcb,0x88,0xba,0x9c,0x8f,0x45,0x5c,0x60,
         0x79,0xbe,0x97,0x27,0x8e,0x23,0x82,0x34,0x7f,0x56,0x86,0x71,0xcb,0x09,0x03,0x31,
         0x5d,0x46,0xc6,0xaa,0xd8,0x96,0xf9,0xe5,0x59,0xdc,0x44,0x5d,0x50,0xbd,0xfc,0x8e,
         0x1f,0xfa,0x5a,0x99,0xb7,0x44,0x07,0xd5,0x87,0x90,0x5a,0x96,0x16,0x17,0x3d,0x89,
         0x49,0xd3,0xd4,0x03,0x09,0x5b,0x00,0xef,0x8a,0x66,0x78,0x5b,0x21,0x32,0x06,0x1e,
         0xa7,0xe3,0xc8,0xcb,0x6f,0xf6,0x50,0xb6,0x22,0x12,0x65,0x0a,0x69,0xbc,0x78,0x04,
         0xb1,0xa2,0x64,0xd0,0xa1,0x04,0x96,0xc3,0x3e,0xfa,0xc3,0xcf,0xed,0x49,0xbe,0x21,
         0xcf,0xbc,0x31,0x3f,0x28,0x09,0x2e,0xad,0xd6,0x92,0xe1,0xfb,0xb6,0xbd,0x67,0x31,
         0x75,0x59,0x01,0x43,0x55,0x74,0x5b,0x6e,0x28,0xab,0x0b,0x08,0x47,0x97,0xc0,0xe3,
         0xa2,0x44,0x45,0x65,0x3d,0xab,0x40,0x46,0x9b,0x47,0xfe,0x46,0x22,0xa1,0x84,0x04,
         0xc6,0x79,0x84,0xc7,0xf3,0x25,0x60,0xae,0x95,0xaa,0x98,0x84,0xc6,0xc5,0xa7,0xde,
         0x7c,0x57,0x79,0x34,0x06,0x7e,0xd4,0x80,0x50,0x3d,0x98,0xd5,0x0c,0x06,0x73,0xd9,
         0xa0,0x25,0x60,0xbf,0x13,0x4e,0x59,0x9a,0x05,0xf8,0x24,0x7f,0xaf,0x29,0x9b,0xc4,
         0x8b,0x93,0x4c,0x44,0x2e,0xf1,0x21,0x3d,0x87,0xce,0xd6,0x3b,0x52,0xa0,0x92,0x11},
        /*TST_PublicExponent_E*/
        {0x01,0x00,0x01},
        /*TST_Modulus_N*/
        {0xdc,0xdf,0xb1,0x56,0xe8,0xc1,0x1f,0x7d,0x2d,0x92,0xf7,0x33,0x58,0x24,0x7e,0xed,
         0x5c,0x93,0x02,0xf8,0xe3,0xf4,0x02,0x22,0xde,0xc7,0x48,0xe8,0x9d,0x99,0xc1,0xc3,
         0xfd,0xa0,0x3d,0x65,0x57,0xee,0xc0,0x91,0x90,0xe7,0x13,0x82,0x7a,0x10,0xba,0x70,
         0x98,0x49,0x57,0x01,0x17,0x5b,0x4d,0xa8,0xb9,0x23,0x48,0x5a,0x5a,0xbc,0xed,0x8b,
         0xa7,0xa1,0x29,0x36,0x43,0xde,0xc2,0x8d,0x96,0x4e,0x6a,0xa6,0x69,0x45,0x73,0xd3,
         0xa5,0xdd,0xb3,0x0d,0x0e,0xea,0x49,0x00,0x13,0x41,0xd7,0x3b,0x6e,0xb7,0xbc,0x01,
         0x39,0xc2,0x7f,0x7c,0xe3,0x00,0x23,0xa7,0x58,0x98,0x5e,0x40,0xda,0x7a,0xe4,0xa7,
         0x23,0xbd,0x6c,0xcf,0xc1,0xb2,0xf9,0xcf,0xb6,0x83,0xbe,0x66,0xde,0x6a,0x1f,0x61,
         0x44,0x00,0xc9,0xd1,0x1d,0xd9,0x6f,0x9f,0xf0,0x17,0x6b,0xcb,0x02,0xc8,0x3b,0xa5,
         0xf8,0x88,0x08,0xea,0xb3,0x8d,0xeb,0x8c,0x44,0x89,0x54,0xb1,0xce,0x35,0x71,0x35,
         0x2c,0xbc,0x47,0x2d,0xb7,0x2b,0x6c,0xed,0x4f,0x72,0x3b,0x4e,0x5c,0x9a,0xe5,0x3e,
         0xd8,0x46,0xf2,0x51,0xad,0x9b,0x31,0x94,0x1c,0xd8,0xd7,0x7b,0x5e,0x69,0xa6,0x25,
         0x87,0xbb,0xc2,0xb8,0x38,0x8a,0x57,0x5e,0xcc,0x89,0xa0,0xfb,0x86,0x44,0x86,0x24,
         0x01,0x82,0xf8,0xce,0xb9,0xa7,0x38,0xf0,0xde,0xb4,0xcd,0x32,0x74,0x43,0x94,0x81,
         0x95,0x15,0x77,0x3d,0x73,0xf7,0x34,0xa0,0xc6,0x0e,0xb0,0x72,0x91,0x50,0x2f,0x96,
         0xfc,0x3b,0x94,0xea,0xf4,0x89,0x6e,0x15,0xc7,0xb1,0x9f,0xea,0x93,0xac,0x57,0xe5},
        /*TST_P*/
        {0xf9,0xc5,0xea,0x97,0x33,0xa5,0x92,0x75,0xe9,0x2e,0x56,0x86,0x66,0xba,0x40,0x58,
         0x2d,0x9f,0xd0,0x28,0x3c,0x1c,0x7a,0x47,0xae,0x98,0xf8,0x34,0x7e,0xc2,0x69,0x46,
         0x91,0xea,0xba,0x22,0xbf,0xf7,0x88,0xcd,0x2f,0x24,0xb8,0x58,0xab,0xb4,0x1f,0x3d,
         0x18,0xaa,0x4d,0x90,0x7c,0xcc,0xf1,0x8d,0xb5,0xac,0x98,0xda,0x7e,0x93,0xcb,0xbd,
         0x29,0x59,0x7f,0x86,0xce,0x8e,0x66,0xb9,0x54,0x99,0xd2,0x22,0xc9,0x85,0x36,0x44,
         0x1e,0xfc,0x9e,0x8d,0x6a,0xd8,0xca,0xdd,0x14,0xd1,0xb7,0xdb,0x2a,0xd4,0xf6,0xd5,
         0xc3,0xc7,0x82,0x67,0x98,0x32,0x81,0x0d,0x4c,0xa9,0x4e,0xc3,0xd2,0x66,0x25,0xe1,
         0x1c,0xbf,0xf9,0x24,0xc8,0x3f,0xb7,0x6c,0xab,0x35,0xe7,0x38,0x58,0x73,0x25,0x0f},
        /*TST_Q*/
        {0xe2,0x61,0x56,0x59,0x38,0xa1,0xab,0xef,0x03,0x80,0x44,0x0d,0x3d,0xb6,0x10,0x4c,
         0xdd,0xa2,0xb0,0x0d,0x43,0x74,0xd5,0xf8,0xc2,0x32,0xc3,0x0f,0xef,0x2b,0x87,0x1d,
         0xb3,0xa5,0x92,0x6f,0xda,0x6e,0x39,0xf6,0xc5,0x55,0xaa,0x33,0xe2,0x4f,0xdf,0x58,
         0x8b,0xfd,0x2b,0xd9,0x79,0x68,0x05,0x02,0x56,0xe9,0x16,0xbb,0xc6,0x13,0x28,0xfd,
         0x6e,0xcd,0xb0,0xdf,0xf2,0xf1,0x51,0x58,0x33,0x48,0xaa,0x1c,0xab,0xde,0x6c,0x62,
         0x7e,0x10,0xa2,0x6f,0x5c,0x61,0x44,0xeb,0x91,0xf8,0x22,0x79,0xfa,0xcf,0x67,0x90,
         0xa1,0xf3,0xb4,0x18,0x45,0x33,0x5e,0xa5,0xd0,0x4e,0x09,0xc1,0x6f,0xfc,0xa8,0x41,
         0xcc,0x2e,0xa9,0x55,0x77,0x2c,0x38,0xdc,0x17,0xde,0xda,0x62,0xde,0xf4,0xbb,0xcb},
        /*TST_dP*/
        {0x54,0x9e,0x9b,0xc2,0x8c,0x09,0xcd,0x1b,0xcb,0x5b,0x1a,0x8f,0x40,0x20,0x5b,0x8a,
         0x44,0x32,0xbf,0x77,0xd2,0x1d,0xa7,0xc3,0xbf,0x40,0x2d,0xde,0xc3,0x0f,0x24,0x51,
         0x77,0x3f,0xf9,0xbd,0xaa,0x21,0xb7,0xa4,0x24,0x13,0xa1,0xac,0xd0,0xc7,0x1e,0x4a,
         0x39,0xa0,0x00,0xd5,0x31,0xa2,0xd1,0x37,0x3c,0x54,0x74,0x18,0x9a,0x07,0x82,0x5f,
         0xdc,0xb1,0x68,0x86,0x08,0x56,0xb0,0x30,0x9b,0x9b,0xdd,0x58,0x51,0xc3,0xa2,0xc5,
         0xe3,0x65,0x9c,0x65,0xb6,0xcc,0x29,0xb6,0x4a,0xc6,0x5e,0x2e,0x8f,0x4d,0x45,0x2e,
         0xd8,0xbc,0x2f,0xce,0xde,0xfe,0x45,0x40,0x77,0x37,0x68,0xea,0xe8,0xce,0x18,0x89,
         0x32,0x8f,0x4b,0x5e,0x0d,0xc5,0xa0,0x63,0xdd,0x81,0x4e,0x8b,0x85,0x53,0xc5,0x3b},
        /*TST_dQ*/
        {0x11,0xa0,0x80,0xa7,0xbb,0xd8,0x22,0xda,0x1e,0x8c,0xab,0x3f,0xd8,0xb1,0x47,0x7d,
         0xa4,0xb8,0x59,0x3a,0xff,0x28,0xa6,0xcc,0x92,0xda,0x7f,0x03,0xcb,0x9c,0xb9,0x0d,
         0xa0,0x02,0x61,0x6f,0xa2,0x33,0x79,0x01,0xf5,0x05,0xa1,0x96,0x1e,0xa6,0x17,0x7e,
         0xfe,0x8f,0x7d,0x0d,0x96,0xfd,0x79,0x7e,0x60,0x24,0x10,0x28,0x18,0xd9,0x3f,0x14,
         0xd4,0xbe,0xe1,0x69,0xde,0xb1,0xd9,0xa2,0xa3,0x83,0xa1,0xf3,0x4f,0x92,0xa7,0x1f,
         0xd8,0x2f,0x15,0x66,0xd4,0x6b,0xa2,0x81,0x31,0x41,0x7f,0xf5,0xbd,0x88,0xce,0xc8,
         0x9d,0x43,0xab,0x9f,0x44,0x2c,0x26,0xcf,0x84,0x73,0xbf,0x20,0xb7,0xc6,0x95,0x97,
         0x61,0xfd,0xb4,0x23,0xba,0x7e,0xd0,0x02,0x9b,0x3d,0x38,0x06,0x00,0xd4,0x4f,0x97},
        /*TST_Qinv*/
        {0xbd,0x13,0x03,0xa6,0x79,0x8b,0x99,0x4f,0xd0,0xab,0x3f,0xf0,0x23,0x9a,0xbe,0xda,
         0x2b,0xa1,0x7f,0xda,0xb9,0xbc,0xc5,0x43,0x3b,0xfc,0x18,0x6b,0x70,0x9c,0x9c,0xab,
         0x30,0x85,0x67,0x71,0x8e,0x44,0x04,0x4a,0x7e,0xbd,0x52,0xe6,0x8d,0x38,0x22,0xd0,
         0x62,0x87,0x73,0x52,0x26,0x31,0xdb,0x55,0xbf,0x53,0xc8,0x94,0xa5,0x45,0x8c,0xe5,
         0x1c,0xea,0x01,0xdd,0xab,0xb7,0x6a,0xb6,0x85,0xda,0x79,0xb4,0x1a,0x40,0x9c,0x24,
         0xc0,0xf8,0xe4,0x8a,0x1a,0x6a,0xd6,0x04,0x74,0xfe,0xd6,0x4e,0x73,0x1a,0x5e,0x40,
         0x63,0x62,0x2a,0x9f,0x77,0xaf,0xfc,0xcb,0x1a,0x8a,0x2a,0xbd,0x98,0x84,0x52,0xb9,
         0xb5,0x49,0x30,0x61,0x4b,0xd3,0x87,0x05,0xaa,0xa8,0x8e,0x6f,0x8b,0x53,0xcb,0xd3},
        /*TST_KeySize*/
        256*sizeof(DxUint8_t),
        /*TST_DPSize*/
        128*sizeof(DxUint8_t),      
        /*TST_PubExponentSize*/
        3*sizeof(DxUint8_t),
        /*TST_SaltLength*/
        20,       
        /*TST_input_hash_SHA1*/
        {0xe4,0x8e,0xbf,0x67,0xe0,0xa0,0x2a,0xfe,0x14,0x71,0x60,0x6f,0x8f,0x4d,0xd4,0xee,
         0x16,0xf4,0xfe,0x7f},
        /*TST_input_hash_MD5*/
        {0xd4,0x22,0x19,0x30,0x15,0x2a,0xa2,0x54,0x81,0xc7,0x5f,0x9a,0xf8,0xce,0x9a,0x45}, 
        /*TST_input_hash_SHA224*/
        {0xc0,0x3d,0x3c,0x30,0xc2,0xa8,0x31,0x5f,0x33,0x7c,0x61,0x8e,0xc5,0xba,0x7c,0x80,
        0xe0,0xb5,0xc4,0x73,0xfe,0x59,0xb9,0xd0,0x6d,0xff,0xab,0x7a},
        /*TST_input_hash_SHA256*/
        {0x4b,0x55,0x8a,0xc5,0xf2,0x7a,0xad,0x4f,0xdd,0x97,0x4c,0x01,0x36,0x13,0x89,0x01,
        0x6a,0xa3,0x37,0x79,0xa8,0x3f,0xc0,0x54,0x2b,0x8e,0x1d,0x28,0xd4,0x53,0x7e,0xd5}, 
        /*TST_input_hash_SHA384*/
        {0x64,0x5b,0x67,0x75,0x8b,0x26,0x5f,0xaf,0x17,0xd7,0x3f,0x58,0xae,0x0b,0xd4,0x98,
        0xa3,0xa8,0xf3,0x3f,0xc9,0x94,0xa2,0x10,0x81,0x00,0xb1,0x0e,0x92,0x57,0xf0,0x4b,
        0x66,0xaf,0x82,0x16,0xe8,0x85,0x16,0x5a,0xa1,0x35,0x27,0x00,0x6f,0x36,0x9e,0x70},
        /*TST_input_hash_SHA512*/
         {0x06,0x9c,0x2d,0x5d,0x4a,0x46,0xbe,0x69,0xa3,0x87,0x66,0x7e,0x8a,0xa6,0x75,0x2e,
         0x74,0x82,0x46,0x6a,0x87,0x16,0xfc,0x14,0x49,0x99,0x28,0xc6,0x01,0xd1,0xeb,0xe3,
         0xb5,0x14,0x85,0x72,0xec,0x01,0xe5,0x56,0x59,0x49,0x3f,0x86,0x95,0x16,0xfc,0x62,
         0xbc,0x4f,0x51,0x5a,0x26,0xc4,0x85,0xa9,0xff,0xa2,0x06,0xc5,0xa5,0x74,0xc4,0x86}, 
        /*TST_output_signiture*/
        {0},
    },      
        /**********************************/
        /*  2112 bit key                  */
        /**********************************/
    { 
        {"Acceptance test - RSA External Hash SignVerify 2112bit key "},
        /*TST_PrivetExponent_D*/
        {0x3E,0x56,0x70,0x88,0xC6,0xF0,0x9B,0xD9,0x44,0x10,0x2E,0x49,0x30,0x59,0xCD,0x0F,
        0x03,0xF1,0x3C,0x85,0x21,0xC4,0xA7,0x0B,0x39,0x6A,0x7F,0x02,0x2D,0xD0,0x9F,0x8C,
        0xAE,0xEB,0x51,0x26,0x85,0x52,0xFC,0xC6,0x68,0xED,0x71,0x9E,0xF5,0x33,0xCB,0xB3,
        0x5D,0x3F,0x3E,0x56,0x15,0xD3,0x9C,0x83,0x5A,0x62,0x91,0x9C,0xBF,0x53,0x14,0x60,
        0x15,0x53,0xAC,0x86,0x63,0xEF,0xB4,0x91,0xAA,0x59,0x47,0x9B,0x2C,0x2A,0x90,0xC2,
        0x03,0xEA,0xBE,0x74,0x57,0x13,0x8B,0x27,0x05,0xFD,0xDD,0xA7,0x7B,0xEB,0x19,0xD9,
        0xB0,0x53,0xB8,0x24,0x59,0x70,0x17,0xDE,0xFC,0xCB,0x32,0x64,0x7E,0x35,0x88,0x26,
        0x1A,0x50,0xB0,0xCF,0x4B,0xED,0x8D,0x16,0xF2,0xC7,0xC7,0x7D,0xFF,0x1D,0xA6,0x2D,
        0xDD,0xBF,0x28,0x44,0xF1,0x11,0x37,0xBF,0xA4,0xAA,0x1A,0x0E,0x71,0x82,0x3A,0xFD,
        0x6E,0xF9,0xE2,0x96,0x04,0xCE,0x0A,0x55,0xB3,0x62,0x44,0xF8,0xB4,0x30,0xA6,0x6D,
        0x4E,0x98,0x95,0xCC,0xD8,0x05,0x64,0xAC,0x05,0xF9,0x7F,0x03,0x99,0x32,0x66,0x91,
        0x8F,0xFE,0x00,0xFF,0x92,0x1A,0x4C,0x6D,0xAF,0x27,0xED,0xE4,0x2E,0x55,0xE4,0x16,
        0xA0,0xD3,0x2C,0x7A,0xFF,0x19,0xDC,0xA7,0x0D,0x3F,0xA0,0x4E,0xCF,0xF6,0xE9,0xB5,
        0xE7,0x3A,0xE4,0xB1,0x88,0xDD,0x0A,0x38,0x33,0xE8,0x5B,0xAD,0xC2,0x78,0xD7,0x7E,
        0x6B,0xF7,0x30,0x78,0x6D,0x81,0xE5,0xF3,0x01,0xD6,0xFB,0x7B,0x58,0x53,0x09,0xE7,
        0xFC,0xA0,0x4D,0x0D,0x59,0x04,0xB2,0xCE,0x48,0x9E,0x2D,0x82,0xC1,0xF8,0xB7,0xB1,
        0xAF,0xE9,0xF0,0xA7,0x9D,0x1F,0xE3,0x79},
        /*TST_PublicExponent_E*/
        {0x01,0x00,0x01},
        /*TST_Modulus_N*/
        {0xCA,0x51,0x9A,0xBF,0x0B,0xB1,0x96,0x03,0x5F,0x03,0x15,0xC8,0xEF,0xB2,0x47,0x48,
	    0xBE,0x92,0xE3,0xA5,0x0D,0xDA,0x9C,0x77,0x53,0xF5,0xE9,0xF9,0x8B,0x7A,0x24,0x25,
	    0xDC,0x87,0x25,0x0E,0x03,0xCC,0x0C,0x57,0x24,0x78,0xC6,0x3B,0xA5,0x6A,0x3C,0xD1,
	    0x17,0x8C,0xD4,0xB2,0x80,0xE7,0x11,0x3D,0xBD,0x29,0x91,0xEC,0x83,0x7D,0x91,0x84,
	    0x29,0x2C,0x88,0xE4,0xE9,0xE7,0x6F,0xE5,0xD1,0xD0,0x88,0xC5,0xB7,0xC8,0xE3,0xA5,
	    0xBE,0x5D,0x5C,0xED,0xA6,0x44,0x1B,0x77,0x8D,0x5A,0xC1,0x40,0x01,0x0C,0x07,0x35,
	    0xFF,0x14,0x67,0x80,0x54,0xA4,0x44,0xB3,0x86,0x2B,0x86,0x57,0x5B,0x51,0x47,0xF0,
	    0xEB,0x62,0x2D,0x69,0x45,0x9F,0xB0,0x23,0x17,0x11,0xE4,0x42,0x28,0xE4,0xC5,0xA9,
	    0xF7,0xEC,0xB4,0x6F,0xC9,0x59,0x14,0xBE,0x0D,0x10,0x9B,0x72,0x43,0x52,0x4A,0x74,
	    0x20,0x8A,0xEE,0x1F,0xD4,0x53,0x5D,0xBC,0xDA,0xFA,0x6F,0x2B,0xD1,0xA1,0xCC,0x00,
	    0xC1,0x23,0x1C,0x7B,0x75,0x9D,0xDE,0x06,0x09,0x3F,0xB9,0x8F,0x4B,0x22,0x57,0x56,
	    0x73,0x0F,0x9D,0x89,0x09,0x27,0xC3,0x41,0xEE,0x18,0xE2,0x7D,0x88,0x11,0x0D,0xC6,
	    0x43,0xDC,0x08,0x8D,0xD8,0x3F,0x2C,0xB3,0xB1,0xF1,0xB3,0x76,0x22,0xB5,0x92,0x3C,
	    0xB0,0x8E,0x4D,0x16,0x70,0xBE,0xE8,0xFF,0x5B,0x5F,0x44,0xFD,0x57,0x80,0x01,0x2D,
	    0x83,0x86,0xB1,0x86,0x11,0xB0,0x92,0x32,0x13,0xB1,0xC1,0xB0,0xF3,0xFB,0xA9,0x31,
	    0x51,0x39,0xDF,0x42,0x15,0xA7,0x52,0xB6,0xA4,0x6C,0x92,0x10,0xF7,0x67,0xBC,0xC5,
	    0x65,0xA5,0x3D,0xD4,0x34,0x8E,0x1E,0x37},
        /*TST_P*/
        {0},
        /*TST_Q*/
        {0},
        /*TST_dP*/
        {0},
        /*TST_dQ*/
        {0},
        /*TST_Qinv*/
        {0},
        /*TST_KeySize*/
        264*sizeof(DxUint8_t),
        /*TST_DPSize*/
        132*sizeof(DxUint8_t),      
        /*TST_PubExponentSize*/
        3*sizeof(DxUint8_t),
        /*TST_SaltLength*/
        20,       
        /*TST_input_hash_SHA1*/
        {0xe4,0x8e,0xbf,0x67,0xe0,0xa0,0x2a,0xfe,0x14,0x71,0x60,0x6f,0x8f,0x4d,0xd4,0xee,
         0x16,0xf4,0xfe,0x7f},
        /*TST_input_hash_MD5*/
        {0xd4,0x22,0x19,0x30,0x15,0x2a,0xa2,0x54,0x81,0xc7,0x5f,0x9a,0xf8,0xce,0x9a,0x45}, 
        /*TST_input_hash_SHA224*/
        {0xc0,0x3d,0x3c,0x30,0xc2,0xa8,0x31,0x5f,0x33,0x7c,0x61,0x8e,0xc5,0xba,0x7c,0x80,
        0xe0,0xb5,0xc4,0x73,0xfe,0x59,0xb9,0xd0,0x6d,0xff,0xab,0x7a},
        /*TST_input_hash_SHA256*/
        {0x4b,0x55,0x8a,0xc5,0xf2,0x7a,0xad,0x4f,0xdd,0x97,0x4c,0x01,0x36,0x13,0x89,0x01,
        0x6a,0xa3,0x37,0x79,0xa8,0x3f,0xc0,0x54,0x2b,0x8e,0x1d,0x28,0xd4,0x53,0x7e,0xd5}, 
        /*TST_input_hash_SHA384*/
        {0x64,0x5b,0x67,0x75,0x8b,0x26,0x5f,0xaf,0x17,0xd7,0x3f,0x58,0xae,0x0b,0xd4,0x98,
        0xa3,0xa8,0xf3,0x3f,0xc9,0x94,0xa2,0x10,0x81,0x00,0xb1,0x0e,0x92,0x57,0xf0,0x4b,
        0x66,0xaf,0x82,0x16,0xe8,0x85,0x16,0x5a,0xa1,0x35,0x27,0x00,0x6f,0x36,0x9e,0x70},
        /*TST_input_hash_SHA512*/
         {0x06,0x9c,0x2d,0x5d,0x4a,0x46,0xbe,0x69,0xa3,0x87,0x66,0x7e,0x8a,0xa6,0x75,0x2e,
         0x74,0x82,0x46,0x6a,0x87,0x16,0xfc,0x14,0x49,0x99,0x28,0xc6,0x01,0xd1,0xeb,0xe3,
         0xb5,0x14,0x85,0x72,0xec,0x01,0xe5,0x56,0x59,0x49,0x3f,0x86,0x95,0x16,0xfc,0x62,
         0xbc,0x4f,0x51,0x5a,0x26,0xc4,0x85,0xa9,0xff,0xa2,0x06,0xc5,0xa5,0x74,0xc4,0x86}, 
        /*TST_output_signiture*/
        {0},
    },      
};
#else
/***********************/
/* ROT13 Example tests */
/***********************/
TST_RSA_TestDataStruct TST_RSA_Acceptance_Primitive_TestData[] =
{
        /**********************************/
        /*  RSA EncryptDecrypt test data  */
        /**********************************/
    { 
        {"Acceptance test - RSA 512bit "},
        /*TST_PrivetExponent_D*/
        {0xa8,0xd6,0xfa,0x2b,0x47,0xde,0x8c,0x36,0x04,0x2a,0x32,0x55,0x7c,0xf5,0xde,0x2e,
         0xe3,0xc1,0x62,0x72,0x83,0x55,0x27,0x76,0x9f,0x6b,0xe0,0xfa,0x9a,0x26,0x03,0x9b,
         0x41,0x1f,0xd6,0xbc,0x3d,0x77,0xd0,0x5f,0xb0,0x71,0x00,0xf6,0x27,0xa7,0x55,0xf8,
         0xb4,0xc7,0x5a,0x31,0xeb,0xce,0x51,0x19,0x94,0x21,0xa6,0xac,0xb8,0xf5,0xbb,0x01},
        /*TST_PublicExponent_E*/
        {0x01,0x00,0x01},
        /*TST_Modulus_N*/
        {0xbb,0x3d,0xf1,0x3f,0x1d,0xcf,0xc6,0xfa,0x13,0x56,0xb3,0x95,0x53,0xcf,0xbd,0x10,
         0xf4,0x75,0xfe,0x7d,0xf6,0x89,0xa1,0x06,0x94,0x67,0xd4,0x5c,0xb7,0x89,0xbe,0xed,
         0xe2,0x49,0x51,0x6b,0xf0,0xd2,0x7c,0xef,0x67,0xbb,0xf6,0x9a,0x8b,0x67,0x51,0xe8,
         0xc0,0xbf,0x52,0xbc,0x2f,0x10,0xc1,0x85,0x77,0x18,0x60,0x52,0x67,0x94,0xd7,0x57},
        /*TST_P*/
        {0xf4,0xab,0x4e,0xda,0x43,0xf4,0xcd,0x34,0xb1,0xd8,0xf4,0xd6,0x97,0xea,0x6f,0x07,
         0xc8,0xfd,0xa6,0x28,0x33,0x4c,0xaf,0x60,0x9b,0x0c,0x48,0x79,0x0a,0xb0,0x14,0xb1},
        /*TST_Q*/
        {0xc3,0xe9,0xcd,0x5a,0xef,0xa1,0x27,0x15,0xbf,0x34,0xc0,0xca,0x41,0x79,0x39,0x19,
         0xf6,0xd2,0x12,0x14,0x14,0x29,0x8e,0x36,0x06,0xa8,0xd3,0xe5,0x90,0x2c,0x4e,0x87},     
        /*TST_dP*/
        {0x40,0xa1,0x80,0x12,0xe8,0x20,0xa2,0x94,0x68,0xe6,0x86,0xc6,0xa9,0x1a,0xa4,0x79,
         0xc9,0xfe,0x37,0x06,0x27,0x86,0xfa,0x4c,0xea,0xa8,0x33,0xfc,0xc5,0x75,0xfe,0x01},
        /*TST_dQ*/
        {0x59,0x58,0x87,0x0e,0xb1,0xba,0x0c,0xd9,0x1e,0x1a,0x30,0xd2,0x0c,0x89,0xfc,0x40,
         0x9b,0x0f,0xb2,0xae,0xf5,0x82,0xfe,0x18,0x25,0x71,0x59,0x31,0x98,0x4e,0x9c,0x81},
        /*TST_Qinv*/
        {0xa5,0x61,0xd2,0x0d,0x6d,0xe7,0x20,0xa5,0xaf,0x9b,0x59,0x8c,0x98,0xa4,0x6a,0x4a,
         0xaf,0x76,0xab,0x60,0x57,0xd4,0xdc,0x71,0xb5,0x1d,0xf2,0xac,0x22,0x0a,0xb6,0xf5},
        /*TST_KeySize*/
        64*sizeof(DxUint8_t),
        /*TST_DPSize*/
        32*sizeof(DxUint8_t),      
        /*TST_PubExponentSize*/
        3*sizeof(DxUint8_t),
        /*TST_input_data*/
        {0x41,0x1f,0xd6,0xbc,0x3d,0x77,0xd0,0x5f,0xb0,0x71,0x00,0xf6,0x27,0xa7,0x55,0xf8,
         0xb4,0xc7,0x5a,0x31,0xeb,0xce,0x51,0x19,0x94,0x21,0xa6,0xac,0xb8,0xf5,0xbb,0x01,
         0xa8,0xd6,0xfa,0x2b,0x47,0xde,0x8c,0x36,0x04,0x2a,0x32,0x55,0x7c,0xf5,0xde,0x2e,
         0xe3,0xc1,0x62,0x72,0x83,0x55,0x27,0x76,0x9f,0x6b,0xe0,0xfa,0x9a,0x26,0x03,0x9b},
        /*TST_output_data*/
        {0},
        /*TST_Expected_output_data*/
        {0x41,0x1f,0xd6,0xc9,0x3d,0x77,0xd0,0x6c,0xb0,0x71,0x01,0x03,0x27,0xa7,0x56,0x05,
		 0xb4,0xc7,0x5a,0x3e,0xeb,0xce,0x51,0x26,0x94,0x21,0xa6,0xb9,0xb8,0xf5,0xbb,0x0e,
		 0xa8,0xd6,0xfa,0x38,0x47,0xde,0x8c,0x43,0x04,0x2a,0x32,0x62,0x7c,0xf5,0xde,0x3b,
		 0xe3,0xc1,0x62,0x7f,0x83,0x55,0x27,0x83,0x9f,0x6b,0xe1,0x07,0x9a,0x26,0x03,0xa8}
    }
};

TST_RSA_TestSignVerifyDataStruct TST_RSA_Acceptance_SignVerify_TestData[] =
{
        /**********************************/
        /*  RSA SignVerify test data      */
        /**********************************/
        /*  512 bit key                   */
        /**********************************/
    { 
        {"Acceptance test - RSA SignVerify 16byteData/512bit key "},
        /*TST_PrivetExponent_D*/
        {0x1e,0x44,0x11,0x20,0x0f,0x3f,0x66,0x1e,0x0a,0xab,0xbb,0xfa,0xfb,0xee,0x9c,0x79,
         0xf8,0xa4,0xa8,0xbb,0x1d,0x12,0x9e,0xbf,0x30,0xdc,0xb0,0x82,0x54,0x58,0xdc,0x64,
         0x58,0xb0,0x97,0xfc,0x05,0x00,0xf5,0x68,0xb8,0x39,0xc8,0x09,0x2b,0xfb,0xcd,0x2e,
         0x1b,0x70,0x20,0xda,0x68,0x9b,0x16,0xf6,0x8d,0xee,0x01,0x32,0x51,0x53,0x37,0x41},
        /*TST_PublicExponent_E*/
        {0x01,0x00,0x01},
        /*TST_Modulus_N*/
        {0xcc,0x41,0xad,0x7d,0x9f,0xc3,0xd3,0x54,0x09,0x38,0x82,0xb8,0x95,0x5b,0x09,0xcb,
         0xac,0xc4,0x10,0x20,0xa1,0x7c,0x58,0x18,0xaa,0x15,0x63,0xa5,0xf8,0x70,0x6d,0x2d,
         0x4b,0x36,0x20,0x8d,0x12,0x8c,0x78,0xa4,0x6a,0x6e,0xf2,0x27,0x49,0x50,0x09,0xb1,
         0x17,0xe4,0x19,0x58,0x74,0x2b,0xd3,0xd5,0xb6,0x43,0xfa,0x6c,0x11,0x80,0xe8,0x2f},
        /*TST_P*/
        {0xfb,0x7f,0x3c,0x7b,0xf8,0x68,0xf2,0x98,0x75,0x3a,0xdc,0x79,0xca,0xab,0x24,0x15,
         0xfb,0x61,0x94,0xc8,0xf2,0x3a,0x08,0x67,0xbe,0x9e,0x76,0xcb,0x2c,0x7f,0x98,0xcf},
        /*TST_Q*/
        {0xcf,0xe9,0xe8,0xdf,0xf6,0xc3,0x00,0x81,0x8a,0x95,0x38,0xa2,0x80,0x54,0xfd,0x62,
         0xff,0x3d,0xf1,0x65,0x00,0x0b,0xe7,0x7c,0xea,0xd8,0xa7,0x21,0x21,0x98,0xd2,0xa1},     
        /*TST_dP*/
        {0x7d,0x6e,0x92,0x0e,0x0a,0x70,0xdd,0x3d,0xa8,0x8a,0x38,0xd8,0x0d,0x7a,0x99,0xbe,
         0xd4,0xe7,0x70,0x3b,0x60,0x84,0x0d,0x19,0x20,0xfb,0x0b,0xa8,0x7d,0x83,0x0e,0x05},
        /*TST_dQ*/
        {0x6a,0x38,0x6c,0x9b,0x0f,0x6c,0xac,0xb3,0x81,0xe3,0x9e,0x9d,0x96,0xc6,0xd4,0xf5,
         0x60,0xc5,0x7a,0xb0,0x49,0x07,0xcb,0xea,0x4b,0xe9,0x07,0xe9,0xab,0x4a,0x72,0x41},
        /*TST_Qinv*/
        {0x3b,0x67,0x2a,0x6c,0xa4,0xd7,0x75,0x5b,0x05,0x4e,0xf0,0x48,0xab,0x14,0xca,0xc3,
         0xaa,0x58,0x92,0x31,0x4c,0x70,0xc0,0xb0,0x95,0x9d,0x86,0xf8,0xcd,0x77,0x45,0x97},
        /*TST_KeySize*/
        64*sizeof(DxUint8_t),
        /*TST_DPSize*/
        32*sizeof(DxUint8_t),      
        /*TST_PubExponentSize*/
        3*sizeof(DxUint8_t),
        /*TST_SaltLength*/
        20,
        /*TST_input_data*/
        {0x41,0x1f,0xd6,0xbc,0x3d,0x77,0xd0,0x5f,0xb0,0x71,0x00,0xf6,0x27,0xa7,0x55,0xf8},
        /*TST_input_dataSize*/
        16*sizeof(DxUint8_t), 
        /*TST_output_signiture*/
        {0},
    }
};

TST_RSA_TestExtHashSignVerifyDataStruct TST_RSA_Acceptance_ExtHashSignVerify_TestData[] =
{
        /*******************************************/
        /*  RSA External Hash SignVerify test data */
        /*******************************************/
        /*  512 bit key                   */
        /**********************************/
    { 
        {"Acceptance test - RSA External Hash SignVerify 512bit key "},
        /*TST_PrivetExponent_D*/
        {0xca,0xbb,0x7e,0x86,0x1e,0x28,0xca,0xdc,0x0c,0x71,0x74,0xb2,0x67,0x84,0x1a,0xd1,
         0xba,0x11,0xfc,0xd8,0x3e,0xc1,0x91,0xfb,0xe1,0xae,0x01,0x25,0x79,0x88,0xeb,0x29,
         0x37,0x84,0xa6,0x6d,0x41,0xf0,0x08,0x9e,0xab,0x97,0x77,0x83,0x98,0x4e,0x9f,0x6b,
         0x64,0x7a,0x6b,0xcf,0x9c,0xdc,0xac,0xbb,0x04,0x95,0x2a,0xd6,0x39,0x74,0x36,0x89},
        /*TST_PublicExponent_E*/
        {0x01,0x00,0x01},
        /*TST_Modulus_N*/
        {0xe4,0x78,0x72,0x76,0x39,0xd6,0xbf,0x7a,0x47,0x52,0x1a,0xb1,0x99,0x75,0xa9,0x32,
         0xd4,0xa3,0x54,0xb7,0x12,0xae,0x85,0x32,0x4c,0x06,0x1a,0xde,0x3f,0x66,0x9d,0xbc,
         0x42,0x8c,0x50,0x6e,0xde,0xc8,0x40,0x9a,0x10,0x86,0xa9,0x09,0x27,0x8c,0xf6,0xb6,
         0x95,0x8c,0xf9,0x4d,0x24,0x2e,0x5a,0xc4,0x05,0x2d,0x7a,0xce,0xdc,0x6f,0x4e,0x59},
        /*TST_P*/
        {0xf3,0xa3,0xd7,0x6b,0x3c,0x72,0x27,0x9e,0x00,0x0c,0xec,0x3b,0x2e,0xfe,0xaf,0xca,
        0x3c,0x94,0x88,0xfb,0xfd,0x89,0xa3,0x28,0xf3,0x0f,0xeb,0x51,0xc0,0x38,0x76,0xcf},
        /*TST_Q*/
        {0xf0,0x0f,0x99,0x4e,0xf6,0x1a,0x49,0xc4,0x01,0xcc,0x5e,0x74,0x38,0xba,0x8b,0xba,
         0x62,0x54,0x85,0x4c,0x1a,0x69,0xc1,0xd8,0xad,0x45,0x6f,0xf4,0x67,0xed,0xb2,0x57},
        /*TST_dP*/
        {0x60,0x8a,0xce,0xc4,0x96,0x6a,0x21,0x9a,0xb1,0x28,0x6d,0xbf,0x31,0xeb,0x07,0xdb,
         0x5a,0x4f,0xfd,0x4b,0xe4,0xf6,0x52,0x29,0xda,0xce,0xb7,0x0f,0x68,0xdc,0xb6,0xef},
        /*TST_dQ*/
        {0x38,0xed,0x2a,0x08,0xbc,0x79,0x6d,0x66,0xaa,0x9a,0x81,0x07,0x84,0x70,0x50,0x34,
        0x29,0x9f,0x2b,0x60,0xe9,0x9e,0x8c,0x96,0x4a,0x38,0x7e,0x1c,0xf2,0x0c,0x3e,0xcf},
        /*TST_Qinv*/
        {0x0a,0xfd,0x35,0x95,0xe8,0xf4,0x6c,0x91,0xc0,0x07,0x51,0x8e,0xd9,0xe4,0x16,0xd3,
         0x7a,0x18,0x31,0xae,0x48,0xc4,0x87,0x5f,0x2b,0xbe,0xfc,0xf9,0x8c,0xd2,0x95,0x29},
        /*TST_KeySize*/
        64*sizeof(DxUint8_t),
        /*TST_DPSize*/
        32*sizeof(DxUint8_t),       
        /*TST_PubExponentSize*/
        3*sizeof(DxUint8_t),
        /*TST_SaltLength*/
        20,
        /*TST_input_hash_SHA1*/
        {0x41,0x1f,0xd6,0xbc,0x3d,0x77,0xd0,0x5f,0xb0,0x71,0x00,0xf6,0x27,0xa7,0x55,0xf8,
         0x41,0x1f,0xd6,0xbc},
        /*TST_input_hash_MD5*/
        {0x5a,0x4f,0xfd,0x4b,0xe4,0xf6,0x52,0x29,0xda,0xce,0xb7,0x0f,0x68,0xdc,0xb6,0xef}, 
        /*TST_output_signiture*/
        {0},
    }
};
#endif

const int TST_NumberOf_RSA_AcceptanceTests = sizeof(TST_RSA_Acceptance_Primitive_TestData)/sizeof(TST_RSA_Acceptance_Primitive_TestData[0]);
const int TST_NumberOf_RSA_AcceptanceSignVerifyTests = sizeof(TST_RSA_Acceptance_SignVerify_TestData)/sizeof(TST_RSA_Acceptance_SignVerify_TestData[0]);
const int TST_NumberOf_RSA_AcceptanceExtHashSignVerifyTests = sizeof(TST_RSA_Acceptance_ExtHashSignVerify_TestData)/sizeof(TST_RSA_Acceptance_ExtHashSignVerify_TestData[0]);

/************************ Private function prototype **********/
/************************ Private Functions *******************/

/* Check returned error code */
CE2Error_t TST_RSA_CheckErrorReturn(CE2Error_t  TST_ErrorRet,
                                     char         TST_FuncName[TST_FUNC_STRING_LEN],
                                     char         TST_SubTestName[TST_FUNC_STRING_LEN],
                                     char         TST_MasterTestName[TST_FUNC_STRING_LEN])
{
	if (TST_ErrorRet != CE2_OK)
	{
		fprintf(FileOut, "\n!!!! TST_Error - Master Test Name -%s\n",TST_MasterTestName);
		fprintf(FileOut, "!!!! TST_Error - SubTest Name -%s\n",TST_SubTestName);
		fprintf(FileOut, "!!!! TST_Error - %s failed\n",TST_FuncName);
		fprintf(FileOut, "!!!! TST_Error - CE2_Error returned %lX \n",TST_ErrorRet);

		TST_TestStatusReturn = CE2_TST_FAILED;

		return CE2_TST_FAILED;
	}
	else
	{
		return CE2_TST_VALID;
	}
}

/* Begin file output */
FILE * TST_REPORT_BEGIN(char * pchFunctionName, FILE * out)
{
	useSTDFile = 0;

	if (out == NULL)
	{
		if (fopen_s(&out, TST_RSA_STD_LOG_FILE_NAME, "w") != 0)
		{
			printf("Can't create log file '%s'!\n", TST_RSA_STD_LOG_FILE_NAME);
			return NULL;
		}
		useSTDFile = 1;
	}

	FileOut = out;

	PrintTestBeginMsg(FileOut, pchFunctionName);

	return out;
}

/* End file output */
void TST_REPORT_END(char * pchFunctionName)
{
	PrintTestEndMsg(FileOut, pchFunctionName, TST_TestStatusReturn);

	if (useSTDFile) fclose(FileOut);
}

/************************ Public Functions ********************/

/***************************************************************
* Function Name: 
*  CE2_TST_RSA_Acceptance_PRIME_EncDec
*
* Inputs:
*  @param out [in] - pointer to file to output debug information;
*
* Outputs: @returns \b
*  CE2Error_t  
*  - CE2_OK - On success
*  - Otherwise - error code.
*
* \brief \b
* Description:
*  This function Is a Acceptance test for RSA primitive encrypt and decrypt
*  This function Encrypts and Decrypts known vectors using RSA primitives
*  Vector/Keys sizes used (in bits) - 512/1024/2048
*  This also outputs the results to an output buffer or the same input buffer
*
* \b
* Algorithm:
*  -# Build the Private Key from external exponent and modulus;
*  -# Build the Public Key from External exponent and modulus;
*  -# Encrypt/Decrypt a known vector;
*  -# Compare the outputted result to the expected one.
***************************************************************/
CE2Error_t CE2_ATP_TST_RSA_Acceptance_PRIME_EncDec(FILE * out)
{
	int			TST_index,TST_CRT_Mode;
	DxUint16_t	TST_GetModulusSize;
	char		TST_MasterTestName[TST_FUNC_STRING_LEN] =
		"CE2_TST_RSA_Acceptance_PRIME_EncDec";
	int			DataSize;

	out = TST_REPORT_BEGIN(__FUNCTION__, out);
	if (out == NULL)
		return CE2_TST_FAILED;

	/* Start of test */
	/* TST_CRT_Mode = 0 no CRT // TST_CRT_Mode = 1 CRT mode*/
	for (TST_CRT_Mode = 0 ; TST_CRT_Mode < 2 ; TST_CRT_Mode++)
	{
		for (TST_index =0 ; TST_index < TST_NumberOf_RSA_AcceptanceTests ; TST_index++) /*To run on all test vectors*/
		{
			/* STUBS */
			/* STUB for CRT mode */
			//if (TST_CRT_Mode == TST_CRT_MODE)
			//	continue;

			/* STUB for keysize */
			/* low level function keysize bound */
			if ((TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_KeySize < (MIN_RSA_SIZE/8)) ||
				(TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_KeySize > (MAX_RSA_SIZE/8)))
				continue;

            /* STUB for keysize */
            /* not enought data for testing in CRT mode */
            if (TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_KeySize == 264 && TST_CRT_Mode == TST_CRT_MODE)
                continue;

			/* STUBS end */

			/* output buffer != input buffer */
			/*
			fprintf(out, "********************************************************************** \n");
			fprintf(out, " %s[test 1.%d]\n",TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_Name,TST_index);
			fprintf(out, (TST_CRT_Mode == TST_NO_CRT)?(" Non CRT mode  \n"):(" CRT mode  \n"));
			fprintf(out, "********************************************************************** \n");
			*/

			/* Build the public Key */
			TST_ATP_Error = CE2_RSA_Build_PubKey(
				&TST_PublicKey,
				TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_PublicExponent_E,
                TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_PubExponentSize,
                TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_Modulus_N,
                TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_KeySize);

			/* Get the E size */
			TST_ATP_Error = CE2_RSA_Get_ModSizeFromPubKey(
				&TST_PublicKey, &TST_GetModulusSize);
            
			TST_TestStatus = TST_RSA_CheckErrorReturn(
				TST_ATP_Error,"CE2_RSA_Get_ModSizeFromPubKey",
				TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_Name,
				TST_MasterTestName);

            /* Check that received E size is correct */
            TST_TestStatus =
				TST_GetModulusSize != TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_KeySize
				? CE2_TST_FAILED : CE2_TST_VALID;

			TST_TestStatus = TST_RSA_CheckErrorReturn(
				TST_ATP_Error,"Compare - TST_GetModulusSize",
				TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_Name,
				TST_MasterTestName);

			TST_TestStatus = TST_RSA_CheckErrorReturn(
				TST_ATP_Error,"CE2_RSA_Build_PubKey",
				TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_Name,
				TST_MasterTestName);

			/* Build the Private Key */
			if (TST_CRT_Mode == TST_NO_CRT)
			{
				TST_ATP_Error = CE2_RSA_Build_PrivKey(
					&TST_PrivateKey,
					TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_PrivetExponent_D,
					TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_KeySize,
					TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_PublicExponent_E,
					TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_PubExponentSize,
					TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_Modulus_N,
					TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_KeySize);

				TST_TestStatus = TST_RSA_CheckErrorReturn(
					TST_ATP_Error,"CE2_RSA_Build_PrivKey",
					TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_Name,
					TST_MasterTestName);
			}
			else
			{
				TST_ATP_Error = CE2_RSA_Build_PrivKeyCRT(
					&TST_PrivateKey,
					TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_P,
					TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_DPSize,
					TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_Q,
					TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_DPSize,
					TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_dP,
					TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_DPSize,
					TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_dQ,
					TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_DPSize,
					TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_Qinv,
					TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_DPSize);

				TST_TestStatus = TST_RSA_CheckErrorReturn(
					TST_ATP_Error,"CE2_RSA_Build_PrivKeyCRT",
					TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_Name,
					TST_MasterTestName);
			}

			DataSize =
				TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_KeySize;

			/* Encrypt the data using the primes */
			/* (Public Key)                      */
			TST_ATP_Error = CE2_RSA_PRIM_Encrypt(
				&TST_PublicKey,
				TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_input_data,
				DataSize,
				TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_output_data);

			TST_TestStatus = TST_RSA_CheckErrorReturn(
				TST_ATP_Error,"CE2_RSA_PRIM_Encrypt",
				TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_Name,
				TST_MasterTestName);

			/* Compare the Encrypted data to the expected */
			/*
			As DataSize is not equat to TST_KeySize (low level datasize bound)
			therefore this part of code is invalid:
			TST_Expected_output_data is crypted from data which length was
			TST_KeySize, but not DataSize.
			*/
			/*
			TST_ATP_Error = (CE2Error_t)memcmp(
				TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_output_data ,
				TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_Expected_output_data,
				TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_KeySize);

			TST_TestStatus = TST_RSA_CheckErrorReturn(
				TST_ATP_Error,"memcmp - Encrypt",
				TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_Name,
				TST_MasterTestName);
			*/

            /* Decrypt the data using the primes */
            /* (Private Key)                     */
			TST_ATP_Error = CE2_RSA_PRIM_Decrypt(
				&TST_PrivateKey,
				TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_output_data,
				TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_KeySize,
                TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_output_data);

			TST_TestStatus = TST_RSA_CheckErrorReturn(
				TST_ATP_Error,"CE2_RSA_PRIM_Decrypt",
				TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_Name,
				TST_MasterTestName);

			TST_ATP_Error = (CE2Error_t)memcmp(
				TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_output_data,
				TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_input_data,
				DataSize);

			TST_TestStatus = TST_RSA_CheckErrorReturn(
				TST_ATP_Error,"memcmp - Decrypt",
				TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_Name,
				TST_MasterTestName);
        }/*End of TST_Index loop*/
    }/*End of TST_CRT_Mode loop*/

	TST_REPORT_END(__FUNCTION__);

	return TST_TestStatusReturn;
}/*End of CE2_ATP_TST_RSA_Acceptance_PRIME_EncDec*/

/***************************************************************
* Function Name:                                                           
*  CE2_TST_RSA_Acceptance_PRIME_SignVerify 		
*
* Inputs:
*  @param out [in] - pointer to file to output debug information;
*
* Outputs: @returns \b
*  CE2Error_t  
*  - CE2_OK - On success
*  - Otherwise - error code.
*
* \brief \b
* Description:
* 	This function Is a Acceptance test for RSA primitive Sign & Verify					
* 	This function signs and verifies known vectors using RSA primitives
*  Vector/Keys sizes used (in bits) - 512/1024/2048														
* 	This also outputs the results to an output buffer or the same input buffer
*
* \b
* Algorithm:
*  -# Build the Private Key from external exponent and modulus
*  -# Build the Public Key from External exponent and modulus
*  -# sign/verify a known vector
*  -# Compare the outputted result to the expected one					
***************************************************************/
CE2Error_t CE2_ATP_TST_RSA_Acceptance_PRIME_SignVerify(FILE *out)
{
	int			TST_index, TST_CRT_Mode;
	CE2Error_t	TST_TestStatus=0;
	DxUint16_t	TST_GetModulusSize;
	char		TST_MasterTestName[TST_FUNC_STRING_LEN] =
		"CE2_ATP_TST_RSA_Acceptance_PRIME_SignVerify";   
	int			DataInSize = 64;

	out = TST_REPORT_BEGIN(__FUNCTION__, out);
	if (out == NULL)
		return CE2_TST_FAILED;

    /* Start of test */
	/* TST_CRT_Mode = 0 no CRT // TST_CRT_Mode = 1 CRT mode*/
	for (TST_CRT_Mode = 0 ; TST_CRT_Mode < 2 ; TST_CRT_Mode++)
	{
		/*To run on all test vectors*/
		for (TST_index =0 ; TST_index < TST_NumberOf_RSA_AcceptanceTests ; TST_index++)
		{  
			/* STUBS */
			/* STUB for CRT mode */
			//if (TST_CRT_Mode != TST_NO_CRT)
			//	continue;

			/* STUB for keysize */
			/* low level function keysize bound */
			if ((TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_KeySize < (MIN_RSA_SIZE/8)) ||
				(TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_KeySize > (MAX_RSA_SIZE/8)))
				continue;

            /* STUB for keysize */
            /* not enought data for testing in CRT mode */
            if (TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_KeySize == 264 && TST_CRT_Mode == TST_CRT_MODE)
                continue;

			/* STUBS end */

			/* output buffer != input buffer    */
			/*
			fprintf(out, "********************************************************************** \n");
			fprintf(out, " %s[test 2.%d]\n",TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_Name,TST_index);  
			fprintf(out, (TST_CRT_Mode == TST_NO_CRT)?(" Non CRT mode  \n"):(" CRT mode  \n"));
			fprintf(out, "********************************************************************** \n");     
			*/

			/* Build the public Key */
			TST_ATP_Error = CE2_RSA_Build_PubKey(
				&TST_PublicKey,
				TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_PublicExponent_E,
				TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_PubExponentSize,
				TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_Modulus_N,
				TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_KeySize);
                                            
			TST_TestStatus = TST_RSA_CheckErrorReturn(
				TST_ATP_Error,"CE2_RSA_Build_PubKey",
				TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_Name,
				TST_MasterTestName);

			/* Get the E size */
			TST_ATP_Error = CE2_RSA_Get_ModSizeFromPubKey(
				&TST_PublicKey, &TST_GetModulusSize);
            
			TST_TestStatus = TST_RSA_CheckErrorReturn(
				TST_ATP_Error,"CE2_RSA_Get_ModSizeFromPubKey",
				TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_Name,
				TST_MasterTestName);

			/* Check that received E size is correct */
			TST_TestStatus =
				TST_GetModulusSize != TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_KeySize
				? CE2_TST_FAILED : CE2_TST_VALID;

			TST_TestStatus = TST_RSA_CheckErrorReturn(
				TST_ATP_Error,"Compare - TST_GetModulusSize",
				TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_Name,
				TST_MasterTestName);

			TST_TestStatus = TST_RSA_CheckErrorReturn(
				TST_ATP_Error,"CE2_RSA_Build_PubKey",
				TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_Name,
				TST_MasterTestName);

			/* Build the Private Key */
			if (TST_CRT_Mode == TST_NO_CRT)
			{
				TST_ATP_Error = CE2_RSA_Build_PrivKey(
					&TST_PrivateKey,
					TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_PrivetExponent_D,
					TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_KeySize,
					TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_PublicExponent_E,
					TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_PubExponentSize,
					TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_Modulus_N,
					TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_KeySize);

				TST_TestStatus = TST_RSA_CheckErrorReturn(
					TST_ATP_Error,"CE2_RSA_Build_PrivKey",
					TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_Name,
					TST_MasterTestName);
			}
			else
			{
				TST_ATP_Error = CE2_RSA_Build_PrivKeyCRT(
					&TST_PrivateKey,
					TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_P,
					TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_DPSize,
					TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_Q,
					TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_DPSize,
					TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_dP,
					TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_DPSize, 
					TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_dQ,
					TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_DPSize,
					TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_Qinv,
					TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_DPSize);

				TST_TestStatus = TST_RSA_CheckErrorReturn(
					TST_ATP_Error,"CE2_RSA_Build_PrivKeyCRT",
					TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_Name,
					TST_MasterTestName);
			}
            
			DataInSize =
				TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_KeySize;

			/* Verify the data using the primes */
			/* (Public Key)                     */
			TST_ATP_Error = CE2_RSA_PRIM_Verify(
				&TST_PublicKey,
				TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_input_data,
				DataInSize,
				TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_output_data);

			TST_TestStatus = TST_RSA_CheckErrorReturn(
				TST_ATP_Error,"CE2_RSA_PRIM_Verify",
				TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_Name,
				TST_MasterTestName);

			/* Compare the Encrypted data to the expected */
			/*
			As DataSize is not equat to TST_KeySize (low level datasize bound)
			therefore this part of code is invalid:
			TST_Expected_output_data is crypted from data which length was
			TST_KeySize, but not DataSize.
			*/
			/*
			TST_ATP_Error = (CE2Error_t)memcmp(
				TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_output_data ,
				TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_Expected_output_data,
				DataInSize);

			TST_TestStatus = TST_RSA_CheckErrorReturn(
				TST_ATP_Error,"memcmp - Verify",
				TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_Name,
				TST_MasterTestName);
			*/
			/* Sign the data using the primes */
			/* (Private Key)                  */
			TST_ATP_Error = CE2_RSA_PRIM_Sign(
				&TST_PrivateKey,
				TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_output_data,
				TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_KeySize,
				TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_output_data);

			TST_TestStatus = TST_RSA_CheckErrorReturn(
				TST_ATP_Error,"CE2_RSA_PRIM_Sign",
				TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_Name,
				TST_MasterTestName);

			TST_ATP_Error = (CE2Error_t)memcmp(
				TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_output_data ,
				TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_input_data,
				DataInSize);

			TST_TestStatus = TST_RSA_CheckErrorReturn(
				TST_ATP_Error,"memcmp - Sign",
				TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_Name,
				TST_MasterTestName);
		}/*End of TST_Index loop*/
	}/*End of TST_CRT_Mode loop*/

	TST_REPORT_END(__FUNCTION__);

	return TST_TestStatusReturn;
}/*End of CE2_ATP_TST_RSA_Acceptance_PRIME_SignVerify*/

/***************************************************************
* Function Name:                                                           
* 	CE2_TST_RSA_Acceptance_PKCS1v15_EncDec 		
* 
* Inputs:
*  @param TST_KeyGeneration_TestStatus [in] -
*         A parameter defining if to run the test with internal key generation 
*         - TST_INTERNAL_KG - Run the test with internal key generation and external keys 
*         - TST_EXTERNAL_KEYPAIR  - Run the test with external key only - NO keyGen
*  @param out [in] - pointer to file to output debug information;
*
* Outputs: @returns \b
*  CE2Error_t  
*  - CE2_OK - On success
*  - Otherwise - error code.
*
* \brief \b
* Description:
*  This function Is a Acceptance test for RSA PKCS1v15 encrypt and decrypt
*  According to PKCS#1 Ver1.5
*  Including RSA KeyGeneration
*  This function Encrypts and Decrypts known vectors
*  Vector/Keys sizes used (in bits) - 512/1024/2048 also CRT private														
*  This also outputs the results to an output buffer or the same input buffer
*
* \b
* Algorithm:
*  -# Prepare keys	
*     a. Generate keys 
*     or
*     a. Build the Private Key from external exponent and modulus
*     b. Build the Public Key from External exponent and modulus
*  -# Encrypt/Decrypt a known vector
*  -# Compare the outputted result to the expected one					
***************************************************************/
CE2Error_t CE2_ATP_TST_RSA_Acceptance_PKCS1v15_EncDec(int TST_KeyGeneration_TestStatus, FILE * out)
{
	int			TST_index,TST_CRT_Mode,TST_KeyGenType;
	CE2Error_t	TST_TestStatus=0;
	char		TST_MasterTestName[TST_FUNC_STRING_LEN] =
		"CE2_ATP_TST_RSA_Acceptance_PKCS1v15_EncDec";  
	DxUint16_t	TST_ActualDecDataSize; 

	out = TST_REPORT_BEGIN(__FUNCTION__, out);
	if (out == NULL)
		return CE2_TST_FAILED;

	/* Start of test */
	/* Setting if to use internal key generation */
	TST_KeyGenType = (TST_KeyGeneration_TestStatus == TST_NO_INTERNAL_KEYGEN)?
		(TST_EXTERNAL_KEYPAIR) : (TST_INTERNAL_KG);

	/*TST_KeyGenType = 0 Internal KeyGen // TST_KeyGenType = 1 External keys*/
	for ( ; TST_KeyGenType <2 ; TST_KeyGenType++)
	{   
		/* TST_CRT_Mode = 0 no CRT // TST_CRT_Mode = 1 CRT mode*/
		for (TST_CRT_Mode = 0 ; TST_CRT_Mode < 2 ; TST_CRT_Mode++)
		{   
			/*To run on all test vectors*/
			for (TST_index =0 ; TST_index < TST_NumberOf_RSA_AcceptanceTests ; TST_index++)
			{
				/* STUBS */
				//if (TST_index == 1)
				//	break;

				/* STUB for CRT mode */
				//if (TST_CRT_Mode != TST_NO_CRT)
				//	continue;

				/* STUB for keysize */
				/* use only 512 and higher length keys */
				if (TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_KeySize
					< TST_RSA_512_KEY_SIZE_IN_BYTES)
					continue;
				/* STUB another keysize */
				/* Keysize from low level function */
				if ((TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_KeySize < (MIN_RSA_SIZE/8)) ||
					(TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_KeySize > (MAX_RSA_SIZE/8)))
					continue;

                /* STUB another keysize */
				/* Keysize from low level function */
				if (TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_KeySize != 264)
					continue;

                /* STUB for keysize */
                /* not enought data for testing in CRT mode */
                if (TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_KeySize == 264 && TST_CRT_Mode == TST_CRT_MODE)
                    continue;

				/* STUBS end */

				TST_ActualDecDataSize = (DxUint16_t)
					(TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_KeySize
					- TST_LESS_DATA_FOR_PKCS1V15_ENCRYPT);

				/* Cleaning the keys to prevent test errors with KG */
				memset(&TST_PrivateKey,0,sizeof(TST_PrivateKey));
				memset(&TST_PublicKey,0,sizeof(TST_PublicKey));
                    
				/* output buffer != input buffer    */
				/*
				fprintf(out, "********************************************************************** \n");
				fprintf(out, " %s[test 3.%d]\n",TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_Name,TST_index);  
				fprintf(out, (TST_CRT_Mode == TST_NO_CRT)?(" Non CRT mode  \n"):(" CRT mode  \n"));
				fprintf(out, (TST_KeyGenType == TST_INTERNAL_KG)?(" Internal Key Generation  \n"):(" External Keys  \n"));
				fprintf(out, "********************************************************************** \n");
				*/

				if (TST_KeyGenType == TST_INTERNAL_KG)
				{
					if (TST_CRT_Mode == TST_NO_CRT)
					{
						/* Generate The Public and private keys */
						/****************************************/
						TST_ATP_Error = CE2_RSA_KG_GenerateKeyPair(
							TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_PublicExponent_E,
							TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_PubExponentSize,
							TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_KeySize*8,
							&TST_PrivateKey,
							&TST_PublicKey);
                                                                
						TST_TestStatus = TST_RSA_CheckErrorReturn(
							TST_ATP_Error,"CE2_RSA_KG_GenerateKeyPair",
							TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_Name,
							TST_MasterTestName);
                    }
                    else
                    {
                        /* Generate The Public and private CRT keys */
                        /********************************************/
                        TST_ATP_Error = CE2_RSA_KG_GenerateKeyPairCRT(
							TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_PublicExponent_E,
                            TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_PubExponentSize,
                            TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_KeySize*8,
                            &TST_PrivateKey,
                            &TST_PublicKey);
                                                                
                        TST_TestStatus = TST_RSA_CheckErrorReturn(
							TST_ATP_Error,"CE2_RSA_KG_GenerateKeyPairCRT",
                            TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_Name,
                            TST_MasterTestName);
					}
				}
				else
				{
					/* Build the public Key */
					/*----------------------*/
					TST_ATP_Error = CE2_RSA_Build_PubKey(
						&TST_PublicKey,
						TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_PublicExponent_E,
						TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_PubExponentSize,
						TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_Modulus_N,
						TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_KeySize);
                                                    
					TST_TestStatus = TST_RSA_CheckErrorReturn(
						TST_ATP_Error,"CE2_RSA_Build_PubKey",
						TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_Name,
						TST_MasterTestName);

					/* Build the Private Key */
					/*-----------------------*/ 
					if (TST_CRT_Mode == TST_NO_CRT)
					{
						TST_ATP_Error = CE2_RSA_Build_PrivKey(
							&TST_PrivateKey,
							TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_PrivetExponent_D,
							TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_KeySize,
							TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_PublicExponent_E,
							TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_PubExponentSize,                                                   
							TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_Modulus_N,
							TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_KeySize);                                  
                        
						TST_TestStatus = TST_RSA_CheckErrorReturn(
							TST_ATP_Error,"CE2_RSA_Build_PrivKey",
							TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_Name,
							TST_MasterTestName);
					}
					else
					{
						TST_ATP_Error = CE2_RSA_Build_PrivKeyCRT(
							&TST_PrivateKey,
							TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_P,
							TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_DPSize,
							TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_Q,                                                                                                 
							TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_DPSize,
							TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_dP,                                                                                                
							TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_DPSize, 
							TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_dQ,                                                                                                
							TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_DPSize,                                                                                                
							TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_Qinv,
							TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_DPSize);
                        
						TST_TestStatus = TST_RSA_CheckErrorReturn(
							TST_ATP_Error,"CE2_RSA_Build_PrivKeyCRT",
							TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_Name,
							TST_MasterTestName);
					}
				}/*End of TST_KeyGenType*/

				/* Encrypt the data using the PKCS1v15 */
				/* (Public Key)                        */
				TST_ATP_Error = CE2_RSA_PKCS1v15_Encrypt(
					&TST_PublicKey,
					TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_input_data,
					TST_ActualDecDataSize,
					TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_output_data);

                TST_TestStatus = TST_RSA_CheckErrorReturn(
					TST_ATP_Error,"CE2_RSA_PKCS1v15_Encrypt",
                    TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_Name,
                    TST_MasterTestName);

				/* Decrypt the data using the PKCS1v15 */
				/* (Private Key)                       */
				TST_ATP_Error = CE2_RSA_PKCS1v15_Decrypt(
					&TST_PrivateKey,
                    /*&TST_PrimeData,*/
                    TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_output_data,
                    TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_KeySize,
                    TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_output_data,
                    &TST_ActualDecDataSize);

				TST_TestStatus = TST_RSA_CheckErrorReturn(
					TST_ATP_Error,"CE2_RSA_PKCS1v15_Decrypt",
                    TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_Name,
                    TST_MasterTestName);

				TST_ATP_Error = (CE2Error_t)memcmp(
					TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_output_data ,
					TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_input_data,
					TST_ActualDecDataSize);

				TST_TestStatus = TST_RSA_CheckErrorReturn(
					TST_ATP_Error,"memcmp - Decrypt",
					TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_Name,
					TST_MasterTestName);
			}/*End of TST_Index loop*/
		}/*End of TST_CRT_Mode loop*/
	}/*End of TST_KeyGenType loop*/

	TST_REPORT_END(__FUNCTION__);

	return TST_TestStatusReturn;
}/*End of CE2_ATP_TST_RSA_Acceptance_PKCS1v15_EncDec*/

/***************************************************************
* Function Name:                                                           
* 	CE2_TST_RSA_Acceptance_PKCS1v15_Integrated_SignVerify 		
* 
* Inputs:
*  @param TST_KeyGeneration_TestStatus [in] -
*         A parameter defining if to run the test with internal key generation 
*         - TST_INTERNAL_KG - Run the test with internal key generation and external keys 
*         - TST_EXTERNAL_KEYPAIR  - Run the test with external key only - NO keyGen
*  @param out [in] - pointer to file to output debug information;
*
* Outputs: @returns \b
*  CE2Error_t  
*  - CE2_OK - On success
*  - Otherwise - error code.
*
* \brief \b
* Description:
*  This function Is a Acceptance test for RSA PKCS1v15 Sign & Verify					
*  This function Signs & Verify known vectors using RSA PKCS1v15
*  Vectors sizes used (in byte) - 16/32/512														
*  Key sizes used     (in bits) - 512/1024/2048
*  This also outputs the results to an output buffer or the same input buffer
*
* \b
* Algorithm:
*  -# Prepare keys	
*     a. Generate keys 
*     or
*     a. Build the Private Key from external exponent and modulus
*     b. Build the Public Key from External exponent and modulus
*  -# Call the CE2_RSA_PKCS1v15_Sign to preform the Sign operation
*  -# Call the CE2_RSA_PKCS1v15_Verify to complete the verification operation
*  -# Compare the outputted result to the expected one					
***************************************************************/
CE2Error_t CE2_ATP_TST_RSA_Acceptance_PKCS1v15_Integrated_SignVerify(int TST_KeyGeneration_TestStatus, FILE * out)
{
	int			TST_index,TST_CRT_Mode;
	CE2Error_t	TST_TestStatus=0;
	int			TST_KeyGenType;
	char		TST_MasterTestName[TST_FUNC_STRING_LEN] =
		"CE2_ATP_TST_RSA_Acceptance_PKCS1v15_Integrated_SignVerify"; 
	int 		TST_HashType;
	CE2_RSA_HASH_OpMode_t TST_RSAHashType = CE2_RSA_HASH_NumOfModes;

	out = TST_REPORT_BEGIN(__FUNCTION__, out);
	if (out == NULL)
		return CE2_TST_FAILED;

    /* Start of test */
    /* Setting if to use internal key generation */
    TST_KeyGenType = 
		(TST_KeyGeneration_TestStatus == TST_NO_INTERNAL_KEYGEN)? 
		(TST_EXTERNAL_KEYPAIR) : (TST_INTERNAL_KG);

	/*TST_KeyGenType = 0 Internal KeyGen // TST_KeyGenType = 1 External keys*/
	for ( ; TST_KeyGenType <2 ; TST_KeyGenType++)
	{   
		for (TST_HashType = 0 ; TST_HashType < CE2_HASH_NumOfModes ; TST_HashType++)
		{   
			switch(TST_HashType)
			{
				case CE2_HASH_SHA1_mode:
					TST_RSAHashType = CE2_RSA_HASH_SHA1_mode;
					break;
				case CE2_HASH_SHA224_mode:
					TST_RSAHashType = CE2_RSA_HASH_SHA224_mode;
					break;
				case CE2_HASH_SHA256_mode:
					TST_RSAHashType = CE2_RSA_HASH_SHA256_mode;
					break;
				case CE2_HASH_SHA384_mode:
					TST_RSAHashType = CE2_RSA_HASH_SHA384_mode;
					break;
				case CE2_HASH_SHA512_mode:
					TST_RSAHashType = CE2_RSA_HASH_SHA512_mode;
					break;
				default:
					break;
			}

			/* TST_CRT_Mode = 0 no CRT // TST_CRT_Mode = 1 CRT mode*/
			for (TST_CRT_Mode = 0 ; TST_CRT_Mode < 2 ; TST_CRT_Mode++)
			{   
				/*To run on all test vectors*/
				for (TST_index =0 ; TST_index < TST_NumberOf_RSA_AcceptanceSignVerifyTests ; TST_index++)
				{
					/* STUBS */
					//if (TST_CRT_Mode == TST_CRT_MODE)
					//	continue;

                    /* SHA384 & SHA512 are not used with RSA 512bit keys*/
                    if ((TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_KeySize == TST_RSA_512_KEY_SIZE_IN_BYTES)&&
                        ((TST_RSAHashType == CE2_RSA_HASH_SHA384_mode)||(TST_RSAHashType == CE2_RSA_HASH_SHA512_mode)))
						continue;

					/* low level function keysize bound */
					if ((TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_KeySize < (MIN_RSA_SIZE/8)) ||
						(TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_KeySize > (MAX_RSA_SIZE/8)))
						continue;

                    /* STUB for keysize */
                    /* not enought data for testing in CRT mode */
                    if (TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_KeySize == 264 && TST_CRT_Mode == TST_CRT_MODE)
                        continue;

					//if (TST_KeyGenType != TST_INTERNAL_KG)
					//	continue;

					//if (TST_index != 6)
					//	continue;

					/* STUBS end */

					/*Cleaning the keys to prevent test errors with KG*/ 
					memset(&TST_PrivateKey,0,sizeof(TST_PrivateKey));
					memset(&TST_PublicKey,0,sizeof(TST_PublicKey));

					/* output buffer != input buffer    */
					/*
					fprintf(out, "********************************************************************** \n");
					fprintf(out, " %s[test 5.%d]\n",TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_Name,TST_index); 
					fprintf(out, "OperationMode_t = %d\n",TST_HashType);
                    
					fprintf(out, (TST_CRT_Mode == TST_NO_CRT)?(" Non CRT mode  \n"):(" CRT mode  \n"));
					fprintf(out, (TST_KeyGenType == TST_INTERNAL_KG)?(" Internal Key Generation  \n"):(" External Keys  \n"));
					fprintf(out, "********************************************************************** \n");
					*/
            
					if (TST_KeyGenType == TST_INTERNAL_KG)
					{
						if (TST_CRT_Mode == TST_NO_CRT)
						{
							/* Generate The Public and private keys */
                            TST_ATP_Error = CE2_RSA_KG_GenerateKeyPair(
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_PublicExponent_E,
                                TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_PubExponentSize,
                                TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_KeySize*8,
                                &TST_PrivateKey,
                                &TST_PublicKey);

                            TST_TestStatus = TST_RSA_CheckErrorReturn(
								TST_ATP_Error,"CE2_RSA_KG_GenerateKeyPair",
                                TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_Name,
                                TST_MasterTestName);
						}
						else
						{
							/* Generate The Public and private CRT keys */
							TST_ATP_Error = CE2_RSA_KG_GenerateKeyPairCRT(
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_PublicExponent_E,
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_PubExponentSize,
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_KeySize*8,
								&TST_PrivateKey,
								&TST_PublicKey);

							TST_TestStatus = TST_RSA_CheckErrorReturn(
								TST_ATP_Error,"CE2_RSA_KG_GenerateKeyPairCRT",
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_Name,
								TST_MasterTestName);
						}
					}
					else
					{                    
						/* Build the public Key */
						TST_ATP_Error = CE2_RSA_Build_PubKey(
							&TST_PublicKey,
							TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_PublicExponent_E,
							TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_PubExponentSize,
							TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_Modulus_N,
							TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_KeySize);

						TST_TestStatus = TST_RSA_CheckErrorReturn(
							TST_ATP_Error,"CE2_RSA_Build_PubKey",
							TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_Name,
							TST_MasterTestName);

						/* Build the Private Key */
						if (TST_CRT_Mode == TST_NO_CRT)
						{
							TST_ATP_Error = CE2_RSA_Build_PrivKey(
								&TST_PrivateKey,
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_PrivetExponent_D,
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_KeySize,
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_PublicExponent_E,
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_PubExponentSize,
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_Modulus_N,
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_KeySize);
	                        
							TST_TestStatus = TST_RSA_CheckErrorReturn(
								TST_ATP_Error,"CE2_RSA_Build_PrivKey",
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_Name,
								TST_MasterTestName);
						}
						else
						{
							TST_ATP_Error = CE2_RSA_Build_PrivKeyCRT(
								&TST_PrivateKey,
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_P,
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_DPSize,
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_Q,                                                                                                
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_DPSize,
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_dP,                                                                                                   
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_DPSize,    
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_dQ,                                                                                                   
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_DPSize,                                                                                                   
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_Qinv,
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_DPSize);
	                                                                                       
							TST_TestStatus = TST_RSA_CheckErrorReturn(
								TST_ATP_Error,"CE2_RSA_Build_PrivKeyCRT",
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_Name,
								TST_MasterTestName);
						}
					}/*End of TST_KeyGenType*/
	                
					/* Debug massages */
					//fprintf(out, "Input Data Size [byte] = %1d \n" ,TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_input_dataSize);

					/*Preform the Sign operation */
					TST_ATP_Error = CE2_RSA_PKCS1v15_Sign(
						&TST_PrivateKey,
						TST_RSAHashType,
						TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_input_data,
						TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_input_dataSize,
						TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_output_signiture,
						&TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_KeySize);

					TST_TestStatus = TST_RSA_CheckErrorReturn(
						TST_ATP_Error,"CE2_RSA_PKCS1v15_Sign",
						TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_Name,
						TST_MasterTestName);

					/*Preform the Verify operation */
					TST_ATP_Error = CE2_RSA_PKCS1v15_Verify(
						&TST_PublicKey,
						 TST_RSAHashType,
						 TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_input_data,
						 TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_input_dataSize,
						 TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_output_signiture);

					TST_TestStatus = TST_RSA_CheckErrorReturn(
						TST_ATP_Error,"CE2_RSA_PKCS1v15_Verify - Using SHA1",
						TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_Name,
						TST_MasterTestName);
                }/*End of TST_Index loop*/
            }/*End of TST_CRT_Mode loop*/
         }/* End of TST_HashType loop*/
        }/* End of TST_KeyGenType loop*/

	TST_REPORT_END(__FUNCTION__);

	return TST_TestStatusReturn;
}/*End of CE2_ATP_TST_RSA_Acceptance_PKCS1v15_Integrated_SignVerify*/

/***************************************************************
* Function Name:                                                           
* 	CE2_TST_RSA_Acceptance_OAEP_EncDec 		
* 
* Inputs:
*  @param TST_KeyGeneration_TestStatus [in] -
*         A parameter defining if to run the test with internal key generation 
*         - TST_INTERNAL_KG - Run the test with internal key generation and external keys 
*         - TST_EXTERNAL_KEYPAIR  - Run the test with external key only - NO keyGen
*  @param out [in] - pointer to file to output debug information;
*
* Outputs: @returns \b
*  CE2Error_t  
*  - CE2_OK - On success
*  - Otherwise - error code.
*
* \brief \b
* Description:
*  This function Is a Acceptance test for RSA OAEP encrypt and decrypt
*  According to PKCS#1 Ver2.1
*  This function Encrypts and Decrypts known vectors
*  Vector/Keys sizes used (in bits) - 512/1024/2048														
*  This also outputs the results to an output buffer or the same input buffer
*
* \b
* Algorithm:
*  -# Prepare keys	
*     a. Generate keys 
*     or
*     a. Build the Private Key from external exponent and modulus
*     b. Build the Public Key from External exponent and modulus 		
*  -# Encrypt/Decrypt a known vector
*  -# Compare the outputted result to the expected one					
***************************************************************/
CE2Error_t CE2_ATP_TST_RSA_Acceptance_OAEP_EncDec(int TST_KeyGeneration_TestStatus, FILE * out)
{
	int			TST_index,TST_CRT_Mode;
	CE2Error_t	TST_TestStatus=0;
	int			TST_KeyGenType;
	char		TST_MasterTestName[TST_FUNC_STRING_LEN] =
		"CE2_ATP_TST_RSA_Acceptance_OAEP_EncDec";  
	DxUint16_t	TST_ActualDecDataSize;
	DxUint16_t	TST_LessDataForOAEP=0;

	int			TST_HashType;
	CE2_RSA_HASH_OpMode_t TST_RSAHashType=CE2_RSA_HASH_NumOfModes;

	out = TST_REPORT_BEGIN(__FUNCTION__, out);
	if (out == NULL)
		return CE2_TST_FAILED;

    /* Start of test */
    /* Setting if to use internal key generation */
    TST_KeyGenType = (TST_KeyGeneration_TestStatus == TST_NO_INTERNAL_KEYGEN)?
		(TST_EXTERNAL_KEYPAIR) : (TST_INTERNAL_KG);

	/*TST_KeyGenType = 0 Internal KeyGen // TST_KeyGenType = 1 External keys*/
	for ( ; TST_KeyGenType <2 ; TST_KeyGenType++)
	{      
		for (TST_HashType = 0 ; TST_HashType < CE2_HASH_NumOfModes ; TST_HashType++) 
		{
			switch(TST_HashType)
			{
				case CE2_HASH_SHA1_mode:
					TST_RSAHashType = CE2_RSA_HASH_SHA1_mode;
					TST_LessDataForOAEP = (DxUint16_t)TST_LESS_DATA_FOR_OAEP_ENCRYPT_SHA1;
					break;
				case CE2_HASH_SHA224_mode:
					TST_RSAHashType = CE2_RSA_HASH_SHA224_mode;
					TST_LessDataForOAEP = (DxUint16_t)TST_LESS_DATA_FOR_OAEP_ENCRYPT_SHA224;
					break;
				case CE2_HASH_SHA256_mode:
					TST_RSAHashType = CE2_RSA_HASH_SHA256_mode;
					TST_LessDataForOAEP = (DxUint16_t)TST_LESS_DATA_FOR_OAEP_ENCRYPT_SHA256;
					break;
				case CE2_HASH_SHA384_mode:
					TST_RSAHashType = CE2_RSA_HASH_SHA384_mode;
					TST_LessDataForOAEP = (DxUint16_t)TST_LESS_DATA_FOR_OAEP_ENCRYPT_SHA384;
					break;
				case CE2_HASH_SHA512_mode:
					TST_RSAHashType = CE2_RSA_HASH_SHA512_mode;
					TST_LessDataForOAEP = (DxUint16_t)TST_LESS_DATA_FOR_OAEP_ENCRYPT_SHA512;
					break;
				default:
					break;
			}

			/* MD5 is not a part of the OAEP scheme*/
			if (TST_HashType == CE2_HASH_MD5_mode)
				continue;

			/* TST_CRT_Mode = 0 no CRT // TST_CRT_Mode = 1 CRT mode*/
			for (TST_CRT_Mode = 0 ; TST_CRT_Mode < 2 ; TST_CRT_Mode++)
			{   
				/*To run on all test vectors*/
				for (TST_index =0 ; TST_index < TST_NumberOf_RSA_AcceptanceTests ; TST_index++)
				{
					/* STUBS */
					//if (TST_CRT_Mode == TST_CRT_MODE)
					//	continue;

					/* SHA256 & SHA384 & SHA512 are not used with RSA 512bit keys in OAEP*/
					if ((TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_KeySize == TST_RSA_512_KEY_SIZE_IN_BYTES)&&
						((TST_RSAHashType == CE2_RSA_HASH_SHA256_mode)||(TST_RSAHashType == CE2_RSA_HASH_SHA384_mode)||(TST_RSAHashType == CE2_RSA_HASH_SHA512_mode)))
						continue;

					/* low level function keysize bound */
					if ((TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_KeySize < (MIN_RSA_SIZE/8)) ||
						(TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_KeySize > (MAX_RSA_SIZE/8)))
						continue;

                    /* STUB for keysize */
                    /* not enought data for testing in CRT mode */
                    if (TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_KeySize == 264 && TST_CRT_Mode == TST_CRT_MODE)
                        continue;

					//if (TST_KeyGenType != TST_INTERNAL_KG)
					//	continue;

					//if (TST_index > 4)
					//	break;

                    /* STUBS end */

					TST_ActualDecDataSize = (DxUint16_t)
						(TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_KeySize*8);

					/* Cleaning the keys to prevent test errors with KG */
					memset(&TST_PrivateKey,0,sizeof(TST_PrivateKey));
					memset(&TST_PublicKey,0,sizeof(TST_PublicKey));

					/* output buffer != input buffer    */
					/*
					fprintf(out, "********************************************************************** \n");
					fprintf(out, " %s[test 7.%d]\n",TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_Name,TST_index);
					fprintf(out, (TST_CRT_Mode == TST_NO_CRT)?(" Non CRT mode  \n"):(" CRT mode  \n"));
					fprintf(out, (TST_KeyGenType == TST_INTERNAL_KG)?(" Internal Key Generation  \n"):(" External Keys  \n")); 
					fprintf(out, "OperationMode_t = %d\n", TST_HashType);
					fprintf(out, "********************************************************************** \n");
					*/
	                
					if (TST_KeyGenType == TST_INTERNAL_KG)
					{
						if (TST_CRT_Mode == TST_NO_CRT)
						{
							/* Generate The Public and private keys */
							TST_ATP_Error = CE2_RSA_KG_GenerateKeyPair(
								TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_PublicExponent_E,
								TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_PubExponentSize,
								TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_KeySize*8,
								&TST_PrivateKey,
								&TST_PublicKey);

								TST_TestStatus = TST_RSA_CheckErrorReturn(
									TST_ATP_Error,"CE2_RSA_KG_GenerateKeyPair",
									TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_Name,
									TST_MasterTestName);
							}
							else
							{
								/* Generate The Public and private CRT keys */
								TST_ATP_Error = CE2_RSA_KG_GenerateKeyPairCRT(
									TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_PublicExponent_E,
									TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_PubExponentSize,
									TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_KeySize*8,
									&TST_PrivateKey,
									&TST_PublicKey);
	                                                                    
								TST_TestStatus = TST_RSA_CheckErrorReturn(
									TST_ATP_Error,"CE2_RSA_KG_GenerateKeyPairCRT",
									TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_Name,
									TST_MasterTestName);
							}
					}
					else
					{
						/* Build the public Key */
						/*----------------------*/
						TST_ATP_Error = CE2_RSA_Build_PubKey(
							&TST_PublicKey,
							TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_PublicExponent_E,
							TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_PubExponentSize,
							TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_Modulus_N,
							TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_KeySize);
	                                                    
						TST_TestStatus = TST_RSA_CheckErrorReturn(
							TST_ATP_Error,"CE2_RSA_Build_PubKey",
							TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_Name,
							TST_MasterTestName);

						/* Build the Private Key */
						if (TST_CRT_Mode == TST_NO_CRT)
						{
							TST_ATP_Error = CE2_RSA_Build_PrivKey(
								&TST_PrivateKey,
								TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_PrivetExponent_D,
								TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_KeySize,
								TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_PublicExponent_E,
								TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_PubExponentSize,
								TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_Modulus_N,
								TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_KeySize);
	                        
							TST_TestStatus = TST_RSA_CheckErrorReturn(
								TST_ATP_Error,"CE2_RSA_Build_PrivKey",
								TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_Name,
								TST_MasterTestName);
						}
						else
						{
							TST_ATP_Error = CE2_RSA_Build_PrivKeyCRT(
								&TST_PrivateKey,
								TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_P,
								TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_DPSize,
								TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_Q,                                                                                                 
								TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_DPSize,
								TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_dP,                                                                                                
								TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_DPSize, 
								TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_dQ,                                                                                                
								TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_DPSize,                                                                                                
								TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_Qinv,
								TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_DPSize);

							TST_TestStatus = TST_RSA_CheckErrorReturn(
								TST_ATP_Error,"CE2_RSA_Build_PrivKeyCRT",
								TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_Name,
								TST_MasterTestName);
						}
					}/* End of TST_KeyGenType*/
	                
					/* Encrypt the data using the OAEP */
					/* (Public Key)                    */
					/*---------------------------------*/   
					TST_ATP_Error = CE2_RSA_OAEP_Encrypt(
						&TST_PublicKey,
						TST_RSAHashType,
						DX_NULL,
						TST_ZERO_DATA,
						CE2_PKCS1_MGF1,
						TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_input_data,
						(DxUint16_t)(TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_KeySize-TST_LessDataForOAEP),
						TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_output_data);

					TST_TestStatus = TST_RSA_CheckErrorReturn(
						TST_ATP_Error,"CE2_RSA_OAEP_Encrypt",
						TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_Name,
						TST_MasterTestName);

					/* Decrypt the data using the OAEP */
					/* (Private Key)                   */
					TST_ATP_Error = CE2_RSA_OAEP_Decrypt(
						&TST_PrivateKey,
						TST_RSAHashType,               
						DX_NULL,
						TST_ZERO_DATA,
						CE2_PKCS1_MGF1,                                            
						TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_output_data,
						TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_KeySize,
						TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_output_data,
						&TST_ActualDecDataSize);

					TST_TestStatus = TST_RSA_CheckErrorReturn(
						TST_ATP_Error,"CE2_RSA_OAEP_Decrypt",
						TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_Name,
						TST_MasterTestName);

					TST_ATP_Error = (CE2Error_t)memcmp(
						TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_output_data ,
						TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_input_data,
						TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_KeySize-TST_LessDataForOAEP);   

					TST_TestStatus = TST_RSA_CheckErrorReturn(
						TST_ATP_Error,"memcmp - Decrypt",
						TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_Name,
						TST_MasterTestName);
				}/*End of TST_Index loop*/
			}/*End of TST_CRT_Mode loop*/
		}/*End of Hash Type loop*/
	 }/*End of TST_KeyGenType loop*/    

	TST_REPORT_END(__FUNCTION__);

	return TST_TestStatusReturn;
}/*End of CE2_ATP_TST_RSA_Acceptance_OAEP_EncDec*/

/***************************************************************
* Function Name:                                                           
* 	CE2_TST_RSA_Acceptance_PSS_Integrated_SignVerify 		
* 
* Inputs:
*  @param TST_KeyGeneration_TestStatus [in] -
*         A parameter defining if to run the test with internal key generation 
*         - TST_INTERNAL_KG - Run the test with internal key generation and external keys 
*         - TST_EXTERNAL_KEYPAIR  - Run the test with external key only - NO keyGen
*  @param out [in] - pointer to file to output debug information;
*
* Outputs: @returns \b
*  CE2Error_t  
*  - CE2_OK - On success
*  - Otherwise - error code.
*
* \brief \b
* Description:
*  This function Is a Acceptance test for RSA PSS PKCS#1v2.1 sign & Verify 					
*  This function  signs & Verify known vectors using RSA PSS PKCS#1v2.1
*  Vectors sizes used (in byte) - 16/32/512														
*  Key sizes used     (in bits) - 512/1024/2048
*  This also outputs the results to an output buffer or the same input buffer
*
* \b
* Algorithm:
*  -# Prepare keys	
*     a. Generate keys 
*     or
*     a. Build the Private Key from external exponent and modulus
*     b. Build the Public Key from External exponent and modulus 	
*  -# Call the CE2_RSA_PSS_Sign to preform the Sign operation
*  -# Call the RSA_PSS_Verify to preform the verification operation					
***************************************************************/
CE2Error_t CE2_ATP_TST_RSA_Acceptance_PSS_Integrated_SignVerify (int TST_KeyGeneration_TestStatus, FILE * out)
{
	int			TST_index,TST_CRT_Mode;
	CE2Error_t	TST_TestStatus=0;
	int			TST_KeyGenType;
	char		TST_MasterTestName[TST_FUNC_STRING_LEN] =
		"CE2_ATP_TST_RSA_Acceptance_PSS_Integrated_SignVerify";  
	int			TST_HashType;
	CE2_RSA_HASH_OpMode_t	TST_RSAHashType = CE2_RSA_HASH_NumOfModes;

	out = TST_REPORT_BEGIN(__FUNCTION__, out);
	if (out == NULL)
		return CE2_TST_FAILED;

	/* Start of test */
	/* Setting if to use internal key generation */
	TST_KeyGenType = (TST_KeyGeneration_TestStatus == TST_NO_INTERNAL_KEYGEN)?
		(TST_EXTERNAL_KEYPAIR) : (TST_INTERNAL_KG);

	/*TST_KeyGenType = 0 Internal KeyGen // TST_KeyGenType = 1 External keys*/
	for ( ; TST_KeyGenType <2 ; TST_KeyGenType++)
	{ 
		for (TST_HashType = 0 ; TST_HashType < CE2_HASH_NumOfModes ; TST_HashType++) 
		{
			switch(TST_HashType)
			{
				case CE2_HASH_SHA1_mode:
					TST_RSAHashType = CE2_RSA_HASH_SHA1_mode;
					break;
				case CE2_HASH_SHA224_mode:
					TST_RSAHashType = CE2_RSA_HASH_SHA224_mode;
					break;
				case CE2_HASH_SHA256_mode:
					TST_RSAHashType = CE2_RSA_HASH_SHA256_mode;
					break;
				case CE2_HASH_SHA384_mode:
					TST_RSAHashType = CE2_RSA_HASH_SHA384_mode;
					break;
				case CE2_HASH_SHA512_mode:
					TST_RSAHashType = CE2_RSA_HASH_SHA512_mode;
					break;
				default:
					break;
			}

			/* MD5 is not a part of the OAEP scheme*/
			if (TST_HashType == CE2_HASH_MD5_mode)
				continue;

			/* TST_CRT_Mode = 0 no CRT // TST_CRT_Mode = 1 CRT mode*/
			for (TST_CRT_Mode = 0 ; TST_CRT_Mode < 2 ; TST_CRT_Mode++)
			{   
				/*To run on all test vectors*/
				for (TST_index =0 ; TST_index < TST_NumberOf_RSA_AcceptanceSignVerifyTests ; TST_index++)
				{
					/* STUBS */
					//if (TST_CRT_Mode == TST_CRT_MODE)
					//	continue;

					/* SHA384 & SHA512 are not used with RSA 512bit keys*/
					if ((TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_KeySize == TST_RSA_512_KEY_SIZE_IN_BYTES)&&
						((TST_HashType == CE2_HASH_SHA384_mode)||(TST_HashType == CE2_HASH_SHA512_mode)))
						continue;

					/* low level function keysize bound */
					if ((TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_KeySize < (MIN_RSA_SIZE/8)) ||
						(TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_KeySize > (MAX_RSA_SIZE/8)))
						continue;

                    /* STUB for keysize */
                    /* not enought data for testing in CRT mode */
                    if (TST_RSA_Acceptance_Primitive_TestData[TST_index].TST_KeySize == 264 && TST_CRT_Mode == TST_CRT_MODE)
                        continue;

					//if (TST_KeyGenType != TST_INTERNAL_KG)
					//	continue;

					//if (TST_index > 4)
					//	break;
                    
					/* STUBS end */

					/*Cleaning the keys to prevent test errors with KG*/ 
					memset(&TST_PrivateKey,0,sizeof(TST_PrivateKey));
					memset(&TST_PublicKey,0,sizeof(TST_PublicKey));

					/* output buffer != input buffer    */
					/*
					fprintf(out, "********************************************************************** \n");
					fprintf(out, " %s[test 9.%d]\n",TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_Name,TST_index); 
					fprintf(out, (TST_CRT_Mode == TST_NO_CRT)?(" Non CRT mode  \n"):(" CRT mode  \n"));
					fprintf(out, (TST_KeyGenType == TST_INTERNAL_KG)?(" Internal Key Generation  \n"):(" External Keys  \n"));
					fprintf(out, "OperationMode_t = %d\n", TST_HashType);
					fprintf(out, "********************************************************************** \n");
					*/

					if (TST_KeyGenType == TST_INTERNAL_KG)
					{
						if (TST_CRT_Mode == TST_NO_CRT)
						{
							/* Generate The Public and private keys */
							TST_ATP_Error = CE2_RSA_KG_GenerateKeyPair(
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_PublicExponent_E,
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_PubExponentSize,
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_KeySize*8,
								&TST_PrivateKey,
								&TST_PublicKey);

								TST_TestStatus = TST_RSA_CheckErrorReturn(
									TST_ATP_Error,"CE2_RSA_KG_GenerateKeyPair",
									TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_Name,
									TST_MasterTestName);
						}
						else
						{
							/* Generate The Public and private CRT keys */
							TST_ATP_Error = CE2_RSA_KG_GenerateKeyPairCRT(
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_PublicExponent_E,
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_PubExponentSize,
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_KeySize*8,
								&TST_PrivateKey,
								&TST_PublicKey);

							TST_TestStatus = TST_RSA_CheckErrorReturn(
								TST_ATP_Error,"CE2_RSA_KG_GenerateKeyPairCRT",
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_Name,
								TST_MasterTestName);
						}
					}
					else
					{               
						/* Build the public Key */
						TST_ATP_Error = CE2_RSA_Build_PubKey(
							&TST_PublicKey,
							TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_PublicExponent_E,
							TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_PubExponentSize,
							TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_Modulus_N,
							TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_KeySize);

						TST_TestStatus = TST_RSA_CheckErrorReturn(
							TST_ATP_Error,"CE2_RSA_Build_PubKey",
							TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_Name,
							TST_MasterTestName);

						/* Build the Private Key */
						if (TST_CRT_Mode == TST_NO_CRT)
						{
							TST_ATP_Error = CE2_RSA_Build_PrivKey(
								&TST_PrivateKey,
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_PrivetExponent_D,
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_KeySize,
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_PublicExponent_E,
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_PubExponentSize,                                                  
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_Modulus_N,
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_KeySize);

							TST_TestStatus = TST_RSA_CheckErrorReturn(
								TST_ATP_Error,"CE2_RSA_Build_PrivKey",
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_Name,
								TST_MasterTestName);
						}
						else
						{
							TST_ATP_Error = CE2_RSA_Build_PrivKeyCRT(
								&TST_PrivateKey,
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_P,
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_DPSize,
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_Q,
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_DPSize,
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_dP,
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_DPSize,
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_dQ,
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_DPSize,
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_Qinv,
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_DPSize);
                                                                                           
							TST_TestStatus = TST_RSA_CheckErrorReturn(
								TST_ATP_Error,"CE2_RSA_Build_PrivKeyCRT",
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_Name,
								TST_MasterTestName);
						}
					}/*End of TST_KeyGenType*/

					/*Preform the Sign operation */
					TST_ATP_Error = CE2_RSA_PSS_Sign(
						&TST_PrivateKey,
						TST_RSAHashType,
						CE2_PKCS1_MGF1,
						TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_SaltLength,
						TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_input_data,
						TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_input_dataSize,
						TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_output_signiture,
						&TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_KeySize);
                  
					TST_TestStatus = TST_RSA_CheckErrorReturn(
						TST_ATP_Error,"CE2_RSA_PSS_Sign",
						TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_Name,
						TST_MasterTestName);

					/*Preform the Verify operation */
					TST_ATP_Error = CE2_RSA_PSS_Verify(
						&TST_PublicKey,
						TST_RSAHashType,
						CE2_PKCS1_MGF1,
						TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_SaltLength,
						TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_input_data,
						TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_input_dataSize,
						TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_output_signiture);

					TST_TestStatus = TST_RSA_CheckErrorReturn(
						TST_ATP_Error,"CE2_RSA_PSS_Verify",
						TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_Name,
						TST_MasterTestName);
				}/*End of TST_Index loop*/
			}/*End of TST_CRT_Mode loop*/
		}/*End of HASH type loop*/
	 }/*End of TST_KeyGenType Loop*/

	TST_REPORT_END(__FUNCTION__);

	return TST_TestStatusReturn;
}/*End of CE2_ATP_TST_RSA_Acceptance_PSS_NonIntegrate_SignVerify*/

/***************************************************************
* Function Name:                                                           
* 	CE2_TST_RSA_Build_Get_PubKey 		
* 
* Inputs:
*  @param out [in] - pointer to file to output debug information;
*
* Outputs: @returns \b
*  CE2Error_t  
*  - CE2_OK - On success
*  - Otherwise - error code.
*
* \brief \b
* Description:
*  This function tests generation and export and import functions
*  under public key
*  Vectors sizes used (in byte) - 16/32/512
*  Key sizes used     (in bits) - 512/1024/2048
*  This also outputs the results to an output buffer or the same input buffer
*
* \b
* Algorithm:
*  -# Prepare keys	
*     a. Generate key
*     or
*     a. Build the Public Key from External exponent and modulus 	
*  -# Call the CE2_RSA_Get_PubKey to preform the Get operation
*  -# Call the CE2_RSA_Build_PubKey to preform the build operation
*  -# Compare the outputted result to the expected one
***************************************************************/
CE2Error_t CE2_TST_RSA_Build_Get_PubKey(FILE *out)
{
	DxUint8_t              PrivExponent_ptr[] =
        {0xa8,0xd6,0xfa,0x2b,0x47,0xde,0x8c,0x36,0x04,0x2a,0x32,0x55,0x7c,0xf5,0xde,0x2e,
         0xe3,0xc1,0x62,0x72,0x83,0x55,0x27,0x76,0x9f,0x6b,0xe0,0xfa,0x9a,0x26,0x03,0x9b,
         0x41,0x1f,0xd6,0xbc,0x3d,0x77,0xd0,0x5f,0xb0,0x71,0x00,0xf6,0x27,0xa7,0x55,0xf8,
         0xb4,0xc7,0x5a,0x31,0xeb,0xce,0x51,0x19,0x94,0x21,0xa6,0xac,0xb8,0xf5,0xbb,0x01};
	DxUint16_t             PrivExponentSize =
		sizeof(PrivExponent_ptr)*sizeof(DxUint8_t);
	DxUint8_t              PubExponent_ptr[] =
		{0x01,0x00,0x01};
	DxUint16_t             PubExponentSize = 
		sizeof(PubExponent_ptr)*sizeof(DxUint8_t);
	DxUint8_t              Modulus_ptr[] =
        {0xbb,0x3d,0xf1,0x3f,0x1d,0xcf,0xc6,0xfa,0x13,0x56,0xb3,0x95,0x53,0xcf,0xbd,0x10,
         0xf4,0x75,0xfe,0x7d,0xf6,0x89,0xa1,0x06,0x94,0x67,0xd4,0x5c,0xb7,0x89,0xbe,0xed,
         0xe2,0x49,0x51,0x6b,0xf0,0xd2,0x7c,0xef,0x67,0xbb,0xf6,0x9a,0x8b,0x67,0x51,0xe8,
         0xc0,0xbf,0x52,0xbc,0x2f,0x10,0xc1,0x85,0x77,0x18,0x60,0x52,0x67,0x94,0xd7,0x57};
	DxUint16_t             ModulusSize =
		sizeof(Modulus_ptr)*sizeof(DxUint8_t);
	CE2_RSAUserPubKey_t UserPubKey_ptr;

	DxUint8_t              PubExponentOut_ptr[64] = { 0 };
	DxUint16_t             PubExponentSizeOut = 0;
	DxUint8_t              ModulusOut_ptr[2048] = { 0 };
	DxUint16_t             ModulusSizeOut = sizeof(ModulusOut_ptr)*sizeof(DxUint8_t);
	CE2_RSAUserPubKey_t	   UserPubKeyOut_ptr = { 0 };

	out = TST_REPORT_BEGIN(__FUNCTION__, out);
	if (out == NULL)
		return CE2_TST_FAILED;

	/* Build public key */
	TST_ATP_Error = CE2_RSA_Build_PubKey(
		&UserPubKey_ptr,
		PubExponent_ptr, PubExponentSize,
		Modulus_ptr, ModulusSize);

	TST_TestStatus = TST_RSA_CheckErrorReturn(
		TST_ATP_Error,"CE2_RSA_Build_PubKey",
		"CE2_RSA_Build_PubKey", "CE2_TST_RSA_Build_PubKey");

	PubExponentSizeOut = PubExponentSize;
	ModulusSizeOut = ModulusSize;

	/* Get public key from builded */
	TST_ATP_Error = CE2_RSA_Get_PubKey(
		&UserPubKey_ptr,
		(DxUint8_t*)&PubExponentOut_ptr, &PubExponentSizeOut,
		(DxUint8_t*)&ModulusOut_ptr, &ModulusSizeOut);

	/* Check returned sizes of pub exponent */
	TST_ATP_Error = (PubExponentSizeOut == PubExponentSize) ? (CE2_TST_VALID) : (CE2_TST_FAILED);
	TST_RSA_CheckErrorReturn(
		TST_ATP_Error,"CE2_RSA_Get_PubKey",
		"PubExponentSizeOut", "PubExponentSize");

	/* Check returned sizes of modulus */
	TST_ATP_Error = (ModulusSizeOut == ModulusSize) ? (CE2_TST_VALID) : (CE2_TST_FAILED);
	TST_RSA_CheckErrorReturn(
		TST_ATP_Error,"CE2_RSA_Compare_CRT_Pub_Key",
		"ModulusSizeOut", "ModulusSize");

	/* Check returned pub exponent and expected */
	TST_ATP_Error = 
		memcmp(PubExponent_ptr, PubExponentOut_ptr, sizeof(PubExponent_ptr));
	TST_RSA_CheckErrorReturn(
		TST_ATP_Error,"CE2_RSA_Compare_CRT_Pub_Key",
		"PubExponent_ptr", "PubExponentOut_ptr");

	/* Check returned modulus exponent and expected */
	TST_ATP_Error = 
		memcmp(Modulus_ptr, ModulusOut_ptr, sizeof(Modulus_ptr));
	TST_RSA_CheckErrorReturn(
		TST_ATP_Error,"CE2_RSA_Compare_CRT_Pub_Key",
		"Modulus_ptr", "ModulusOut_ptr");

	TST_REPORT_END(__FUNCTION__);

	return TST_TestStatusReturn;
} /* End of CE2_TST_RSA_Build_Get_PubKey */

/***************************************************************
* Function Name:                                                           
* 	CE2_TST_RSA_Build_Get_PrivKey 		
* 
* Inputs:
*  @param out [in] - pointer to file to output debug information;
*
* Outputs: @returns \b
*  CE2Error_t  
*  - CE2_OK - On success
*  - Otherwise - error code.
*
* \brief \b
* Description:
*  This function tests generation and export and import functions
*  under public key
*  Vectors sizes used (in byte) - 16/32/512
*  Key sizes used     (in bits) - 512/1024/2048
*  This also outputs the results to an output buffer or the same input buffer
*
*
* \b
* Algorithm:
*  -# Prepare keys	
*     a. Generate key
*     or
*     a. Build the Private Key from External exponent and modulus 	
*  -# Call the CE2_RSA_Get_PrivKey to preform the Get operation
*  -# Call the CE2_RSA_Build_PrivKey to preform the build operation
*  -# Compare the outputted result to the expected one
***************************************************************/
CE2Error_t CE2_TST_RSA_Build_Get_PrivKey(int TST_KeyGeneration_TestStatus, FILE * out)
{
	TST_RSA_TestGetPrivKeyDataStruct	TST_RSA_Tmp_PrivKey;
	int			TST_index,TST_CRT_Mode;
	CE2Error_t	TST_TestStatus=0;
	int			TST_KeyGenType;
	char		TST_MasterTestName[TST_FUNC_STRING_LEN] =
		"CE2_ATP_TST_RSA_Get_PrivKey"; 
	int 		TST_HashType;
	CE2_RSA_HASH_OpMode_t	TST_RSAHashType=CE2_RSA_HASH_NumOfModes;
	int			yanivSize = 0;

	out = TST_REPORT_BEGIN(__FUNCTION__, out);
	if (out == NULL)
		return CE2_TST_FAILED;

    /* Start of test */
    /* Setting if to use internal key generation */
    TST_KeyGenType = (TST_KeyGeneration_TestStatus == TST_NO_INTERNAL_KEYGEN)?
		(TST_EXTERNAL_KEYPAIR):(TST_INTERNAL_KG);

	/*TST_KeyGenType = 0 Internal KeyGen // TST_KeyGenType = 1 External keys*/
	for ( ; TST_KeyGenType <2 ; TST_KeyGenType++)
	{
		for (TST_HashType = 0 ; TST_HashType < CE2_HASH_NumOfModes ; TST_HashType++)
		{   
			switch(TST_HashType)
			{
				case CE2_HASH_SHA1_mode:
					TST_RSAHashType = CE2_RSA_HASH_SHA1_mode;
					break;
				case CE2_HASH_SHA224_mode:
					TST_RSAHashType = CE2_RSA_HASH_SHA224_mode;
					break;
				case CE2_HASH_SHA256_mode:
					TST_RSAHashType = CE2_RSA_HASH_SHA256_mode;
					break;
				case CE2_HASH_SHA384_mode:
					TST_RSAHashType = CE2_RSA_HASH_SHA384_mode;
					break;
				case CE2_HASH_SHA512_mode:
					TST_RSAHashType = CE2_RSA_HASH_SHA512_mode;
					break;
				default:
					break;
			}

			/* TST_CRT_Mode = 0 no CRT // TST_CRT_Mode = 1 CRT mode*/
			for (TST_CRT_Mode = 0 ; TST_CRT_Mode < 2 ; TST_CRT_Mode++)
			{   
				/*To run on all test vectors*/
				for (TST_index =0 ; TST_index < TST_NumberOf_RSA_AcceptanceSignVerifyTests ; TST_index++)
				{
					/* STUBS */
					/* STUB: do not use CRT mode */
					//if (TST_CRT_Mode == TST_NO_CRT)
					//	continue;

					/* SHA384 & SHA512 are not used with RSA 512bit keys*/
					if ((TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_KeySize == TST_RSA_512_KEY_SIZE_IN_BYTES)&&
						((TST_RSAHashType == CE2_RSA_HASH_SHA384_mode)||(TST_RSAHashType == CE2_RSA_HASH_SHA512_mode)))
					continue;

					/* low level function keysize bound */
					if ((TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_KeySize < (MIN_RSA_SIZE/8)) ||
						(TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_KeySize > (MAX_RSA_SIZE/8)))
						continue;

					/* STUB: do not use TST_INTERNAL_KG */
					if (TST_KeyGenType == TST_INTERNAL_KG)
						continue;

					/* STUBS end */

					/*Cleaning the keys to prevent test errors with KG*/ 
					memset(&TST_PrivateKey,0,sizeof(TST_PrivateKey));
					memset(&TST_PublicKey,0,sizeof(TST_PublicKey));
	                
					/* output buffer != input buffer    */
					/*
					fprintf(out, "********************************************************************** \n");
					fprintf(out, " %s[test 5.%d]\n",TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_Name,TST_index); 
					fprintf(out, "OperationMode_t = %d\n", TST_HashType);
					fprintf(out, (TST_CRT_Mode == TST_NO_CRT)?(" Non CRT mode  \n"):(" CRT mode  \n"));
					fprintf(out, (TST_KeyGenType == TST_INTERNAL_KG)?(" Internal Key Generation  \n"):(" External Keys  \n"));
					fprintf(out, "********************************************************************** \n");
					*/

					if (TST_KeyGenType == TST_INTERNAL_KG)
					{
						if (TST_CRT_Mode == TST_NO_CRT)
						{
							/* Generate The Public and private keys */
							TST_ATP_Error = CE2_RSA_KG_GenerateKeyPair(
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_PublicExponent_E,
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_PubExponentSize,
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_KeySize*8,
								&TST_PrivateKey,
								&TST_PublicKey);

							TST_TestStatus = TST_RSA_CheckErrorReturn(
								TST_ATP_Error,"CE2_RSA_KG_GenerateKeyPair",
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_Name,
								TST_MasterTestName);
						}
						else
						{
							/* Generate The Public and private CRT keys */
							TST_ATP_Error = CE2_RSA_KG_GenerateKeyPairCRT(
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_PublicExponent_E,
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_PubExponentSize,
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_KeySize*8,
								&TST_PrivateKey,
								&TST_PublicKey);
	                                                                    
							TST_TestStatus = TST_RSA_CheckErrorReturn(
								TST_ATP_Error,"CE2_RSA_KG_GenerateKeyPairCRT",
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_Name,
								TST_MasterTestName);
						}
					}
					else
					{
						/* Build the public Key */
						TST_ATP_Error = CE2_RSA_Build_PubKey(
							&TST_PublicKey,
							TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_PublicExponent_E,
							TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_PubExponentSize,
							TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_Modulus_N,
							TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_KeySize);

						TST_TestStatus = TST_RSA_CheckErrorReturn(
							TST_ATP_Error,"CE2_RSA_Build_PubKey",
							TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_Name,
							TST_MasterTestName);

						/* Build the Private Key */
						if (TST_CRT_Mode == TST_NO_CRT)
						{
							TST_ATP_Error = CE2_RSA_Build_PrivKey(
								&TST_PrivateKey,
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_PrivetExponent_D,
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_KeySize,
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_PublicExponent_E,
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_PubExponentSize,                                                  
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_Modulus_N,
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_KeySize);                                 

							TST_TestStatus = TST_RSA_CheckErrorReturn(
								TST_ATP_Error,"CE2_RSA_Build_PrivKey",
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_Name,
								TST_MasterTestName);
						} 
						else 
						{
							TST_ATP_Error = CE2_RSA_Build_PrivKeyCRT(
								&TST_PrivateKey,
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_P,
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_DPSize,
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_Q,                                                                                                
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_DPSize,
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_dP,                                                                                                   
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_DPSize,    
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_dQ,                                                                                                   
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_DPSize,                                                                                                   
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_Qinv,
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_DPSize);

							TST_TestStatus = TST_RSA_CheckErrorReturn(
								TST_ATP_Error,"CE2_RSA_Build_PrivKeyCRT",
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_Name,
								TST_MasterTestName);
						}
						
					}/*End of TST_KeyGenType*/

					/* Debug massages */
					//fprintf(out, "Input Data Size [byte] = %1d \n" ,TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_input_dataSize);

					if (TST_CRT_Mode == TST_NO_CRT)
					{
						/* Generate The private key */
						TST_RSA_Tmp_PrivKey.TST_PrivExponentSize=TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_KeySize;
						TST_RSA_Tmp_PrivKey.TST_PubExponentSize=TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_PubExponentSize;
						TST_RSA_Tmp_PrivKey.TST_ModulusSize=TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_KeySize;

						TST_ATP_Error = CE2_RSA_Get_PrivKey(
							&TST_PrivateKey,
							TST_RSA_Tmp_PrivKey.TST_PrivetExponent_D,
							&TST_RSA_Tmp_PrivKey.TST_PrivExponentSize,
							TST_RSA_Tmp_PrivKey.TST_PublicExponent_E,
							&TST_RSA_Tmp_PrivKey.TST_PubExponentSize,
							TST_RSA_Tmp_PrivKey.TST_Modulus_N,
							&TST_RSA_Tmp_PrivKey.TST_ModulusSize);

						TST_TestStatus = TST_RSA_CheckErrorReturn(
							TST_ATP_Error,"CE2_RSA_Get_PrivKey",
							TST_RSA_Tmp_PrivKey.TST_Name,
							TST_MasterTestName);

						/*Comparing The Private Key */
						if (TST_KeyGenType != TST_INTERNAL_KG)
						{
							TST_ATP_Error = (CE2Error_t)memcmp(
								TST_RSA_Tmp_PrivKey.TST_PrivetExponent_D,
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_PrivetExponent_D,
								TST_RSA_Tmp_PrivKey.TST_PrivExponentSize);

							if ((TST_RSA_Tmp_PrivKey.TST_PrivExponentSize) == 0)
								TST_ATP_Error = CE2_TST_FAILED;

							TST_TestStatus = TST_RSA_CheckErrorReturn(
								TST_ATP_Error,"CE2_RSA_Compare_Private_Key",
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_Name,
								TST_MasterTestName);
						}
					}
					else
					{
						/* Get The private CRT key */
						/********************************************/
						TST_RSA_Tmp_PrivKey.TST_pSize    = 	TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_DPSize;
						TST_RSA_Tmp_PrivKey.TST_qSize    = 	TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_DPSize;
						TST_RSA_Tmp_PrivKey.TST_DpSize   = 	TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_DPSize;
						TST_RSA_Tmp_PrivKey.TST_DqSize   = 	TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_DPSize;
						TST_RSA_Tmp_PrivKey.TST_QinvSize = 	TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_DPSize;

						TST_ATP_Error = CE2_RSA_Get_PrivKeyCRT(
							&TST_PrivateKey,
							TST_RSA_Tmp_PrivKey.TST_P,
							&TST_RSA_Tmp_PrivKey.TST_pSize,
							TST_RSA_Tmp_PrivKey.TST_Q,
							&TST_RSA_Tmp_PrivKey.TST_qSize,
							TST_RSA_Tmp_PrivKey.TST_Dp,
							&TST_RSA_Tmp_PrivKey.TST_DpSize,
							TST_RSA_Tmp_PrivKey.TST_Dq,
							&TST_RSA_Tmp_PrivKey.TST_DqSize,
							TST_RSA_Tmp_PrivKey.TST_Qinv,
							&TST_RSA_Tmp_PrivKey.TST_QinvSize);

						TST_TestStatus = TST_RSA_CheckErrorReturn(
							TST_ATP_Error,"CE2_RSA_Get_PrivKeyCRT",
							TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_Name,
							TST_MasterTestName);

                		/*Comparing The Private Key */
						if (TST_KeyGenType != TST_INTERNAL_KG)
						{
							TST_ATP_Error = (CE2Error_t)memcmp(
								TST_RSA_Tmp_PrivKey.TST_P,
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_P,
								TST_RSA_Tmp_PrivKey.TST_pSize);

							if (TST_RSA_Tmp_PrivKey.TST_pSize==0)
								TST_ATP_Error = CE2_TST_FAILED;

							TST_TestStatus = TST_RSA_CheckErrorReturn(
								TST_ATP_Error,"CE2_RSA_Compare_CRT_Private_Key",
								TST_RSA_Acceptance_SignVerify_TestData[TST_index].TST_Name,
								TST_MasterTestName);
						}
					}
				}/*End of TST_Index loop*/
			}/*End of TST_CRT_Mode loop*/
		}/* End of TST_HashType loop*/
	}/* End of TST_KeyGenType loop*/

 	TST_REPORT_END(__FUNCTION__);

	return TST_TestStatusReturn;
}/*End of CE2_ATP_TST_RSA_Acceptance_PKCS1v15_Integrated_SignVerify*/

/***************************************************************
* Function Name:                                                           
* 	CE2_TST_RSA_PRIME_Encrypt_Decrypt_PKCS1v15v21_Full 		
* 
* Inputs:
*  @param out [in] - pointer to file to output debug information;
*  @param testZeroMessage [in] - indicates whether test should use
*         zero message only;
*
* Outputs: @returns \b
*  CE2Error_t  
*  - CE2_OK - On success
*  - Otherwise - error code.
*
* \brief \b
* Description:
*  This function Is a Acceptance test for RSA PKCS1v15 encrypt and decrypt
*  According to PKCS#1 Ver1.5, to PKCS#1 Ver2.1
*  Including RSA KeyGeneration
*  This function Encrypts and Decrypts known vectors
*  Vector/Keys sizes used (in bits) - 512/1024/2048 also CRT private														
*  This also outputs the results to an output buffer or the same input buffer
*
* \b
* Algorithm:
*  -# Prepare keys	
*     a. Generate keys 
*     or
*     a. Build the Private Key from external exponent and modulus
*     b. Build the Public Key from External exponent and modulus
*  -# Encrypt/Decrypt a known vector
*  -# Compare the outputted result to the expected one
***************************************************************/
CE2Error_t CE2_TST_RSA_PRIME_Encrypt_Decrypt_PKCS1v15v21_Full(FILE *out, unsigned char testZeroMessage)
{
	char TST_MasterTestName[] = "CE2_TST_RSA_PRIME_Encrypt_Decrypt";

	CE2_RSAUserPubKey_t		UserPubKey = { 0 };
	CE2_RSAUserPrivKey_t	UserPrivKey = { 0 };

	DxUint8_t				PubExponent[] = {0x01,0x00,0x01};
	DxUint16_t				PubExponentSize =  sizeof(PubExponent)*sizeof(DxUint8_t);

	DxUint8_t				MessageData[] = "01234567890123456789012345678";
	DxUint16_t				MessageDataSize = sizeof(MessageData);
	DxUint8_t				*Data = MessageData;
	DxUint16_t				DataSize = MessageDataSize;
	DxUint8_t				EncryptOutput[1024] = { 0 };
	DxUint8_t				DecryptOutput[1024] = { 0 };
	DxUint16_t				DecryptOutputSize = sizeof(DecryptOutput);
	DxUint16_t				EncryptOutputSize = sizeof(DecryptOutput);

	DxUint8_t				PubExponentOut_ptr[64] = { 0 };
	DxUint16_t				PubExponentSizeOut = 0;
	DxUint8_t				ModulusOut_ptr[2048] = { 0 };
	DxUint16_t				ModulusSizeOut = sizeof(ModulusOut_ptr)*sizeof(DxUint8_t);
	int						mode;

	CE2_PKCS1_version		v;

	out = TST_REPORT_BEGIN(__FUNCTION__, out);
	if (out == NULL)
		return CE2_TST_FAILED;

	if (testZeroMessage)
	{
		Data		= NULL;
		DataSize	= 0;
	}

	fprintf(out, " testZeroMessage = [%d]\n", testZeroMessage);

	/* generate keys */
	TST_ATP_Error = CE2_RSA_KG_GenerateKeyPair(
		PubExponent, PubExponentSize, 1024,
		&UserPrivKey, &UserPubKey);

	TST_RSA_CheckErrorReturn(TST_ATP_Error,
		"CE2_RSA_KG_GenerateKeyPair", __FUNCTION__, __FUNCTION__);

	/* test PKCS1 v1.5 and v2.1 */
	for (v = CE2_PKCS1_VER15; v <= CE2_PKCS1_VER21; ++v)
	{
		//fprintf(out, " CE2_PKCS1_version = [%d]\n", v);

		/* tru all modes */
		for (mode = CE2_RSA_HASH_SHA1_mode; mode <= CE2_RSA_HASH_SHA512_mode; ++mode)
		{
			/*
			fprintf(out, " mode = [%d]\n", mode);
			fprintf(out, "\n");
			*/

			/* encrypt data using public key */
			TST_ATP_Error = CE2_RSA_PRIM_Encrypt(
				&UserPubKey, Data, DataSize, EncryptOutput);

			TST_RSA_CheckErrorReturn(TST_ATP_Error,
				"CE2_RSA_PRIM_Encrypt", __FUNCTION__, __FUNCTION__);

			/* get modulus size */
			TST_ATP_Error = CE2_RSA_Get_ModSizeFromPubKey(&UserPubKey, &ModulusSizeOut);

			TST_RSA_CheckErrorReturn(TST_ATP_Error,
				"CE2_RSA_Get_ModSizeFromPubKey", __FUNCTION__, __FUNCTION__);

			/* decrypt data using private key */
			TST_ATP_Error = CE2_RSA_PRIM_Decrypt(
				&UserPrivKey, EncryptOutput, ModulusSizeOut, DecryptOutput);

			TST_RSA_CheckErrorReturn(TST_ATP_Error,
				"CE2_RSA_PRIM_Decrypt", __FUNCTION__, __FUNCTION__);

			/* compare decrypded and expected data */
			if (!testZeroMessage)
			{
				TST_ATP_Error = memcmp(Data, DecryptOutput + (ModulusSizeOut - DataSize), DataSize);

				TST_RSA_CheckErrorReturn(TST_ATP_Error,
					"memcmp", "Compare Data and Decrypt data", __FUNCTION__);
			}

			/* clear encrypt/ decrypt data */
			memset(EncryptOutput, 0, sizeof(EncryptOutput));
			memset(DecryptOutput, 0, sizeof(DecryptOutput));
			DecryptOutputSize = sizeof(DecryptOutput);
			EncryptOutputSize = sizeof(DecryptOutput);

			/* tests for SCHEMES */
			/* only supported */
			if (mode == CE2_RSA_HASH_SHA1_mode ||
				mode == CE2_RSA_HASH_SHA256_mode ||
				mode == CE2_RSA_HASH_SHA384_mode /*||
				mode == CE2_RSA_HASH_SHA512_mode*/)
			{
				/* encrypt data using public key */
				TST_ATP_Error = CE2_DX_RSA_SCHEMES_Encrypt(
					&UserPubKey, mode, 0, 0,
					CE2_PKCS1_MGF1, Data, DataSize, EncryptOutput, v);

				TST_RSA_CheckErrorReturn(TST_ATP_Error,
					"_DX_RSA_SCHEMES_Encrypt", __FUNCTION__, __FUNCTION__);

				/* get modulus size */
				TST_ATP_Error = CE2_RSA_Get_ModSizeFromPubKey(&UserPubKey, &ModulusSizeOut);

				TST_RSA_CheckErrorReturn(TST_ATP_Error,
					"CE2_RSA_Get_ModSizeFromPubKey", __FUNCTION__, __FUNCTION__);

				//if (v == CE2_PKCS1_VER15)
				//	DecryptOutputSize = DataSize;

				/* decrypt data using private key */
				TST_ATP_Error = CE2_DX_RSA_SCHEMES_Decrypt(
					&UserPrivKey, mode, 0, 0,
					CE2_PKCS1_MGF1, EncryptOutput, ModulusSizeOut,
					DecryptOutput, &DecryptOutputSize, v);

				TST_RSA_CheckErrorReturn(TST_ATP_Error,
					"_DX_RSA_SCHEMES_Decrypt", __FUNCTION__, __FUNCTION__);

				/* compare decrypded and expected data */
				if (DecryptOutputSize == DataSize)
				{
					TST_ATP_Error = memcmp(Data, DecryptOutput, DataSize);

					TST_RSA_CheckErrorReturn(TST_ATP_Error,
						"memcmp", "Compare Data and Decrypt data", __FUNCTION__);
				}
				else
					TST_RSA_CheckErrorReturn(TST_ATP_Error,
						"output size compare", "Compare Data size and Decrypt data size", __FUNCTION__);
#if 0
				/* clear decrypt data */
				memset(DecryptOutput, 0, sizeof(DecryptOutput));
				DecryptOutputSize = sizeof(DecryptOutput);

				/* corrypt encrypted data */
				EncryptOutput[0] ^= 1;

				if (v == CE2_PKCS1_VER15)
					DecryptOutputSize = DataSize;

				/* decrypt data using private key */
				TST_ATP_Error = CE2_DX_RSA_SCHEMES_Decrypt(
					&UserPrivKey, CE2_RSA_HASH_SHA1_mode, 0, 0,
					CE2_PKCS1_MGF1, EncryptOutput, ModulusSizeOut,
					DecryptOutput, &DecryptOutputSize, v);
				
				TST_RSA_CheckErrorReturn(TST_ATP_Error,
					"_DX_RSA_SCHEMES_Decrypt", __FUNCTION__, __FUNCTION__);

				/* compare decrypded and expected data */
				/* expected error */
				TST_ATP_Error = !memcmp(Data, DecryptOutput + (ModulusSizeOut - DataSize), DataSize);

				TST_RSA_CheckErrorReturn(TST_ATP_Error,
					"memcmp", "Compare Data and Corrupted Decrypt data", __FUNCTION__);
#endif
				/*Unit test for Crush by NULL ptr*/
				TST_ATP_Error = CE2_DX_RSA_SCHEMES_Encrypt(
					&UserPubKey, mode, 0, 0,
					CE2_PKCS1_MGF1, NULL, 0, EncryptOutput, v);

				TST_RSA_CheckErrorReturn(TST_ATP_Error,
					"_DX_RSA_SCHEMES_Encrypt", __FUNCTION__, __FUNCTION__);
			}

			/* clear encrypt/ decrypt data */
			memset(EncryptOutput, 0, sizeof(EncryptOutput));
			memset(DecryptOutput, 0, sizeof(DecryptOutput));
			DecryptOutputSize = sizeof(DecryptOutput);
			EncryptOutputSize = sizeof(DecryptOutput);

			/* tests for SCHEMES Sign / Verify */
			/* sign the data using private key */
      if (v == CE2_PKCS1_VER15)
      {
			  TST_ATP_Error = CE2_DX_RSA_Sign(
				  &UserPrivKey, mode + 6, CE2_PKCS1_MGF1, 20,
				  Data, DataSize, EncryptOutput, &EncryptOutputSize, v);
      } else {
        TST_ATP_Error = CE2_DX_RSA_Sign(
          &UserPrivKey, mode, CE2_PKCS1_MGF1, 20,
          Data, DataSize, EncryptOutput, &EncryptOutputSize, v);

      }

			TST_RSA_CheckErrorReturn(TST_ATP_Error,
				"_DX_RSA_Sign", __FUNCTION__, __FUNCTION__);

			/* get modulus size */
			TST_ATP_Error = CE2_RSA_Get_ModSizeFromPubKey(&UserPubKey, &ModulusSizeOut);

			TST_RSA_CheckErrorReturn(TST_ATP_Error,
				"CE2_RSA_Get_ModSizeFromPubKey", __FUNCTION__, __FUNCTION__);

			/* verify data using public key */
			if (v == CE2_PKCS1_VER15)
			{
				/* test for LLF_RSA_pkcs_v15_sa_get_sig_hash_mode */
				TST_ATP_Error = CE2_DX_RSA_Verify(
					&UserPubKey, CE2_RSA_After_HASH_NOT_KNOWN_mode, CE2_PKCS1_MGF1, 20,
					Data, DataSize, EncryptOutput, v);

        if (TST_ATP_Error != 0)
        {
          fprintf(out, "Can't verify sign (v15)!\n");
        }
			}
			else
			{
				TST_ATP_Error = CE2_DX_RSA_Verify(
					&UserPubKey, mode, CE2_PKCS1_MGF1, 20,
					Data, DataSize, EncryptOutput, v);

        if (TST_ATP_Error != 0)
        {
          fprintf(out, "Can't verify sign (v21)!\n");
        }
			}

			TST_RSA_CheckErrorReturn(TST_ATP_Error,
				"_DX_RSA_Verify", __FUNCTION__, __FUNCTION__);
#if 0
			/* corrupt data */
			Data[0] ^= 1;

			/* verify data using public key */
			if (v == CE2_PKCS1_VER15)
			{
				/* test for LLF_RSA_pkcs_v15_sa_get_sig_hash_mode */
				TST_ATP_Error = CE2_DX_RSA_Verify(
					&UserPubKey, CE2_RSA_After_HASH_NOT_KNOWN_mode, CE2_PKCS1_MGF1, 20,
					Data, DataSize, EncryptOutput, v);
			}
			else
			{
				TST_ATP_Error = CE2_DX_RSA_Verify(
					&UserPubKey, mode, CE2_PKCS1_MGF1, 20,
					Data, DataSize, EncryptOutput, v);
			}

			/* check result, error expected */
			TST_ATP_Error = (TST_ATP_Error != CE2_OK) ? (CE2_OK) : (CE2_ERROR_BASE);

			TST_RSA_CheckErrorReturn(TST_ATP_Error,
				"_DX_RSA_Verify", __FUNCTION__, __FUNCTION__);
#endif
		}
	}

	TST_REPORT_END(__FUNCTION__);

	return TST_TestStatusReturn;
}

CE2Error_t CE2_TST_RSA_PRIME_EncDecTest(FILE * out)
{
	int			TST_index,TST_CRT_Mode;
	char		TST_MasterTestName[TST_FUNC_STRING_LEN] =
		"CE2_TST_RSA_Acceptance_PRIME_EncDec";
	int			DataSize;

	DxUint8_t  pDecrData[0xc0];

	DxUint8_t  encrSize;
	DxUint8_t  pEncrData[0xc0];// = {0};

	TST_index = 0;
	encrSize = 0xc0;

	TST_CRT_Mode = TST_NO_CRT;

	out = TST_REPORT_BEGIN(__FUNCTION__, out);
	if (out == NULL)
		return CE2_TST_FAILED;

	/* Build the public Key */
	TST_ATP_Error = CE2_RSA_Build_PubKey(
		&TST_PublicKey,
		TestData[TST_index].TST_PublicExponent_E,
		TestData[TST_index].TST_PubExponentSize,
		TestData[TST_index].TST_Modulus_N,
		TestData[TST_index].TST_KeySize);

	/* Build the Private Key not CRT */
	if (TST_CRT_Mode == TST_NO_CRT)
	{
		TST_ATP_Error = CE2_RSA_Build_PrivKey(
			&TST_PrivateKey,
			TestData[TST_index].TST_PrivetExponent_D,
			TestData[TST_index].TST_KeySize,
			TestData[TST_index].TST_PublicExponent_E,
			TestData[TST_index].TST_PubExponentSize,
			TestData[TST_index].TST_Modulus_N,
			TestData[TST_index].TST_KeySize);
	}
	else
	{
		TST_ATP_Error = CE2_RSA_Build_PrivKeyCRT(
			&TST_PrivateKey,
			TestData[TST_index].TST_P,
			TestData[TST_index].TST_DPSize,
			TestData[TST_index].TST_Q,
			TestData[TST_index].TST_DPSize,
			TestData[TST_index].TST_dP,
			TestData[TST_index].TST_DPSize,
			TestData[TST_index].TST_dQ,
			TestData[TST_index].TST_DPSize,
			TestData[TST_index].TST_Qinv,
			TestData[TST_index].TST_DPSize);


	}

	DataSize = 16; // modulus size


	/* Encrypt the data using the primes */
	/* (Public Key)                      */
	TST_ATP_Error = CE2_RSA_PRIM_Encrypt(
		&TST_PublicKey,
		TestData[TST_index].TST_input_data,
		DataSize,
		pEncrData
		/*TestData[TST_index].TST_output_data*/);

	/* Decrypt the data using the primes */
	/* (Private Key)                     */
	TST_ATP_Error = CE2_RSA_PRIM_Decrypt(
		&TST_PrivateKey,
		//			TestData[TST_index].TST_output_data,
		//			TestData[TST_index].TST_KeySize,
		pEncrData,
		encrSize,
		//			TestData[TST_index].TST_output_data);
		pDecrData);

	TST_ATP_Error = (CE2Error_t)memcmp(
		pDecrData + (encrSize - DataSize), //TestData[TST_index].TST_output_data ,
		TestData[TST_index].TST_input_data,
		DataSize);

	PrintTestEndMsg(out, __FUNCTION__, TST_ATP_Error);

	//TST_REPORT_END(__FUNCTION__);

	return TST_TestStatusReturn;
}/*End of CE2_ATP_TST_RSA_Acceptance_PRIME_EncDec*/


CE2Error_t CE2_TST_RSA_PRIME_EncDecTest2(FILE * out)
{
	int			TST_index,TST_CRT_Mode;
	char		TST_MasterTestName[TST_FUNC_STRING_LEN] =
		"CE2_TST_RSA_Acceptance_PRIME_EncDec";
	int			DataSize;

	DxUint8_t  pDecrData[0xA0] = {0};

	DxUint8_t  encrSize;
	DxUint8_t  pEncrData[0xA0] = {0};

	TST_index = 0;
	encrSize = 0xA0;

	TST_CRT_Mode = /*TST_NO_CRT;*/TST_CRT_MODE;

	out = TST_REPORT_BEGIN(__FUNCTION__, out);
	if (out == NULL)
		return CE2_TST_FAILED;

	/* Build the public Key */
	TST_ATP_Error = CE2_RSA_Build_PubKey(
		&TST_PublicKey,
		TestData2[TST_index].TST_PublicExponent_E,
		TestData2[TST_index].TST_PubExponentSize,
		TestData2[TST_index].TST_Modulus_N,
		TestData2[TST_index].TST_KeySize);

	/* Build the Private Key not CRT */
	if (TST_CRT_Mode == TST_NO_CRT)
	{
		TST_ATP_Error = CE2_RSA_Build_PrivKey(
			&TST_PrivateKey,
			TestData2[TST_index].TST_PrivetExponent_D,
			TestData2[TST_index].TST_KeySize,
			TestData2[TST_index].TST_PublicExponent_E,
			TestData2[TST_index].TST_PubExponentSize,
			TestData2[TST_index].TST_Modulus_N,
			TestData2[TST_index].TST_KeySize);
	}
	else
	{
		TST_ATP_Error = CE2_RSA_Build_PrivKeyCRT(
			&TST_PrivateKey,
			TestData2[TST_index].TST_P,
			TestData2[TST_index].TST_DPSize,
			TestData2[TST_index].TST_Q,
			TestData2[TST_index].TST_DPSize,
			TestData2[TST_index].TST_dP,
			TestData2[TST_index].TST_DPSize,
			TestData2[TST_index].TST_dQ,
			TestData2[TST_index].TST_DPSize,
			TestData2[TST_index].TST_Qinv,
			TestData2[TST_index].TST_DPSize);


	}

	DataSize = 77; // modulus size


	/* Encrypt the data using the primes */
	/* (Public Key)                      */
	TST_ATP_Error = CE2_RSA_PRIM_Encrypt(
		&TST_PublicKey,
		TestData2[TST_index].TST_input_data,
		DataSize,
		pEncrData
		/*TestData2[TST_index].TST_output_data*/);





	/* Decrypt the data using the primes */
	/* (Private Key)                     */
	TST_ATP_Error = CE2_RSA_PRIM_Decrypt(
		&TST_PrivateKey,
		//TestData2[TST_index].TST_output_data,
		//TestData2[TST_index].TST_KeySize,
		pEncrData,
		encrSize,
		//			TestData2[TST_index].TST_output_data);
		pDecrData);

	TST_ATP_Error = (CE2Error_t)memcmp(
		pDecrData + (encrSize - DataSize),// TestData2[TST_index].TST_output_data ,
		TestData2[TST_index].TST_input_data,
		DataSize);


	PrintTestEndMsg(out, __FUNCTION__, TST_ATP_Error);

	//TST_REPORT_END(__FUNCTION__);

	return TST_TestStatusReturn;
}/*End of CE2_ATP_TST_RSA_Acceptance_PRIME_EncDec*/

#include	"CE2_UTIL_RSA_SCHEMES.h"

CE2Error_t CE2_TST_RSA_UTILS_EASY_TST(FILE * out){
	CE2_RSAUserPubKey_t		UserPubKey = { 0 };
	CE2_RSAUserPrivKey_t	UserPrivKey = { 0 };

	DxUint8_t				PubExponent[] = { 0x01, 0x00, 0x01 };
	DxUint16_t				PubExponentSize =  sizeof(PubExponent)*sizeof(DxUint8_t);

	DxUint8_t				Data[] = "01234567890123456789012345678";
	DxUint16_t				DataSize = sizeof(Data);

	DxUint8_t				EncryptOutput[1024] = { 0 };

	int						mode = CE2_RSA_HASH_SHA1_mode;
	CE2_PKCS1_version		v = CE2_PKCS1_VER15;

	out = TST_REPORT_BEGIN(__FUNCTION__, out);
	if (out == NULL)
		return CE2_TST_FAILED;
	


	/* generate keys */
	TST_ATP_Error = CE2_RSA_KG_GenerateKeyPair(	PubExponent, PubExponentSize, 1024,	&UserPrivKey, &UserPubKey );
	TST_RSA_CheckErrorReturn(TST_ATP_Error,	"_DX_RSA_SCHEMES_Encrypt", __FUNCTION__, __FUNCTION__);

	TST_ATP_Error = CE2_DX_RSA_SCHEMES_WrongEncrypt( &UserPubKey, mode, 0, 0, CE2_PKCS1_MGF1, Data, DataSize, EncryptOutput, 0x0, v );
	TST_RSA_CheckErrorReturn(TST_ATP_Error, "_DX_RSA_SCHEMES_Encrypt", __FUNCTION__, __FUNCTION__);

	return TST_TestStatusReturn;
}

CE2Error_t CE2_TST_RSA_TST_Verify(FILE * out)
{
	CE2_RSAUserPubKey_t		UserPubKey = { 0 };
	CE2_RSAUserPrivKey_t	UserPrivKey = { 0 };

	DxUint8_t				PubExponent[] = { 0x03};
	DxUint16_t				PubExponentSize =  1;
    DxUint32_t              ModulusSize = 0xa0;
    CE2_RSA_HASH_OpMode_t   hashFunc = CE2_RSA_After_SHA256_mode;

    DxUint8_t               Modulus[] = 
                                {0xB4,0xE5,0x70,0x90,0xA4,0x42,0xDB,0x72,0x2A,0xFB,0x45,0xD1,0xBD,0x0F,0xCA,0x68,
                                0x2C,0xD0,0x59,0x7F,0x75,0xC1,0x79,0x8B,0xF7,0xB9,0xB2,0xDB,0x84,0x3B,0x03,0x49,
                                0xB0,0x2C,0x31,0xC3,0x07,0x00,0x49,0x1F,0x79,0x61,0xF3,0x06,0x81,0x10,0x97,0xDA,
                                0xFD,0xCD,0xFC,0x9A,0x72,0xF0,0x37,0x27,0xD7,0x81,0xD7,0x8F,0x58,0x46,0x7E,0x8A,
                                0x83,0x8B,0x66,0x8B,0x40,0xE5,0xDE,0xE3,0x85,0xBC,0x93,0xBD,0x46,0xFF,0xB6,0x3D,
                                0x21,0x84,0x7D,0xE3,0x8C,0xE1,0xA8,0xB6,0x98,0xC4,0x22,0x55,0x68,0x55,0x18,0xE7,
                                0xE1,0x69,0x4C,0x63,0x0C,0x67,0xC9,0xB2,0x04,0x59,0xD7,0x00,0x1E,0x3F,0xDC,0x3A,
                                0xBC,0xBB,0xE7,0x8F,0x89,0x57,0xB4,0xAB,0x18,0xD3,0x27,0xFB,0x97,0xD1,0x85,0xD2,
                                0x07,0xE1,0xDB,0x36,0xF5,0x73,0xD5,0xCC,0x34,0x2F,0x35,0x93,0x35,0x0C,0x0B,0xA5,
                                0x27,0x61,0x75,0x7B,0x15,0x96,0x8A,0x3F,0xCD,0x69,0x5B,0x76,0x9E,0x48,0xB6,0xF1};

	
    CE2_PKCS1_MGF_t     MGF = CE2_PKCS1_MGF1;
    DxUint16_t          SaltLen = 19;
    DxUint16_t          inputDataSize = 32;
    DxUint8_t           data[]={0x23,0x99,0x2,0xa6,0xeb,0xc2,0x3d,0x50,0x92,0xd3,0x54,0xf6,0xb7,0x46,0x1a,0xcb,
                                0x5c,0x2d,0x60,0xb5,0x54,0xc,0xb0,0x63,0x1e,0x62,0x48,0x2f,0xba,0xab,0x47,0x3a};

    //DxUint8_t           signature[] ={0x1e,0x77,0xfa,0x69,0x4a,0x78,0xa7,0x65,0xc0,0x2d,0xae,0x71,0x73,0x64,0x26,0x60,0xcf,0xd8,0x5b,0x37,0x3a,0xb6,0x75,0x8c,0x6c,0x50,0xe9,0x1f,0x9e,0x8c,0xd0,0x63,0xa1,0x77,0x8d,0x90,0x16,0xa9,0xc6,0xfb,0x41,0xc7,0x4e,0xff,0xc,0x45,0x7a,0xc9,0xd9,0x1e,0xcf,0x9b,0x87,0x9b,0x90,0x5d,0x83,0x97,0x74,0xf5,0xc2,0x78,0xa7,0x15,0x23,0x84,0x67,0x2c,0xe2,0xf4,0xe,0xa,0x6c,0xdb,0xc2,0x87,0x28,0xf8,0x8d,0x3c,0xee,0x76,0xed,0xe3,0x15,0x1d,0xd1,0x90,0x1d,0xc2,0x77,0xbe,0x84,0x86,0x31,0xc6,0xe3,0x74,0x8b,0xf4,0x1f,0xd3,0x36,0xb2,0x56,0x11,0x44,0xa1,0xab,0x48,0x8f,0xf6,0xa7,0x68,0xdc,0x8d,0xf3,0x48,0xa1,0x4,0x32,0x3d,0xf,0x68,0x33,0xc2,0x1c,0xf6,0x12,0x51,0x95,0xdd,0x3e,0x50,0x27,0x6f,0x11,0xf,0x96,0x3c,0x17,0xdf,0xf4,0x76,0x52,0xae,0x7d,0xec,0x22,0x42,0x8a,0x46,0xef,0xf7,0xee,0x44,0x94,0xfc,0x64,0x50};

    DxUint8_t           signature[] = {0x49,0xB8,0xB4,0xD5,0x71,0x83,0x72,0x2D,0xD3,0x49,0x29,0x99,0x04,0x56,0x72,0x59,
                            0xEA,0x25,0x34,0x7A,0x73,0xF7,0xBA,0xD0,0x81,0xA9,0x95,0x39,0xC5,0xCD,0x03,0xBE,
                            0xFD,0x7E,0x84,0xA7,0x7C,0x35,0x14,0x9B,0xA4,0xD8,0x8A,0x4B,0xBD,0x52,0x36,0x8D,
                            0xFC,0xF2,0x72,0xFF,0x82,0x5D,0xDB,0x48,0x96,0x38,0xBD,0x27,0xE2,0x3C,0x53,0x8E,
                            0x94,0x6E,0xEF,0x1E,0xF4,0xB5,0x99,0x3A,0x4D,0xEA,0x35,0xC2,0xEF,0x60,0x94,0xC9,
                            0x40,0x49,0x72,0x97,0x06,0xA1,0x01,0xC1,0xF9,0xB1,0xB5,0xD9,0xA1,0x35,0x9E,0xCA,
                            0x58,0xCE,0xD2,0x80,0x5D,0x9A,0xF6,0xE6,0x0C,0x9C,0x93,0xF9,0x54,0x95,0x20,0xAD,
                            0x7C,0xD0,0x96,0xD6,0xAA,0xBA,0xB1,0x21,0x12,0x71,0x28,0x31,0x41,0xC2,0xEC,0x2E,
                            0xA9,0x1C,0x67,0xEB,0x4B,0xC8,0xD3,0x28,0xBC,0x99,0x96,0x05,0x4B,0x95,0x33,0x2A,
                            0xBC,0x98,0x99,0xE3,0xAF,0xEB,0xE8,0x52,0x5E,0xC0,0x6D,0x4A,0xB3,0x81,0x73,0x65};

	out = TST_REPORT_BEGIN(__FUNCTION__, out);
	if (out == NULL)
		return CE2_TST_FAILED;
	


	/* generate keys */
	TST_ATP_Error = CE2_RSA_Build_PubKey(
                        &UserPubKey,/* out */
                        PubExponent,			/* in */
                        PubExponentSize,			/* in */
                        Modulus,				/* in */
                        ModulusSize);	

	TST_ATP_Error = CE2_RSA_PSS_Verify(
						&UserPubKey,
						hashFunc,
						CE2_PKCS1_MGF1,
						SaltLen,
						data,
						inputDataSize,
						signature);

    

	return TST_TestStatusReturn;
}
